/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.service;

import com.microej.kf.util.service.SharedServiceRegistry;
import ej.kf.Kernel;
import ej.service.ServiceRegistry;
import ej.service.loader.SystemPropertiesServiceLoader;
import ej.service.registry.SimpleServiceRegistry;

public class ServiceRegistryKF
extends SimpleServiceRegistry
implements ServiceRegistry {
    private static SharedServiceRegistry sharedServiceRegistryKF;

    public ServiceRegistryKF() {
        if (sharedServiceRegistryKF == null) {
            sharedServiceRegistryKF = (SharedServiceRegistry)new SystemPropertiesServiceLoader().getService(SharedServiceRegistry.class);
        }
    }

    public <T> T getService(Class<T> service) {
        Object implementation = super.getService(service);
        if (implementation != null) {
            return (T)implementation;
        }
        return (T)sharedServiceRegistryKF.getService(service);
    }

    public <T> void register(Class<T> service, T instance) {
        if (Kernel.isInKernelMode()) {
            super.register(service, instance);
        } else if (Kernel.isSharedInterface(service)) {
            sharedServiceRegistryKF.register(service, instance);
        } else {
            super.register(service, instance);
        }
    }

    public <T> void register(Class<T> service, T instance, boolean isKernelLocal) {
        if (Kernel.isInKernelMode()) {
            if (isKernelLocal) {
                super.register(service, instance);
            } else {
                sharedServiceRegistryKF.register(service, instance);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public <T> void unregister(Class<T> service, T instance) {
        if (!Kernel.isInKernelMode()) {
            if (Kernel.isSharedInterface(service)) {
                sharedServiceRegistryKF.unregister(service, instance);
            } else {
                super.unregister(service, instance);
            }
        } else {
            super.unregister(service, instance);
        }
    }

    public <T> void unregister(Class<T> service, T instance, boolean isKernelLocal) {
        if (Kernel.isInKernelMode()) {
            if (isKernelLocal) {
                super.unregister(service, instance);
            } else {
                sharedServiceRegistryKF.unregister(service, instance);
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

