/*
 * Decompiled with CFR 0.152.
 */
package ej.net;

import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import ej.annotation.Nullable;
import ej.bon.Timer;
import ej.bon.TimerTask;
import ej.net.Network;
import ej.net.util.NetUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PollerConnectivityManager
extends ConnectivityManager {
    protected static final NetworkCapabilities INTERNET_CONNECTED = new NetworkCapabilities(new int[]{12});
    protected static final NetworkCapabilities INTERNET_UNCONNECTED = new NetworkCapabilities();
    private static final boolean DEBUG = false;
    private final Timer timer;
    private final Map<String, Network> networks = new HashMap<String, Network>();
    protected static final String BASE_PROPERTY = "connectivity.";
    private static final String TASK = "task.";
    private static final long DEFAULT_DELAY = Long.getLong("connectivity.task.delay", 0L);
    private static final long DEFAULT_PERIOD_WHEN_LOST = Long.getLong("connectivity.task.period", 1000L);
    private static final long DEFAULT_PERIOD_WHEN_AVAILABLE = Long.getLong("connectivity.task.period_when_up", 5L * DEFAULT_PERIOD_WHEN_LOST);
    private static final long DEFAULT_PERIOD_WHEN_INTERNET = Long.getLong("connectivity.task.period_when_internet", 4L * DEFAULT_PERIOD_WHEN_AVAILABLE);
    static final String EMPTY_NETWORK = "";
    private final long periodWhenLost;
    private final long periodWhenAvailable;
    private final long periodWhenInternet;
    @Nullable
    private ConnectivityManagerTimerTask pollerTask;
    private Network activeNetwork;
    private long currentPeriod;

    public PollerConnectivityManager() {
        this(new Timer());
        this.timer.schedule(new TimerTask(){

            public void run() {
                Thread.currentThread().setName(PollerConnectivityManager.class.getSimpleName());
            }
        }, 0L);
    }

    public PollerConnectivityManager(Timer timer) {
        this(timer, DEFAULT_DELAY, DEFAULT_PERIOD_WHEN_AVAILABLE, DEFAULT_PERIOD_WHEN_LOST, DEFAULT_PERIOD_WHEN_INTERNET);
    }

    public PollerConnectivityManager(Timer timer, long delay, long period) {
        this(timer, delay, period, period);
    }

    public PollerConnectivityManager(Timer timer, long delay, long periodWhenAvailable, long periodWhenLost) {
        this(timer, delay, periodWhenAvailable, periodWhenLost, periodWhenAvailable);
    }

    public PollerConnectivityManager(Timer timer, long delay, long periodWhenAvaialble, long periodWhenLost, long periodWhenInternet) {
        Network network = new Network(EMPTY_NETWORK);
        this.networks.put(EMPTY_NETWORK, network);
        this.timer = timer;
        this.periodWhenLost = periodWhenLost;
        this.periodWhenAvailable = periodWhenAvaialble;
        this.periodWhenInternet = periodWhenInternet;
        this.activeNetwork = network;
        this.setActiveNetwork(network);
        NetworkInfo activeNetworkInfo = this.getActiveNetworkInfo();
        if (activeNetworkInfo != null) {
            this.setAvailable(false, network, activeNetworkInfo);
        }
        this.startPolling(delay, periodWhenLost);
    }

    public void startPolling(long delay) {
        this.startPolling(delay, this.periodWhenLost);
    }

    public synchronized void stopPolling() {
        if (this.pollerTask != null) {
            this.pollerTask.cancel();
            this.pollerTask = null;
        }
    }

    public void cancel() {
        this.stopPolling();
        this.timer.cancel();
    }

    protected void log(int msg) {
    }

    protected void log(int msg, Throwable t) {
    }

    private synchronized void startPolling(long delay, long period) {
        this.stopPolling();
        this.currentPeriod = period;
        this.pollerTask = new ConnectivityManagerTimerTask();
        this.timer.schedule((TimerTask)this.pollerTask, delay, this.currentPeriod);
    }

    protected NetworkCapabilities getCapabilities(InetAddress connectedAddress) {
        return INTERNET_UNCONNECTED;
    }

    @Nullable
    protected Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return NetworkInterface.getNetworkInterfaces();
    }

    @Nullable
    protected NetworkInterface getNetworkInterface(String name) throws SocketException {
        return NetworkInterface.getByName(name);
    }

    private class ConnectivityManagerTimerTask
    extends TimerTask {
        private ConnectivityManagerTimerTask() {
        }

        public void run() {
            PollerConnectivityManager.this.log(1);
            String activenetworkInterface = PollerConnectivityManager.this.activeNetwork.getNetworkInterface();
            try {
                InetAddress checkConnected;
                if (PollerConnectivityManager.this.activeNetwork.getCapabilities() == INTERNET_CONNECTED && (checkConnected = this.checkConnected(PollerConnectivityManager.this.getNetworkInterface(activenetworkInterface))) != null && PollerConnectivityManager.this.getCapabilities(checkConnected) == INTERNET_CONNECTED) {
                    PollerConnectivityManager.this.log(2);
                    return;
                }
            }
            catch (SocketException e2) {
                PollerConnectivityManager.this.log(-255, e2);
            }
            try {
                Enumeration<NetworkInterface> e = PollerConnectivityManager.this.getNetworkInterfaces();
                this.checkNetworkInterfacesState(e);
            }
            catch (Throwable e1) {
                PollerConnectivityManager.this.log(-255, e1);
            }
        }

        private void checkNetworkInterfacesState(@Nullable Enumeration<NetworkInterface> interfaces) throws SocketException {
            Network activeNetwork = PollerConnectivityManager.this.activeNetwork;
            Network internetNetwork = null;
            Network availableNetwork = null;
            Network notAvailableNetwork = null;
            Network downNetwork = null;
            for (Map.Entry network : PollerConnectivityManager.this.networks.entrySet()) {
                ((Network)((Object)network.getValue())).setPresent(false);
            }
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface n = interfaces.nextElement();
                    String name = n.getName();
                    if (n.isLoopback() || name == null) continue;
                    Network currentNetwork = this.getNetwork(name);
                    currentNetwork.setPresent(true);
                    if (n.isUp()) {
                        InetAddress connectedAddress = this.checkConnected(n);
                        if (connectedAddress != null) {
                            NetworkCapabilities capabilities = PollerConnectivityManager.this.getCapabilities(connectedAddress);
                            if (capabilities.hasCapability(12)) {
                                if (internetNetwork == activeNetwork) continue;
                                internetNetwork = currentNetwork;
                                break;
                            }
                            if (availableNetwork == activeNetwork && availableNetwork != null) continue;
                            availableNetwork = currentNetwork;
                            continue;
                        }
                        if (notAvailableNetwork == activeNetwork && notAvailableNetwork != null) continue;
                        notAvailableNetwork = currentNetwork;
                        continue;
                    }
                    if (downNetwork == activeNetwork) continue;
                    downNetwork = currentNetwork;
                }
            }
            if (internetNetwork == null) {
                Iterator iterator = PollerConnectivityManager.this.networks.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getKey() == PollerConnectivityManager.EMPTY_NETWORK || ((Network)((Object)entry.getValue())).isPresent()) continue;
                    iterator.remove();
                }
            }
            this.updateNetworkState(internetNetwork, availableNetwork, notAvailableNetwork, downNetwork, activeNetwork);
        }

        private void updateNetworkState(@Nullable Network internetNetwork, @Nullable Network availableNetwork, @Nullable Network notAvailableNetwork, @Nullable Network downNetwork, Network activeNetwork) {
            this.updatePollingRate(availableNetwork != null, internetNetwork != null);
            if (internetNetwork != null) {
                this.notify(internetNetwork, true, INTERNET_CONNECTED, activeNetwork);
            } else if (availableNetwork != null) {
                this.notify(availableNetwork, true, INTERNET_UNCONNECTED, activeNetwork);
            } else if (notAvailableNetwork != null) {
                this.notify(notAvailableNetwork, false, INTERNET_UNCONNECTED, activeNetwork);
            } else if (downNetwork != null) {
                this.notify(downNetwork, false, INTERNET_UNCONNECTED, activeNetwork);
            } else if (activeNetwork != PollerConnectivityManager.this.networks.get(PollerConnectivityManager.EMPTY_NETWORK)) {
                Network network = (Network)((Object)PollerConnectivityManager.this.networks.get(PollerConnectivityManager.EMPTY_NETWORK));
                assert (network != null);
                this.notify(network, false, INTERNET_UNCONNECTED, activeNetwork);
            }
        }

        private void notify(Network newNetwork, boolean available, NetworkCapabilities capabilities, Network previousNetwork) {
            boolean willAvailableChanged = newNetwork.willChanged(available);
            boolean willCapabilitiesChanged = newNetwork.willChanged(capabilities);
            newNetwork.setAvailable(available);
            newNetwork.setCapabilities(capabilities);
            PollerConnectivityManager.this.activeNetwork = newNetwork;
            PollerConnectivityManager.this.setActiveNetwork(newNetwork);
            if (newNetwork != previousNetwork) {
                if (previousNetwork.getCapabilities() == INTERNET_CONNECTED) {
                    previousNetwork.setCapabilities(INTERNET_UNCONNECTED);
                    PollerConnectivityManager.this.notifyNetworkCallbacks(previousNetwork, INTERNET_UNCONNECTED);
                }
                if (previousNetwork.isAvailable()) {
                    previousNetwork.setAvailable(false);
                    PollerConnectivityManager.this.notifyNetworkCallbacks(previousNetwork, false);
                }
            }
            if (available) {
                if (willAvailableChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, available);
                }
                if (willCapabilitiesChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, capabilities);
                }
            } else if (newNetwork == previousNetwork) {
                if (willCapabilitiesChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, capabilities);
                }
                if (willAvailableChanged) {
                    PollerConnectivityManager.this.notifyNetworkCallbacks(newNetwork, available);
                }
            }
        }

        private void updatePollingRate(boolean avaialble, boolean internet) {
            if (internet) {
                if (PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenInternet) {
                    PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenInternet, PollerConnectivityManager.this.periodWhenInternet);
                }
            } else if (avaialble && PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenAvailable) {
                PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenAvailable, PollerConnectivityManager.this.periodWhenAvailable);
            } else if (!avaialble && PollerConnectivityManager.this.currentPeriod != PollerConnectivityManager.this.periodWhenLost) {
                PollerConnectivityManager.this.startPolling(PollerConnectivityManager.this.periodWhenLost, PollerConnectivityManager.this.periodWhenLost);
            }
        }

        private Network getNetwork(String networkInterface) {
            Network network = (Network)((Object)PollerConnectivityManager.this.networks.get(networkInterface));
            if (network == null) {
                network = new Network(networkInterface);
                PollerConnectivityManager.this.networks.put(networkInterface, network);
            }
            return network;
        }

        @Nullable
        private InetAddress checkConnected(@Nullable NetworkInterface n) {
            InetAddress connectedAddress = null;
            if (n != null) {
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress inetAddress = ee.nextElement();
                    if (!NetUtil.isValidInetAdress((InetAddress)inetAddress)) continue;
                    connectedAddress = inetAddress;
                    break;
                }
            }
            return connectedAddress;
        }
    }
}

