/*
 * Java
 *
 * Copyright 2016-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.ecom.wifi;

/**
 * List of Wi-Fi security modes.
 */
public enum SecurityMode {

	/**
	 * Enterprise NO security.
	 */
	Enterprise_NO_security,
	/**
	 * Enterprise WPA mixed.
	 */
	Enterprise_WPA_mixed,
	/**
	 * Enterprise WPA1.
	 */
	Enterprise_WPA1,
	/**
	 * Enterprise WPA2.
	 */
	Enterprise_WPA2,
	/**
	 * Enterprise WEP.
	 */
	EnterpriseWEP,
	/**
	 * MIXED (WPA1 / WPA2).
	 */
	MIXED,
	/**
	 * Open (no authentification).
	 */
	OPEN,
	/**
	 * WEP 128.
	 */
	WEP128,
	/**
	 * WEP 64.
	 */
	WEP64,
	/**
	 * WPA1.
	 */
	WPA1,
	/**
	 * WPA2.
	 */
	WPA2,
	/**
	 * WPA3.
	 */
	WPA3,
	/**
	 * MIXED WPA2 / WPA3.
	 */
	WPA2_WPA3_MIXED,
	/**
	 * Enterprise WPA3.
	 */
	Enterprise_WPA3,
	/**
	 * Enterprise MIXED WPA2 / WPA3.
	 */
	Enterprise_WPA2_WPA3_MIXED,
	/**
	 * Unknown (for unsupported protocols).
	 */
	UNKNOWN;
}
