package java.lang;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;

/**
 * The <code>String</code> class represents character strings. All string literals in Java programs,
 * such as <code>"abc"</code>, are implemented as instances of this class.
 * <p>
 * Strings are constant; their values cannot be changed after they are created. String buffers
 * support mutable strings. Because String objects are immutable they can be shared. For example:
 * <p>
 * <blockquote>
 * 
 * <pre>
 * String str = &quot;abc&quot;;
 * </pre>
 * 
 * </blockquote>
 * <p>
 * is equivalent to:
 * <p>
 * <blockquote>
 * 
 * <pre>
 * char[] data = { 'a', 'b', 'c' };
 * String str = new String(data);
 * </pre>
 * 
 * </blockquote>
 * <p>
 * Here are some more examples of how strings can be used:
 * <p>
 * <blockquote>
 * 
 * <pre>
 * System.out.println(&quot;abc&quot;);
 * String cde = &quot;cde&quot;;
 * System.out.println(&quot;abc&quot; + cde);
 * String c = &quot;abc&quot;.substring(2, 3);
 * String d = cde.substring(1, 2);
 * </pre>
 * 
 * </blockquote>
 * <p>
 * The class <code>String</code> includes methods for examining individual characters of the
 * sequence, for comparing strings, for searching strings, for extracting substrings, and for
 * creating a copy of a string with all characters translated to uppercase or to lowercase. Case
 * mapping is based on the Unicode Standard version specified by the {@link java.lang.Character
 * Character} class.
 * <p>
 * The Java language provides special support for the string concatenation operator (&nbsp;+&nbsp;),
 * and for conversion of other objects to strings. String concatenation is implemented through the
 * <code>StringBuilder</code>(or <code>StringBuffer</code>) class and its <code>append</code>
 * method. String conversions are implemented through the method <code>toString</code>, defined by
 * <code>Object</code> and inherited by all classes in Java. For additional information on string
 * concatenation and conversion, see Gosling, Joy, and Steele, <i>The Java Language
 * Specification</i>.
 * 
 * <p>
 * Unless otherwise noted, passing a <tt>null</tt> argument to a constructor or method in this class
 * will cause a {@link NullPointerException} to be thrown.
 */

public final class String implements java.io.Serializable, Comparable<String>, CharSequence {
	/**
	 * A Comparator that orders <code>String</code> objects as by <code>compareToIgnoreCase</code>.
	 * This comparator is serializable.
	 */
	public static final Comparator<String> CASE_INSENSITIVE_ORDER = null;

	/**
	 * Returns a String that represents the character sequence in the array specified.
	 * 
	 * @param data
	 *        the character array.
	 * @return a <code>String</code> that contains the characters of the character array.
	 */
	public static String copyValueOf(char[] data) {
		throw new RuntimeException();
	}

	/**
	 * Returns a String that represents the character sequence in the array specified.
	 * 
	 * @param data
	 *        the character array.
	 * @param offset
	 *        initial offset of the subarray.
	 * @param count
	 *        length of the subarray.
	 * @return a <code>String</code> that contains the characters of the specified subarray of the
	 *         character array.
	 */
	public static String copyValueOf(char[] data, int offset, int count) {
		throw new RuntimeException();
	}

	/**
	 * Code shared by String and StringBuffer to do searches. The source is the character array
	 * being searched, and the target is the string being searched for.
	 * 
	 * @param source
	 *        the characters being searched.
	 * @param sourceOffset
	 *        offset of the source string.
	 * @param sourceCount
	 *        count of the source string.
	 * @param target
	 *        the characters being searched for.
	 * @param targetOffset
	 *        offset of the target string.
	 * @param targetCount
	 *        count of the target string.
	 * @param fromIndex
	 *        the index to begin searching from.
	 */
	static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>boolean</code> argument.
	 * 
	 * @param b
	 *        a <code>boolean</code>.
	 * @return if the argument is <code>true</code>, a string equal to <code>"true"</code> is
	 *         returned; otherwise, a string equal to <code>"false"</code> is returned.
	 */
	public static String valueOf(boolean b) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>char</code> argument.
	 * 
	 * @param c
	 *        a <code>char</code>.
	 * @return a string of length <code>1</code> containing as its single character the argument
	 *         <code>c</code>.
	 */
	public static String valueOf(char c) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>char</code> array argument. The contents of
	 * the character array are copied; subsequent modification of the character array does not
	 * affect the newly created string.
	 * 
	 * @param data
	 *        a <code>char</code> array.
	 * @return a newly allocated string representing the same sequence of characters contained in
	 *         the character array argument.
	 */
	public static String valueOf(char[] data) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of a specific subarray of the <code>char</code> array
	 * argument.
	 * <p>
	 * The <code>offset</code> argument is the index of the first character of the subarray. The
	 * <code>count</code> argument specifies the length of the subarray. The contents of the
	 * subarray are copied; subsequent modification of the character array does not affect the newly
	 * created string.
	 * 
	 * @param data
	 *        the character array.
	 * @param offset
	 *        the initial offset into the value of the <code>String</code>.
	 * @param count
	 *        the length of the value of the <code>String</code>.
	 * @return a string representing the sequence of characters contained in the subarray of the
	 *         character array argument.
	 * @exception IndexOutOfBoundsException
	 *            if <code>offset</code> is negative, or <code>count</code> is negative, or
	 *            <code>offset+count</code> is larger than <code>data.length</code>.
	 */
	public static String valueOf(char[] data, int offset, int count) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>double</code> argument.
	 * <p>
	 * The representation is exactly the one returned by the <code>Double.toString</code> method of
	 * one argument.
	 * 
	 * @param d
	 *        a <code>double</code>.
	 * @return a string representation of the <code>double</code> argument.
	 * @see java.lang.Double#toString(double)
	 */
	public static String valueOf(double d) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>float</code> argument.
	 * <p>
	 * The representation is exactly the one returned by the <code>Float.toString</code> method of
	 * one argument.
	 * 
	 * @param f
	 *        a <code>float</code>.
	 * @return a string representation of the <code>float</code> argument.
	 * @see java.lang.Float#toString(float)
	 */
	public static String valueOf(float f) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>int</code> argument.
	 * <p>
	 * The representation is exactly the one returned by the <code>Integer.toString</code> method of
	 * one argument.
	 * 
	 * @param i
	 *        an <code>int</code>.
	 * @return a string representation of the <code>int</code> argument.
	 * @see java.lang.Integer#toString(int, int)
	 */
	public static String valueOf(int i) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>long</code> argument.
	 * <p>
	 * The representation is exactly the one returned by the <code>Long.toString</code> method of
	 * one argument.
	 * 
	 * @param l
	 *        a <code>long</code>.
	 * @return a string representation of the <code>long</code> argument.
	 * @see java.lang.Long#toString(long)
	 */
	public static String valueOf(long l) {
		throw new RuntimeException();
	}

	/**
	 * Returns the string representation of the <code>Object</code> argument.
	 * 
	 * @param obj
	 *        an <code>Object</code>.
	 * @return if the argument is <code>null</code>, then a string equal to <code>"null"</code>;
	 *         otherwise, the value of <code>obj.toString()</code> is returned.
	 * @see java.lang.Object#toString()
	 */
	public static String valueOf(Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Initializes a newly created {@code String} object so that it represents an empty character
	 * sequence. Note that use of this constructor is unnecessary since Strings are immutable.
	 */
	public String() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@code String} by decoding the specified array of bytes using the platform's
	 * default charset. The length of the new {@code String} is a function of the charset, and hence
	 * may not be equal to the length of the byte array.
	 * 
	 * @param bytes
	 *        The bytes to be decoded into characters
	 */
	public String(byte[] bytes) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@code String} by decoding the specified subarray of bytes using the
	 * platform's default charset. The length of the new {@code String} is a function of the
	 * charset, and hence may not be equal to the length of the subarray.
	 * 
	 * @param bytes
	 *        The bytes to be decoded into characters
	 * 
	 * @param offset
	 *        The index of the first byte to decode
	 * 
	 * @param length
	 *        The number of bytes to decode
	 * 
	 * @throws IndexOutOfBoundsException
	 *         If the {@code offset} and the {@code length} arguments index characters outside the
	 *         bounds of the {@code bytes} array
	 */
	public String(byte[] bytes, int offset, int length) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@code String} by decoding the specified subarray of bytes using the
	 * specified charset. The length of the new {@code String} is a function of the charset, and
	 * hence may not be equal to the length of the subarray.
	 * 
	 * @param bytes
	 *        The bytes to be decoded into characters
	 * 
	 * @param offset
	 *        The index of the first byte to decode
	 * 
	 * @param length
	 *        The number of bytes to decode
	 * 
	 * @param charsetName
	 *        The name of a supported charset
	 * 
	 * @throws UnsupportedEncodingException
	 *         If the named charset is not supported
	 * 
	 * @throws IndexOutOfBoundsException
	 *         If the {@code offset} and {@code length} arguments index characters outside the
	 *         bounds of the {@code bytes} array
	 */
	public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new {@code String} by decoding the specified array of bytes using the specified
	 * charset. The length of the new {@code String} is a function of the charset, and hence may not
	 * be equal to the length of the byte array.
	 * 
	 * @param bytes
	 *        The bytes to be decoded into characters
	 * 
	 * @param charsetName
	 *        The name of a supported charset
	 * 
	 * @throws UnsupportedEncodingException
	 *         If the named charset is not supported
	 */
	public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
		throw new RuntimeException();
	}

	/**
	 * Allocates a new {@code String} so that it represents the sequence of characters currently
	 * contained in the character array argument. The contents of the character array are copied;
	 * subsequent modification of the character array does not affect the newly created string.
	 * 
	 * @param value
	 *        The initial value of the string
	 */
	public String(char[] value) {
		throw new RuntimeException();
	}

	/**
	 * Allocates a new {@code String} that contains characters from a subarray of the character
	 * array argument. The {@code offset} argument is the index of the first character of the
	 * subarray and the {@code count} argument specifies the length of the subarray. The contents of
	 * the subarray are copied; subsequent modification of the character array does not affect the
	 * newly created string.
	 * 
	 * @param value
	 *        Array that is the source of characters
	 * 
	 * @param offset
	 *        The initial offset
	 * 
	 * @param count
	 *        The length
	 * 
	 * @throws IndexOutOfBoundsException
	 *         If the {@code offset} and {@code count} arguments index characters outside the bounds
	 *         of the {@code value} array
	 */
	public String(char[] value, int offset, int count) {
		throw new RuntimeException();
	}

	/**
	 * Initializes a newly created {@code String} object so that it represents the same sequence of
	 * characters as the argument; in other words, the newly created string is a copy of the
	 * argument string. Unless an explicit copy of {@code original} is needed, use of this
	 * constructor is unnecessary since Strings are immutable.
	 * 
	 * @param original
	 *        A {@code String}
	 */
	public String(String original) {
		throw new RuntimeException();
	}

	/**
	 * Allocates a new string that contains the sequence of characters currently contained in the
	 * string buffer argument. The contents of the string buffer are copied; subsequent modification
	 * of the string buffer does not affect the newly created string.
	 * 
	 * @param buffer
	 *        A {@code StringBuffer}
	 */
	public String(StringBuffer buffer) {
		throw new RuntimeException();
	}

	/**
	 * Allocates a new string that contains the sequence of characters currently contained in the
	 * string builder argument. The contents of the string builder are copied; subsequent
	 * modification of the string builder does not affect the newly created string.
	 * 
	 * <p>
	 * This constructor is provided to ease migration to {@code StringBuilder}. Obtaining a string
	 * from a string builder via the {@code toString} method is likely to run faster and is
	 * generally preferred.
	 * 
	 * @param builder
	 *        A {@code StringBuilder}
	 */
	public String(StringBuilder builder) {
		throw new RuntimeException();
	}

	/**
	 * Returns the <code>char</code> value at the specified index. An index ranges from
	 * <code>0</code> to <code>length() - 1</code>. The first <code>char</code> value of the
	 * sequence is at index <code>0</code>, the next at index <code>1</code>, and so on, as for
	 * array indexing.
	 * 
	 * @param index
	 *        the index of the <code>char</code> value.
	 * @return the <code>char</code> value at the specified index of this string. The first
	 *         <code>char</code> value is at index <code>0</code>.
	 * @exception IndexOutOfBoundsException
	 *            if the <code>index</code> argument is negative or not less than the length of this
	 *            string.
	 */
	public char charAt(int index) {
		throw new RuntimeException();
	}

	/**
	 * Compares two strings lexicographically. The comparison is based on the Unicode value of each
	 * character in the strings. The character sequence represented by this <code>String</code>
	 * object is compared lexicographically to the character sequence represented by the argument
	 * string. The result is a negative integer if this <code>String</code> object lexicographically
	 * precedes the argument string. The result is a positive integer if this <code>String</code>
	 * object lexicographically follows the argument string. The result is zero if the strings are
	 * equal; <code>compareTo</code> returns <code>0</code> exactly when the {@link #equals(Object)}
	 * method would return <code>true</code>.
	 * <p>
	 * This is the definition of lexicographic ordering. If two strings are different, then either
	 * they have different characters at some index that is a valid index for both strings, or their
	 * lengths are different, or both. If they have different characters at one or more index
	 * positions, let <i>k</i> be the smallest such index; then the string whose character at
	 * position <i>k</i> has the smaller value, as determined by using the &lt; operator,
	 * lexicographically precedes the other string. In this case, <code>compareTo</code> returns the
	 * difference of the two character values at position <code>k</code> in the two string -- that
	 * is, the value: <blockquote>
	 * 
	 * <pre>
	 * this.charAt(k) - anotherString.charAt(k)
	 * </pre>
	 * 
	 * </blockquote> If there is no index position at which they differ, then the shorter string
	 * lexicographically precedes the longer string. In this case, <code>compareTo</code> returns
	 * the difference of the lengths of the strings -- that is, the value: <blockquote>
	 * 
	 * <pre>
	 * this.length() - anotherString.length()
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param anotherString
	 *        the <code>String</code> to be compared.
	 * @return the value <code>0</code> if the argument string is equal to this string; a value less
	 *         than <code>0</code> if this string is lexicographically less than the string
	 *         argument; and a value greater than <code>0</code> if this string is lexicographically
	 *         greater than the string argument.
	 */
	public int compareTo(String anotherString) {
		throw new RuntimeException();
	}

	/**
	 * Compares two strings lexicographically, ignoring case differences. This method returns an
	 * integer whose sign is that of calling <code>compareTo</code> with normalized versions of the
	 * strings where case differences have been eliminated by calling
	 * <code>Character.toLowerCase(Character.toUpperCase(character))</code> on each character.
	 * <p>
	 * Note that this method does <em>not</em> take locale into account, and will result in an
	 * unsatisfactory ordering for certain locales. The java.text package provides
	 * <em>collators</em> to allow locale-sensitive ordering.
	 * 
	 * @param str
	 *        the <code>String</code> to be compared.
	 * @return a negative integer, zero, or a positive integer as the specified String is greater
	 *         than, equal to, or less than this String, ignoring case considerations.
	 */
	public int compareToIgnoreCase(String str) {
		throw new RuntimeException();
	}

	/**
	 * Concatenates the specified string to the end of this string.
	 * <p>
	 * If the length of the argument string is <code>0</code>, then this <code>String</code> object
	 * is returned. Otherwise, a new <code>String</code> object is created, representing a character
	 * sequence that is the concatenation of the character sequence represented by this
	 * <code>String</code> object and the character sequence represented by the argument string.
	 * <p>
	 * Examples: <blockquote>
	 * 
	 * <pre>
	 * "cares".concat("s") returns "caress"
	 * "to".concat("get").concat("her") returns "together"
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param str
	 *        the <code>String</code> that is concatenated to the end of this <code>String</code>.
	 * @return a string that represents the concatenation of this object's characters followed by
	 *         the string argument's characters.
	 */
	public String concat(String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns true if and only if this string contains the specified sequence of char values.
	 * 
	 * @param s
	 *        the sequence to search for
	 * @return true if this string contains <code>s</code>, false otherwise
	 * @throws NullPointerException
	 *         if <code>s</code> is <code>null</code>
	 */
	public boolean contains(CharSequence s) {
		throw new RuntimeException();
	}

	/**
	 * Compares this string to the specified {@code CharSequence}. The result is {@code true} if and
	 * only if this {@code String} represents the same sequence of char values as the specified
	 * sequence.
	 * 
	 * @param cs
	 *        The sequence to compare this {@code String} against
	 * 
	 * @return {@code true} if this {@code String} represents the same sequence of char values as
	 *         the specified sequence, {@code false} otherwise
	 */
	public boolean contentEquals(CharSequence cs) {
		throw new RuntimeException();
	}

	/**
	 * Compares this string to the specified {@code StringBuffer}. The result is {@code true} if and
	 * only if this {@code String} represents the same sequence of characters as the specified
	 * {@code StringBuffer}.
	 * 
	 * @param sb
	 *        The {@code StringBuffer} to compare this {@code String} against
	 * 
	 * @return {@code true} if this {@code String} represents the same sequence of characters as the
	 *         specified {@code StringBuffer}, {@code false} otherwise
	 */
	public boolean contentEquals(StringBuffer sb) {
		throw new RuntimeException();
	}

	/**
	 * Tests if this string ends with the specified suffix.
	 * 
	 * @param suffix
	 *        the suffix.
	 * @return <code>true</code> if the character sequence represented by the argument is a suffix
	 *         of the character sequence represented by this object; <code>false</code> otherwise.
	 *         Note that the result will be <code>true</code> if the argument is the empty string or
	 *         is equal to this <code>String</code> object as determined by the
	 *         {@link #equals(Object)} method.
	 */
	public boolean endsWith(String suffix) {
		throw new RuntimeException();
	}

	/**
	 * Compares this string to the specified object. The result is {@code true} if and only if the
	 * argument is not {@code null} and is a {@code String} object that represents the same sequence
	 * of characters as this object.
	 * 
	 * @param anObject
	 *        The object to compare this {@code String} against
	 * 
	 * @return {@code true} if the given object represents a {@code String} equivalent to this
	 *         string, {@code false} otherwise
	 * 
	 * @see #compareTo(String)
	 * @see #equalsIgnoreCase(String)
	 */
	public boolean equals(Object anObject) {
		throw new RuntimeException();
	}

	/**
	 * Compares this {@code String} to another {@code String}, ignoring case considerations. Two
	 * strings are considered equal ignoring case if they are of the same length and corresponding
	 * characters in the two strings are equal ignoring case.
	 * 
	 * <p>
	 * Two characters {@code c1} and {@code c2} are considered the same ignoring case if at least
	 * one of the following is true:
	 * <ul>
	 * <li>The two characters are the same (as compared by the {@code ==} operator)
	 * <li>Applying the method {@link java.lang.Character#toUpperCase(char)} to each character
	 * produces the same result
	 * <li>Applying the method {@link java.lang.Character#toLowerCase(char)} to each character
	 * produces the same result
	 * </ul>
	 * 
	 * @param anotherString
	 *        The {@code String} to compare this {@code String} against
	 * 
	 * @return {@code true} if the argument is not {@code null} and it represents an equivalent
	 *         {@code String} ignoring case; {@code false} otherwise
	 * 
	 * @see #equals(Object)
	 */
	public boolean equalsIgnoreCase(String anotherString) {
		throw new RuntimeException();
	}

	/**
	 * Encodes this {@code String} into a sequence of bytes using the platform's default charset,
	 * storing the result into a new byte array.
	 * 
	 * @return The resultant byte array
	 */
	public byte[] getBytes() {
		throw new RuntimeException();
	}

	/**
	 * Encodes this {@code String} into a sequence of bytes using the named charset, storing the
	 * result into a new byte array.
	 * 
	 * @param charsetName
	 *        The name of a supported charset
	 * 
	 * @return The resultant byte array
	 * 
	 * @throws UnsupportedEncodingException
	 *         If the named charset is not supported
	 */
	public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
		throw new RuntimeException();
	}

	/**
	 * Copies characters from this string into the destination character array.
	 * <p>
	 * The first character to be copied is at index <code>srcBegin</code>; the last character to be
	 * copied is at index <code>srcEnd-1</code> (thus the total number of characters to be copied is
	 * <code>srcEnd-srcBegin</code>). The characters are copied into the subarray of
	 * <code>dst</code> starting at index <code>dstBegin</code> and ending at index:
	 * <p>
	 * <blockquote>
	 * 
	 * <pre>
	 * dstbegin + (srcEnd - srcBegin) - 1
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param srcBegin
	 *        index of the first character in the string to copy.
	 * @param srcEnd
	 *        index after the last character in the string to copy.
	 * @param dst
	 *        the destination array.
	 * @param dstBegin
	 *        the start offset in the destination array.
	 * @exception IndexOutOfBoundsException
	 *            If any of the following is true:
	 *            <ul>
	 *            <li><code>srcBegin</code> is negative. <li><code>srcBegin</code> is greater than
	 *            <code>srcEnd</code> <li><code>srcEnd</code> is greater than the length of this
	 *            string <li><code>dstBegin</code> is negative <li><code>dstBegin+(srcEnd-srcBegin)
	 *            </code> is larger than <code>dst.length</code>
	 *            </ul>
	 */
	public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
		throw new RuntimeException();
	}

	/**
	 * Returns a hash code for this string. The hash code for a <code>String</code> object is
	 * computed as <blockquote>
	 * 
	 * <pre>
	 * s[0]*31^(n-1) + s[1]*31^(n-2) + ... + s[n-1]
	 * </pre>
	 * 
	 * </blockquote> using <code>int</code> arithmetic, where <code>s[i]</code> is the <i>i</i>th
	 * character of the string, <code>n</code> is the length of the string, and <code>^</code>
	 * indicates exponentiation. (The hash value of the empty string is zero.)
	 * 
	 * @return a hash code value for this object.
	 */
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified character. If a
	 * character with value <code>ch</code> occurs in the character sequence represented by this
	 * <code>String</code> object, then the index (in Unicode code units) of the first such
	 * occurrence is returned. For values of <code>ch</code> in the range from 0 to 0xFFFF
	 * (inclusive), this is the smallest value <i>k</i> such that: <blockquote>
	 * 
	 * <pre>
	 * this.charAt(<i>k</i>) == ch
	 * </pre>
	 * 
	 * </blockquote> is true. For other values of <code>ch</code>, it is the smallest value <i>k</i>
	 * such that: <blockquote>
	 * 
	 * <pre>
	 * this.codePointAt(<i>k</i>) == ch
	 * </pre>
	 * 
	 * </blockquote> is true. In either case, if no such character occurs in this string, then
	 * <code>-1</code> is returned.
	 * 
	 * @param ch
	 *        a character (Unicode code point).
	 * @return the index of the first occurrence of the character in the character sequence
	 *         represented by this object, or <code>-1</code> if the character does not occur.
	 */
	public int indexOf(int ch) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified character,
	 * starting the search at the specified index.
	 * <p>
	 * If a character with value <code>ch</code> occurs in the character sequence represented by
	 * this <code>String</code> object at an index no smaller than <code>fromIndex</code>, then the
	 * index of the first such occurrence is returned. For values of <code>ch</code> in the range
	 * from 0 to 0xFFFF (inclusive), this is the smallest value <i>k</i> such that: <blockquote>
	 * 
	 * <pre>
	 * (this.charAt(<i>k</i>) == ch) && (<i>k</i> &gt;= fromIndex)
	 * </pre>
	 * 
	 * </blockquote> is true. For other values of <code>ch</code>, it is the smallest value <i>k</i>
	 * such that: <blockquote>
	 * 
	 * <pre>
	 * (this.codePointAt(<i>k</i>) == ch) && (<i>k</i> &gt;= fromIndex)
	 * </pre>
	 * 
	 * </blockquote> is true. In either case, if no such character occurs in this string at or after
	 * position <code>fromIndex</code>, then <code>-1</code> is returned.
	 * 
	 * <p>
	 * There is no restriction on the value of <code>fromIndex</code>. If it is negative, it has the
	 * same effect as if it were zero: this entire string may be searched. If it is greater than the
	 * length of this string, it has the same effect as if it were equal to the length of this
	 * string: <code>-1</code> is returned.
	 * 
	 * <p>
	 * All indices are specified in <code>char</code> values (Unicode code units).
	 * 
	 * @param ch
	 *        a character (Unicode code point).
	 * @param fromIndex
	 *        the index to start the search from.
	 * @return the index of the first occurrence of the character in the character sequence
	 *         represented by this object that is greater than or equal to <code>fromIndex</code>,
	 *         or <code>-1</code> if the character does not occur.
	 */
	public int indexOf(int ch, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified substring.
	 * 
	 * <p>
	 * The returned index is the smallest value <i>k</i> for which: <blockquote>
	 * 
	 * <pre>
	 * this.startsWith(str, <i>k</i>)
	 * </pre>
	 * 
	 * </blockquote> If no such value of <i>k</i> exists, then {@code -1} is returned.
	 * 
	 * @param str
	 *        the substring to search for.
	 * @return the index of the first occurrence of the specified substring, or {@code -1} if there
	 *         is no such occurrence.
	 */
	public int indexOf(String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the first occurrence of the specified substring,
	 * starting at the specified index.
	 * 
	 * <p>
	 * The returned index is the smallest value <i>k</i> for which: <blockquote>
	 * 
	 * <pre>
	 * <i>k</i> &gt;= fromIndex && this.startsWith(str, <i>k</i>)
	 * </pre>
	 * 
	 * </blockquote> If no such value of <i>k</i> exists, then {@code -1} is returned.
	 * 
	 * @param str
	 *        the substring to search for.
	 * @param fromIndex
	 *        the index from which to start the search.
	 * @return the index of the first occurrence of the specified substring, starting at the
	 *         specified index, or {@code -1} if there is no such occurrence.
	 */
	public int indexOf(String str, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns a canonical representation for the string object.
	 * <p>
	 * A pool of strings, initially empty, is maintained privately by the class <code>String</code>.
	 * <p>
	 * When the intern method is invoked, if the pool already contains a string equal to this
	 * <code>String</code> object as determined by the {@link #equals(Object)} method, then the
	 * string from the pool is returned. Otherwise, this <code>String</code> object is added to the
	 * pool and a reference to this <code>String</code> object is returned.
	 * <p>
	 * It follows that for any two strings <code>s</code> and <code>t</code>,
	 * <code>s.intern()&nbsp;==&nbsp;t.intern()</code> is <code>true</code> if and only if
	 * <code>s.equals(t)</code> is <code>true</code>.
	 * <p>
	 * All literal strings and string-valued constant expressions are interned. String literals are
	 * defined in section 3.10.5 of the <cite>The Java&trade; Language Specification</cite>.
	 * 
	 * @return a string that has the same contents as this string, but is guaranteed to be from a
	 *         pool of unique strings.
	 */
	public String intern() {
		throw new RuntimeException();
	}

	/**
	 * Returns <tt>true</tt> if, and only if, {@link #length()} is <tt>0</tt>.
	 * 
	 * @return <tt>true</tt> if {@link #length()} is <tt>0</tt>, otherwise <tt>false</tt>
	 */
	public boolean isEmpty() {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the last occurrence of the specified character. For
	 * values of <code>ch</code> in the range from 0 to 0xFFFF (inclusive), the index (in Unicode
	 * code units) returned is the largest value <i>k</i> such that: <blockquote>
	 * 
	 * <pre>
	 * this.charAt(<i>k</i>) == ch
	 * </pre>
	 * 
	 * </blockquote> is true. For other values of <code>ch</code>, it is the largest value <i>k</i>
	 * such that: <blockquote>
	 * 
	 * <pre>
	 * this.codePointAt(<i>k</i>) == ch
	 * </pre>
	 * 
	 * </blockquote> is true. In either case, if no such character occurs in this string, then
	 * <code>-1</code> is returned. The <code>String</code> is searched backwards starting at the
	 * last character.
	 * 
	 * @param ch
	 *        a character (Unicode code point).
	 * @return the index of the last occurrence of the character in the character sequence
	 *         represented by this object, or <code>-1</code> if the character does not occur.
	 */
	public int lastIndexOf(int ch) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the last occurrence of the specified character,
	 * searching backward starting at the specified index. For values of <code>ch</code> in the
	 * range from 0 to 0xFFFF (inclusive), the index returned is the largest value <i>k</i> such
	 * that: <blockquote>
	 * 
	 * <pre>
	 * (this.charAt(<i>k</i>) == ch) && (<i>k</i> &lt;= fromIndex)
	 * </pre>
	 * 
	 * </blockquote> is true. For other values of <code>ch</code>, it is the largest value <i>k</i>
	 * such that: <blockquote>
	 * 
	 * <pre>
	 * (this.codePointAt(<i>k</i>) == ch) && (<i>k</i> &lt;= fromIndex)
	 * </pre>
	 * 
	 * </blockquote> is true. In either case, if no such character occurs in this string at or
	 * before position <code>fromIndex</code>, then <code>-1</code> is returned.
	 * 
	 * <p>
	 * All indices are specified in <code>char</code> values (Unicode code units).
	 * 
	 * @param ch
	 *        a character (Unicode code point).
	 * @param fromIndex
	 *        the index to start the search from. There is no restriction on the value of
	 *        <code>fromIndex</code>. If it is greater than or equal to the length of this string,
	 *        it has the same effect as if it were equal to one less than the length of this string:
	 *        this entire string may be searched. If it is negative, it has the same effect as if it
	 *        were -1: -1 is returned.
	 * @return the index of the last occurrence of the character in the character sequence
	 *         represented by this object that is less than or equal to <code>fromIndex</code>, or
	 *         <code>-1</code> if the character does not occur before that point.
	 */
	public int lastIndexOf(int ch, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the last occurrence of the specified substring. The
	 * last occurrence of the empty string "" is considered to occur at the index value
	 * {@code this.length()}.
	 * 
	 * <p>
	 * The returned index is the largest value <i>k</i> for which: <blockquote>
	 * 
	 * <pre>
	 * this.startsWith(str, <i>k</i>)
	 * </pre>
	 * 
	 * </blockquote> If no such value of <i>k</i> exists, then {@code -1} is returned.
	 * 
	 * @param str
	 *        the substring to search for.
	 * @return the index of the last occurrence of the specified substring, or {@code -1} if there
	 *         is no such occurrence.
	 */
	public int lastIndexOf(String str) {
		throw new RuntimeException();
	}

	/**
	 * Returns the index within this string of the last occurrence of the specified substring,
	 * searching backward starting at the specified index.
	 * 
	 * <p>
	 * The returned index is the largest value <i>k</i> for which: <blockquote>
	 * 
	 * <pre>
	 * <i>k</i> &lt;= fromIndex && this.startsWith(str, <i>k</i>)
	 * </pre>
	 * 
	 * </blockquote> If no such value of <i>k</i> exists, then {@code -1} is returned.
	 * 
	 * @param str
	 *        the substring to search for.
	 * @param fromIndex
	 *        the index to start the search from.
	 * @return the index of the last occurrence of the specified substring, searching backward from
	 *         the specified index, or {@code -1} if there is no such occurrence.
	 */
	public int lastIndexOf(String str, int fromIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns the length of this string. The length is equal to the number of <a
	 * href="Character.html#unicode">Unicode code units</a> in the string.
	 * 
	 * @return the length of the sequence of characters represented by this object.
	 */
	public int length() {
		throw new RuntimeException();
	}

	/**
	 * Tests if two string regions are equal.
	 * <p>
	 * A substring of this <tt>String</tt> object is compared to a substring of the argument
	 * <tt>other</tt>. The result is <tt>true</tt> if these substrings represent character sequences
	 * that are the same, ignoring case if and only if <tt>ignoreCase</tt> is true. The substring of
	 * this <tt>String</tt> object to be compared begins at index <tt>toffset</tt> and has length
	 * <tt>len</tt>. The substring of <tt>other</tt> to be compared begins at index <tt>ooffset</tt>
	 * and has length <tt>len</tt>. The result is <tt>false</tt> if and only if at least one of the
	 * following is true:
	 * <ul>
	 * <li><tt>toffset</tt> is negative.
	 * <li><tt>ooffset</tt> is negative.
	 * <li><tt>toffset+len</tt> is greater than the length of this <tt>String</tt> object.
	 * <li><tt>ooffset+len</tt> is greater than the length of the other argument.
	 * <li><tt>ignoreCase</tt> is <tt>false</tt> and there is some nonnegative integer <i>k</i> less
	 * than <tt>len</tt> such that: <blockquote>
	 * 
	 * <pre>
	 * this.charAt(toffset + k) != other.charAt(ooffset + k)
	 * </pre>
	 * 
	 * </blockquote>
	 * <li><tt>ignoreCase</tt> is <tt>true</tt> and there is some nonnegative integer <i>k</i> less
	 * than <tt>len</tt> such that: <blockquote>
	 * 
	 * <pre>
	 * Character.toLowerCase(this.charAt(toffset + k)) != Character.toLowerCase(other.charAt(ooffset + k))
	 * </pre>
	 * 
	 * </blockquote> and: <blockquote>
	 * 
	 * <pre>
	 * Character.toUpperCase(this.charAt(toffset + k)) != Character.toUpperCase(other.charAt(ooffset + k))
	 * </pre>
	 * 
	 * </blockquote>
	 * </ul>
	 * 
	 * @param ignoreCase
	 *        if <code>true</code>, ignore case when comparing characters.
	 * @param toffset
	 *        the starting offset of the subregion in this string.
	 * @param other
	 *        the string argument.
	 * @param ooffset
	 *        the starting offset of the subregion in the string argument.
	 * @param len
	 *        the number of characters to compare.
	 * @return <code>true</code> if the specified subregion of this string matches the specified
	 *         subregion of the string argument; <code>false</code> otherwise. Whether the matching
	 *         is exact or case insensitive depends on the <code>ignoreCase</code> argument.
	 */
	public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
		throw new RuntimeException();
	}

	/**
	 * Tests if two string regions are equal.
	 * <p>
	 * A substring of this <tt>String</tt> object is compared to a substring of the argument other.
	 * The result is true if these substrings represent identical character sequences. The substring
	 * of this <tt>String</tt> object to be compared begins at index <tt>toffset</tt> and has length
	 * <tt>len</tt>. The substring of other to be compared begins at index <tt>ooffset</tt> and has
	 * length <tt>len</tt>. The result is <tt>false</tt> if and only if at least one of the
	 * following is true:
	 * <ul>
	 * <li><tt>toffset</tt> is negative.
	 * <li><tt>ooffset</tt> is negative.
	 * <li><tt>toffset+len</tt> is greater than the length of this <tt>String</tt> object.
	 * <li><tt>ooffset+len</tt> is greater than the length of the other argument.
	 * <li>There is some nonnegative integer <i>k</i> less than <tt>len</tt> such that:
	 * <tt>this.charAt(toffset+<i>k</i>)&nbsp;!=&nbsp;other.charAt(ooffset+<i>k</i>)</tt>
	 * </ul>
	 * 
	 * @param toffset
	 *        the starting offset of the subregion in this string.
	 * @param other
	 *        the string argument.
	 * @param ooffset
	 *        the starting offset of the subregion in the string argument.
	 * @param len
	 *        the number of characters to compare.
	 * @return <code>true</code> if the specified subregion of this string exactly matches the
	 *         specified subregion of the string argument; <code>false</code> otherwise.
	 */
	public boolean regionMatches(int toffset, String other, int ooffset, int len) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new string resulting from replacing all occurrences of <code>oldChar</code> in this
	 * string with <code>newChar</code>.
	 * <p>
	 * If the character <code>oldChar</code> does not occur in the character sequence represented by
	 * this <code>String</code> object, then a reference to this <code>String</code> object is
	 * returned. Otherwise, a new <code>String</code> object is created that represents a character
	 * sequence identical to the character sequence represented by this <code>String</code> object,
	 * except that every occurrence of <code>oldChar</code> is replaced by an occurrence of
	 * <code>newChar</code>.
	 * <p>
	 * Examples: <blockquote>
	 * 
	 * <pre>
	 * "mesquite in your cellar".replace('e', 'o')
	 *         returns "mosquito in your collar"
	 * "the war of baronets".replace('r', 'y')
	 *         returns "the way of bayonets"
	 * "sparring with a purple porpoise".replace('p', 't')
	 *         returns "starring with a turtle tortoise"
	 * "JonL".replace('q', 'x') returns "JonL" (no change)
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param oldChar
	 *        the old character.
	 * @param newChar
	 *        the new character.
	 * @return a string derived from this string by replacing every occurrence of
	 *         <code>oldChar</code> with <code>newChar</code>.
	 */
	public String replace(char oldChar, char newChar) {
		throw new RuntimeException();
	}

	/**
	 * Replaces each substring of this string that matches the literal target sequence with the
	 * specified literal replacement sequence. The replacement proceeds from the beginning of the
	 * string to the end, for example, replacing "aa" with "b" in the string "aaa" will result in
	 * "ba" rather than "ab".
	 * 
	 * @param target
	 *        The sequence of char values to be replaced
	 * @param replacement
	 *        The replacement sequence of char values
	 * @return The resulting string
	 * @throws NullPointerException
	 *         if <code>target</code> or <code>replacement</code> is <code>null</code>.
	 */
	public String replace(CharSequence target, CharSequence replacement) {
		throw new RuntimeException();
	}

	/**
	 * Tests if this string starts with the specified prefix.
	 * 
	 * @param prefix
	 *        the prefix.
	 * @return <code>true</code> if the character sequence represented by the argument is a prefix
	 *         of the character sequence represented by this string; <code>false</code> otherwise.
	 *         Note also that <code>true</code> will be returned if the argument is an empty string
	 *         or is equal to this <code>String</code> object as determined by the
	 *         {@link #equals(Object)} method.
	 */
	public boolean startsWith(String prefix) {
		throw new RuntimeException();
	}

	/**
	 * Tests if the substring of this string beginning at the specified index starts with the
	 * specified prefix.
	 * 
	 * @param prefix
	 *        the prefix.
	 * @param toffset
	 *        where to begin looking in this string.
	 * @return <code>true</code> if the character sequence represented by the argument is a prefix
	 *         of the substring of this object starting at index <code>toffset</code>;
	 *         <code>false</code> otherwise. The result is <code>false</code> if
	 *         <code>toffset</code> is negative or greater than the length of this
	 *         <code>String</code> object; otherwise the result is the same as the result of the
	 *         expression
	 * 
	 *         <pre>
	 * this.substring(toffset).startsWith(prefix)
	 * </pre>
	 */
	public boolean startsWith(String prefix, int toffset) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new character sequence that is a subsequence of this sequence.
	 * 
	 * <p>
	 * An invocation of this method of the form
	 * 
	 * <blockquote>
	 * 
	 * <pre>
	 * str.subSequence(begin, end)
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * behaves in exactly the same way as the invocation
	 * 
	 * <blockquote>
	 * 
	 * <pre>
	 * str.substring(begin, end)
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * This method is defined so that the <tt>String</tt> class can implement the
	 * {@link CharSequence} interface.
	 * </p>
	 * 
	 * @param beginIndex
	 *        the begin index, inclusive.
	 * @param endIndex
	 *        the end index, exclusive.
	 * @return the specified subsequence.
	 * 
	 * @throws IndexOutOfBoundsException
	 *         if <tt>beginIndex</tt> or <tt>endIndex</tt> are negative, if <tt>endIndex</tt> is
	 *         greater than <tt>length()</tt>, or if <tt>beginIndex</tt> is greater than
	 *         <tt>startIndex</tt>
	 */
	public CharSequence subSequence(int beginIndex, int endIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new string that is a substring of this string. The substring begins with the
	 * character at the specified index and extends to the end of this string.
	 * <p>
	 * Examples: <blockquote>
	 * 
	 * <pre>
	 * "unhappy".substring(2) returns "happy"
	 * "Harbison".substring(3) returns "bison"
	 * "emptiness".substring(9) returns "" (an empty string)
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param beginIndex
	 *        the beginning index, inclusive.
	 * @return the specified substring.
	 * @exception IndexOutOfBoundsException
	 *            if <code>beginIndex</code> is negative or larger than the length of this
	 *            <code>String</code> object.
	 */
	public String substring(int beginIndex) {
		throw new RuntimeException();
	}

	/**
	 * Returns a new string that is a substring of this string. The substring begins at the
	 * specified <code>beginIndex</code> and extends to the character at index
	 * <code>endIndex - 1</code>. Thus the length of the substring is
	 * <code>endIndex-beginIndex</code>.
	 * <p>
	 * Examples: <blockquote>
	 * 
	 * <pre>
	 * "hamburger".substring(4, 8) returns "urge"
	 * "smiles".substring(1, 5) returns "mile"
	 * </pre>
	 * 
	 * </blockquote>
	 * 
	 * @param beginIndex
	 *        the beginning index, inclusive.
	 * @param endIndex
	 *        the ending index, exclusive.
	 * @return the specified substring.
	 * @exception IndexOutOfBoundsException
	 *            if the <code>beginIndex</code> is negative, or <code>endIndex</code> is larger
	 *            than the length of this <code>String</code> object, or <code>beginIndex</code> is
	 *            larger than <code>endIndex</code>.
	 */
	public String substring(int beginIndex, int endIndex) {
		throw new RuntimeException();
	}

	/**
	 * Converts this string to a new character array.
	 * 
	 * @return a newly allocated character array whose length is the length of this string and whose
	 *         contents are initialized to contain the character sequence represented by this
	 *         string.
	 */
	public char[] toCharArray() {
		throw new RuntimeException();
	}

	/**
	 * Converts all of the characters in this <code>String</code> to lower case using the rules of
	 * the default locale. This is equivalent to calling
	 * <code>toLowerCase(Locale.getDefault())</code>.
	 * 
	 * @return the <code>String</code>, converted to lowercase.
	 */
	public String toLowerCase() {
		throw new RuntimeException();
	}

	/**
	 * This object (which is already a string!) is itself returned.
	 * 
	 * @return the string itself.
	 */
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Converts all of the characters in this <code>String</code> to upper case using the rules of
	 * the default locale. This method is equivalent to
	 * <code>toUpperCase(Locale.getDefault())</code>.
	 * 
	 * @return the <code>String</code>, converted to uppercase.
	 */
	public String toUpperCase() {
		throw new RuntimeException();
	}

	/**
	 * Returns a copy of the string, with leading and trailing whitespace omitted.
	 * <p>
	 * If this <code>String</code> object represents an empty character sequence, or the first and
	 * last characters of character sequence represented by this <code>String</code> object both
	 * have codes greater than <code>'&#92;u0020'</code> (the space character), then a reference to
	 * this <code>String</code> object is returned.
	 * <p>
	 * Otherwise, if there is no character with a code greater than <code>'&#92;u0020'</code> in the
	 * string, then a new <code>String</code> object representing an empty string is created and
	 * returned.
	 * <p>
	 * Otherwise, let <i>k</i> be the index of the first character in the string whose code is
	 * greater than <code>'&#92;u0020'</code>, and let <i>m</i> be the index of the last character
	 * in the string whose code is greater than <code>'&#92;u0020'</code>. A new <code>String</code>
	 * object is created, representing the substring of this string that begins with the character
	 * at index <i>k</i> and ends with the character at index <i>m</i>-that is, the result of
	 * <code>this.substring(<i>k</i>,&nbsp;<i>m</i>+1)</code>.
	 * <p>
	 * This method may be used to trim whitespace (as defined above) from the beginning and end of a
	 * string.
	 * 
	 * @return A copy of this string with leading and trailing white space removed, or this string
	 *         if it has no leading or trailing white space.
	 */
	public String trim() {
		throw new RuntimeException();
	}

}
