/*
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */

package com.microej.wear.services;

import java.io.File;

import com.microej.wear.components.UpdateListener;

/**
 * This service allows Features to control the lifecycle of other Features.
 */
public interface FeatureService {

	/**
	 * Installs the feature of the given feature file.
	 * 
	 * @param featureFile
	 *            a feature file
	 * @return the UUID of the installed feature
	 */
	public byte[] install(File featureFile);

	/**
	 * Uninstalls the feature identified by the given UUID.
	 *
	 * @param featureUID
	 *            the UUID of an installed feature
	 */
	public void uninstall(byte[] featureUID);

	/**
	 * Adds the given {@link UpdateListener} to the list of listeners that are notified when an app has been updated on
	 * the device.
	 *
	 * @param listener
	 *            the new listener to add
	 */
	void addUpdateListener(UpdateListener listener);

	/**
	 * Removes the given {@link UpdateListener} from the list of listeners that are notified when an app has been
	 * updated on the device.
	 *
	 * <p>
	 * Does nothing if the listener is not registered.
	 *
	 * @param listener
	 *            the listener to be removed
	 */
	void removeUpdateListener(UpdateListener listener);
}
