/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.net;

import android.net.NetworkCapabilities;

/**
 * A network.
 */
public class Network extends android.net.Network {

	private final String networkInterface;
	private boolean available;
	private NetworkCapabilities capabilities;
	private boolean init;

	private boolean isPresent;

	/**
	 * Instantiates a {@link Network}.
	 *
	 * @param networkInterface
	 *            the network interface name, cannot be <code>null</code>.
	 */
	public Network(String networkInterface) {
		this.networkInterface = networkInterface;
		this.init = false;
		this.capabilities = new NetworkCapabilities();
		isPresent = true;
	}

	/**
	 * Gets the isPresent.
	 *
	 * @return the isPresent.
	 */
	public boolean isPresent() {
		return isPresent;
	}

	/**
	 * Sets the isPresent.
	 *
	 * @param isPresent
	 *            the isPresent to set.
	 */
	public void setPresent(boolean isPresent) {
		this.isPresent = isPresent;
	}

	/**
	 * Gets the network Interface.
	 *
	 * @return the networkInterface.
	 */
	public String getNetworkInterface() {
		return this.networkInterface;
	}

	/**
	 * Checks whether the network is available.
	 *
	 * @return the availability.
	 */
	public boolean isAvailable() {
		return this.available;
	}

	/**
	 * Sets whether the network is available.
	 *
	 * @param available
	 *            the availability.
	 */
	public void setAvailable(boolean available) {
		this.available = available;
		this.init = true;
	}

	/**
	 * Gets the capabilities.
	 *
	 * @return the capabilities.
	 */
	public NetworkCapabilities getCapabilities() {
		return this.capabilities;
	}

	/**
	 * Sets the capabilities.
	 *
	 * @param capabilities
	 *            the capabilities to set, cannot be <code>null</code>.
	 */
	public void setCapabilities(NetworkCapabilities capabilities) {
		this.capabilities = capabilities;
	}

	/**
	 * Checks whether the network is initialised.
	 *
	 * @return <code>true</code> if the network is initialised.
	 */
	public boolean isInitialised() {
		return this.init;
	}

	/**
	 * Checks whether the network will change or has not been initialised yet.
	 *
	 * @param available
	 *            the new state.
	 * @return <code>true</code> if the network status change.
	 */
	public boolean willChanged(boolean available) {
		return (available != this.available) || !this.init;
	}

	/**
	 *
	 * Checks if the Network state will change if set a new capability.
	 *
	 * @param capabilities
	 *            the new capabilities, cannot be <code>null</code>.
	 * @return <code>true</code> if it will change.
	 */
	public boolean willChanged(NetworkCapabilities capabilities) {
		return !this.capabilities.equals(capabilities);
	}
}
