/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class SendReadResponseCommand extends Command<Boolean> {

	private final short connHandle;
	private final short attributeHandle;
	private final byte status;
	private final byte[] value;
	private final int valueSize;

	public SendReadResponseCommand(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
		this.connHandle = connHandle;
		this.attributeHandle = attributeHandle;
		this.status = status;
		this.value = value;
		this.valueSize = valueSize;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_READ_RESPONSE;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
		sender.sendInt(this.attributeHandle);
		sender.sendInt(this.status);
		sender.sendByteArray(this.value, 0, this.valueSize);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
