package java.io;

/**
 * This class implements an output stream in which the data is written into a byte array. The buffer
 * automatically grows as data is written to it. The data can be retrieved using
 * <code>toByteArray()</code> and <code>toString()</code>.
 * <p>
 * Closing a <code>ByteArrayOutputStream</code> has no effect. The methods in this class can be called
 * after the stream has been closed without generating an <code>IOException</code>.
 */
public class ByteArrayOutputStream extends OutputStream {
	/**
	 * The buffer where data is stored.
	 */
	protected byte[] buf;
	/**
	 * The number of valid bytes in the buffer.
	 */
	protected int count;

	/**
	 * Creates a new byte array output stream. The buffer capacity is initially 32 bytes, though its
	 * size increases if necessary.
	 */
	public ByteArrayOutputStream() {
		throw new RuntimeException();
	}

	/**
	 * Creates a new byte array output stream, with a buffer capacity of the specified size, in bytes.
	 *
	 * @param size
	 *        the initial size.
	 * @exception IllegalArgumentException
	 *            if size is negative.
	 */
	public ByteArrayOutputStream(int size) {
		throw new RuntimeException();
	}

	/**
	 * Closing a <code>ByteArrayOutputStream</code> has no effect. The methods in this class can be called
	 * after the stream has been closed without generating an <code>IOException</code>.
	 */
	@Override
	public void close() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Resets the <code>count</code> field of this byte array output stream to zero, so that all
	 * currently accumulated output in the output stream is discarded. The output stream can be used
	 * again, reusing the already allocated buffer space.
	 *
	 * @see java.io.ByteArrayInputStream#count
	 */
	public void reset() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current size of the buffer.
	 *
	 * @return the value of the <code>count</code> field, which is the number of valid bytes in this
	 *         output stream.
	 * @see java.io.ByteArrayOutputStream#count
	 */
	public int size() {
		throw new RuntimeException();
	}

	/**
	 * Creates a newly allocated byte array. Its size is the current size of this output stream and the
	 * valid contents of the buffer have been copied into it.
	 *
	 * @return the current contents of this output stream, as a byte array.
	 * @see java.io.ByteArrayOutputStream#size()
	 */
	public byte[] toByteArray() {
		throw new RuntimeException();
	}

	/**
	 * Converts the buffer's contents into a string decoding bytes using the platform's default
	 * character set. The length of the new <code>String</code> is a function of the character set, and
	 * hence may not be equal to the size of the buffer.
	 *
	 * @return String decoded from the buffer's contents.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

	/**
	 * Writes <code>len</code> bytes from the specified byte array starting at offset <code>off</code>
	 * to this byte array output stream.
	 *
	 * @param b
	 *        the data.
	 * @param off
	 *        the start offset in the data.
	 * @param len
	 *        the number of bytes to write.
	 */
	@Override
	public void write(byte[] b, int off, int len) {
		throw new RuntimeException();
	}

	/**
	 * Writes the specified byte to this byte array output stream.
	 *
	 * @param b
	 *        the byte to be written.
	 */
	@Override
	public void write(int b) {
		throw new RuntimeException();
	}

	/**
	 * Writes the complete contents of this byte array output stream to the specified output stream
	 * argument, as if by calling the output stream's write method using
	 * <code>out.write(buf, 0, count)</code>.
	 *
	 * @param out
	 *        the output stream to which to write the data.
	 * @exception IOException
	 *            if an I/O error occurs.
	 */
	public void writeTo(OutputStream out) throws IOException {
		throw new RuntimeException();
	}

}