/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Character}. This converter creates a clone of the original {@link Character}.
 */
public class CharacterConverter implements Converter<Character> {

	@Override
	public Character convert(Character arg0, Feature targetOwner) throws IllegalAccessError {
		final char value = arg0.charValue();
		RunnableWithResult<Character> runnable = new RunnableWithResult<Character>() {
			@Override
			public Character runWithResult() {
				return new Character(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Character> getType() {
		return Character.class;
	}

}