/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.outline;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.mwt.util.Outlineable;
import ej.mwt.util.Size;

/**
 * Represents an outline that wraps a rectangle.
 * <p>
 * An outline is used to wrap the content of a widget. The widget is wrapped in the following sequence: first the
 * padding, then the border, and finally the margin.<br>
 * <img src="../doc-files/boxmodel.png" alt="Outlines model.">
 *
 * @see ej.mwt.style.Style#getMargin()
 * @see ej.mwt.style.Style#getBorder()
 * @see ej.mwt.style.Style#getPadding()
 *
 */
public interface Outline {

	/**
	 * Removes the thickness of this outline from the given object.
	 *
	 * @param outlineable
	 *            the object to unwrap.
	 */
	void apply(Outlineable outlineable);

	/**
	 * Applies the outline on a graphics context.
	 *
	 * @param g
	 *            the graphics context.
	 * @param size
	 *            the size to apply on.
	 */
	void apply(GraphicsContext g, Size size);

	@Override
	boolean equals(@Nullable Object obj);

	@Override
	int hashCode();
}
