/*
 * Java
 *
 * Copyright 2017-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.util.text;

import java.text.DateFormatSymbols;

/**
 * Symbols computing the short format from the full length ones.
 */
public class ComputeShortFormatSymbols extends DateFormatSymbols {

	private static final int SHORT_SIZE = 3;

	@Override
	public String getShortMonth(int i) {
		return super.getMonth(i).substring(0, SHORT_SIZE);
	}

	@Override
	public String[] getShortMonths() {
		String[] months = super.getShortMonths();
		if (months == null) {
			String[] fullMonths = getMonths();
			int length = fullMonths.length;
			months = new String[length];
			for (int i = 0; i < length; i++) {
				months[i] = fullMonths[i].substring(0, SHORT_SIZE);
			}
			setShortMonths(months);
		}
		return months;
	}

	@Override
	public String getShortWeekday(int i) {
		return super.getWeekday(i).substring(0, SHORT_SIZE);
	}

	@Override
	public String[] getShortWeekdays() {
		String[] days = super.getShortWeekdays();
		if (days == null) {
			String[] fullDays = getWeekdays();
			int length = fullDays.length;
			days = new String[length];
			for (int i = 0; i < length; i++) {
				days[i] = fullDays[i].substring(0, SHORT_SIZE);
			}
			setShortWeekdays(days);
		}
		return days;
	}
}
