/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class PairReplyCommand extends Command<Boolean> {

	private final short connHandle;
	private final boolean accept;

	public PairReplyCommand(short connHandle, boolean accept) {
		this.connHandle = connHandle;
		this.accept = accept;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_PAIR_REPLY;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
		sender.sendBoolean(this.accept);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
