/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * TERMS OF USE - EASING EQUATIONS
 * Open source under the BSD License.
 *
 * Copyright © 2001 Robert Penner
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * Neither the name of the author nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 */
package ej.motion.quad;

import ej.motion.AbstractMotion;

/**
 * Represents a ease in/out motion: starts at a steady speed, then slows down to a stop.
 */
public class QuadEaseInOutMotion extends AbstractMotion {

	private static final float ROUND = 0.5f;

	/**
	 * Creates a ease in/out motion for a move from start to stop.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 * @param maxDuration
	 *            the maximum duration of the motion.
	 */
	public QuadEaseInOutMotion(int start, int stop, long maxDuration) {
		super(start, stop, maxDuration);
	}

	@Override
	protected int computeCurrentValue(long currentTime) {
		float t = (float) (currentTime << 1) / this.duration;
		int delay = this.stop - this.start;
		float startPlusRound = this.start + ROUND;
		float halfDelay = (float) delay / 2;
		if (t < 1) {
			return (int) (startPlusRound + halfDelay * (t * t));
		} else {
			t--;
			return (int) (startPlusRound - halfDelay * (t * (t - 2) - 1));
		}
	}
}
