/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion;

import ej.motion.util.TossHelper;

/**
 * A motion manager groups the 3 derivations of the same effect: ease in, ease out, ease in out.
 */
public interface MotionManager {

	/**
	 * Moves from start to stop with a time constraint.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 * @param duration
	 *            the duration of the motion.
	 * @return the motion for the move.
	 */
	Motion easeIn(int start, int stop, long duration);

	/**
	 * Moves from start to stop with a time constraint.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 * @param duration
	 *            the duration of the motion.
	 * @return the motion for the move.
	 */
	Motion easeOut(int start, int stop, long duration);

	/**
	 * Moves from start to stop with a time constraint.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 * @param duration
	 *            the duration of the motion.
	 * @return the motion for the move.
	 */
	Motion easeInOut(int start, int stop, long duration);

	/**
	 * Moves from start with an initial speed. Movement is limited to min or max depending on the direction.
	 *
	 * @param start
	 *            the start value.
	 * @param min
	 *            the minimum bound.
	 * @param max
	 *            the maximum bound.
	 * @param initialSpeed
	 *            the initial move speed (in pixels/second).
	 * @param duration
	 *            the duration of the motion.
	 * @return the motion for the toss.
	 *
	 * @deprecated use {@link TossHelper} methods instead.
	 */
	@Deprecated
	Motion toss(int start, int min, int max, float initialSpeed, long duration);

}
