package ej.ecom.io;

import java.io.IOException;

/** 
 * This class defines methods for opening a {@link Connection} from an URL.
 * The URL format (which complies with RFC 2396) is on the following format:
 * <pre>
 * [protocol]:[name](;[param])*
 * </pre>
 * Where:
 * <ul>
 * <li><code>protocol</code> defines the connection protocol (for example: <code>comm</code>, <code>http</code>)</li>
 * <li><code>name</code> is the name of the connection to open (for example: <code>/dev/ttyS0</code>, <code>192.168.1.1</code>)</li>
 * <li><code>param</code> is a connection specific parameter
 * </ul>  
 * <p>
 * The factory corresponding to the extracted protocol is dynamically bound and its {@link ConnectionFactory#open} method is called on the specified URL.
 * </p>
 * @see ConnectionFactory
 */
public class Connector {

	/** 
	 * Access mode READ.
	 */
	public static final int READ = 1;

	/**
	 * Access mode WRITE.
	 */
	public static final int WRITE = 2;

	/** 
	 * Access mode READ/WRITE.
	 */
	public static final int READ_WRITE = 3;
	
	private Connector(){
		throw new RuntimeException();
	}

	/** 
	 * Create and open a Connection from an URL.
	 * @param url the connection URL to open
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 * @throws SecurityException if a security manager exists and it does not allow the caller to open such kind of connection
	 * @return the open {@link Connection}.
	 */
	public static Connection open(String url) throws IOException{
		throw new RuntimeException();
	}

	/** 
	 * Create and open a Connection.
	 * @param url the connection URL to open
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 * @throws SecurityException if a security manager exists and it does not allow the caller to open such kind of connection
	 * @return the open {@link Connection}.
	 */
	public static Connection open(String url, int mode) throws IOException{
		throw new RuntimeException();
	}

	/** 
	 * Create and open a Connection.
	 * @param url the connection URL to open
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 * @throws SecurityException if a security manager exists and it does not allow the caller to open such kind of connection
	 * @return the open {@link Connection}.
	 */
	public static Connection open(String url, int mode, boolean timeouts) throws IOException{
		throw new RuntimeException();
	}

	/** 
	 * Create and open a Connection with the specified {@link ConnectionFactory} package name.
	 * @param url the connection URL to open
	 * @param packageName the package name prefix of the {@link ConnectionFactory} to bind
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 * @throws SecurityException if a security manager exists and it does not allow the caller to open such kind of connection
	 * @see ConnectionFactory
	 * @return the open {@link Connection}.
	 */
	public static Connection open(String packageName, String url, int mode, boolean timeouts) throws IOException{
		throw new RuntimeException();
	}
}