# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 3.4.0 - 2023-10-23

### Added

  - Add the pre-multiplied image formats `ARGB8888_PRE`, `ARGB1555_PRE` and `ARGB4444_PRE`.

## 3.3.0 - 2023-07-17

### Added

  - Add the flag `GraphicsContext.DRAWING_LOG_MISSING_CHARACTER`, stating that an undefined character was drawn.

## 3.2.0 - 2023-05-03

### Added

  - Introduce an enum listing all the available formats for buffered images.
  - Introduce a new constructor to create buffered images with a specific (standard or custom) format.
  - Add `GraphicsContext.getAndClearDrawingLogFlags()` and `GraphicsContext.checkDrawingLogFlags()` to handle incidents in drawing operations.
  - Add `MicroUIException.DRAWING_ERROR` error code to signify an error during a drawing operation.
  - Add `MicroUIException.IMAGE_UNSUPPORTED_FORMAT` error code to signify an error when a buffered image cannot be created.

## 3.1.1 - 2022-04-28

### Fixed

  - Fix comment of `Displayable.requestRender()`: missing a parenthesis.
  - Fix comment of `Displayable.onShown()`: nothing is performed by default.
  - Fix comment of `Display.waitFlushCompleted()`: it is not allowed to call this method from a `callSerially`.
  - Fix comment of `GraphicsContext.readPixels()` and `Image.readPixels()`: the `array` refers to the application's array, not an internal array. 
  - Clarify comments of `Painter.drawChar()` and `Font.charWidth()` about surrogate characters.

## 3.1.0 - 2021-07-16

### Added 

  - Add `Display.cancelCallOnFlushCompleted()` to unregister the event set by  `Display.callOnFlushCompleted()`.
  - Add `GenericEventGenerator.eventReceived()` and `GenericEventGenerator.eventsReceived()` with a handler to be able to immediately handle native generic events like MicroUI events (like other event generators)).
   
### Changed

  - Throw a dedicated MicroUIException when the pool of event generators is full.

### Fixed

  - Fix comment of `Display.waitFlushCompleted()`: the exception is a MicroUIException.

## 3.0.4 - 2021-03-11

### Fixed

  - Review changelog content. 

## 3.0.3 - 2020-12-09

### Fixed

  - Fix MMM dependencies. 

## 3.0.2 - 2020-12-03

### Fixed

  - Fix visibility of Display constructor. 
  - Clarify clip VS translate. 
  - Clarify antialiased shape bounding box. 

## 3.0.1 - 2020-09-21

### Fixed

  - Clarify `Display.getDisplay()` exception. 

## 3.0.0 - 2020-07-28

### Added 

  - Add `getSNIContext()` to retrieve a context to give to a SNI native method.

### Changed

  - All drawings methods have been extracted from `GraphicsContext` to `Painter` classes.
  - Extract `ej.microui.display.shape`,  `ej.microui.display.transform` and polygon in another library: MicroUI Drawing (`ej.api.drawing`).
  - Split `Image` in `Image`, `ResourceImage` and `BufferedImage`.
  - MicroUI `UncaughtExceptionHandler` is replaced by `Thread's UncaughtExceptionHandler`.
  - Move events serializer notion from `Display` to `MicroUI`.
  - `GraphicsContext` does not hold anymore a font.
  - Retrieve a font thanks its path, not more thanks its characteristics.
  - Use same specification for draw/fill rectangle/round rectangle: right limit is `x + width - 1` (idem for `y`).
  - Use same specification for draw/fill circle/arc/ellipse : empty diameter/size means _no drawing_.
  - Define an angle by a float (shapes, image rotation).
  - Review ellipsis truncation mechanism.

### Removed

  - Notion of multiple displays; several APIs don't take anymore a display as parameter.
  - Autoclosable images (image cache).
  - Font dynamic styles and ratios: a font is immutable.
  - Deprecated APIs.

### Class per Class

**ej.microui.MicroUI**
  - [Added] `callSerially(Runnable)`: moved from `Display` class.
  - [Added] `isUIThread()` and `isUIThread(Thread)`: replaces `Display.isDisplayThread()` and `Display.isDisplayThread(Thread)`.
  - [Removed] `setUncaughtExceptionHandler()`: use `Thread.setUncaughtExceptionHandler()` instead.

**ej.microui.MicroUIException**
  - [Added] All MicroUI exceptions are merged in an unique class, each exception has got an unique identifier.

**ej.microui.UncaughtExceptionHandler**
  - [Removed] Use `Thread.setUncaughtExceptionHandler()` instead.

**ej.microui.display.BufferedImage**
  - [Added] `BufferedImage(int,int)`: replaces `Image.createImage(int,int)` by a dedicated class.
  - [Added] `getGraphicsContext()`: replaces `Image.getGraphicsContext()`.
  - [Changed] Background is not filled in white when creating a buffered image.

**ej.microui.display.Colors**
  - [Changed] Interface has been replaced by a final class.

**ej.microui.display.Display**
  - [Added] `isShown(Displayable)`, `requestShow(Displayable)` and `requestHide()`: replace respectively `Displayable.isShown()`, `Displayable.show()` and `Displayable.hide()`.
  - [Added] `requestRender()`: replaces `Displayable.repaint()`.
  - [Added] `waitFlushCompleted()`: locks until previous call to `flush()` is performed.
  - [Changed] `getNewExplicitFlush()`, `getNewGraphicsContext()`, `requestFlush()` and notion of `ExplicitFlush`: replaced by `flush()` and `getGraphicsContext()`.
  - [Changed] `getBPP()`: replaced by `getPixelDepth()`.
  - [Changed] `getEventSerializer()`: replaced by `getEventHandler()`
  - [Removed] `getAllDisplays()` and `getDefaultDisplay()`: notion of multiple displays has been removed. Only one display is available at any time. Use `getDisplay()` instead.
  - [Removed] `callSerially(Runnable)`: moved in `MicroUI` class.
  - [Removed] `getBacklightColor()`.
  - [Removed] `getNumberOfAlphaLevels()`.
  - [Removed] `getScreenshot()` and `getScreenshot(int,int,int,int)`: use `Painter.drawDisplayRegion()` instead.
  - [Removed] `handleEvent(int)`: use `getEventHandler().handleEvent(int)` instead.
  - [Removed] `isDisplayThread()` and `isDisplayThread(Thread)`: replaced by `Display.isUIThread()` and `Display.isUIThread(Thread)`.
  - [Removed] `setPriority(int)`: use MicroEJ launch option `com.microej.library.microui.pump.priority` instead.
  - [Removed] `switchBacklight(boolean)`: use `setBacklight(int)` instead.
  - [Removed] `waitForEvent()` and `waitForEvent(int)`: can be externally implemented (old implementation is available on demand).

**ej.microui.display.Displayable**
  - [Changed] `Displayable(Display)`: replaced by `Displayable()` (notion of multiple displays has been removed).
  - [Changed] `hideNotify()` and `showNotify()`: replaced respectively by `onHidden()` and `onShown()`.
  - [Changed] `paint(GraphicsContext)`: replaced by `render(GraphicsContext)`.
  - [Changed] `repaint()`: replaces by `requestRender()`.
  - [Removed] `getController()`: use `Display.getEventHandler()` instead.
  - [Removed] `getDisplay()`: notion of multiple displays has been removed.
  - [Removed] `hide()`, `show()` and `isShown()`: replaced respectively by `Display.requestHide(Displayable)`, `Display.requestShow(Displayable)` and `Display.isShown(Displayable)` 
 
**ej.microui.display.DisplayPermission**
  - [Removed] `getDisplay()`: notion of multiple displays has been removed.

**ej.microui.display.ExplicitFlush**
  - [Removed] Use `Display.flush()` and `Display.getGraphicsContext()` instead.

**ej.microui.display.FlyingImage**
  - [Removed] Can be externally implemented.

**ej.microui.display.Font**
  - [Added] `getSNIContext()`: allows to identify the font when calling a SNI native method.
  - [Changed] `getFont(int,int,int)`: replaced by `getFont(String)`: use the font file path instead of font characteritics.
  - [Removed] All languages identifiers (`ARABIC`, `LATIN` etc.): moved in the dedicated class `FontIdentifiers`.
  - [Removed] Style `STYLE_UNDERLINED`: use `Painter.drawHorizontalLine(GraphicsContext,int,int,int)` instead.
  - [Removed] Style `STYLE_RESIZED`, `getXRatio()`, `getYRatio()`, `resetRatios()` and `setRatios(int,int)`: notion of ratio has been removed; use `TransformPainter.drawScaledStringBilinear(GraphicsContext,String,Font,int,int,float,float)` instead.
  - [Removed] `charsWidth(char[],int,int)`.

**ej.microui.display.FontIdentifiers**
  - [Added] All languages identifiers have been moved in this class.

**ej.microui.display.GraphicsContext**
  - [Added] `getHeight()` and `getWidth()`: returns the graphics context size.
  - [Added] `getSNIContext()`: allows to identify the graphics context when calling a SNI native method.
  - [Added] `reset()`: resets the graphics context to its initial configuration (clip, translate, color, ellipsis).
  - [Added] `resetClip()`: resets the graphics context clip.
  - [Added] `resetTranslate()`: resets the graphics context translation.
  - [Added] `setTranslate(int,int)`: sets the graphics context translation.
  - [Changed] `clipRect(int,int,int,int)`: replaced by `intersectClip(int,int,int,int)`.
  - [Changed] `getARGB(int[],int,int,int,int,int,int)`: replaced by `readPixels(int[],int,int,int,int,int,int)`.
  - [Changed] `getEllipsis()` and `setEllipsis(boolean)`: replaced by `enableEllipsis(int)`, `disableEllipsis()` and `getEllipsisWidth()`.
  - [Changed] `getTranslateX()` and `getTranslateY()`: replaced by `getTranslationX()` and `getTranslationY()`.
  - [Changed] `readPixel()` returns an ARGB color,  apply bitwise AND operation on the result with `0xFFFFFF` if you intend to compare it with a non-alpha color.
  - [Removed] Anchors `BASELINE`, `BOTTOM`, `HCENTER`, `HCENTER_BOTTOM`, `HCENTER_TOP`, `HCENTER_VCENTOR`, `LEFT`, `LEFT_BOTTOM`, `LEFT_TOP`, `LEFT_VENTER`, `RIGHT`, `RIGHT_BOTTOM`, `RIGHT_TOP`, `RIGHT_VCENTER`, `TOP`, `VCENTER`: notion of _anchor_ has been removed; shape position is always TOP/LEFT. 
  - [Removed] Stroke styles `DOTTED` and `SOLID`, `getStrokeStyle()` and `setStrokeStyle(int)`: notion of _stroke style_ has been removed; only style SOLID is implicitely used.
  - [Removed] `drawChar(char,int,int,int)`: replaced by `Painter.drawChar(GraphicsContext,char,Font,int,int)`.
  - [Removed] `drawChars(char[],int,int,int,int,int)`.
  - [Removed] `drawCircle(int,int,int)`: replaced by `Painter.drawCircle(GraphicsContext,int,int,int)`.
  - [Removed] `drawCircleArc(int,int,int,int,int)`: replaced by `Painter.drawCircleArc(GraphicsContext,int,int,int,float,float)`.
  - [Removed] `drawEllipse(int,int,int,int)`: replaced by `Painter.drawEllipse(GraphicsContext,int,int,int,int)`.
  - [Removed] `drawEllipseArc(int,int,int,int,int)`: replaced by `Painter.drawEllipseArc(GraphicsContext,int,int,int,int,int)`.
  - [Removed] `drawHorizontalLine(int,int,int)`: replaced by `Painter.drawHorizontalLine(GraphicsContext,int,int,int)`.
  - [Removed] `drawImage(Image,,int,int,int)`: replaced by `Painter.drawImage(GraphicsContext,Image,int,int)`.
  - [Removed] `drawImage(Image,,int,int,int,int)`: replaced by `Painter.drawImage(GraphicsContext,Image,int,int,int)`.
  - [Removed] `drawLine(int,int,int,int)`: replaced by `Painter.drawLine(GraphicsContext,int,int,int,int)`.
  - [Removed] `drawPixel(int,int)`: replaced by `Painter.writePixel(GraphicsContext,int,int)`.
  - [Removed] `drawPolygon(int[])`: replaced by `ShapePainter.drawPolygon(GraphicsContext,int[])`.
  - [Removed] `drawPolygon(int[],int,int)`: replaced by `ShapePainter.drawPolygon(GraphicsContext,int[],int,int)`.
  - [Removed] `drawRect(int,int,int,int)`: replaced by `Painter.drawRectangle(GraphicsContext,int,int,int,int)`.
  - [Removed] `drawRegion(Display,int,int,int,int,int,int,int)`: replaced by `Painter.drawDisplayRegion(GraphicsContext,int,int,int,int,int,int)`.
  - [Removed] `drawRegion(Display,int,int,int,int,int,int,int,int)`: replaced by `Painter.drawDisplayRegion(GraphicsContext,int,int,int,int,int,int,int)`.
  - [Removed] `drawRegion(Image,int,int,int,int,int,int,int)`: replaced by `Painter.drawImageRegion(GraphicsContext,int,int,int,int,int,int)`.
  - [Removed] `drawRegion(Image,int,int,int,int,int,int,int,int)`: replaced by `Painter.drawImageRegion(GraphicsContext,int,int,int,int,int,int,int)`.
  - [Removed] `drawRoundRect(int,int,int,int,int,int)`: replaced by `Painter.drawRoundedRectangle(GraphicsContext,int,int,int,int,int,int)`.
  - [Removed] `drawString(Strig,int,int,int)`: replaced by `Painter.drawString(GraphicsContext,String,Font,int,int)`.
  - [Removed] `drawSubstring(Strig,int,int,int,int,int)`: replaced by `Painter.drawSubstring(GraphicsContext,String,int,int,Font,int,int)`.
  - [Removed] `drawVerticalLine(int,int,int)`: replaced by `Painter.drawVerticalLine(GraphicsContext,int,int,int)`.
  - [Removed] `fillCircle(int,int,int)`: replaced by `Painter.fillCircle(GraphicsContext,int,int,int)`.
  - [Removed] `fillCircleArc(int,int,int,int,int)`: replaced by `Painter.fillCircleArc(GraphicsContext,int,int,int,float,float)`.
  - [Removed] `fillEllipse(int,int,int,int)`: replaced by `Painter.fillEllipse(GraphicsContext,int,int,int,int)`.
  - [Removed] `fillEllipseArc(int,int,int,int,int)`: replaced by `Painter.fillEllipseArc(GraphicsContext,int,int,int,int,int)`.
  - [Removed] `fillPolygon(int[])`: replaced by `ShapePainter.fillPolygon(GraphicsContext,int[])`.
  - [Removed] `fillPolygon(int[],int,int)`: replaced by `ShapePainter.fillPolygon(GraphicsContext,int[],int,int)`.
  - [Removed] `fillRect(int,int,int,int)`: replaced by `Painter.fillRectangle(GraphicsContext,int,int,int,int)`.
  - [Removed] `fillRoundRect(int,int,int,int,int,int)`: replaced by `Painter.fillRoundedRectangle(GraphicsContext,int,int,int,int,int,int)`.
  - [Removed] `getDisplay()`: notion of multiple displays has been removed.
  - [Removed] `getDisplayColor(int)`: use `Display.getDisplayColor(int)` instead.
  - [Removed] `getFont()` and `setFont(Font)`: graphics context does not hold anymore a font; give the font as parameter instead.

**ej.microui.display.Image**
  - [Added] `canGetImage(String)`: tells if image is reachable without loading step. 
  - [Added] `getSNIContext()`: allows to identify the image when calling a SNI native method.
  - [Changed] `createImage(String)`: replaced by `getImage(String)` when the image is reachable without loading step or by `ResourceImage.loadImage()` otherwise.
  - [Changed] `getARGB(int[],int,int,int,int,int,int)`: replaces by `readPixels(int[],int,int,int,int,int,int)`.
  - [Removed] `OutputFormat`: moved in `ResourceImage` class.
  - [Removed] `createImage(Display,int,int)`: notion of multiple displays has been removed.
  - [Removed] `createImage(Image,int,int,int,int)` and `createImage(Image,int,int,int,int,OutputFormat)`.
  - [Removed] `createImage(InputStream,int)` and `createImage(InputStream,int,OutputFormat)`: replaced by `ResourceImage.loadImage(InputStream,int)` and `loadImage(InputStream,int,OutputFormat)`.
  - [Removed] `createImage(int,int)`: replaced by `BufferedImage` class.
  - [Removed] `createImage(String,OutputFormat)`: replaced by `ResourceImage.loadImage(String,OutputFormat)`.
  - [Removed] `getGraphicsContext()`: replaced by `BufferedImage.getGraphicsContext()`.
  - [Removed] `isMutable()`: only buffered images are mutable.

**ej.microui.display.ImageCreationException**
  - [Removed] Replaced by `MicroUIException`.

**ej.microui.display.Painter**
  - [Added] Shares all simple rendering methods: draw line, fill rectangle, draw string, draw image etc. 

**ej.microui.display.Renderable**
  - [Removed]

**ej.microui.display.RenderableChar**
  - [Removed] To rotate a character, use `TransformPainter.drawRotatedCharXXX(...)` instead.

**ej.microui.display.RenderableString**
  - [Added] `getCharArray()`: gets the string representation in a char array.
  - [Added] `getIndices()`: gets the string characters indices in the font.

**ej.microui.display.ResourceImage**
  - [Added] `OutputFormat`: moved from `Image`.
  - [Added] `canLoadImage(String)`: tells if image is reachable.
  - [Added] `loadImage(InputStream,int)` and `loadImage(InputStream,int,OutputFormat)`: replace `Image.createImage(InputStream,int)` and `Image.createImage(InputStream,int,OutputFormat)`.
  - [Added] `loadImage(String)` and `loadImage(String,OutputFormat)`: replace `createImage(String)` and `createImage(String,OutputFormat)`.
  - [Added] `close()` and `isClosed()`: application has the responsability to close a dynamic image.

**ej.microui.display.shape.AntiAliasedShapes**
  - [Removed] Replaced by `ej.drawing.ShapePainter` class in `ej.api.drawing` library.
  - [Removed] `Cap`: replaced by `ShapePainter#Cap`.
  - [Removed] `Singleton` and `AntiAliasedShapes()`: all methods are now static.
  - [Removed] `drawCircle(GraphicsContext,int,int,int)`: replaced by `ShapePainter.drawThickFadedCircle(GraphicsContext,int,int,int,int,int)`.
  - [Removed] `drawCircleArc(GraphicsContext,int,int,int,int,int)`: replaced by `ShapePainter.drawThickFadedCircleArc(GraphicsContext,int,int,int,float,float,int,int,Cap,Cap)`.
  - [Removed] `drawEllipse(GraphicsContext,int,int,int,int)`: replaced by `ShapePainter.drawThickFadedEllipse(GraphicsContext,int,int,int,int,int,int)`.
  - [Removed] `drawLine(GraphicsContext,int,int,int,int)`: replaced by `ShapePainter.drawThickFadedLine(GraphicsContext,int,int,int,int,int,int,Cap,Cap)`.
  - [Removed] `drawPoint(GraphicsContext,int,int)`: replaced by `ShapePainter.drawThickFadedPoint(GraphicsContext,int,int,int,int)`.
  - [Removed] `getEndCap()`, `getFade()`, `getStartCap()`, `getThickness()`, `reset()`, `setCaps(Cap,Cap)`, `setEndCap(Cap)`, `setFade(int)`, `setStartCap(Cap)`, `setThickness(int)`: all drawing effects are now given as parameters.

**ej.microui.display.shape.ThickShapes**
  - [Removed] Replaced by `ej.drawing.ShapePainter` class in `ej.api.drawing` library.
  - [Removed] `Singleton` and `ThickShapes()`: all methods are now static.
  - [Removed] `drawCircle(GraphicsContext,int,int,int)`: replaced by `ShapePainter.drawThickCircle(GraphicsContext,int,int,int,int)`.
  - [Removed] `drawCircleArc(GraphicsContext,int,int,int,int,int)`: replaced by `ShapePainter.drawThickCircleArc(GraphicsContext,int,int,int,float,float,int)` .
  - [Removed] `drawLine(GraphicsContext,int,int,int,int)`: replaced by `ShapePainter.drawThickLine(GraphicsContext,int,int,int,int,int)`.
  - [Removed] `getThickness()`, `reset()`, `setThickness(int)`: all drawing effects are now given as parameters.

**ej.microui.display.transform.AbstractTransform**
  - [Removed] Replaced by `ej.drawing.TransformPainter` class in `ej.api.drawing` library.
  - [Removed] `AbstractTransform()`: all methods are now static.
  - [Removed] `getAlpha()`, `getTranslateX()`, `getTranslateY()`, `isMirrored()`, `resetAlpha()`, `resetTranslate()`, `setAlpha(int)`, `setMirror(boolean)`, `translate(int, int)`:  all drawing effects are now given as parameters.

**ej.microui.display.transform.ImageDeformation**
  - [Removed] `Singleton` and `ImageDeformation()`: all methods are now static.
  - [Removed] `draw(GraphicsContext,Image,int[],int,int,int)`: replaced by `TransformPainter.drawDeformedImage(GraphicsContext,Image,int,int,int[])`.

**ej.microui.display.transform.ImageFlip**
  - [Removed] `Action`: replaced by `TransformPainter#Flip`.
  - [Removed] `Singleton` and `ImageFlip()`: all methods are now static.
  - [Removed] `draw(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawFlippedImage(GraphicsContext,Image,int,int,Flip)` and `TransformPainter.drawFlippedImage(GraphicsContext, Image,int,int,Flip,int)`.
  - [Removed] `getAction()`, `setAction(Action)`:  all drawing effects are now given as parameters.

**ej.microui.display.transform.ImageRotation**
  - [Removed] `Singleton` and `ImageRotation()`: all methods are now static.
  - [Removed] `drawBilinear(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawRotatedImageBilinear(GraphicsContext,Image,int,int,int,int,float)` and `TransformPainter.drawRotatedImageBilinear(GraphicsContext,Image,int,int,int,int,float,int)`.
  - [Removed] `drawNearestNeighbor(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawRotatedImageNearestNeighbor(GraphicsContext,Image,int,int,int,int,float)` and `TransformPainter.drawRotatedImageNearestNeighbor(GraphicsContext,Image,int,int,int,int,float,int)`.

**ej.microui.display.transform.ImageScale**
  - [Removed] `Singleton` and `ImageScale()`: all methods are now static.
  - [Removed] `draw(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawScaledImageNearestNeighbor(GraphicsContext,Image,int,int,float,float)` and `TransformPainter.drawScaledImageNearestNeighbor(GraphicsContext,Image,int,int,float,float,int)`.
  - [Removed] `drawBilinear(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawScaledImageBilinear(GraphicsContext,Image,int,int,float,float)` and `TransformPainter.drawScaledImageBilinear(GraphicsContext,Image,int,int,float,float,int)`.
  - [Removed] `drawNearestNeighbor(GraphicsContext,Image,int,int,int)`: replaced by `TransformPainter.drawScaledImageNearestNeighbor(GraphicsContext,Image,int,int,float,float)` and `TransformPainter.drawScaledImageNearestNeighbor(GraphicsContext,Image,int,int,float,float,int)`.
  - [Removed] `getFactor()`, `getFactorX()`, `getFactorY()`, `setFactor(float)`, `setFactorX(float)`, `setFactorY(float)`:  all drawing effects are now given as parameters.

**ej.microui.display.transform.Rotate**
  - [Removed] `Rotate()`: all methods are now static.
  - [Removed] `drawBilinear(GraphicsContext,Renderable,int,int,int)`: replaced by `TransformPainter.drawRotatedImageBilinear(GraphicsContext,Image,int,int,int,int,float)`, `TransformPainter.drawRotatedImageBilinear(GraphicsContext,Image,int,int,int,int,float,int)`, `drawRotatedCharBilinear(GraphicsContext,Font,char,int,int,int,int,float)` and `drawRotatedCharBilinear(GraphicsContext,Font,char,int,int,int,int,float,int)`.
  - [Removed] `drawNearestNeighbor(GraphicsContext,Renderable,int,int,int)`: replaced by `TransformPainter.drawRotatedImageNearestNeighbor(GraphicsContext,Image,int,int,int,int,float)`, `TransformPainter.drawRotatedImageNearestNeighbor(GraphicsContext,Image,int,int,int,int,float,int)`, `drawRotatedCharNearestNeighbor(GraphicsContext,Font,char,int,int,int,int,float)` and `drawRotatedCharNearestNeighbor(GraphicsContext,Font,char,int,int,int,int,float,int)`.
  - [Removed] `getAngle()`, `getRotationX()`, `getRotationY()`, `setAngle(int)`, `setRotationCenter(int,int)`:  all drawing effects are now given as parameters.

**ej.microui.event.Event**
  - [Changed] `getGeneratorID()`: replaced by `getGeneratorId()`.
  - [Removed] Event types `BUTTON`, `COMMAND`, `POINTER` and `STATES`: replaces respectively by `Buttons.EVENT_TYPE`, `Command.EVENT_TYPE`, `Pointer.EVENT_TYPE` and `States.EVENT_TYPE`.
  - [Removed] Event types `KEYBOARD` and `KEYPAD`.

**ej.microui.event.EventGenerator**
  - [Changed] `getID()`: replaced by `getId()`.
  - [Removed] `getList(Class<E>)`.

**ej.microui.event.EventHandler**
  - [Added] Replace `ej.microui.util.EventHandler`.

**ej.microui.event.controller.ButtonEventHandler**
  - [Removed] Can be externally implemented.

**ej.microui.event.controller.CommandEventHandler**
  - [Removed] Can be externally implemented.

**ej.microui.event.controller.DispatchEventHandler**
  - [Removed] Can be externally implemented.

**ej.microui.event.controller.DispatchHelper**
  - [Removed] Can be externally implemented.

**ej.microui.event.controller.EventGeneratorsHandler**
  - [Removed] Can be externally implemented.

**ej.microui.event.controller.PointerEventHandler**
  - [Removed] Can be externally implemented.

**ej.microui.event.generator.Buttons**
  - [Added] Constant `EVENT_TYPE`; replaces `Event.BUTTON`.
  - [Added] `buildEvent(int,int)`: builds an event.
  - [Changed] `getButtonID()`: replaces by `getButtonId()`.

**ej.microui.event.generator.Command**
  - [Added] Constant `EVENT_TYPE`; replaces `Event.COMMAND`.
  - [Added] `buildEvent(int,int)`: builds an event.

**ej.microui.event.generator.Keyboard**
  - [Removed]

**ej.microui.event.generator.Keypad**
  - [Removed]

**ej.microui.event.generator.Pointer**
  - [Added] Constant `EVENT_TYPE`; replaces `Event.POINTER`.
  - [Added] `buildEvent(int,int)`: builds an event.
  - [Removed] Events `ENTERED` and `EXITED`, `isEntered(), isExited()`: notion of _enter_ and _exit_ has been removed.
  - [Removed] `getFlyingImage()`, `setFlyingImage(FlyingImage)` and `setFlyingImage(FlyingImage,int,int)`: notion of _flying image_ has been removed.
  - [Removed] `setScale(Display)`: notion of multiple displays has been removed.

**ej.microui.event.generator.States**
  - [Added] Constant `EVENT_TYPE`; replaces `Event.STATES`.
  - [Added] `buildEvent(int,int)`: builds an event.
  - [Changed] `getButtonID()`: replaces by `getButtonId()`.

**ej.microui.util.EventHandler**
  - [Removed] Replaced by `ej.microui.event.EventHandler`.

## 2.4.0 - 2019-10-16

### Added

  - Add @Nullable annotations.
  - Add API to rotate a character. 

## 2.3.0 - 2018-06-28

### Added

  - Add thick shapes drawings.

## 2.2.0 - 2017-07-21

### Adde
  - Add alignment utility constants with couple (horizontal,vertical) such as (`LEFT`,`TOP`).

## 2.1.3 - 2017-03-16

### Added

  - Add `RenderableString`.
  - Add `MicroUI.isStarted()` API.
  - Add `Image.isTransparent()` API.
  
### Fixed
  - `Font.getWidth()` and `getHeight()` don't use ratio factor.
  
## 2.1.2 - 2017-02-13

### Added

  - Antialiased circle arc with no ends or perpendicular ends.
  - Draw image scale API
  
## 2.0.6 - 2017-01-26

### Fixed

  - MicroUI API contains some methods with implementation code.

## 2.0.5 - 2016-11-17

### Fixed

  - ImageScale::draw(...) Javadoc refers to the Action class used in ImageFlip class instead of referring to scaling factor.

## 2.0.4 - 2016-04-01

  Initial public revision.

---
_2016-2023 ESR - Not subject to Copyright._  
_This document has been released and published by E-S-R consortium, a non-profit entity._  
_To learn more about E-S-R consortium, please visit http://www.e-s-r.net/._  
_The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies._  
	
