# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.4.2] - 2022-10-20

### Deprecated

  - Deprecate `Immutables.put(String, Object)` and `Immutables.putAll(Hashtable)`

### Changed

  - Improve Javadoc on Immutable objects creation

## [1.4.1] - 2022-03-14

### Changed

  - Migrate module to MMM
  - Update `LICENSE.txt` to latest ESR license 

## [1.4.0] - 2019-06-03

### Changed

  - Mark BON APIs for Null Analysis
  - Update `ej.bon.Immortals.setImmortal(Object)`, `ej.bon.Immortals.deepImmortal(Object)`, `ej.bon.ReferenceQueue` and `ej.bon.EnqueuedWeakReference` with parameterized types
  - Update `ej.bon.TimerTask.uncaughtException(Timer,Throwable)` default behavior (related to added uncaught exception handlers)
  - Mark `ej.bon.Util` methods `dynamicCodeAllowed`, `throwExceptionInThread()` and `throwHardExceptionInThread` as deprecated. These legacy APIs are not implemented. Please refer to _Kernel & Features_ specification instead (`ESR001`).
  - Update `LICENSE.txt` and file headers according to latest ESR rules
  - Update templates for `CHANGELOG.md` and `README.md`
  - Update javadoc paragraphs formatting
  
### Added

  - Add class `ej.bon.Constants` for compile-time constants access
  - Add methods for custom `ej.bon.TimerTask` uncaught exception handling at `ej.bon.Timer` instance or class level
    - `ej.bon.Timer.setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler)`
    - `ej.bon.Timer.getUncaughtExceptionHandler()` 
    - `ej.bon.Timer.setDefaultUncaughtExceptionHandler(Thread.)` 
    - `ej.bon.Timer.getDefaultUncaughtExceptionHandler()` 
  - Add method `ej.bon.Util.newArray(Class,int)` for creating arrays of references dynamically
  - Mark `Nullable` APIs
  - Add method `ej.bon.Timer.dump(PrintStream)` for debugging timers
  
### Fixed

  - Fix documentation of `ej.bon.ResourceBuffer.ResourceBuffer(String)` parameter

## [1.3.0] - 2017-07-20

### Added

  - Initial public revision with changelog.

---
_Markdown_  
_2011-2022 ESR - Not subject to Copyright._

_This document has been released and published by E-S-R consortium, a non-profit entity._  
_To learn more about E-S-R consortium, please visit http://www.e-s-r.net/._  
_The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies._