# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.7.1] - 2025-04-09

### Fixed

- [intern] Fix the values of the error causes in the javadoc of `VectorGraphicsException`.
- [Front Panel] Fix the drawing bounds of the BufferedVectorImage's elements.
- [Front Panel] Fix the drawing of a BufferedVectorImage outside the destination's clip.
- [Front Panel] Fix the drawing of the BufferedVectorImage's elements which are outside the BufferedVectorImage's clip.
- [Front Panel] Fix the management of transparent gradients for the NemaVG GPU.
- [Front Panel] Fix the drawing of gradient paths with zero or one color. 

## [1.7.0] - 2024-10-09

### Added

- Add the extension of MicroUI Font from a MicroVG Font.

## Changed

- Change the minimal UI Pack compatibility: 14.1.0.
- [Front Panel] Compare the version fetched by the Front Panel project and the VEE Port.

## Fixed

- [Front Panel] Exclude the VG Front Panel fetched by the Front Panel project from the VEE Port's classpath.

## [1.6.0] - 2024-07-19

### Added

- Add the `nema` value for the MicroVG implementation (image generator and front panel).
- Add the publication of the Front Panel API and Image Generator Vector API to be able to extend the Front Panel VG and Image Generator VG engines in the VEE Port projects. 
- Add the properties `dynamicPath` and `dynamicLinearGradient` (in `microvg.properties`) to disable respectively the support of dynamic paths and dynamic linear gradients on the simulator (enabled by default). 
- Add the properties `path.length` and `chunk.length` (in `microvg.properties`) to configure the construction of the dynamic paths (respectively the initial size and the additional chunck size).
- Add the structure that represents a MicroVG Image in C: `MICROVG_Image`.

### Changed

- Pass the MicroVG implementation to the Image Generator.
- Increase the UI Pack dependency to version 14.0.1.
- Change the semantic of the LLAPI `LLVG_GRADIENT_IMPL_initializeGradient()`: the positions array cannot be null.
- Change the signatures of `LLVG_PAINTER_IMPL_drawImage()` and `LLVG_BVI_IMPL_map_context()` to use the new type `MICROVG_Image`.

## [1.5.1] - 2024-04-11

### Fixed

- Fix the drawing of a BufferedVectorImage in a BufferedVectorImage with a clip on the simulator.
- Fix the drawing of a glyph with path overlap on the simulator.

## [1.5.0] - 2024-02-15

### Changed

- Make the VG Pack compatible with the UI Pack 14.0.0.

### Fixed

- Fix comment in header file `LLVG_BVI_impl.h`.
- Fix the exception when loading a font with an empty path.
- Fix the exception when getting an image with an empty path.
- Fix the release of the BVI resources (use the hook of the UI Pack 13.7 to close the custom image's resources). 
- Fix the memory leak on images (ResourceVectorImage and BufferedVectorImage) on the simulator.

## [1.4.2] - 2023-11-13

### Fixed

- Fix dynamic paths larger than 64 KB.

## [1.4.1] - 2023-09-21

### Changed

- Update the license.
   
### Fixed

- Fix the path command "move relative". 

## [1.4.0] - 2023-07-21

### Changed

- Implement MicroVG 1.4.0.

### Fixed

- Fix the UI Pack minimal compatible version (13.5.0).

## [1.3.0] - 2023-05-10

### Changed

- Implement MicroVG 1.3.0.
- [Front Panel] Change the implementation to be compatible with the UI Pack 13.5.0.

### Fixed

- [Front Panel] Simplify pixels data conversion after drawing.
- [Image Generator] Support SVG clip-path feature.

## [1.2.1] - 2023-02-06

### Fixed

- [Front Panel] Fix the cropped images when using GraphicsContext clip and translation.
- [Front Panel] Fix AWT `RasterFormatException` exception.

## [1.2.0] - 2022-12-30

### Added

- Add "fill alpha" and "stroke alpha" animations to gradient elements.

### Changed

- Implement MicroVG 1.2.0.
- Change the VectorImage internal format: _raw_ format instead of _immutables_ format.

### Fixed

- [Front Panel] Fix the redirection of fillEllipseArc to the right software alogorithm.

## [1.1.2] - 2022-10-14

### Changed

- Update Vector Image Generator to version 1.0.3 for faster conversion.

## [1.1.1] - 2022-09-05

### Fixed

- Fix the README.md file for publication.

## [1.1.0] - 2022-09-02

### Added

- Add a sanity check on UI Pack fetched by the platform and the minimal version expected by the VG pack.
- Add the VG Pack version in the header file LLVG_impl.h.

### Changed

- Implement MicroVG 1.1.0 (can close a VectorFont, Matrix.getSNIContext()). 
- Allow to load a VectorFont from the external resources. 
- Add layout modes (simple or complex) feature to VectorFont(see limitations in README.md).
- Join character bboxes at baseline for drawStringOnCircle.

### Fixed

- Fix NullPointerException while sorting TranslateXY VectorDrawableObjectAnimator in vectorimage-converter.

## [1.0.1] - 2022-05-16

### Fixed

- Fix incorrect transformation of animated paths while creating a filteredImage.
- Fix incorrect detection of overlapping paths in vector images.

## [1.0.0] - 2022-05-13

### Added

- Initial revision.
- Implement MicroVG-1.0.0

---
_Copyright 2022-2025 MicroEJ Corp. All rights reserved._\  
_This library is provided in source code for use, modification and test, subject to license terms._\  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._
