# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 13.6.1 - 2023-07-26

### Changed

  - Aligned with MicroEJ Architecture UI 13.6.1.

## 13.6.0 - 2023-07-17

### Changed

  - Aligned with MicroEJ Architecture UI 13.6.0.
  - [frontpanel] Add the drawing log flag `DRAWING_LOG_MISSING_CHARACTER`, stating that an undefined character was drawn.

## 13.5.1 - 2023-06-08

### Changed

  - Aligned with MicroEJ Architecture UI 13.5.1.

## 13.5.0 - 2023-05-03

### Added

  - [frontpanel] Add a service to decode immutable images with a custom format. 
  - [frontpanel] Add a service to create mutable images with a custom format. 
  - [frontpanel] Add a service to draw into mutable images with a format different than the display format. 
  - [frontpanel] Add some methods to manage the MicroUI Drawing Log flags.
  - [frontpanel] Add some methods to change the MicroUI clip and colors.

### Changed

  - Aligned with MicroEJ Architecture UI 13.5.0.
  - [frontpanel] Merge `DWDrawing` in `UIDrawing`.
  - [frontpanel] Turn `UIDrawing` as a service to handle drawings for a specific format.
  - [frontpanel] Change the mechanism to get the software drawer.
  - [frontpanel] Change the MicroUI image format `MICROUI_IMAGE_FORMAT_LCD` by `MICROUI_IMAGE_FORMAT_DISPLAY`.

### Removed

  - [frontpanel] Remove the interfaces `UIDrawingDefault` and `DWDrawingDefault` (implement the interface `UIDrawing` instead).

## 13.4.1 - 2023-02-06

### Changed

  - Aligned with MicroEJ Architecture UI 13.4.1.

## 13.4.0 - 2022-12-20

### Added

  - [frontpanel] Add some checks to not performing a drawing when it is useless. 

### Changed

  - Aligned with MicroEJ Architecture UI 13.4.0.

## 13.3.1 - 2022-09-09

### Changed

  - Aligned with MicroEJ Architecture UI 13.3.1.

## 13.3.0 - 2022-09-02

### Added

  - [frontpanel] Add custom image formats in the `MicroUIImageFormat` enumeration and the `BufferedImageProvider` service to prepare for future MicroUI functionality.

### Changed

  - Aligned with MicroEJ Architecture UI 13.3.0.
  
## 13.2.0 - 2022-05-05

### Added

  - [frontpanel] Add `LLUIDisplayImpl.decode()` (the implementation can open encoded images).
  - [frontpanel] Add `LLUIDisplay.readPixel()`.
  - [imageGenerator] Allow to a custom image converter to generate a file other than a binary resource.
  - [imageGenerator] Allow to a custom image converter to specify the supported *.list files.

### Changed

  - Aligned with MicroEJ Architecture UI 13.2.0.

## 13.1.0 - 2021-08-03

### Added

  - [frontpanel] Add `MicroUIImage.getImage(int)` (apply a rendering color on Ax images). 
  - [frontpanel] Add `LLUIDisplay.convertRegion()` (convert a region according image format restrictions). 
  - [frontpanel] Add `LLUIDisplayImpl.waitFlush()` (the implementation can manage an asynchronous flush).

### Changed

  - Aligned with MicroEJ Architecture UI 13.1.0.
  - [frontpanel] Update Pointer event format. 

## 13.0.7 - 2021-07-30

### Changed

  - Aligned with MicroEJ Architecture UI 13.0.7.

## 13.0.6 - 2021-03-29

### Changed

  - Aligned with MicroEJ Architecture UI 13.0.6.

## 13.0.5 - 2021-03-08

### Changed

  - Aligned with MicroEJ Architecture UI 13.0.5.

## 13.0.4 - 2021-01-15

### Changed

  - Aligned with MicroEJ Architecture UI 13.0.4.

### Fixed

  - [imageGenerator] NullPointerException when trying to convert an unknown image.

## 13.0.3 - 2020-12-03

### Changed

  - Aligned with MicroEJ Architecture UI 13.0.3.

## 13.0.1 - 2020-09-22

### Fixed

  - [frontpanel] fillRectangle() parameters names are invalid.
  - [frontpanel] Missing LLAPI to check if destination region overlaps source region.
  
## 13.0.0 - 2020-07-30

### Added

  - Initial revision.
  - Publish frontpanel.jar and imagegenerator.jar (libraries to build a platform against UI pack 13.x)

### Changed 

  - `ej.tool.frontpanel#widget-microui` has been renamed in `com.microej.pack.ui#ui-pack(frontpanel)`. This library is fetched by transitivity when front panel project depends on `ej.tool.frontpanel#widget-2.0.0`. 
  - Image generator extension project has to use ivy dependency `com.microej.pack.ui#ui-pack(imageGenerator)` instead of classpath variable `IMAGE-GENERATOR-x.x`.

---
_Copyright 2020-2023 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._
