# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 10.3.0 (2022-10-03)
### Changed
  - SSL: Set getClientContextID public + and add getter for SSLContextSpi 

## 10.2.0 (2022-09-15)
### Added
  - SSL: Support of DTLS versions in ssl mock context creation method.
  - SSL: Keystores getters in SSL mock for compatibility with DTLS mock.

## 10.1.0  (2022-03-03)
### Added
  - PACK: set architecture minimum version to 7.13.0 (as SNI-1.4 is required for SECURITY module since API 1.4.0)
  
### Changed
  - NET: change properties file to comply with MicroEJ naming convention. System properties files should have the suffix `.properties.list`
  - SSL: change properties file to comply with MicroEJ naming convention. System properties files should have the suffix `.properties.list`
  
### Fixed
 - SEC: documentation in LLAPI `LLSEC_PRIVATE_KEY.h`

## 10.0.0  (2021-10-11)
### Added
 - SEC: key pair generation API for RSA and EC algorithms
 - NET: null Analysis annotation to API
 - SSL: null Analysis annotation to API

### Changed
 - SEC: the storage of the native resources from byte arrays to an integer pointer. This avoid the additional native call to get the max size of the byte array instantiated on java side

### Fixed
- SSL: an issue with key store password. The password length passed to the native should not include the null terminating byte
- SEC: an issue where allocated native resources were not properly managed, this could leads to memory leaks
- SEC: an issue with signature max size calculation. Using a default max size of 512. It can be configured using `com.microej.security.signature.max.size` system property
- SEC: an issue where native resources created in the mock were not properly closed 

## 9.4.0 (2021-05-07)

Features:

  - M0172MEJANET-637: Remove pool of immortals buffers. Update net impl, mock and ssl impl deps.

## 9.3.0 (2020-12-19)

Features:

  - J0216S-135: Add customizable buffer size for X509 certificate loading. New LLAPI LLSEC_X509_CERT_IMPL_get_key_size() added.
  
Fixes:

  - J0216S-139 Security Mockup: IndexOutOfBoundsException after freeing a MessageDigest

## 9.2.3 (2020-11-05)

Bugfixes:
  - M0172MEJANET-549: Fix wrong packaging.
  - M0172MEJANET-489: Update License to LAW-0011-LCS-MicroEJSDK-EULA-3.0-B. 

## 9.2.2 (2020-07-06)

Bugfixes:

  - J0216S-131: Fix CertificateException when using SSL. 

## 9.2.1 (2020-04-23)

Bugfixes:

  - J0216S-128 Security: Load required types from script instead of `.types.list`.

## 9.2.0 (2020-01-30)

Bugfixes:

  - J0216S-86 Security: Fix wrong return type in Cipher API.
  - J0216S-119 Security: Add missing nativeGetBufferedLength native in Cipher API.
  - J0216S-104 Security: Fix LLSEC API documentation.
  - J0216S-86 Security: Implement a missing CipherSpi.engineInit method.
  
## 9.1.1 (2019-05-23)

Bugfixes:

  - M0172MEJANET-388: Fix missing require type for TLS 1.3 support

## 9.1.0 (2019-03-29)

Features:

  - M0172MEJANET-184: Add TLS 1.3 support in SSL foundation library.
  - J0216S-108: Update Digest implementation in Security foundation library mock to remove restriction on SHA-256 algorithm.
  
## 9.0.3 (2019-03-27) 

Bugfixes:

  - J0216S-107 Fix wrong include in `LLSEC_RANDOM_impl.h` header file.
 
## 9.0.2 (2019-03-08) 

Bugfixes:

  - M0172MEJANET-366: Add bug fixes on Security foundation library.
  - J0216S-103: Fix Security foundation library low level API wrong X509 parse function signature. 
  
## 9.0.1 (2019-03-08) 

Bugfixes:

  - M0172MEJANET-365: Add bug fixes on Security foundation library.
  - J0216S-102: Fix Security foundation library packaging issue that do not contains low level APIs.
  - J0216S-100: Set ContextLocalStorage for NativeResources to fix a KF issue in Security foundation library.

## 9.0.0 (2019-03-01) 

Features:

  - M0172MEJANET-161: Add Security foundation library.
  - M0172MEJANET-161: Remove useless low level API based on X509 certificate parse (now done by Security foundation library).
  
Bugfixes:

  - M0172MEJANET-336: Clean SSL workbench extension packaging.
  - M0172MEJANET-337: Clean NET workbench extension packaging.
  - M0172MEJANET-345: Fix SSL llapi artifact dependency organisation and module name.
  - M0172MEJANET-347: Fix SSL testsuite launch scripts issue.
    
## 8.2.0 (2019-01-29) 

Features:

  - M0172MEJANET-157: Support TLS SNI client-side
  
## 8.1.6 (2019-01-29) 

Bugfixes:

  - M0172MEJANET-189 Fix wrong SSL artifact name

## 8.1.5 (2018-10-15) 

Bugfixes:

  - CC0091LGICB-58 Allow to retrieve the underlying native file descriptor from a datagram socket.
  - CC0091LGICB-58 Allow to subclass SSLContext for dtls.


## 8.1.4 (2018-08-31) 

Bugfixes:

  - M0172MEJANET-113: Use the net embedded resources 1.1.0.

## 8.1.3 (2018-07-27) 

Bugfixes:

  - M0172MEJANET-96 LLNET API: port format in LLNET_DATAGRAMSOCKETCHANNEL_IMPL_receive not specified

## 8.1.2 (2018-07-18) 

Bugfixes:

  - M0172MEJANET-93 Generic pack generation instead of architecture specific

## 8.1.1 (2018-06-04) 

Bugfixes:

  - WI 20744: Net pack scripts may reference a directory that doesn't exist
  
## 8.1.0 (2018-01-22)

Features:

  - WI 20454: Net Library and Pack review, optimization and refactoring
  - WI 20657: Update to WolfSSL 3.10.2

## 8.0.0 (2017-11-06)

Features:

  - WI 20421: Net: Remove dispatch from the pack

## 7.0.0 (2017-10-10)

Features:

  - WI 18615: SSL ServerSocket implementation
  - WI 17855: Bidirectional SSL
  
## 6.1.5  (2017-06-21)

Bugfixes:

  - WI 19928: Soft DNS resolver doesn't retry on timeout and doesn't try other servers on errors
  - WI 19794: DNS soft should be case insensitive on hostname

## 6.1.4  (2017-03-31)

Bugfixes:

  - WI 19490: Virtual Devices are slow to enumerate network interfaces
  - WI 19495: Missing documentation on native NetworkInterfaceNatives.getVMInterface(int, byte[], int, int, boolean)

## 6.1.3 (2017-03-14)

Bugfixes:

  - Wrong labels on Net Workbench Extension

## 6.1.2 (2017-03-06)

Bugfixes:

  - Some Readme and changelog files not embed
  - SSL C header files missing
  
## 6.1.1 (2017-03-03)

Bugfixes:

  - Missing description for Net and SSL in MicroEJ SDK 4 .platform -> content view -> details -> description

## 6.1.0 (2016-12-29)

Features:

  - Updated all dependencies for NET 1.1 compatibility

## 6.0.0 (2016-11-22)

Features:

  - Add retry pattern on all SSL natives

## 5.1.0 (2016-11-16)

Features:

  - Net 1.1

Bugfixes:
  
  - Fix issue in the Java implementation of the DNS resolver with unknown hosts on multiple CNAME entries
  
## 5.0.2  (2016-07-13)

Features:

  - Memory leak issue fixed in soft DNS part when resolving unknown host name.

## 5.0.1  (2016-07-04)

Features:

  - Artifacts API retrieved from "ej.api" instead of "com.is2t.libraries.net-embedded"

## 5.0.0  (2016-03-17)

Features:

  - Add DNS Java support in XPFP Net
  - Net Embedded KF ready
  - Update Net native method to match right arguments when buffer exchanged
  - Add "network not initialized" specific error code

Bugfixes:

  - DNS Client host IP address resolution failed on multiple request
  - SSL JavaDoc API build fails with jdk8 due to references to non-existent classes and methods in the API
  - Net API javadoc doest not build with jdk8 
    
## 4.0.0  (2016-01-29)

Features:

  - Pull-up TCP/IP stack error codes
  - Net-Embedded Low Level APIs documentation
  - Remove API JavaDoc from Net-Embedded implementation
  - Net-Embedded Impl on OpenJDK - remove GNU-Classpath Copyright
  - Remove javadoc from SSL implementation
  - SSL Low Level APis documentation
  
## 3.0.0  (2016-01-11)

Features:

  - Certificate chain validation implem
  
## 2.1.0  (2016-01-04)

Features:

  - SSL Immortals allocation optimisation
  - SSL context automatic recycle
  - Pull up SSL error code Emb+Sim
  
Bugfixes:

  - Net API issue on NetworkInterface.getNetworkInterfaces() method

## 2.0.0  (2015-12-7)

Features:

  - SSL TrustStore implementation 

Bugfixes:
  
  - LLNET_Cfg.h header file missing in network settings workbench extension artifact

## 1.2.0  (2015-11-12)

Features:

  - Optimization of read/writes native call operations in Net library.

## 1.1.1  (2015-10-30)

Features:

  - Keep backward compatibility with old Platform Architecture which do not have resource manager. 

## 1.1.0  (2015-10-30)

Features:

  - Initial revision.

---
_Copyright 2015-2022 MicroEJ Corp. All rights reserved._  
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._
