<!--
# Changelog

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
### Changed
 - Keep track of upcoming changes here

## [M.m.p] - YYYY-mm-dd

### Changed
  - List here changes in existing functionality

### Added
  - List here the new features.
  
### Deprecated
  - List here soon-to-be removed features.
  
### Fixed
  - List here any bug fixes

### Security
  - List here case of vulnerabilities
-->


## [6.0.4] - 2023-08-16

### Fixed

- Fix an issue where `FileInputStream.read()` wasn't reading all available bytes.

## [6.0.3] - 2022-03-28
### Fixed
- M0074FS-206 an issue where multiple calls of `java.io.File.lastModified()` return different values when the file is unchanged.
- M0074FS-211 a regression in `6.0.2` where the `java.io.InputStream.read(byte[], int, int)` offset and length were not checked to be in the range of the output buffer when length is zero.

### Changed
 - Update changelog to use keepachangelog v `1.0.0` format.

## [6.0.2] - 2021-11-25
### Fixed
  - M0074FS-204 Fix an issue where a blocking read (on blocking files like character device files) causes deadlocks preventing close() and reclaim() from being executed.
  - M0074FS-203 Fix an issue where a read with buffer will blocks until reading all requested data length instead of returning available data. This can block for ever on blocking files like character device files.

## [6.0.1] - 2021-09-27
### Fixed
  - M0074FS-161 Relax opendirNative spec to allow negative IDs.

## [6.0.0] - 2021-04-27
### Fixed
  - M0074FS-179 Bump impl dep with Random Access File implementation.
  - M0074FS-179 Convert to MMM.
  

## [5.1.2] - 2020-11-05
### Fixed
  - M0074FS-168: Fix wrong packaging.

## [5.1.1] - 2020-10-09
### Fixed
  - M0074FS-167: Don't embed HIL classes in mock jar.

## [5.1.0] - 2020-05-27
### Added
  - M0074FS-83: add flush native function.
	
## [5.0.1] - 2019-09-27
### Fixed
  - M0074FS-132: Fix workbench extension.
  - M0074FS-137: Fix LLAPI documentation.

## [5.0.0] - 2019-05-31
### Added
  - M0074FS-114: Update pack to use SNI `1.3`.

## [4.0.3] - 2020-11-19
### Fixed
  - M0074FS-169: Fix wrong packaging.

## [4.0.2] - 2018-07-19
### Fixed
  - M0074FS-2: Generic FS pack.
  
## [4.0.1] - 2018-03-23
### Fixed
  - WI 20743: HIL: SNI.toCString() doesn't flush content when FS pack is embedded.
  
## [4.0.0] - 2018-01-30
### Added
  - WI 20393: Build pack compatible with MicroEJ Architecture `7.0.0`.
  - WI 18524: Build of a dev pack is sufficient.
  - WI 20672: Fetch XPFP dependencies in a private conf.
  
## [3.0.2] - 2017-06-02
### Fixed
  - WI19876: XPFP FS 3.0.1 wrong properties in `release_pack.properties`.

## [3.0.1] - 2017-06-01
### Fixed
  - WI19365: No Java lib version in CCO ivy module name.
  - WI19857: FS HIL UnsatisfiedLinkError when Unix filesystem used.
  - WI19862: FS wrong canonicalPath returned by HIL UnixFileSystem implementation.

## [3.0.0] - 2017-03-07
### Added   
  - Remove S3 System.out redirection patch
  
### Fixed
  - WI 17014: Missing fragment description in MicroEJ SDK 4 .platform -> content view -> details -> description.
  - WI 19262: Missing C header files metadata in FS impl artifacts.

## [2.2.1] - 2016-12-30
### Added   
  - Add an integration testsuite..

## [2.2.0] - 2016-07-05
### Added
  - Add support for Unix and WinNT filesystems.

## [1.0.1] - 2015-09-23
### Fixed   
  - Fix issues when closing a file stream several times.

## [1.0.0] - 2015-09-18
### Added
  - Initial revision.

___  
_Copyright 2015-2023 MicroEJ Corp. All rights reserved._  
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._