/*
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Widget;

/**
 * A disabled selector selects by checking if the widget is disabled.
 * <p>
 * Equivalent to <code>:disabled</code> selector in CSS. Its specificity is (0,0,1,0).
 *
 * @see SelectorHelper
 */
public class DisabledSelector implements Selector {

	/**
	 * Disabled selector singleton to avoid creating several ones.
	 */
	public static final DisabledSelector DISABLED_SELECTOR = new DisabledSelector();

	/**
	 * Creates a disabled selector.
	 */
	private DisabledSelector() {
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		return !widget.isEnabled();
	}

	@Override
	public int getSpecificity() {
		return SelectorHelper.getSpecificity(0, 0, 1, 0);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return 0;
	}
}
