/*
 * Copyright (c) 1999, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2019-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package javax.security.auth;

/**
 * Signals that a {@code destroy} operation failed.
 *
 * <p>
 * This exception is thrown by credentials implementing the {@code Destroyable} interface when the {@code destroy}
 * method fails.
 *
 */
public class DestroyFailedException extends Exception {

	private static final long serialVersionUID = -7790152857282749162L;

	/**
	 * Constructs a DestroyFailedException with no detail message. A detail message is a String that describes this
	 * particular exception.
	 */
	public DestroyFailedException() {
		super();
	}

	/**
	 * Constructs a DestroyFailedException with the specified detail message. A detail message is a String that
	 * describes this particular exception.
	 *
	 * <p>
	 *
	 * @param msg
	 *            the detail message.
	 */
	public DestroyFailedException(String msg) {
		super(msg);
	}
}