/*
 * Java
 *
 * Copyright 2014-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket.http;

/**
 * HTTP status line as described by RFC 2616, section 6.1. Status Line.
 * 
 * 
 * 
 */
public class StatusLine {

	private static final char SPACE = ' ';

	private String protocol;
	private int status;
	private String reason;

	/**
	 * @param line
	 *            the status line in text format with terminating CRLF
	 */
	/* default */StatusLine(String line) {
		// When HttpResponse constructs a new StatusLine, 'line' ends with "\r\n" (CRLF)

		int firstSpace = line.indexOf(SPACE);
		int secondSpace = line.indexOf(SPACE, firstSpace + 1);
		int end = line.length() - 2;

		protocol = line.substring(0, firstSpace);
		status = Integer.parseInt(line.substring(firstSpace + 1, secondSpace));
		reason = line.substring(secondSpace + 1, end);
	}

	/**
	 * @return the protocol version ("HTTP/x")
	 */
	public String getProtocolVersion() {
		return protocol;
	}

	/**
	 * @return the status code (ex: 404, 101)
	 */
	public int getStatusCode() {
		return status;
	}

	/**
	 * @return the reason phrase provided by the server
	 */
	public String getReasonPhrase() {
		return reason;
	}

	@Override
	public String toString() {
		return "StatusLine [protocol=" + protocol + ", status=" + status + ", reason=" + reason + "]";
	}
}
