/*
 * Java
 *
 * Copyright 2014-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket;

/**
 * RFC6455 defined several possible states for a websocket. This enum type offer a Java representation for these states.
 * <p>
 * This enum type add a additional state, {@link #NEW}. It indicate that the Websocket object has been created but the {@link WebSocket#connect()}
 * method has not been already called. Hence, the {@link WebSocket} is not yet in the {@link #CONNECTING} state.
 *
 *
 *
 */
public enum ConnectionStates {

	/**
	 * The {@link WebSocket} Java object has been created but its {@link WebSocket#connect()} method has not been called yet.
	 */
	NEW,

	/**
	 * Initial state of the websocket in the RFC6455. The application is "establishing a websocket connection". It Java,
	 * the websocket moves to this sate when the {@link WebSocket#connect()} method is called.
	 * <p>
	 * See section 4.1. Client Requirements.
	 */
	CONNECTING,

	/**
	 * State once the opening handshake is done.
	 * <p>
	 * See end of section 4.1. Client Requirements.
	 */
	OPEN,

	/**
	 * State "upon either sending or receiving a Close control frame".
	 * <p>
	 * See section 7.1.3. The WebSocket Closing Handshake is Started.
	 */
	CLOSING,

	/**
	 * State once the underlying TCP connection is closed.
	 * <p>
	 * See section 7.1.4. The WebSocket Connection is Closed.
	 */
	CLOSED

}
