/*
 * Java
 *
 * Copyright 2021-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 *
 * This File is a derivative work. Subject to §4 of the applicable Apache License, MicroEJ provides the above different license terms and conditions for use.
 *
 * // Copyright (C) 2006 The Android Open Source Project
 * //
 * // Licensed under the Apache License, Version 2.0 (the "License");
 * // you may not use this file except in compliance with the License.
 * // You may obtain a copy of the License at
 * //
 * //      http://www.apache.org/licenses/LICENSE-2.0
 * //
 * // Unless required by applicable law or agreed to in writing, software
 * // distributed under the License is distributed on an "AS IS" BASIS,
 * // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * // See the License for the specific language governing permissions and
 * // limitations under the License.
 */
package ej.microvg;

/**
 * Represents a geometric paths consisting of straight line segments, quadratic curves, and cubic curves.
 */
public class Path {

	/**
	 * Creates an empty path.
	 * <p>
	 * The origin is set to (0,0).
	 */
	public Path() {
		throw new VectorGraphicsException();
	}

	/**
	 * Resets the path to an empty one.
	 * <p>
	 * The origin is also reset to (0,0).
	 */
	public void reset() {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the beginning of the next contour to the point (x,y).
	 *
	 * @param x
	 *            the x-coordinate of the start of a new contour
	 * @param y
	 *            the y-coordinate of the start of a new contour
	 */
	public void moveTo(float x, float y) {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the beginning of the next contour relative to the last point on the previous contour. If there is no
	 * previous contour, this is treated the same as {@link #moveTo(float, float)}.
	 *
	 * @param dx
	 *            the amount to add to the x-coordinate of the end of the previous contour, to specify the start of a
	 *            new contour
	 * @param dy
	 *            the amount to add to the y-coordinate of the end of the previous contour, to specify the start of a
	 *            new contour
	 */
	public void moveToRelative(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Adds a line from the last point to the specified point (x,y). If no {@link #moveTo(float, float)} call has been
	 * made for this contour, the first point is automatically set to (0,0).
	 *
	 * @param x
	 *            the x-coordinate of the end of a line
	 * @param y
	 *            the y-coordinate of the end of a line
	 */
	public void lineTo(float x, float y) {
		throw new VectorGraphicsException();
	}

	/**
	 * Same as {@link #lineTo(float, float)}, but the coordinates are considered relative to the last point on this
	 * contour. If there is no previous point, then a <code>moveTo(0,0)</code> is inserted automatically.
	 *
	 * @param dx
	 *            the amount to add to the x-coordinate of the previous point on this contour, to specify a line
	 * @param dy
	 *            the amount to add to the y-coordinate of the previous point on this contour, to specify a line
	 */
	public void lineToRelative(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Adds a quadratic bezier from the last point, approaching control point (x1,y1), and ending at (x2,y2). If no
	 * {@link #moveTo(float, float)} call has been made for this contour, the first point is automatically set to (0,0).
	 *
	 * @param x1
	 *            the x-coordinate of the control point on a quadratic curve
	 * @param y1
	 *            the y-coordinate of the control point on a quadratic curve
	 * @param x2
	 *            the x-coordinate of the end point on a quadratic curve
	 * @param y2
	 *            the y-coordinate of the end point on a quadratic curve
	 */
	public void quadTo(float x1, float y1, float x2, float y2) {
		throw new VectorGraphicsException();
	}

	/**
	 * Same as {@link #quadTo(float, float, float, float)}, but the coordinates are considered relative to the last
	 * point on this contour. If there is no previous point, then a moveTo(0,0) is inserted automatically.
	 *
	 * @param dx1
	 *            the amount to add to the x-coordinate of the last point on this contour, for the control point of a
	 *            quadratic curve
	 * @param dy1
	 *            the amount to add to the y-coordinate of the last point on this contour, for the control point of a
	 *            quadratic curve
	 * @param dx2
	 *            the amount to add to the x-coordinate of the last point on this contour, for the end point of a
	 *            quadratic curve
	 * @param dy2
	 *            the amount to add to the y-coordinate of the last point on this contour, for the end point of a
	 *            quadratic curve
	 */
	public void quadToRelative(float dx1, float dy1, float dx2, float dy2) {
		throw new VectorGraphicsException();
	}

	/**
	 * Adds a cubic bezier from the last point, approaching control points (x1,y1) and (x2,y2), and ending at (x3,y3).
	 * If no {@link #moveTo(float, float)} call has been made for this contour, the first point is automatically set to
	 * (0,0).
	 *
	 * @param x1
	 *            the x-coordinate of the 1st control point on a cubic curve
	 * @param y1
	 *            the y-coordinate of the 1st control point on a cubic curve
	 * @param x2
	 *            the x-coordinate of the 2nd control point on a cubic curve
	 * @param y2
	 *            the y-coordinate of the 2nd control point on a cubic curve
	 * @param x3
	 *            the x-coordinate of the end point on a cubic curve
	 * @param y3
	 *            the y-coordinate of the end point on a cubic curve
	 */
	public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
		throw new VectorGraphicsException();
	}

	/**
	 * Same as {@link #cubicTo(float, float, float, float, float, float)}, but the coordinates are considered relative
	 * to the current point on this contour. If there is no previous point, then a moveTo(0,0) is inserted
	 * automatically.
	 *
	 * @param dx1
	 *            the x-coordinate of the 1st control point on a cubic curve
	 * @param dy1
	 *            the y-coordinate of the 1st control point on a cubic curve
	 * @param dx2
	 *            the x-coordinate of the 2nd control point on a cubic curve
	 * @param dy2
	 *            the y-coordinate of the 2nd control point on a cubic curve
	 * @param dx3
	 *            the x-coordinate of the end point on a cubic curve
	 * @param dy3
	 *            the y-coordinate of the end point on a cubic curve
	 */
	public void cubicToRelative(float dx1, float dy1, float dx2, float dy2, float dx3, float dy3) {
		throw new VectorGraphicsException();
	}

	/**
	 * Closes the current contour. If the current point is not equal to the first point of the contour, a line segment
	 * is automatically added.
	 */
	public void close() {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the offset that will be applied to all the subsequent absolute points of the contour.
	 *
	 * @param dx
	 *            the amount in the x direction to offset the subsequent points
	 * @param dy
	 *            the amount in the y direction to offset the subsequent points
	 */
	public void setOrigin(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the left bound of this path.
	 * <p>
	 * If this path does not contain any point, all bounds are equal to 0.
	 *
	 * @return the left bound of this path
	 */
	public float getLeftBound() {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the right bound of this path.
	 * <p>
	 * If this path does not contain any point, all bounds are equal to 0.
	 *
	 * @return the right bound of this path
	 */
	public float getRightBound() {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the top bound of this path.
	 * <p>
	 * If this path does not contain any point, all bounds are equal to 0.
	 *
	 * @return the top bound of this path
	 */
	public float getTopBound() {
		throw new VectorGraphicsException();
	}

	/**
	 * Gets the bottom bound of this path.
	 * <p>
	 * If this path does not contain any point, all bounds are equal to 0.
	 *
	 * @return the bottom bound of this path
	 */
	public float getBottomBound() {
		throw new VectorGraphicsException();
	}
}
