/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.http.requesthandler;

import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;

/**
 * A handler to process request and create appropriate response.
 * <p>
 * Implementations must be thread-safe to protect themselves against concurrent calls from different jobs.
 */
public interface RequestHandler {

	/**
	 * Processes the request and return the appropriate response.
	 *
	 * @param request
	 *            the {@link HttpRequest} to process.
	 * @param response
	 *            the {@link HttpResponse} to send.
	 *
	 */
	void process(HttpRequest request, HttpResponse response);

}
