/*
 * Copyright 2014-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

import ej.annotation.Nullable;
import ej.kf.Feature.State;

/**
 * The listener interface for receiving notifications when the state of a Feature has changed. Object instances of
 * classes that implement this interface must be added to the Kernel listener list using
 * {@link Kernel#addFeatureStateListener(FeatureStateListener)}
 */
public interface FeatureStateListener {

	/**
	 * Called when the state of a Feature has changed.
	 *
	 * @param feature
	 *            the Feature which state has changed
	 * @param previousState
	 *            the previous state, <code>null</code> if Feature state is {@link State#INSTALLED}
	 */
	public void stateChanged(Feature feature, @Nullable State previousState);

}
