/*
 * Copyright 2013-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.kf;

/**
 * This exception is thrown by the system when a Feature code has been stopped because it is being uninstalled. Only
 * Kernel code can receive this exception: it never occurs in Feature code. Each call from Kernel to a Feature shall
 * catch this exception and handle the fact the Feature is not able to execute the desired "service".
 */
public class DeadFeatureException extends RuntimeException {

}
