/*
 * Java
 *
 * Copyright 2021-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.paint;

import java.awt.geom.AffineTransform;

/**
 * Visitor that changes the attribute of a {@link VGPaint}.
 */
public interface PaintVisitor {

	/**
	 * Changes a color into an other one.
	 *
	 * @param color
	 *            the ARGB color to change
	 * @return a new ARGB color
	 */
	default int visitColor(int color) {
		return color;
	}

	/**
	 * Changes the affine transform by an other one.
	 *
	 * @param at
	 *            the affine transform to change
	 * @return a new affine transform
	 */
	default AffineTransform visitTransform(AffineTransform at) {
		return at;
	}
}
