/*
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class represents access rights the audio records.
 * <p>
 * The actions are:
 * <dl>
 * <dt>{@link #CREATE_ACTION}
 * <dd>Permission is checked when creating an {@link AudioRecord}.
 * <dt>{@link #READ_ACTION}
 * <dd>Permission is checked when reading from an {@link AudioRecord}
 * ({@link AudioRecord#readBuffer(byte[], int, int)}).
 * </dl>
 *
 * @see java.security.Permission
 */
public class AudioRecordPermission extends Permission {

	private static final long serialVersionUID = 7255642980799924972L;

	/**
	 * The action when creating an {@link AudioRecord}.
	 */
	public static final String CREATE_ACTION = "create";
	/**
	 * The action when reading from an {@link AudioRecord}.
	 */
	public static final String READ_ACTION = "read";

	private AudioRecordPermission() {
		super(null);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
