/*
 * Java
 *
 * Copyright 2010-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sni;



/**
 * A pool of reusable immortal byte buffers.
 */
public class PoolOfImmortalByteBuffers extends PoolOfLimitedReusableResources{

	/**
	 * Allocate a new pool of Immortals byte buffer resources
	 *
	 * @param maxNbResources a strictly positive integer giving the maximum number of allocated resources,
	 *            or 0 if an unlimited number of resources is allowed
	 * @param allocationSize size of allocated resources (in bytes). 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfImmortalByteBuffers(int maxNbResources, int allocationSize) {
		super(maxNbResources, allocationSize);
		throw new RuntimeException();
	}

	/**
	 * Allocate a new Immortal byte buffer resource
	 */
	@Override
	protected Object newResource() {
		throw new RuntimeException();
	}

}
