package java.lang;

/**
 * Thrown when an application attempts to use {@code null} in a case where an object is required.
 * These include:
 * <ul>
 * <li>Calling the instance method of a {@code null} object.
 * <li>Accessing or modifying the field of a {@code null} object.
 * <li>Taking the length of {@code null} as if it were an array.
 * <li>Accessing or modifying the slots of {@code null} as if it were an array.
 * <li>Throwing {@code null} as if it were a {@code Throwable} value.
 * </ul>
 * <p>
 * Applications should throw instances of this class to indicate other illegal uses of the
 * {@code null} object.
 */
public class NullPointerException extends RuntimeException {

	/**
	 * Constructs a {@code NullPointerException} with no detail message.
	 */
	public NullPointerException() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a {@code NullPointerException} with the specified detail message.
	 *
	 * @param s
	 *        the detail message.
	 */
	public NullPointerException(String s) {
		throw new RuntimeException();
	}
}