/*
 *	Java
 *
 *	Copyright 2015-2016 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * This class holds a context in order to perform a free deformation on images. The deformation is specified by a
 * coordinates array .<br>
 * <p>
 * An image deformation instance holds a global state for all drawings. Several instances can be created at the same
 * time. However a default instance is created on MicroUI framework startup and is always available.<br>
 *
 * @since 2.0
 */
public class ImageDeformation extends AbstractTransform {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static ImageDeformation Singleton = new ImageDeformation();

	/**
	 * Draws a deformed image at the given anchor point.<br>
	 * The image anchor point is at position @{code (x,y)}. Position constants may be given to specify the precise
	 * location of the image around the anchor point.<br>
	 * <br>
	 * The deformed image is identified by its four corner points. These points are defined by the array of integer
	 * coordinates and they must respect the following order: first is the top-left corner, second is the top-right,
	 * third is the bottom-right and fourth is the bottom-left.<br>
	 * <br>
	 * Examples with img an image and imgWidth and imgHeight its size.<br>
	 * <ul>
	 * <li>To draw normal img, the array should be : {0, 0, imgWidth-1, 0, imgWidth-1, imgHeight-1, 0, imgHeight-1}.
	 * </li>
	 * <li>To draw img with a rotation clockwise by 90 degrees, the array should be : {imgHeight-1, 0, imgHeight-1,
	 * imgWidth-1, 0, imgWidth-1, 0, 0}.</li>
	 * <li>To draw img mirrored about the vertical axis, the array should be : {0, 0, -(imgWidth-1), 0, -(imgWidth-1),
	 * -(imgHeight-1), 0, -(imgHeight-1)}.</li>
	 * <li>To draw img with a double scale, the array should be : {0, 0, (imgWidth-1)*2, 0, (imgWidth-1)*2,
	 * (imgHeight-1)*2, 0, (imgHeight-1)*2}.</li>
	 * </ul>
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the anchor point
	 * @param y
	 *            the y coordinate of the anchor point
	 * @param xys
	 *            the array of coordinates : x1,y1,x2,y2,x3,y3,x4,y4.
	 * @param anchor
	 *            position of the image around the anchor point
	 * @throws NullPointerException
	 *             if @{code image}, @{code gc} or @{code xys} array is @{code null}
	 * @throws IllegalArgumentException
	 *             if the @{code xys} length is different than 2*4.
	 */
	public void draw(GraphicsContext gc, Image image, int[] xys, int x, int y, int anchor) {
		throw new RuntimeException();
	}
}
