/*
 * Copyright 2018 IS2T. All rights reserved.
 *
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.basictool.map;

/**
 * This class implements the {@link AbstractPackedMap} class, using reference-equality when comparing keys. In other
 * words, in an IdentityPackedMap, two keys k1 and k2 are considered equal if and only if <code>(k1==k2)</code>.
 *
 * @param <K>
 *            the type of keys maintained by this map.
 * @param <V>
 *            the type of mapped values.
 */
public class IdentityPackedMap<K, V> extends AbstractPackedMap<K, V> {

	/**
	 * Constructs an empty map.
	 */
	public IdentityPackedMap() {
		super();
	}

	/**
	 * Constructs a map with the same mappings as the specified map.
	 *
	 * @param map
	 *            the map whose mappings are to be placed in this map.
	 * @throws NullPointerException
	 *             if the specified map is <code>null</code>.
	 */
	public IdentityPackedMap(IdentityPackedMap<K, V> map) {
		super(map);
	}

	@Override
	public Object clone() {
		return new IdentityPackedMap<>(this);
	}

	@Override
	protected boolean isSame(Object key, Object candidateKey) {
		return candidateKey == key;
	}

}
