/*
 * Copyright 2017-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.util.swipe;

/**
 * A swipe listener is notified when a swipe is started or stopped.
 */
public interface SwipeListener {

	/**
	 * A swipe is started.
	 */
	void onSwipeStarted();

	/**
	 * A swipe is stopped.
	 */
	void onSwipeStopped();

}
