/*
 * Java
 *
 * Copyright 2022-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

/**
 * Tests applying a color filter to an image.
 */
public class TestColorFilterMap {

	// private static final String BLENDMODE_SVG = "/com/microej/microvg/test/blendmode.xml";

	/**
	 * Starts MicroUI.
	 */
	@BeforeClass
	public static void pre() {
		TestUtilities.startMicroUI();
	}

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Resets the content of the screen to black.
	 */
	@Before
	public static void preTest() {
		TestUtilities.clearScreen();
	}

	// /**
	// * Tests transforming an image with {@link BlendMode#SRC}.
	// */
	// @Test
	// public static void testColorFilterFullMap() {
	// Display display = Display.getDisplay();
	// GraphicsContext g = display.getGraphicsContext();
	//
	// // Start of tests
	// drawTransformedImage(0xd5d5d5d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #08a808d5 fc: #d5d5d5d5", 125, 115, g, 0xc9b3d0);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #d5d5d5d5", 145, 145, g, 0xe1e1e1);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #d5d5d5d5", 145, 175, g, 0xe9e9e9);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #d5d5d5d5", 175, 125, g, 0xd0d0c9);
	// TestUtilities.check("SRC_OVER c: #a808a8d5 fc: #d5d5d5d5", 155, 135, g, 0xc9e1e9);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #d5d5d5d5", 125, 185, g, 0xf1d0f1);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #d5d5d5d5", 185, 185, g, 0xf1f1f1);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #d5d5d5d5", 115, 155, g, 0xe9c9e1);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #d5d5d5d5", 125, 155, g, 0xe9c9e9);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #d5d5d5d5", 175, 145, g, 0xe1e9e1);
	// TestUtilities.check("SRC_OVER c: #08a8a8a8 fc: #d5d5d5d5", 145, 115, g, 0xc9c9c9);
	// TestUtilities.check("SRC_OVER c: #0808d508 fc: #d5d5d5d5", 165, 105, g, 0xb3d0b3);
	// TestUtilities.check("SRC_OVER c: #a8d50808 fc: #d5d5d5d5", 105, 155, g, 0xe9c9c9);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #d5d5d5d5", 125, 165, g, 0xd0d0f1);
	// TestUtilities.check("SRC_OVER c: #0808d5a8 fc: #d5d5d5d5", 175, 105, g, 0xb3d0c9);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #d5d5d5d5", 105, 125, g, 0xd0b3b3);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #d5d5d5d5", 155, 115, g, 0xc9c9d0);
	// TestUtilities.check("SRC_OVER c: #08d5a8a8 fc: #d5d5d5d5", 145, 125, g, 0xd0c9c9);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #d5d5d5d5", 185, 145, g, 0xe1e9e9);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #d5d5d5d5", 165, 135, g, 0xc9e9c9);
	// drawTransformedImage(0x08a8d5a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #0808a8a8 fc: #08a8d5a8", 145, 105, g, 0x0a0f0f);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #08a8d5a8", 185, 185, g, 0xd6d6d6);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #08a8d5a8", 135, 165, g, 0x92d692);
	// TestUtilities.check("SRC_OVER c: #0808d508 fc: #08a8d5a8", 165, 105, g, 0x0a0f0a);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #08a8d5a8", 125, 185, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #08a8d5a8", 125, 155, g, 0xaa92aa);
	// TestUtilities.check("SRC_OVER c: #08a8a808 fc: #08a8d5a8", 135, 115, g, 0x0f0f0a);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #08a8d5a8", 175, 125, g, 0x0f0f0f);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #08a8d5a8", 135, 125, g, 0x0f0f0a);
	// TestUtilities.check("SRC_OVER c: #0808d5a8 fc: #08a8d5a8", 175, 105, g, 0x0a0f0f);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #08a8d5a8", 145, 135, g, 0x74aaaa);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #08a8d5a8", 145, 145, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #d5d50808 fc: #08a8d5a8", 105, 185, g, 0xd6b892);
	// TestUtilities.check("SRC_OVER c: #08d508a8 fc: #08a8d5a8", 115, 125, g, 0x0f0c0f);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #08a8d5a8", 185, 145, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #08a8d5a8", 155, 145, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #a8d5a808 fc: #08a8d5a8", 135, 155, g, 0xaaaa74);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #08a8d5a8", 125, 175, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #d5a808a8 fc: #08a8d5a8", 115, 175, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #d5a8d5a8 fc: #08a8d5a8", 175, 175, g, 0xd6d6d6);
	// drawTransformedImage(0xd5a808a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #08a8a8a8 fc: #d5a808a8", 145, 115, g, 0xa31da3);
	// TestUtilities.check("SRC_OVER c: #a8d5a808 fc: #d5a808a8", 135, 155, g, 0xbf209f);
	// TestUtilities.check("SRC_OVER c: #08a8d5a8 fc: #d5a808a8", 175, 115, g, 0xa324a3);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #d5a808a8", 105, 145, g, 0xb7089f);
	// TestUtilities.check("SRC_OVER c: #0808a8d5 fc: #d5a808a8", 155, 105, g, 0x8d1daa);
	// TestUtilities.check("SRC_OVER c: #0808a8a8 fc: #d5a808a8", 145, 105, g, 0x8d1da3);
	// TestUtilities.check("SRC_OVER c: #d508d508 fc: #d5a808a8", 165, 165, g, 0xa429a4);
	// TestUtilities.check("SRC_OVER c: #d5d5d5a8 fc: #d5a808a8", 175, 185, g, 0xc529bd);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #d5a808a8", 145, 135, g, 0x9f20b7);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #d5a808a8", 135, 165, g, 0xa422a4);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #d5a808a8", 165, 145, g, 0xb7289f);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #d5a808a8", 105, 115, g, 0xa3078d);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #d5a808a8", 135, 125, g, 0xaa1d8d);
	// TestUtilities.check("SRC_OVER c: #08d5d5d5 fc: #d5a808a8", 185, 125, g, 0xaa24aa);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #d5a808a8", 115, 155, g, 0xbf08b7);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #d5a808a8", 145, 175, g, 0xbd22bd);
	// TestUtilities.check("SRC_OVER c: #08d508d5 fc: #d5a808a8", 125, 125, g, 0xaa07aa);
	// TestUtilities.check("SRC_OVER c: #d50808a8 fc: #d5a808a8", 115, 165, g, 0xa408bd);
	// TestUtilities.check("SRC_OVER c: #d5a8d508 fc: #d5a808a8", 165, 175, g, 0xbd29a4);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #d5a808a8", 105, 125, g, 0xaa078d);
	// drawTransformedImage(0x08d5d5a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #a8d5a8a8 fc: #08d5d5a8", 145, 155, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #d5a808a8 fc: #08d5d5a8", 115, 175, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #d508d5a8 fc: #08d5d5a8", 175, 165, g, 0xb8d6d6);
	// TestUtilities.check("SRC_OVER c: #080808a8 fc: #08d5d5a8", 115, 105, g, 0x0c0c0f);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #08d5d5a8", 155, 125, g, 0x0f0f0f);
	// TestUtilities.check("SRC_OVER c: #08080808 fc: #08d5d5a8", 105, 105, g, 0x0c0c0a);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #08d5d5a8", 115, 155, g, 0xaa92aa);
	// TestUtilities.check("SRC_OVER c: #d5a8d5a8 fc: #08d5d5a8", 175, 175, g, 0xd6d6d6);
	// TestUtilities.check("SRC_OVER c: #a80808d5 fc: #08d5d5a8", 125, 135, g, 0x9292aa);
	// TestUtilities.check("SRC_OVER c: #d5d508a8 fc: #08d5d5a8", 115, 185, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #08d5d5a8", 145, 145, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #08d5d5a8", 155, 145, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #a8d5d508 fc: #08d5d5a8", 165, 155, g, 0xaaaa74);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #08d5d5a8", 135, 125, g, 0x0f0f0a);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #08d5d5a8", 125, 185, g, 0xd6b8d6);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #08d5d5a8", 135, 175, g, 0xd6d692);
	// TestUtilities.check("SRC_OVER c: #a8d5d5d5 fc: #08d5d5a8", 185, 155, g, 0xaaaaaa);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #08d5d5a8", 125, 155, g, 0xaa92aa);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #08d5d5a8", 145, 135, g, 0x92aaaa);
	// TestUtilities.check("SRC_OVER c: #a8d5a8d5 fc: #08d5d5a8", 155, 155, g, 0xaaaaaa);
	// drawTransformedImage(0x0808a808, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #0808a808", 145, 145, g, 0x71aa71);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #0808a808", 165, 145, g, 0x71aa0a);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #0808a808", 185, 135, g, 0x0aaa8e);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #0808a808", 165, 135, g, 0x0aaa0a);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #0808a808", 125, 165, g, 0x0c92b3);
	// TestUtilities.check("SRC_OVER c: #08a8d5a8 fc: #0808a808", 175, 115, g, 0x0a0f0a);
	// TestUtilities.check("SRC_OVER c: #08a8d5d5 fc: #0808a808", 185, 115, g, 0x0a0f0c);
	// TestUtilities.check("SRC_OVER c: #d5d5d5a8 fc: #0808a808", 175, 185, g, 0xb3d68e);
	// TestUtilities.check("SRC_OVER c: #a8a8a808 fc: #0808a808", 135, 145, g, 0x71aa0a);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #0808a808", 105, 125, g, 0x0c0a00);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #0808a808", 135, 165, g, 0x0cd60c);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #0808a808", 135, 135, g, 0x0aaa0a);
	// TestUtilities.check("SRC_OVER c: #d5a8d5d5 fc: #0808a808", 185, 175, g, 0x8ed6b3);
	// TestUtilities.check("SRC_OVER c: #a80808a8 fc: #0808a808", 115, 135, g, 0x0a7471);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #0808a808", 155, 145, g, 0x71aa8e);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #0808a808", 145, 175, g, 0x8ed68e);
	// TestUtilities.check("SRC_OVER c: #d5d50808 fc: #0808a808", 105, 185, g, 0xb3920c);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #0808a808", 135, 175, g, 0x8ed60c);
	// TestUtilities.check("SRC_OVER c: #0808d508 fc: #0808a808", 165, 105, g, 0x000f00);
	// TestUtilities.check("SRC_OVER c: #d5a808a8 fc: #0808a808", 115, 175, g, 0x8e928e);
	// drawTransformedImage(0xd50808d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #d50808d5", 145, 145, g, 0x2020e1);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #d50808d5", 155, 145, g, 0x2020e9);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #d50808d5", 155, 165, g, 0x0822f1);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #d50808d5", 175, 125, g, 0x2424c9);
	// TestUtilities.check("SRC_OVER c: #a808a8d5 fc: #d50808d5", 155, 135, g, 0x0820e9);
	// TestUtilities.check("SRC_OVER c: #08a8d5a8 fc: #d50808d5", 175, 115, g, 0x1d24c9);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #d50808d5", 165, 125, g, 0x2424b3);
	// TestUtilities.check("SRC_OVER c: #08a8d5d5 fc: #d50808d5", 185, 115, g, 0x1d24d0);
	// TestUtilities.check("SRC_OVER c: #a8d5a8d5 fc: #d50808d5", 155, 155, g, 0x2820e9);
	// TestUtilities.check("SRC_OVER c: #d5d50808 fc: #d50808d5", 105, 185, g, 0x2908d0);
	// TestUtilities.check("SRC_OVER c: #d508d5d5 fc: #d50808d5", 185, 165, g, 0x0829f1);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #d50808d5", 115, 115, g, 0x1d07c9);
	// TestUtilities.check("SRC_OVER c: #a808d5a8 fc: #d50808d5", 175, 135, g, 0x0828e1);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #d50808d5", 185, 135, g, 0x0828e9);
	// TestUtilities.check("SRC_OVER c: #08a8d508 fc: #d50808d5", 165, 115, g, 0x1d24b3);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #d50808d5", 145, 135, g, 0x0820e1);
	// TestUtilities.check("SRC_OVER c: #0808d5d5 fc: #d50808d5", 185, 105, g, 0x0724d0);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #d50808d5", 135, 125, g, 0x241db3);
	// TestUtilities.check("SRC_OVER c: #a8a8a808 fc: #d50808d5", 135, 145, g, 0x2020c9);
	// TestUtilities.check("SRC_OVER c: #d5d5a808 fc: #d50808d5", 135, 185, g, 0x2922d0);
	// drawTransformedImage(0x0808d5d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #08d508a8 fc: #0808d5d5", 115, 125, g, 0x0c0c0f);
	// TestUtilities.check("SRC_OVER c: #a8d5d5d5 fc: #0808d5d5", 185, 155, g, 0x8eaaaa);
	// TestUtilities.check("SRC_OVER c: #d5a80808 fc: #0808d5d5", 105, 175, g, 0x8eb8b8);
	// TestUtilities.check("SRC_OVER c: #d5a8d5d5 fc: #0808d5d5", 185, 175, g, 0x8ed6d6);
	// TestUtilities.check("SRC_OVER c: #a8a8a808 fc: #0808d5d5", 135, 145, g, 0x71aa92);
	// TestUtilities.check("SRC_OVER c: #d508d5a8 fc: #0808d5d5", 175, 165, g, 0x0cd6d6);
	// TestUtilities.check("SRC_OVER c: #08a8a8a8 fc: #0808d5d5", 145, 115, g, 0x0a0f0f);
	// TestUtilities.check("SRC_OVER c: #08a8d508 fc: #0808d5d5", 165, 115, g, 0x0a0f0c);
	// TestUtilities.check("SRC_OVER c: #a8d5a8d5 fc: #0808d5d5", 155, 155, g, 0x8eaaaa);
	// TestUtilities.check("SRC_OVER c: #080808a8 fc: #0808d5d5", 115, 105, g, 0x000c0f);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #0808d5d5", 175, 125, g, 0x0c0f0f);
	// TestUtilities.check("SRC_OVER c: #08d5a8a8 fc: #0808d5d5", 145, 125, g, 0x0c0f0f);
	// TestUtilities.check("SRC_OVER c: #0808a8d5 fc: #0808d5d5", 155, 105, g, 0x000f0f);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #0808d5d5", 105, 115, g, 0x0a0c0c);
	// TestUtilities.check("SRC_OVER c: #a80808a8 fc: #0808d5d5", 115, 135, g, 0x0a92aa);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #0808d5d5", 155, 165, g, 0x0cd6d6);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #0808d5d5", 125, 175, g, 0x8eb8d6);
	// TestUtilities.check("SRC_OVER c: #a80808d5 fc: #0808d5d5", 125, 135, g, 0x0a92aa);
	// TestUtilities.check("SRC_OVER c: #d5d5d508 fc: #0808d5d5", 165, 185, g, 0xb3d6b8);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #0808d5d5", 155, 125, g, 0x0c0f0f);
	// drawTransformedImage(0xa808d5a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #080808d5 fc: #a808d5a8", 125, 105, g, 0x068fa0);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #a808d5a8", 135, 165, g, 0x09f0a0);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #a808d5a8", 175, 125, g, 0x35aa96);
	// TestUtilities.check("SRC_OVER c: #a8d50808 fc: #a808d5a8", 105, 155, g, 0x46bd96);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #a808d5a8", 165, 135, g, 0x08e196);
	// TestUtilities.check("SRC_OVER c: #08a8a8a8 fc: #a808d5a8", 145, 115, g, 0x2baa96);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #a808d5a8", 185, 145, g, 0x39e1d3);
	// TestUtilities.check("SRC_OVER c: #a8d5a8a8 fc: #a808d5a8", 145, 155, g, 0x46e1c6);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #a808d5a8", 105, 115, g, 0x2b8f71);
	// TestUtilities.check("SRC_OVER c: #a8a808d5 fc: #a808d5a8", 125, 145, g, 0x39bdd3);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #a808d5a8", 135, 125, g, 0x35aa71);
	// TestUtilities.check("SRC_OVER c: #0808a808 fc: #a808d5a8", 135, 105, g, 0x06aa71);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #a808d5a8", 135, 175, g, 0x3df0a0);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #a808d5a8", 175, 145, g, 0x39e1c6);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #a808d5a8", 185, 185, g, 0x4bf0e1);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #a808d5a8", 165, 145, g, 0x39e196);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #a808d5a8", 145, 175, g, 0x3df0d3);
	// TestUtilities.check("SRC_OVER c: #a8d5d508 fc: #a808d5a8", 165, 155, g, 0x46e196);
	// TestUtilities.check("SRC_OVER c: #d5d5a808 fc: #a808d5a8", 135, 185, g, 0x4bf0a0);
	// TestUtilities.check("SRC_OVER c: #a808a8d5 fc: #a808d5a8", 155, 135, g, 0x08e1d3);
	// drawTransformedImage(0xa80808a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #a80808a8", 135, 165, g, 0x093da0);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #a80808a8", 105, 115, g, 0x2b0671);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #a80808a8", 125, 185, g, 0x4b09e1);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #a80808a8", 135, 135, g, 0x083996);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #a80808a8", 145, 145, g, 0x3939c6);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #a80808a8", 165, 125, g, 0x353571);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #a80808a8", 175, 145, g, 0x3946c6);
	// TestUtilities.check("SRC_OVER c: #a8d5d5d5 fc: #a80808a8", 185, 155, g, 0x4646d3);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #a80808a8", 175, 125, g, 0x353596);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #a80808a8", 155, 165, g, 0x093de1);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #a80808a8", 185, 135, g, 0x0846d3);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #a80808a8", 115, 145, g, 0x3908c6);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #a80808a8", 105, 145, g, 0x390896);
	// TestUtilities.check("SRC_OVER c: #08080808 fc: #a80808a8", 105, 105, g, 0x060671);
	// TestUtilities.check("SRC_OVER c: #a8d5d5a8 fc: #a80808a8", 175, 155, g, 0x4646c6);
	// TestUtilities.check("SRC_OVER c: #d5d508a8 fc: #a80808a8", 115, 185, g, 0x4b09d3);
	// TestUtilities.check("SRC_OVER c: #d5a808a8 fc: #a80808a8", 115, 175, g, 0x3d09d3);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #a80808a8", 125, 155, g, 0x4608d3);
	// TestUtilities.check("SRC_OVER c: #08a8d5d5 fc: #a80808a8", 185, 115, g, 0x2b35a0);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #a80808a8", 145, 135, g, 0x0839c6);
	// drawTransformedImage(0xa808a8d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #0808d5a8 fc: #a808a8d5", 175, 105, g, 0x06a0aa);
	// TestUtilities.check("SRC_OVER c: #08a808d5 fc: #a808a8d5", 125, 115, g, 0x2b71aa);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #a808a8d5", 145, 135, g, 0x08c6e1);
	// TestUtilities.check("SRC_OVER c: #08d508d5 fc: #a808a8d5", 125, 125, g, 0x3571aa);
	// TestUtilities.check("SRC_OVER c: #080808d5 fc: #a808a8d5", 125, 105, g, 0x0671aa);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #a808a8d5", 155, 125, g, 0x3596aa);
	// TestUtilities.check("SRC_OVER c: #a8080808 fc: #a808a8d5", 105, 135, g, 0x0896bd);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #a808a8d5", 115, 115, g, 0x2b71aa);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #a808a8d5", 165, 125, g, 0x35a08f);
	// TestUtilities.check("SRC_OVER c: #0808a8d5 fc: #a808a8d5", 155, 105, g, 0x0696aa);
	// TestUtilities.check("SRC_OVER c: #d5d50808 fc: #a808a8d5", 105, 185, g, 0x4ba0ca);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #a808a8d5", 145, 175, g, 0x3dd3f0);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #a808a8d5", 145, 145, g, 0x39c6e1);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #a808a8d5", 125, 185, g, 0x4ba0f0);
	// TestUtilities.check("SRC_OVER c: #08a8d5a8 fc: #a808a8d5", 175, 115, g, 0x2ba0aa);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #a808a8d5", 175, 145, g, 0x39d3e1);
	// TestUtilities.check("SRC_OVER c: #0808d5d5 fc: #a808a8d5", 185, 105, g, 0x06a0aa);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #a808a8d5", 185, 135, g, 0x08d3e1);
	// TestUtilities.check("SRC_OVER c: #d508a8a8 fc: #a808a8d5", 145, 165, g, 0x09d3f0);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #a808a8d5", 165, 135, g, 0x08d3bd);
	// drawTransformedImage(0x08a8a808, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #08a8a808", 185, 185, g, 0xd6d6b3);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #08a8a808", 125, 155, g, 0xaa748e);
	// TestUtilities.check("SRC_OVER c: #08d5a8a8 fc: #08a8a808", 145, 125, g, 0x0f0f0a);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #08a8a808", 165, 135, g, 0x74aa0a);
	// TestUtilities.check("SRC_OVER c: #d5d5a808 fc: #08a8a808", 135, 185, g, 0xd6d60c);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #08a8a808", 125, 175, g, 0xd692b3);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #08a8a808", 125, 165, g, 0x9292b3);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #08a8a808", 145, 175, g, 0xd6d68e);
	// TestUtilities.check("SRC_OVER c: #d5d5d5a8 fc: #08a8a808", 175, 185, g, 0xd6d68e);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #08a8a808", 145, 145, g, 0xaaaa71);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #08a8a808", 155, 125, g, 0x0f0f0c);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #08a8a808", 105, 115, g, 0x0f0a00);
	// TestUtilities.check("SRC_OVER c: #0808a8d5 fc: #08a8a808", 155, 105, g, 0x0a0f0c);
	// TestUtilities.check("SRC_OVER c: #08080808 fc: #08a8a808", 105, 105, g, 0x0a0a00);
	// TestUtilities.check("SRC_OVER c: #a8d5a808 fc: #08a8a808", 135, 155, g, 0xaaaa0a);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #08a8a808", 115, 115, g, 0x0f0a0a);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #08a8a808", 155, 115, g, 0x0f0f0c);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #08a8a808", 135, 175, g, 0xd6d60c);
	// TestUtilities.check("SRC_OVER c: #a8a8a808 fc: #08a8a808", 135, 145, g, 0xaaaa0a);
	// TestUtilities.check("SRC_OVER c: #a8080808 fc: #08a8a808", 105, 135, g, 0x74740a);
	// drawTransformedImage(0x08a80808, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #08a80808", 155, 145, g, 0xaa718e);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #08a80808", 135, 135, g, 0x74710a);
	// TestUtilities.check("SRC_OVER c: #d5080808 fc: #08a80808", 105, 165, g, 0x920c0c);
	// TestUtilities.check("SRC_OVER c: #d5d5a8d5 fc: #08a80808", 155, 185, g, 0xd68eb3);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #08a80808", 105, 115, g, 0x0f0000);
	// TestUtilities.check("SRC_OVER c: #a8a808d5 fc: #08a80808", 125, 145, g, 0xaa0a8e);
	// TestUtilities.check("SRC_OVER c: #d5a8d5d5 fc: #08a80808", 185, 175, g, 0xd6b3b3);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #08a80808", 125, 165, g, 0x920cb3);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #08a80808", 155, 165, g, 0x928eb3);
	// TestUtilities.check("SRC_OVER c: #080808d5 fc: #08a80808", 125, 105, g, 0x0a000c);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #08a80808", 125, 175, g, 0xd60cb3);
	// TestUtilities.check("SRC_OVER c: #0808d5a8 fc: #08a80808", 175, 105, g, 0x0a0c0a);
	// TestUtilities.check("SRC_OVER c: #0808a808 fc: #08a80808", 135, 105, g, 0x0a0a00);
	// TestUtilities.check("SRC_OVER c: #080808a8 fc: #08a80808", 115, 105, g, 0x0a000a);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #08a80808", 135, 175, g, 0xd68e0c);
	// TestUtilities.check("SRC_OVER c: #08a808d5 fc: #08a80808", 125, 115, g, 0x0f000c);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #08a80808", 145, 175, g, 0xd68e8e);
	// TestUtilities.check("SRC_OVER c: #d5a8d5a8 fc: #08a80808", 175, 175, g, 0xd6b38e);
	// TestUtilities.check("SRC_OVER c: #a80808a8 fc: #08a80808", 115, 135, g, 0x740a71);
	// TestUtilities.check("SRC_OVER c: #0808a8a8 fc: #08a80808", 145, 105, g, 0x0a0a0a);
	// drawTransformedImage(0xa808a8a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d508a8a8 fc: #a808a8a8", 145, 165, g, 0x09d3d3);
	// TestUtilities.check("SRC_OVER c: #08a8a8a8 fc: #a808a8a8", 145, 115, g, 0x2b9696);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #a808a8a8", 105, 115, g, 0x2b7171);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #a808a8a8", 155, 115, g, 0x2b96a0);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #a808a8a8", 135, 135, g, 0x08c696);
	// TestUtilities.check("SRC_OVER c: #a8d5d5d5 fc: #a808a8a8", 185, 155, g, 0x46d3d3);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #a808a8a8", 185, 145, g, 0x39d3d3);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #a808a8a8", 125, 155, g, 0x4696d3);
	// TestUtilities.check("SRC_OVER c: #d5d5a8a8 fc: #a808a8a8", 145, 185, g, 0x4bd3d3);
	// TestUtilities.check("SRC_OVER c: #0808d5d5 fc: #a808a8a8", 185, 105, g, 0x06a0a0);
	// TestUtilities.check("SRC_OVER c: #a8d5a8a8 fc: #a808a8a8", 145, 155, g, 0x46c6c6);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #a808a8a8", 115, 145, g, 0x3996c6);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #a808a8a8", 125, 165, g, 0x09a0e1);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #a808a8a8", 155, 145, g, 0x39c6d3);
	// TestUtilities.check("SRC_OVER c: #d508d5a8 fc: #a808a8a8", 175, 165, g, 0x09e1d3);
	// TestUtilities.check("SRC_OVER c: #d5d50808 fc: #a808a8a8", 105, 185, g, 0x4ba0a0);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #a808a8a8", 105, 125, g, 0x357171);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #a808a8a8", 165, 125, g, 0x35a071);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #a808a8a8", 105, 145, g, 0x399696);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #a808a8a8", 175, 145, g, 0x39d3c6);
	// drawTransformedImage(0xd5080808, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d5a8a808 fc: #d5080808", 135, 175, g, 0x222208);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #d5080808", 115, 115, g, 0x1d071d);
	// TestUtilities.check("SRC_OVER c: #0808d508 fc: #d5080808", 165, 105, g, 0x072407);
	// TestUtilities.check("SRC_OVER c: #a80808a8 fc: #d5080808", 115, 135, g, 0x080820);
	// TestUtilities.check("SRC_OVER c: #d5d5a8a8 fc: #d5080808", 145, 185, g, 0x292222);
	// TestUtilities.check("SRC_OVER c: #a8d5a8d5 fc: #d5080808", 155, 155, g, 0x282028);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #d5080808", 185, 135, g, 0x082828);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #d5080808", 155, 115, g, 0x1d1d24);
	// TestUtilities.check("SRC_OVER c: #d508a8a8 fc: #d5080808", 145, 165, g, 0x082222);
	// TestUtilities.check("SRC_OVER c: #a8a8a808 fc: #d5080808", 135, 145, g, 0x202008);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #d5080808", 155, 165, g, 0x082229);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #d5080808", 165, 145, g, 0x202808);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #d5080808", 105, 145, g, 0x200808);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #d5080808", 135, 135, g, 0x082008);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #d5080808", 145, 135, g, 0x082020);
	// TestUtilities.check("SRC_OVER c: #d508d508 fc: #d5080808", 165, 165, g, 0x082908);
	// TestUtilities.check("SRC_OVER c: #08a808d5 fc: #d5080808", 125, 115, g, 0x1d0724);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #d5080808", 185, 145, g, 0x202828);
	// TestUtilities.check("SRC_OVER c: #a8a8a8d5 fc: #d5080808", 155, 145, g, 0x202028);
	// TestUtilities.check("SRC_OVER c: #d5d5d508 fc: #d5080808", 165, 185, g, 0x292908);
	// drawTransformedImage(0xd5d5a808, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #d5d5a808", 185, 145, g, 0xe1bf28);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #d5d5a808", 105, 115, g, 0xc98d07);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #d5d5a808", 125, 185, g, 0xf1a429);
	// TestUtilities.check("SRC_OVER c: #d5d5a8d5 fc: #d5d5a808", 155, 185, g, 0xf1bd29);
	// TestUtilities.check("SRC_OVER c: #08d508d5 fc: #d5d5a808", 125, 125, g, 0xd08d24);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #d5d5a808", 145, 175, g, 0xe9bd22);
	// TestUtilities.check("SRC_OVER c: #d508d5d5 fc: #d5d5a808", 185, 165, g, 0xd0c529);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #d5d5a808", 105, 145, g, 0xe19f08);
	// TestUtilities.check("SRC_OVER c: #080808d5 fc: #d5d5a808", 125, 105, g, 0xb38d24);
	// TestUtilities.check("SRC_OVER c: #08d5a8a8 fc: #d5d5a808", 145, 125, g, 0xd0a31d);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #d5d5a808", 115, 145, g, 0xe19f20);
	// TestUtilities.check("SRC_OVER c: #08d5a808 fc: #d5d5a808", 135, 125, g, 0xd0a307);
	// TestUtilities.check("SRC_OVER c: #a80808d5 fc: #d5d5a808", 125, 135, g, 0xc99f28);
	// TestUtilities.check("SRC_OVER c: #d508a8a8 fc: #d5d5a808", 145, 165, g, 0xd0bd22);
	// TestUtilities.check("SRC_OVER c: #a8d5d5a8 fc: #d5d5a808", 175, 155, g, 0xe9bf20);
	// TestUtilities.check("SRC_OVER c: #d508d5a8 fc: #d5d5a808", 175, 165, g, 0xd0c522);
	// TestUtilities.check("SRC_OVER c: #a808a808 fc: #d5d5a808", 135, 135, g, 0xc9b708);
	// TestUtilities.check("SRC_OVER c: #08d5d5d5 fc: #d5d5a808", 185, 125, g, 0xd0aa24);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #d5d5a808", 135, 165, g, 0xd0bd08);
	// TestUtilities.check("SRC_OVER c: #d5d5d5a8 fc: #d5d5a808", 175, 185, g, 0xf1c522);
	// drawTransformedImage(0xa8d5d508, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #a8d5d508", 125, 185, g, 0xf0ca4b);
	// TestUtilities.check("SRC_OVER c: #d5d5a8a8 fc: #a8d5d508", 145, 185, g, 0xf0f03d);
	// TestUtilities.check("SRC_OVER c: #a8d5a8d5 fc: #a8d5d508", 155, 155, g, 0xe1e146);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #a8d5d508", 165, 125, g, 0xaaaa06);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #a8d5d508", 155, 115, g, 0xaaaa35);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #a8d5d508", 115, 145, g, 0xe1bd39);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #a8d5d508", 145, 175, g, 0xf0f03d);
	// TestUtilities.check("SRC_OVER c: #a8d5d5a8 fc: #a8d5d508", 175, 155, g, 0xe1e139);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #a8d5d508", 145, 145, g, 0xe1e139);
	// TestUtilities.check("SRC_OVER c: #080808a8 fc: #a8d5d508", 115, 105, g, 0x8f8f2b);
	// TestUtilities.check("SRC_OVER c: #a8d50808 fc: #a8d5d508", 105, 155, g, 0xe1bd08);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #a8d5d508", 105, 145, g, 0xe1bd08);
	// TestUtilities.check("SRC_OVER c: #08080808 fc: #a8d5d508", 105, 105, g, 0x8f8f06);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #a8d5d508", 115, 115, g, 0xaa8f2b);
	// TestUtilities.check("SRC_OVER c: #d5a8d5d5 fc: #a8d5d508", 185, 175, g, 0xf0f04b);
	// TestUtilities.check("SRC_OVER c: #a8a8d5a8 fc: #a8d5d508", 175, 145, g, 0xe1e139);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #a8d5d508", 105, 115, g, 0xaa8f06);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #a8d5d508", 155, 165, g, 0xcaf04b);
	// TestUtilities.check("SRC_OVER c: #d5080808 fc: #a8d5d508", 105, 165, g, 0xcaca09);
	// TestUtilities.check("SRC_OVER c: #080808d5 fc: #a8d5d508", 125, 105, g, 0x8f8f35);
	// drawTransformedImage(0x0808d5a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #08d5d508 fc: #0808d5a8", 165, 125, g, 0x0c0f0a);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #0808d5a8", 185, 145, g, 0x71aaaa);
	// TestUtilities.check("SRC_OVER c: #d5a8d5a8 fc: #0808d5a8", 175, 175, g, 0x8ed6d6);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #0808d5a8", 185, 185, g, 0xb3d6d6);
	// TestUtilities.check("SRC_OVER c: #08a80808 fc: #0808d5a8", 105, 115, g, 0x0a0c0a);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #0808d5a8", 135, 165, g, 0x0cd692);
	// TestUtilities.check("SRC_OVER c: #0808a808 fc: #0808d5a8", 135, 105, g, 0x000f0a);
	// TestUtilities.check("SRC_OVER c: #08a8d5a8 fc: #0808d5a8", 175, 115, g, 0x0a0f0f);
	// TestUtilities.check("SRC_OVER c: #a808d5a8 fc: #0808d5a8", 175, 135, g, 0x0aaaaa);
	// TestUtilities.check("SRC_OVER c: #a8a8a8a8 fc: #0808d5a8", 145, 145, g, 0x71aaaa);
	// TestUtilities.check("SRC_OVER c: #a80808a8 fc: #0808d5a8", 115, 135, g, 0x0a92aa);
	// TestUtilities.check("SRC_OVER c: #08a8d508 fc: #0808d5a8", 165, 115, g, 0x0a0f0a);
	// TestUtilities.check("SRC_OVER c: #d5d5d508 fc: #0808d5a8", 165, 185, g, 0xb3d692);
	// TestUtilities.check("SRC_OVER c: #0808d5d5 fc: #0808d5a8", 185, 105, g, 0x000f0f);
	// TestUtilities.check("SRC_OVER c: #a8d5a808 fc: #0808d5a8", 135, 155, g, 0x8eaa74);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #0808d5a8", 125, 185, g, 0xb3b8d6);
	// TestUtilities.check("SRC_OVER c: #a8080808 fc: #0808d5a8", 105, 135, g, 0x0a9274);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #0808d5a8", 165, 145, g, 0x71aa74);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #0808d5a8", 145, 135, g, 0x0aaaaa);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #0808d5a8", 125, 165, g, 0x0cb8d6);
	// drawTransformedImage(0xd508d5a8, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #d508d5a8", 155, 125, g, 0x24c9aa);
	// TestUtilities.check("SRC_OVER c: #d5a80808 fc: #d508d5a8", 105, 175, g, 0x22d0a4);
	// TestUtilities.check("SRC_OVER c: #08d5a8a8 fc: #d508d5a8", 145, 125, g, 0x24c9a3);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #d508d5a8", 155, 165, g, 0x08e9c5);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #d508d5a8", 185, 185, g, 0x29f1c5);
	// TestUtilities.check("SRC_OVER c: #08a8d5d5 fc: #d508d5a8", 185, 115, g, 0x1dd0aa);
	// TestUtilities.check("SRC_OVER c: #d5d508a8 fc: #d508d5a8", 115, 185, g, 0x29d0bd);
	// TestUtilities.check("SRC_OVER c: #a808a8a8 fc: #d508d5a8", 145, 135, g, 0x08e1b7);
	// TestUtilities.check("SRC_OVER c: #a8080808 fc: #d508d5a8", 105, 135, g, 0x08c99f);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #d508d5a8", 115, 155, g, 0x28c9b7);
	// TestUtilities.check("SRC_OVER c: #08a8a8d5 fc: #d508d5a8", 155, 115, g, 0x1dc9aa);
	// TestUtilities.check("SRC_OVER c: #d5a8d5a8 fc: #d508d5a8", 175, 175, g, 0x22f1bd);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #d508d5a8", 115, 145, g, 0x20c9b7);
	// TestUtilities.check("SRC_OVER c: #d50808d5 fc: #d508d5a8", 125, 165, g, 0x08d0c5);
	// TestUtilities.check("SRC_OVER c: #a8d5a8a8 fc: #d508d5a8", 145, 155, g, 0x28e1b7);
	// TestUtilities.check("SRC_OVER c: #a80808d5 fc: #d508d5a8", 125, 135, g, 0x08c9bf);
	// TestUtilities.check("SRC_OVER c: #d5d5d508 fc: #d508d5a8", 165, 185, g, 0x29f1a4);
	// TestUtilities.check("SRC_OVER c: #0808a808 fc: #d508d5a8", 135, 105, g, 0x07c98d);
	// TestUtilities.check("SRC_OVER c: #d5d5d5a8 fc: #d508d5a8", 175, 185, g, 0x29f1bd);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #d508d5a8", 125, 155, g, 0x28c9bf);
	// drawTransformedImage(0xa808d5d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #0808d508 fc: #a808d5d5", 165, 105, g, 0x06aa8f);
	// TestUtilities.check("SRC_OVER c: #a8a808a8 fc: #a808d5d5", 115, 145, g, 0x39bde1);
	// TestUtilities.check("SRC_OVER c: #0808d5d5 fc: #a808d5d5", 185, 105, g, 0x06aaaa);
	// TestUtilities.check("SRC_OVER c: #d5d508a8 fc: #a808d5d5", 115, 185, g, 0x4bcaf0);
	// TestUtilities.check("SRC_OVER c: #a8a8d5d5 fc: #a808d5d5", 185, 145, g, 0x39e1e1);
	// TestUtilities.check("SRC_OVER c: #a8d508d5 fc: #a808d5d5", 125, 155, g, 0x46bde1);
	// TestUtilities.check("SRC_OVER c: #a8a808d5 fc: #a808d5d5", 125, 145, g, 0x39bde1);
	// TestUtilities.check("SRC_OVER c: #d508a8d5 fc: #a808d5d5", 155, 165, g, 0x09f0f0);
	// TestUtilities.check("SRC_OVER c: #0808a8a8 fc: #a808d5d5", 145, 105, g, 0x06aaaa);
	// TestUtilities.check("SRC_OVER c: #0808a8d5 fc: #a808d5d5", 155, 105, g, 0x06aaaa);
	// TestUtilities.check("SRC_OVER c: #a808a8d5 fc: #a808d5d5", 155, 135, g, 0x08e1e1);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #a808d5d5", 115, 155, g, 0x46bde1);
	// TestUtilities.check("SRC_OVER c: #a8080808 fc: #a808d5d5", 105, 135, g, 0x08bdbd);
	// TestUtilities.check("SRC_OVER c: #a808d5d5 fc: #a808d5d5", 185, 135, g, 0x08e1e1);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #a808d5d5", 125, 175, g, 0x3dcaf0);
	// TestUtilities.check("SRC_OVER c: #d508a808 fc: #a808d5d5", 135, 165, g, 0x09f0ca);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #a808d5d5", 185, 185, g, 0x4bf0f0);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #a808d5d5", 115, 115, g, 0x2b8faa);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #a808d5d5", 105, 125, g, 0x358f8f);
	// TestUtilities.check("SRC_OVER c: #d5a8a8a8 fc: #a808d5d5", 145, 175, g, 0x3df0f0);
	// drawTransformedImage(0x080808d5, BlendMode.SRC_OVER);
	// TestUtilities.check("SRC_OVER c: #d5d5d5d5 fc: #080808d5", 185, 185, g, 0xb3b3d6);
	// TestUtilities.check("SRC_OVER c: #a8d50808 fc: #080808d5", 105, 155, g, 0x8e0a92);
	// TestUtilities.check("SRC_OVER c: #d5d5a8d5 fc: #080808d5", 155, 185, g, 0xb38ed6);
	// TestUtilities.check("SRC_OVER c: #a8a8d508 fc: #080808d5", 165, 145, g, 0x718e92);
	// TestUtilities.check("SRC_OVER c: #08a8d508 fc: #080808d5", 165, 115, g, 0x0a0c0c);
	// TestUtilities.check("SRC_OVER c: #0808a808 fc: #080808d5", 135, 105, g, 0x000a0c);
	// TestUtilities.check("SRC_OVER c: #08d50808 fc: #080808d5", 105, 125, g, 0x0c000c);
	// TestUtilities.check("SRC_OVER c: #a8a80808 fc: #080808d5", 105, 145, g, 0x710a92);
	// TestUtilities.check("SRC_OVER c: #a8d5d5d5 fc: #080808d5", 185, 155, g, 0x8e8eaa);
	// TestUtilities.check("SRC_OVER c: #08d5d5a8 fc: #080808d5", 175, 125, g, 0x0c0c0f);
	// TestUtilities.check("SRC_OVER c: #a8a808d5 fc: #080808d5", 125, 145, g, 0x710aaa);
	// TestUtilities.check("SRC_OVER c: #a8d508a8 fc: #080808d5", 115, 155, g, 0x8e0aaa);
	// TestUtilities.check("SRC_OVER c: #08d5a8d5 fc: #080808d5", 155, 125, g, 0x0c0a0f);
	// TestUtilities.check("SRC_OVER c: #0808a8a8 fc: #080808d5", 145, 105, g, 0x000a0f);
	// TestUtilities.check("SRC_OVER c: #a808d508 fc: #080808d5", 165, 135, g, 0x0a8e92);
	// TestUtilities.check("SRC_OVER c: #d5d5d508 fc: #080808d5", 165, 185, g, 0xb3b3b8);
	// TestUtilities.check("SRC_OVER c: #d5d508d5 fc: #080808d5", 125, 185, g, 0xb30cd6);
	// TestUtilities.check("SRC_OVER c: #d5a808d5 fc: #080808d5", 125, 175, g, 0x8e0cd6);
	// TestUtilities.check("SRC_OVER c: #d508d508 fc: #080808d5", 165, 165, g, 0x0cb3b8);
	// TestUtilities.check("SRC_OVER c: #08a808a8 fc: #080808d5", 115, 115, g, 0x0a000f);
	// drawTransformedImage(0x08a808a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #08a808a8", 105, 115, g, 0x0f000a);
	// TestUtilities.check("DST_OVER c: #08d5d508 fc: #08a808a8", 165, 125, g, 0x0f0c0a);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #08a808a8", 165, 135, g, 0x2b8f2b);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #08a808a8", 125, 145, g, 0x9606aa);
	// TestUtilities.check("DST_OVER c: #080808d5 fc: #08a808a8", 125, 105, g, 0x0a000f);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #08a808a8", 185, 145, g, 0x968faa);
	// TestUtilities.check("DST_OVER c: #d508d5a8 fc: #08a808a8", 175, 165, g, 0x1db3a3);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #08a808a8", 125, 135, g, 0x2b06aa);
	// TestUtilities.check("DST_OVER c: #d5a808d5 fc: #08a808a8", 125, 175, g, 0xa307c9);
	// TestUtilities.check("DST_OVER c: #d508a808 fc: #08a808a8", 135, 165, g, 0x1d8d1d);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #08a808a8", 135, 135, g, 0x2b712b);
	// TestUtilities.check("DST_OVER c: #d508d5d5 fc: #08a808a8", 185, 165, g, 0x1db3c9);
	// TestUtilities.check("DST_OVER c: #08a8a8a8 fc: #08a808a8", 145, 115, g, 0x0f0a0f);
	// TestUtilities.check("DST_OVER c: #08d508a8 fc: #08a808a8", 115, 125, g, 0x0f000f);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #08a808a8", 155, 105, g, 0x0a0a0f);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #08a808a8", 145, 185, g, 0xc98da3);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #08a808a8", 145, 135, g, 0x2b7196);
	// TestUtilities.check("DST_OVER c: #d5a8a8d5 fc: #08a808a8", 155, 175, g, 0xa38dc9);
	// TestUtilities.check("DST_OVER c: #d508a8a8 fc: #08a808a8", 145, 165, g, 0x1d8da3);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #08a808a8", 175, 185, g, 0xc9b3a3);
	// drawTransformedImage(0xa808a8a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #08d508d5 fc: #a808a8a8", 125, 125, g, 0x9271aa);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #a808a8a8", 115, 175, g, 0x9f20b7);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #a808a8a8", 135, 135, g, 0x08c639);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #a808a8a8", 155, 105, g, 0x0aaaaa);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #a808a8a8", 145, 185, g, 0xc9b7b7);
	// TestUtilities.check("DST_OVER c: #d5a8a8a8 fc: #a808a8a8", 145, 175, g, 0x9fb7b7);
	// TestUtilities.check("DST_OVER c: #a8d508a8 fc: #a808a8a8", 115, 155, g, 0xbd39c6);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #a808a8a8", 175, 155, g, 0xbde1c6);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #a808a8a8", 105, 105, g, 0x0a7171);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #a808a8a8", 135, 155, g, 0xbdc639);
	// TestUtilities.check("DST_OVER c: #d5d5a808 fc: #a808a8a8", 135, 185, g, 0xc9b720);
	// TestUtilities.check("DST_OVER c: #d5a8a808 fc: #a808a8a8", 135, 175, g, 0x9fb720);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #a808a8a8", 115, 135, g, 0x0839c6);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #a808a8a8", 175, 125, g, 0x92aaaa);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #a808a8a8", 185, 145, g, 0x96e1e1);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #a808a8a8", 165, 135, g, 0x08e139);
	// TestUtilities.check("DST_OVER c: #0808d5d5 fc: #a808a8a8", 185, 105, g, 0x0aaaaa);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #a808a8a8", 175, 185, g, 0xc9e1b7);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #a808a8a8", 175, 145, g, 0x96e1c6);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #a808a8a8", 125, 145, g, 0x9639e1);
	// drawTransformedImage(0x08d5d5a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #08d5d5a8", 185, 145, g, 0xa0aaaa);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #08d5d5a8", 145, 155, g, 0xaaa096);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #08d5d5a8", 125, 135, g, 0x3535aa);
	// TestUtilities.check("DST_OVER c: #d508a8d5 fc: #08d5d5a8", 155, 165, g, 0x24aac9);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #08d5d5a8", 115, 135, g, 0x353596);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #08d5d5a8", 165, 145, g, 0xa0aa2b);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #08d5d5a8", 165, 135, g, 0x35aa2b);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #08d5d5a8", 175, 185, g, 0xd0d0a3);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #08d5d5a8", 105, 175, g, 0xaa241d);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #08d5d5a8", 105, 115, g, 0x0f0c0a);
	// TestUtilities.check("DST_OVER c: #d508d5a8 fc: #08d5d5a8", 175, 165, g, 0x24d0a3);
	// TestUtilities.check("DST_OVER c: #d5d5d508 fc: #08d5d5a8", 165, 185, g, 0xd0d01d);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #08d5d5a8", 175, 105, g, 0x0c0f0f);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #08d5d5a8", 175, 125, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #d5d50808 fc: #08d5d5a8", 105, 185, g, 0xd0241d);
	// TestUtilities.check("DST_OVER c: #08d5a8d5 fc: #08d5d5a8", 155, 125, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #08d5d5a8", 125, 115, g, 0x0f0c0f);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #08d5d5a8", 155, 155, g, 0xaaa0aa);
	// TestUtilities.check("DST_OVER c: #a8a8a808 fc: #08d5d5a8", 135, 145, g, 0xa0a02b);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #08d5d5a8", 135, 105, g, 0x0c0f0a);
	// drawTransformedImage(0xd5a8d508, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #d5a8d508", 145, 135, g, 0x3de1a0);
	// TestUtilities.check("DST_OVER c: #08a8a808 fc: #d5a8d508", 135, 115, g, 0xd6d60c);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #d5a8d508", 145, 155, g, 0xf0e1a0);
	// TestUtilities.check("DST_OVER c: #08a8d5d5 fc: #d5a8d508", 185, 115, g, 0xd6d6b8);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #d5a8d508", 105, 145, g, 0xd34b09);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #d5a8d508", 125, 145, g, 0xd34bca);
	// TestUtilities.check("DST_OVER c: #d5a8a808 fc: #d5a8d508", 135, 175, g, 0xbdc508);
	// TestUtilities.check("DST_OVER c: #0808d5d5 fc: #d5a8d508", 185, 105, g, 0x8ed6b8);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #d5a8d508", 165, 155, g, 0xf0f009);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #d5a8d508", 175, 145, g, 0xd3f0a0);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #d5a8d508", 155, 115, g, 0xd6d6b8);
	// TestUtilities.check("DST_OVER c: #a8d50808 fc: #d5a8d508", 105, 155, g, 0xf04b09);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #d5a8d508", 165, 145, g, 0xd3f009);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #d5a8d508", 105, 175, g, 0xbd2908);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #d5a8d508", 175, 155, g, 0xf0f0a0);
	// TestUtilities.check("DST_OVER c: #d508a8d5 fc: #d5a8d508", 155, 165, g, 0x22c5d0);
	// TestUtilities.check("DST_OVER c: #08a808a8 fc: #d5a8d508", 115, 115, g, 0xd6b392);
	// TestUtilities.check("DST_OVER c: #a808d5d5 fc: #d5a8d508", 185, 135, g, 0x3df0ca);
	// TestUtilities.check("DST_OVER c: #d5a8d508 fc: #d5a8d508", 165, 175, g, 0xbdf108);
	// TestUtilities.check("DST_OVER c: #d5d5a808 fc: #d5a8d508", 135, 185, g, 0xe9c508);
	// drawTransformedImage(0x08a8d5d5, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5d508d5 fc: #08a8d5d5", 125, 185, g, 0xc924d0);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #08a8d5d5", 155, 105, g, 0x0a0f0f);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #08a8d5d5", 125, 145, g, 0x9635aa);
	// TestUtilities.check("DST_OVER c: #a8a808a8 fc: #08a8d5d5", 115, 145, g, 0x9635a0);
	// TestUtilities.check("DST_OVER c: #08a8d5d5 fc: #08a8d5d5", 185, 115, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #08a8d5d5", 115, 175, g, 0xa324aa);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #08a8d5d5", 135, 155, g, 0xaaa035);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #08a8d5d5", 175, 175, g, 0xa3d0aa);
	// TestUtilities.check("DST_OVER c: #a8d50808 fc: #08a8d5d5", 105, 155, g, 0xaa3535);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #08a8d5d5", 105, 145, g, 0x963535);
	// TestUtilities.check("DST_OVER c: #08a8a808 fc: #08a8d5d5", 135, 115, g, 0x0f0f0c);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #08a8d5d5", 135, 105, g, 0x0a0f0c);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #08a8d5d5", 115, 105, g, 0x0a0c0f);
	// TestUtilities.check("DST_OVER c: #080808d5 fc: #08a8d5d5", 125, 105, g, 0x0a0c0f);
	// TestUtilities.check("DST_OVER c: #a8a8a808 fc: #08a8d5d5", 135, 145, g, 0x96a035);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #08a8d5d5", 145, 185, g, 0xc9aaaa);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #08a8d5d5", 125, 115, g, 0x0f0c0f);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #08a8d5d5", 115, 165, g, 0x1d24aa);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #08a8d5d5", 105, 115, g, 0x0f0c0c);
	// TestUtilities.check("DST_OVER c: #d508d5a8 fc: #08a8d5d5", 175, 165, g, 0x1dd0aa);
	// drawTransformedImage(0xd50808a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #d50808a8", 115, 175, g, 0xa408bd);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #d50808a8", 105, 145, g, 0xa0093d);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #d50808a8", 135, 105, g, 0x0c928e);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #d50808a8", 155, 115, g, 0x9292d6);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #d50808a8", 125, 115, g, 0x920cd6);
	// TestUtilities.check("DST_OVER c: #0808d508 fc: #d50808a8", 165, 105, g, 0x0cb88e);
	// TestUtilities.check("DST_OVER c: #0808a8a8 fc: #d50808a8", 145, 105, g, 0x0c92d6);
	// TestUtilities.check("DST_OVER c: #d508d5d5 fc: #d50808a8", 185, 165, g, 0x08d0e9);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #d50808a8", 145, 185, g, 0xd0a4bd);
	// TestUtilities.check("DST_OVER c: #08d5a8a8 fc: #d50808a8", 145, 125, g, 0xb892d6);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #d50808a8", 185, 145, g, 0xa0caf0);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #d50808a8", 105, 105, g, 0x0c0c8e);
	// TestUtilities.check("DST_OVER c: #d5a8d508 fc: #d50808a8", 165, 175, g, 0xa4d022);
	// TestUtilities.check("DST_OVER c: #a8a808a8 fc: #d50808a8", 115, 145, g, 0xa009d3);
	// TestUtilities.check("DST_OVER c: #d508d5a8 fc: #d50808a8", 175, 165, g, 0x08d0bd);
	// TestUtilities.check("DST_OVER c: #08a8d5a8 fc: #d50808a8", 175, 115, g, 0x92b8d6);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #d50808a8", 175, 135, g, 0x09cad3);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #d50808a8", 115, 135, g, 0x0909d3);
	// TestUtilities.check("DST_OVER c: #d508a8d5 fc: #d50808a8", 155, 165, g, 0x08a4e9);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #d50808a8", 115, 105, g, 0x0c0cd6);
	// drawTransformedImage(0xa8d50808, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #08a8d5d5 fc: #a8d50808", 185, 115, g, 0xaa9292);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #a8d50808", 165, 155, g, 0xe1bd08);
	// TestUtilities.check("DST_OVER c: #08a8a8a8 fc: #a8d50808", 145, 115, g, 0xaa7474);
	// TestUtilities.check("DST_OVER c: #0808d508 fc: #a8d50808", 165, 105, g, 0x8e920a);
	// TestUtilities.check("DST_OVER c: #08d5a808 fc: #a8d50808", 135, 125, g, 0xaa740a);
	// TestUtilities.check("DST_OVER c: #d508a8a8 fc: #a8d50808", 145, 165, g, 0x289f9f);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #a8d50808", 115, 165, g, 0x28089f);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #a8d50808", 105, 145, g, 0xd30808);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #a8d50808", 185, 155, g, 0xe1bdbd);
	// TestUtilities.check("DST_OVER c: #080808d5 fc: #a8d50808", 125, 105, g, 0x8e0a92);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #a8d50808", 125, 115, g, 0xaa0a92);
	// TestUtilities.check("DST_OVER c: #d5d50808 fc: #a8d50808", 105, 185, g, 0xe90808);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #a8d50808", 175, 155, g, 0xe1bd96);
	// TestUtilities.check("DST_OVER c: #d5d508d5 fc: #a8d50808", 125, 185, g, 0xe908c9);
	// TestUtilities.check("DST_OVER c: #d5d5a8d5 fc: #a8d50808", 155, 185, g, 0xe99fc9);
	// TestUtilities.check("DST_OVER c: #08d5d508 fc: #a8d50808", 165, 125, g, 0xaa920a);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #a8d50808", 175, 185, g, 0xe9c99f);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #a8d50808", 165, 135, g, 0x46bd08);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #a8d50808", 135, 155, g, 0xe19608);
	// TestUtilities.check("DST_OVER c: #a8d508d5 fc: #a8d50808", 125, 155, g, 0xe108bd);
	// drawTransformedImage(0x08a8a8d5, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #08a8a8d5", 175, 135, g, 0x2baaa0);
	// TestUtilities.check("DST_OVER c: #d5d5a8d5 fc: #08a8a8d5", 155, 185, g, 0xc9a3d0);
	// TestUtilities.check("DST_OVER c: #08a8a8a8 fc: #08a8a8d5", 145, 115, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #08a8a8d5", 105, 105, g, 0x0a0a0c);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #08a8a8d5", 155, 105, g, 0x0a0f0f);
	// TestUtilities.check("DST_OVER c: #d5a8a808 fc: #08a8a8d5", 135, 175, g, 0xa3a324);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #08a8a8d5", 185, 155, g, 0xaaaaaa);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #08a8a8d5", 105, 115, g, 0x0f0a0c);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #08a8a8d5", 155, 155, g, 0xaa96aa);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #08a8a8d5", 115, 105, g, 0x0a0a0f);
	// TestUtilities.check("DST_OVER c: #08d5d5d5 fc: #08a8a8d5", 185, 125, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #08a8a8d5", 185, 185, g, 0xc9c9d0);
	// TestUtilities.check("DST_OVER c: #a808d5d5 fc: #08a8a8d5", 185, 135, g, 0x2baaaa);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #08a8a8d5", 165, 155, g, 0xaaaa35);
	// TestUtilities.check("DST_OVER c: #a8a8a8d5 fc: #08a8a8d5", 155, 145, g, 0x9696aa);
	// TestUtilities.check("DST_OVER c: #a8080808 fc: #08a8a8d5", 105, 135, g, 0x2b2b35);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #08a8a8d5", 135, 135, g, 0x2b9635);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #08a8a8d5", 175, 185, g, 0xc9c9aa);
	// TestUtilities.check("DST_OVER c: #08d508a8 fc: #08a8a8d5", 115, 125, g, 0x0f0a0f);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #08a8a8d5", 105, 175, g, 0xa31d24);
	// drawTransformedImage(0xa8a808d5, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5d50808 fc: #a8a808d5", 105, 185, g, 0xe10828);
	// TestUtilities.check("DST_OVER c: #08d5d5d5 fc: #a8a808d5", 185, 125, g, 0xaa92aa);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #a8a808d5", 175, 105, g, 0x7192aa);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #a8a808d5", 145, 155, g, 0xe196d3);
	// TestUtilities.check("DST_OVER c: #a8d508d5 fc: #a8a808d5", 125, 155, g, 0xe108e1);
	// TestUtilities.check("DST_OVER c: #0808a8a8 fc: #a8a808d5", 145, 105, g, 0x7174aa);
	// TestUtilities.check("DST_OVER c: #a8a8a8a8 fc: #a8a808d5", 145, 145, g, 0xc696d3);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #a8a808d5", 165, 145, g, 0xc6bd46);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #a8a808d5", 105, 175, g, 0xb70828);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #a8a808d5", 185, 155, g, 0xe1bde1);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #a8a808d5", 185, 185, g, 0xe1c9e9);
	// TestUtilities.check("DST_OVER c: #d5a8d508 fc: #a8a808d5", 165, 175, g, 0xb7c928);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #a8a808d5", 115, 135, g, 0x3908d3);
	// TestUtilities.check("DST_OVER c: #0808d508 fc: #a8a808d5", 165, 105, g, 0x71928e);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #a8a808d5", 175, 135, g, 0x39bdd3);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #a8a808d5", 175, 145, g, 0xc6bdd3);
	// TestUtilities.check("DST_OVER c: #a8080808 fc: #a8a808d5", 105, 135, g, 0x390846);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #a8a808d5", 155, 155, g, 0xe196e1);
	// TestUtilities.check("DST_OVER c: #d5d508d5 fc: #a8a808d5", 125, 185, g, 0xe108e9);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #a8a808d5", 105, 115, g, 0xaa0a8e);
	// drawTransformedImage(0xd5a8a8a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #d5a8a8a8", 175, 135, g, 0x3df0d3);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #d5a8a8a8", 115, 175, g, 0xbd22bd);
	// TestUtilities.check("DST_OVER c: #a8a808a8 fc: #d5a8a8a8", 115, 145, g, 0xd33dd3);
	// TestUtilities.check("DST_OVER c: #08a8a8a8 fc: #d5a8a8a8", 145, 115, g, 0xd6d6d6);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #d5a8a8a8", 175, 175, g, 0xbde9bd);
	// TestUtilities.check("DST_OVER c: #a8d508d5 fc: #d5a8a8a8", 125, 155, g, 0xf03df0);
	// TestUtilities.check("DST_OVER c: #08d5a8d5 fc: #d5a8a8a8", 155, 125, g, 0xd6d6d6);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #d5a8a8a8", 185, 155, g, 0xf0f0f0);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #d5a8a8a8", 135, 105, g, 0x8ed68e);
	// TestUtilities.check("DST_OVER c: #d50808d5 fc: #d5a8a8a8", 125, 165, g, 0x2222e9);
	// TestUtilities.check("DST_OVER c: #08a808a8 fc: #d5a8a8a8", 115, 115, g, 0xd68ed6);
	// TestUtilities.check("DST_OVER c: #08d5d508 fc: #d5a8a8a8", 165, 125, g, 0xd6d68e);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #d5a8a8a8", 155, 115, g, 0xd6d6d6);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #d5a8a8a8", 135, 135, g, 0x3dd33d);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #d5a8a8a8", 135, 155, g, 0xf0d33d);
	// TestUtilities.check("DST_OVER c: #0808d5d5 fc: #d5a8a8a8", 185, 105, g, 0x8ed6d6);
	// TestUtilities.check("DST_OVER c: #d5d508a8 fc: #d5a8a8a8", 115, 185, g, 0xe922bd);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #d5a8a8a8", 175, 105, g, 0x8ed6d6);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #d5a8a8a8", 125, 135, g, 0x3d3df0);
	// TestUtilities.check("DST_OVER c: #d5080808 fc: #d5a8a8a8", 105, 165, g, 0x222222);
	// drawTransformedImage(0x0808d5a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #0808d5a8", 105, 175, g, 0x8d241d);
	// TestUtilities.check("DST_OVER c: #08d5a808 fc: #0808d5a8", 135, 125, g, 0x0c0f0a);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #0808d5a8", 165, 135, g, 0x06aa2b);
	// TestUtilities.check("DST_OVER c: #08d50808 fc: #0808d5a8", 105, 125, g, 0x0c0c0a);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #0808d5a8", 125, 115, g, 0x0a0c0f);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #0808d5a8", 185, 155, g, 0x8faaaa);
	// TestUtilities.check("DST_OVER c: #d5a8a8a8 fc: #0808d5a8", 145, 175, g, 0x8daaa3);
	// TestUtilities.check("DST_OVER c: #08a8a808 fc: #0808d5a8", 135, 115, g, 0x0a0f0a);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #0808d5a8", 135, 135, g, 0x06a02b);
	// TestUtilities.check("DST_OVER c: #08a808a8 fc: #0808d5a8", 115, 115, g, 0x0a0c0f);
	// TestUtilities.check("DST_OVER c: #d5d5d508 fc: #0808d5a8", 165, 185, g, 0xb3d01d);
	// TestUtilities.check("DST_OVER c: #d5a8a8d5 fc: #0808d5a8", 155, 175, g, 0x8daac9);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #0808d5a8", 105, 145, g, 0x71352b);
	// TestUtilities.check("DST_OVER c: #a8a8a808 fc: #0808d5a8", 135, 145, g, 0x71a02b);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #0808d5a8", 145, 185, g, 0xb3aaa3);
	// TestUtilities.check("DST_OVER c: #a8d508d5 fc: #0808d5a8", 125, 155, g, 0x8f35aa);
	// TestUtilities.check("DST_OVER c: #d508a8a8 fc: #0808d5a8", 145, 165, g, 0x07aaa3);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #0808d5a8", 175, 145, g, 0x71aa96);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #0808d5a8", 155, 115, g, 0x0a0f0f);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #0808d5a8", 125, 135, g, 0x0635aa);
	// drawTransformedImage(0xd5a808d5, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #08a808a8 fc: #d5a808d5", 115, 115, g, 0xd60cd6);
	// TestUtilities.check("DST_OVER c: #0808d508 fc: #d5a808d5", 165, 105, g, 0x8eb8b3);
	// TestUtilities.check("DST_OVER c: #08d5a8d5 fc: #d5a808d5", 155, 125, g, 0xd692d6);
	// TestUtilities.check("DST_OVER c: #d5d5a808 fc: #d5a808d5", 135, 185, g, 0xe9a429);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #d5a808d5", 175, 185, g, 0xe9d0c5);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #d5a808d5", 115, 135, g, 0x3d09e1);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #d5a808d5", 105, 145, g, 0xd3094b);
	// TestUtilities.check("DST_OVER c: #a8a8a8a8 fc: #d5a808d5", 145, 145, g, 0xd3a0e1);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #d5a808d5", 175, 125, g, 0xd6b8d6);
	// TestUtilities.check("DST_OVER c: #a8a8a808 fc: #d5a808d5", 135, 145, g, 0xd3a04b);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #d5a808d5", 175, 135, g, 0x3dcae1);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #d5a808d5", 145, 155, g, 0xf0a0e1);
	// TestUtilities.check("DST_OVER c: #08d5a8a8 fc: #d5a808d5", 145, 125, g, 0xd692d6);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #d5a808d5", 155, 115, g, 0xd692d6);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #d5a808d5", 155, 105, g, 0x8e92d6);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #d5a808d5", 125, 135, g, 0x3d09f0);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #d5a808d5", 145, 135, g, 0x3da0e1);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #d5a808d5", 155, 155, g, 0xf0a0f0);
	// TestUtilities.check("DST_OVER c: #a8a808a8 fc: #d5a808d5", 115, 145, g, 0xd309e1);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #d5a808d5", 165, 155, g, 0xf0ca4b);
	// drawTransformedImage(0xa8a808a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5d508d5 fc: #a8a808a8", 125, 185, g, 0xe108e1);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #a8a808a8", 105, 105, g, 0x710a71);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #a8a808a8", 145, 135, g, 0x3996c6);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #a8a808a8", 165, 155, g, 0xe1bd39);
	// TestUtilities.check("DST_OVER c: #08d5a808 fc: #a8a808a8", 135, 125, g, 0xaa7471);
	// TestUtilities.check("DST_OVER c: #d5d5a808 fc: #a8a808a8", 135, 185, g, 0xe19f20);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #a8a808a8", 175, 155, g, 0xe1bdc6);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #a8a808a8", 165, 135, g, 0x39bd39);
	// TestUtilities.check("DST_OVER c: #d5d5d5a8 fc: #a8a808a8", 175, 185, g, 0xe1c9b7);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #a8a808a8", 175, 145, g, 0xc6bdc6);
	// TestUtilities.check("DST_OVER c: #08d50808 fc: #a8a808a8", 105, 125, g, 0xaa0a71);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #a8a808a8", 145, 155, g, 0xe196c6);
	// TestUtilities.check("DST_OVER c: #d5a8d508 fc: #a8a808a8", 165, 175, g, 0xb7c920);
	// TestUtilities.check("DST_OVER c: #d5d5a8d5 fc: #a8a808a8", 155, 185, g, 0xe19fe1);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #a8a808a8", 115, 105, g, 0x710aaa);
	// TestUtilities.check("DST_OVER c: #08a8d508 fc: #a8a808a8", 165, 115, g, 0xaa9271);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #a8a808a8", 155, 155, g, 0xe196e1);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #a8a808a8", 105, 175, g, 0xb70820);
	// TestUtilities.check("DST_OVER c: #08d5a8a8 fc: #a8a808a8", 145, 125, g, 0xaa74aa);
	// TestUtilities.check("DST_OVER c: #d508d508 fc: #a8a808a8", 165, 165, g, 0x20c920);
	// drawTransformedImage(0xd5d508a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #d5d508a8", 135, 155, g, 0xf0a03d);
	// TestUtilities.check("DST_OVER c: #a8a8a8d5 fc: #d5d508a8", 155, 145, g, 0xe1a0f0);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #d5d508a8", 175, 105, g, 0xb3b8d6);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #d5d508a8", 165, 155, g, 0xf0ca3d);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #d5d508a8", 175, 125, g, 0xd6b8d6);
	// TestUtilities.check("DST_OVER c: #d508a8a8 fc: #d5d508a8", 145, 165, g, 0x29a4bd);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #d5d508a8", 165, 145, g, 0xe1ca3d);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #d5d508a8", 105, 115, g, 0xd60c8e);
	// TestUtilities.check("DST_OVER c: #08d5d508 fc: #d5d508a8", 165, 125, g, 0xd6b88e);
	// TestUtilities.check("DST_OVER c: #d508a808 fc: #d5d508a8", 135, 165, g, 0x29a422);
	// TestUtilities.check("DST_OVER c: #08d508d5 fc: #d5d508a8", 125, 125, g, 0xd60cd6);
	// TestUtilities.check("DST_OVER c: #0808d508 fc: #d5d508a8", 165, 105, g, 0xb3b88e);
	// TestUtilities.check("DST_OVER c: #a808a8d5 fc: #d5d508a8", 155, 135, g, 0x4ba0f0);
	// TestUtilities.check("DST_OVER c: #a8080808 fc: #d5d508a8", 105, 135, g, 0x4b093d);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #d5d508a8", 175, 135, g, 0x4bcad3);
	// TestUtilities.check("DST_OVER c: #d5d50808 fc: #d5d508a8", 105, 185, g, 0xf10822);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #d5d508a8", 115, 105, g, 0xb30cd6);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #d5d508a8", 105, 105, g, 0xb30c8e);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #d5d508a8", 155, 115, g, 0xd692d6);
	// TestUtilities.check("DST_OVER c: #d5a8a808 fc: #d5d508a8", 135, 175, g, 0xc5a422);
	// drawTransformedImage(0xa80808a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a8080808 fc: #a80808a8", 105, 135, g, 0x080839);
	// TestUtilities.check("DST_OVER c: #a8d508d5 fc: #a80808a8", 125, 155, g, 0xbd08e1);
	// TestUtilities.check("DST_OVER c: #a8d5a808 fc: #a80808a8", 135, 155, g, 0xbd9639);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #a80808a8", 165, 135, g, 0x08bd39);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #a80808a8", 175, 135, g, 0x08bdc6);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #a80808a8", 175, 105, g, 0x0a92aa);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #a80808a8", 145, 185, g, 0xc99fb7);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #a80808a8", 135, 135, g, 0x089639);
	// TestUtilities.check("DST_OVER c: #d5a8d5d5 fc: #a80808a8", 185, 175, g, 0x9fc9e1);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #a80808a8", 105, 105, g, 0x0a0a71);
	// TestUtilities.check("DST_OVER c: #a808d5d5 fc: #a80808a8", 185, 135, g, 0x08bde1);
	// TestUtilities.check("DST_OVER c: #a8d5a8d5 fc: #a80808a8", 155, 155, g, 0xbd96e1);
	// TestUtilities.check("DST_OVER c: #d5a8a8d5 fc: #a80808a8", 155, 175, g, 0x9f9fe1);
	// TestUtilities.check("DST_OVER c: #08d508d5 fc: #a80808a8", 125, 125, g, 0x920aaa);
	// TestUtilities.check("DST_OVER c: #080808d5 fc: #a80808a8", 125, 105, g, 0x0a0aaa);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #a80808a8", 125, 115, g, 0x740aaa);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #a80808a8", 145, 155, g, 0xbd96c6);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #a80808a8", 175, 125, g, 0x9292aa);
	// TestUtilities.check("DST_OVER c: #a8d508a8 fc: #a80808a8", 115, 155, g, 0xbd08c6);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #a80808a8", 165, 145, g, 0x96bd39);
	// drawTransformedImage(0xd508d5a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5a8a808 fc: #d508d5a8", 135, 175, g, 0xa4c522);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #d508d5a8", 185, 145, g, 0xa0f0f0);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #d508d5a8", 175, 155, g, 0xcaf0d3);
	// TestUtilities.check("DST_OVER c: #08d5d5d5 fc: #d508d5a8", 185, 125, g, 0xb8d6d6);
	// TestUtilities.check("DST_OVER c: #d508a8a8 fc: #d508d5a8", 145, 165, g, 0x08c5bd);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #d508d5a8", 155, 105, g, 0x0cd6d6);
	// TestUtilities.check("DST_OVER c: #d5d508a8 fc: #d508d5a8", 115, 185, g, 0xd029bd);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #d508d5a8", 115, 175, g, 0xa429bd);
	// TestUtilities.check("DST_OVER c: #d508a808 fc: #d508d5a8", 135, 165, g, 0x08c522);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #d508d5a8", 145, 155, g, 0xcae1d3);
	// TestUtilities.check("DST_OVER c: #d5a8a8a8 fc: #d508d5a8", 145, 175, g, 0xa4c5bd);
	// TestUtilities.check("DST_OVER c: #a8d5d508 fc: #d508d5a8", 165, 155, g, 0xcaf03d);
	// TestUtilities.check("DST_OVER c: #d508d508 fc: #d508d5a8", 165, 165, g, 0x08f122);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #d508d5a8", 145, 135, g, 0x09e1d3);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #d508d5a8", 185, 185, g, 0xd0f1e9);
	// TestUtilities.check("DST_OVER c: #d5a8d508 fc: #d508d5a8", 165, 175, g, 0xa4f122);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #d508d5a8", 125, 115, g, 0x92b3d6);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #d508d5a8", 115, 135, g, 0x094bd3);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #d508d5a8", 105, 145, g, 0xa04b3d);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #d508d5a8", 115, 165, g, 0x0829bd);
	// drawTransformedImage(0x08d5d508, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #08d5d508", 155, 115, g, 0x0f0f0c);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #08d5d508", 175, 175, g, 0xaad08d);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #08d5d508", 125, 115, g, 0x0f0c0c);
	// TestUtilities.check("DST_OVER c: #d5a80808 fc: #08d5d508", 105, 175, g, 0xaa2407);
	// TestUtilities.check("DST_OVER c: #08a8a8a8 fc: #08d5d508", 145, 115, g, 0x0f0f0a);
	// TestUtilities.check("DST_OVER c: #a808a8a8 fc: #08d5d508", 145, 135, g, 0x35a071);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #08d5d508", 175, 135, g, 0x35aa71);
	// TestUtilities.check("DST_OVER c: #08d5d5d5 fc: #08d5d508", 185, 125, g, 0x0f0f0c);
	// TestUtilities.check("DST_OVER c: #a808d508 fc: #08d5d508", 165, 135, g, 0x35aa06);
	// TestUtilities.check("DST_OVER c: #a8d50808 fc: #08d5d508", 105, 155, g, 0xaa3506);
	// TestUtilities.check("DST_OVER c: #08d508d5 fc: #08d5d508", 125, 125, g, 0x0f0c0c);
	// TestUtilities.check("DST_OVER c: #a8d5a8a8 fc: #08d5d508", 145, 155, g, 0xaaa071);
	// TestUtilities.check("DST_OVER c: #d5d50808 fc: #08d5d508", 105, 185, g, 0xd02407);
	// TestUtilities.check("DST_OVER c: #a808a808 fc: #08d5d508", 135, 135, g, 0x35a006);
	// TestUtilities.check("DST_OVER c: #d508d5d5 fc: #08d5d508", 185, 165, g, 0x24d0b3);
	// TestUtilities.check("DST_OVER c: #0808a8d5 fc: #08d5d508", 155, 105, g, 0x0c0f0c);
	// TestUtilities.check("DST_OVER c: #a8a80808 fc: #08d5d508", 105, 145, g, 0xa03506);
	// TestUtilities.check("DST_OVER c: #a8a8d5a8 fc: #08d5d508", 175, 145, g, 0xa0aa71);
	// TestUtilities.check("DST_OVER c: #08a80808 fc: #08d5d508", 105, 115, g, 0x0f0c00);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #08d5d508", 115, 165, g, 0x24248d);
	// drawTransformedImage(0x08a8a8a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a8080808 fc: #08a8a8a8", 105, 135, g, 0x2b2b2b);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #08a8a8a8", 115, 165, g, 0x1d1da3);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #08a8a8a8", 125, 115, g, 0x0f0a0f);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #08a8a8a8", 175, 175, g, 0xa3c9a3);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #08a8a8a8", 115, 175, g, 0xa31da3);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #08a8a8a8", 125, 145, g, 0x962baa);
	// TestUtilities.check("DST_OVER c: #d5d508a8 fc: #08a8a8a8", 115, 185, g, 0xc91da3);
	// TestUtilities.check("DST_OVER c: #d508a808 fc: #08a8a8a8", 135, 165, g, 0x1da31d);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #08a8a8a8", 185, 185, g, 0xc9c9c9);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #08a8a8a8", 185, 155, g, 0xaaaaaa);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #08a8a8a8", 135, 105, g, 0x0a0f0a);
	// TestUtilities.check("DST_OVER c: #d5a8a8a8 fc: #08a8a8a8", 145, 175, g, 0xa3a3a3);
	// TestUtilities.check("DST_OVER c: #08d5a8d5 fc: #08a8a8a8", 155, 125, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #a808d5d5 fc: #08a8a8a8", 185, 135, g, 0x2baaaa);
	// TestUtilities.check("DST_OVER c: #a808d5a8 fc: #08a8a8a8", 175, 135, g, 0x2baa96);
	// TestUtilities.check("DST_OVER c: #a8d508a8 fc: #08a8a8a8", 115, 155, g, 0xaa2b96);
	// TestUtilities.check("DST_OVER c: #08d508d5 fc: #08a8a8a8", 125, 125, g, 0x0f0a0f);
	// TestUtilities.check("DST_OVER c: #08a8a8d5 fc: #08a8a8a8", 155, 115, g, 0x0f0f0f);
	// TestUtilities.check("DST_OVER c: #08d5a808 fc: #08a8a8a8", 135, 125, g, 0x0f0f0a);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #08a8a8a8", 115, 135, g, 0x2b2b96);
	// drawTransformedImage(0xa8a8a8a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #a8d50808 fc: #a8a8a8a8", 105, 155, g, 0xe13939);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #a8a8a8a8", 185, 155, g, 0xe1e1e1);
	// TestUtilities.check("DST_OVER c: #a80808a8 fc: #a8a8a8a8", 115, 135, g, 0x3939c6);
	// TestUtilities.check("DST_OVER c: #08080808 fc: #a8a8a8a8", 105, 105, g, 0x717171);
	// TestUtilities.check("DST_OVER c: #08a8d5a8 fc: #a8a8a8a8", 175, 115, g, 0xaaaaaa);
	// TestUtilities.check("DST_OVER c: #a8d508a8 fc: #a8a8a8a8", 115, 155, g, 0xe139c6);
	// TestUtilities.check("DST_OVER c: #a8a808d5 fc: #a8a8a8a8", 125, 145, g, 0xc639e1);
	// TestUtilities.check("DST_OVER c: #0808a808 fc: #a8a8a8a8", 135, 105, g, 0x71aa71);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #a8a8a8a8", 125, 115, g, 0xaa71aa);
	// TestUtilities.check("DST_OVER c: #a80808d5 fc: #a8a8a8a8", 125, 135, g, 0x3939e1);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #a8a8a8a8", 165, 145, g, 0xc6e139);
	// TestUtilities.check("DST_OVER c: #a8a808a8 fc: #a8a8a8a8", 115, 145, g, 0xc639c6);
	// TestUtilities.check("DST_OVER c: #d508d5a8 fc: #a8a8a8a8", 175, 165, g, 0x20e1b7);
	// TestUtilities.check("DST_OVER c: #08d508a8 fc: #a8a8a8a8", 115, 125, g, 0xaa71aa);
	// TestUtilities.check("DST_OVER c: #d508a8d5 fc: #a8a8a8a8", 155, 165, g, 0x20b7e1);
	// TestUtilities.check("DST_OVER c: #08d5d5a8 fc: #a8a8a8a8", 175, 125, g, 0xaaaaaa);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #a8a8a8a8", 175, 175, g, 0xb7e1b7);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #a8a8a8a8", 185, 185, g, 0xe1e1e1);
	// TestUtilities.check("DST_OVER c: #08d5a808 fc: #a8a8a8a8", 135, 125, g, 0xaaaa71);
	// TestUtilities.check("DST_OVER c: #08d50808 fc: #a8a8a8a8", 105, 125, g, 0xaa7171);
	// drawTransformedImage(0xa8d508a8, BlendMode.DST_OVER);
	// TestUtilities.check("DST_OVER c: #d5d5d508 fc: #a8d508a8", 165, 185, g, 0xe9c920);
	// TestUtilities.check("DST_OVER c: #a8d5d5a8 fc: #a8d508a8", 175, 155, g, 0xe1bdc6);
	// TestUtilities.check("DST_OVER c: #a8d5d5d5 fc: #a8d508a8", 185, 155, g, 0xe1bde1);
	// TestUtilities.check("DST_OVER c: #d5d508a8 fc: #a8d508a8", 115, 185, g, 0xe908b7);
	// TestUtilities.check("DST_OVER c: #d5d5a8a8 fc: #a8d508a8", 145, 185, g, 0xe99fb7);
	// TestUtilities.check("DST_OVER c: #08a808a8 fc: #a8d508a8", 115, 115, g, 0xaa0aaa);
	// TestUtilities.check("DST_OVER c: #d5a808a8 fc: #a8d508a8", 115, 175, g, 0xbf08b7);
	// TestUtilities.check("DST_OVER c: #d5d5d5d5 fc: #a8d508a8", 185, 185, g, 0xe9c9e1);
	// TestUtilities.check("DST_OVER c: #0808d5a8 fc: #a8d508a8", 175, 105, g, 0x8e92aa);
	// TestUtilities.check("DST_OVER c: #a8d508a8 fc: #a8d508a8", 115, 155, g, 0xe108c6);
	// TestUtilities.check("DST_OVER c: #d50808d5 fc: #a8d508a8", 125, 165, g, 0x2808e1);
	// TestUtilities.check("DST_OVER c: #080808a8 fc: #a8d508a8", 115, 105, g, 0x8e0aaa);
	// TestUtilities.check("DST_OVER c: #d50808a8 fc: #a8d508a8", 115, 165, g, 0x2808b7);
	// TestUtilities.check("DST_OVER c: #d5a808d5 fc: #a8d508a8", 125, 175, g, 0xbf08e1);
	// TestUtilities.check("DST_OVER c: #a8a8d5d5 fc: #a8d508a8", 185, 145, g, 0xd3bde1);
	// TestUtilities.check("DST_OVER c: #08d508a8 fc: #a8d508a8", 115, 125, g, 0xaa0aaa);
	// TestUtilities.check("DST_OVER c: #a8a8d508 fc: #a8d508a8", 165, 145, g, 0xd3bd39);
	// TestUtilities.check("DST_OVER c: #d5a8d5a8 fc: #a8d508a8", 175, 175, g, 0xbfc9b7);
	// TestUtilities.check("DST_OVER c: #08a808d5 fc: #a8d508a8", 125, 115, g, 0xaa0aaa);
	// TestUtilities.check("DST_OVER c: #08a8d5d5 fc: #a8d508a8", 185, 115, g, 0xaa92aa);
	// drawTransformedImage(0xd5a808d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5d508a8 fc: #d5a808d5", 115, 185, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #d5a808d5", 175, 145, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #08d508d5 fc: #d5a808d5", 125, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #d5a808d5", 185, 185, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #d5a808d5", 185, 145, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #d5a808d5", 105, 185, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #a8d5a808 fc: #d5a808d5", 135, 155, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #d5a808d5", 165, 185, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #d5a808d5", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #d5a808d5", 185, 165, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #d5d5a8a8 fc: #d5a808d5", 145, 185, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #d5a808d5", 155, 165, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #d5a808d5", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #d5a808d5", 155, 155, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #a808d5a8 fc: #d5a808d5", 175, 135, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #08a8d5d5 fc: #d5a808d5", 185, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #d5a808d5", 165, 145, g, 0x3c024c);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #d5a808d5", 145, 175, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #d50808d5 fc: #d5a808d5", 125, 165, g, 0x61047a);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #d5a808d5", 135, 175, g, 0x61047a);
	// drawTransformedImage(0xa808a808, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #a808a808", 165, 155, g, 0x022f02);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #a808a808", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a8d5 fc: #a808a808", 155, 175, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #a808a808", 125, 135, g, 0x022f02);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #a808a808", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8d508 fc: #a808a808", 165, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a808a8 fc: #a808a808", 115, 145, g, 0x022f02);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #a808a808", 185, 165, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #d508a8a8 fc: #a808a808", 145, 165, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #0808d508 fc: #a808a808", 165, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5a8a8 fc: #a808a808", 145, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #a808a808", 155, 155, g, 0x022f02);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #a808a808", 175, 185, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #a808a808", 115, 175, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #a808a808", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #a808a808", 185, 155, g, 0x022f02);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a808a808", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #a808a808", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a808d5 fc: #a808a808", 125, 175, g, 0x034c03);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #a808a808", 145, 135, g, 0x022f02);
	// drawTransformedImage(0x080808d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #080808d5", 185, 185, g, 0x000004);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #080808d5", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d5d5 fc: #080808d5", 185, 175, g, 0x000004);
	// TestUtilities.check("SRC_IN c: #d508d5a8 fc: #080808d5", 175, 165, g, 0x000004);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #080808d5", 135, 175, g, 0x000004);
	// TestUtilities.check("SRC_IN c: #a808d5d5 fc: #080808d5", 185, 135, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #08d5a8a8 fc: #080808d5", 145, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #080808d5", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #080808d5", 175, 145, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #a808d5a8 fc: #080808d5", 175, 135, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #a8a8a808 fc: #080808d5", 135, 145, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #080808d5", 185, 155, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #a8a8a8d5 fc: #080808d5", 155, 145, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #08a8d508 fc: #080808d5", 165, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #080808d5", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #080808d5", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d50808d5 fc: #080808d5", 125, 165, g, 0x000004);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #080808d5", 165, 145, g, 0x000002);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #080808d5", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5a8d5 fc: #080808d5", 155, 125, g, 0x000000);
	// drawTransformedImage(0x0808a8d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #0808a8d5", 165, 165, g, 0x000304);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #0808a8d5", 135, 165, g, 0x000304);
	// TestUtilities.check("SRC_IN c: #080808a8 fc: #0808a8d5", 115, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a808 fc: #0808a8d5", 135, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #0808a8d5", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #0808a8d5", 135, 175, g, 0x000304);
	// TestUtilities.check("SRC_IN c: #08d5d5d5 fc: #0808a8d5", 185, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #0808a8d5", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #0808a8d5", 145, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #a808d508 fc: #0808a8d5", 165, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #0808a8d5", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8a8a8 fc: #0808a8d5", 145, 145, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #a8d5d5a8 fc: #0808a8d5", 175, 155, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #a8a808a8 fc: #0808a8d5", 115, 145, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #a808d5a8 fc: #0808a8d5", 175, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #0808a8d5", 165, 185, g, 0x000304);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #0808a8d5", 175, 145, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #0808a8d5", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5080808 fc: #0808a8d5", 105, 165, g, 0x000304);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #0808a8d5", 175, 185, g, 0x000304);
	// drawTransformedImage(0xd508d5a8, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #d508d5a8", 175, 185, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #d508d5a8 fc: #d508d5a8", 175, 165, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #a808a808 fc: #d508d5a8", 135, 135, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #d508d5a8", 105, 175, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #d508d5a8", 145, 135, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #d508d5a8", 135, 185, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #d508d5a8", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5d5d5 fc: #d508d5a8", 185, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a808 fc: #d508d5a8", 135, 155, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #08a8d5d5 fc: #d508d5a8", 185, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5a8d5 fc: #d508d5a8", 155, 185, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #08080808 fc: #d508d5a8", 105, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a80808 fc: #d508d5a8", 105, 145, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #d508d5a8", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #d508d5a8", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #d508d5a8", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #d508d5a8", 165, 165, g, 0x047a61);
	// TestUtilities.check("SRC_IN c: #a8080808 fc: #d508d5a8", 105, 135, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #d508d5a8", 185, 145, g, 0x024c3c);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #d508d5a8", 115, 155, g, 0x024c3c);
	// drawTransformedImage(0x08a8d5a8, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5d508d5 fc: #08a8d5a8", 125, 185, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #08a8d5a8", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #08a8d5a8", 165, 165, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #08a8d5a8", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d5a8 fc: #08a8d5a8", 175, 175, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #08a8d5a8", 135, 185, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #08d5a8a8 fc: #08a8d5a8", 145, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8a8d5 fc: #08a8d5a8", 155, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #08a8d5a8", 145, 175, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #08d5a8d5 fc: #08a8d5a8", 155, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8a808 fc: #08a8d5a8", 135, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #08a8d5a8", 175, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #08a8d5a8", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #08a8d5a8", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a80808 fc: #08a8d5a8", 105, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #08a8d5a8", 155, 165, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #08a8d5a8", 165, 175, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #08a8d5a8", 185, 165, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #08a8d5a8", 115, 165, g, 0x030403);
	// TestUtilities.check("SRC_IN c: #d50808d5 fc: #08a8d5a8", 125, 165, g, 0x030403);
	// drawTransformedImage(0xa8d5d5d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #a8d5d5d5", 115, 165, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #a8d5d5d5", 145, 175, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5a8d5d5 fc: #a8d5d5d5", 185, 175, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #a8d5d5d5", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #a8d5d5d5", 165, 185, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #a8d5d5d5", 135, 185, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5d5a8d5 fc: #a8d5d5d5", 155, 185, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #a808a8d5 fc: #a8d5d5d5", 155, 135, g, 0x3c3c3c);
	// TestUtilities.check("SRC_IN c: #08d5a808 fc: #a8d5d5d5", 135, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5a8a8 fc: #a8d5d5d5", 145, 185, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #a8d5d5d5", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #a8d5d5d5", 155, 165, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #a8d5d5d5", 115, 155, g, 0x3c3c3c);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a8d5d5d5", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #a8d5d5d5", 105, 175, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #a8a80808 fc: #a8d5d5d5", 105, 145, g, 0x3c3c3c);
	// TestUtilities.check("SRC_IN c: #08d5a8a8 fc: #a8d5d5d5", 145, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #a8d5d5d5", 185, 165, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #a8d5d5d5", 165, 175, g, 0x616161);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #a8d5d5d5", 185, 185, g, 0x616161);
	// drawTransformedImage(0xa8d5a808, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #a8d5a808", 105, 175, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #a8d5a808", 175, 185, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #08a808a8 fc: #a8d5a808", 115, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #a8d5a808", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8a808 fc: #a8d5a808", 135, 145, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #a8d5a808", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808d5d5 fc: #a8d5a808", 185, 135, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #a8d5a808", 185, 155, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #d5a8d5a8 fc: #a8d5a808", 175, 175, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #a8d5a808", 135, 175, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #a8d5a808", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #a8d5a808", 185, 185, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #a8080808 fc: #a8d5a808", 105, 135, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #a8d5a808", 165, 155, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #d508a8a8 fc: #a8d5a808", 145, 165, g, 0x614c03);
	// TestUtilities.check("SRC_IN c: #08080808 fc: #a8d5a808", 105, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #a8d5a808", 185, 145, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #a8d5a808", 165, 145, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #a8d5d5a8 fc: #a8d5a808", 175, 155, g, 0x3c2f02);
	// TestUtilities.check("SRC_IN c: #d5a808d5 fc: #a8d5a808", 125, 175, g, 0x614c03);
	// drawTransformedImage(0xd50808a8, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #d50808a8", 175, 145, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #d50808a8", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #d50808a8", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a808 fc: #d50808a8", 135, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #d50808a8", 115, 175, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #a808a808 fc: #d50808a8", 135, 135, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #a8a8a808 fc: #d50808a8", 135, 145, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #d50808a8", 155, 165, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #d50808a8", 105, 175, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #d50808a8", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #d50808a8", 145, 135, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #080808d5 fc: #d50808a8", 125, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #d50808a8", 185, 185, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #a8a80808 fc: #d50808a8", 105, 145, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #d50808a8", 165, 185, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #a808a8d5 fc: #d50808a8", 155, 135, g, 0x02023c);
	// TestUtilities.check("SRC_IN c: #08a8d508 fc: #d50808a8", 165, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a8a8 fc: #d50808a8", 145, 165, g, 0x040461);
	// TestUtilities.check("SRC_IN c: #08d5a8d5 fc: #d50808a8", 155, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #d50808a8", 145, 175, g, 0x040461);
	// drawTransformedImage(0x08a808d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5a808d5 fc: #08a808d5", 125, 175, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #08a808d5", 155, 155, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #08d5d5d5 fc: #08a808d5", 185, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #08a808d5", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a808d5 fc: #08a808d5", 125, 145, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #08080808 fc: #08a808d5", 105, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a8a8 fc: #08a808d5", 145, 165, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #08a808d5", 165, 155, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #a8d50808 fc: #08a808d5", 105, 155, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #08a808d5", 125, 135, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #a8a8a8d5 fc: #08a808d5", 155, 145, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #08a808d5", 135, 165, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #d5a8d5a8 fc: #08a808d5", 175, 175, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #a8d5a8a8 fc: #08a808d5", 145, 155, g, 0x020002);
	// TestUtilities.check("SRC_IN c: #0808a8d5 fc: #08a808d5", 155, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d508d5 fc: #08a808d5", 125, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d508d5 fc: #08a808d5", 125, 185, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #08a808d5", 115, 175, g, 0x030004);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #08a808d5", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #08a808d5", 145, 135, g, 0x020002);
	// drawTransformedImage(0xa8080808, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d50808 fc: #a8080808", 105, 155, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5080808 fc: #a8080808", 105, 165, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #a8080808", 115, 155, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #08a80808 fc: #a8080808", 105, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5a808 fc: #a8080808", 135, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #a8080808", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #a8080808", 185, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #a8080808", 185, 185, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #a8080808", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a8080808", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #a8080808", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #a8080808", 165, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #a8080808", 115, 175, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #a8080808", 135, 185, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #08d508d5 fc: #a8080808", 125, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #a8080808", 135, 175, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #a8080808", 115, 165, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #d5a808d5 fc: #a8080808", 125, 175, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #a8080808", 135, 165, g, 0x030303);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #a8080808", 175, 105, g, 0x000000);
	// drawTransformedImage(0x0808d5d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #0808d5d5", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8080808 fc: #0808d5d5", 105, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #a8a8a8a8 fc: #0808d5d5", 145, 145, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #0808d5d5", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #0808d5d5", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #0808d5d5", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #0808d5d5", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #0808d5d5", 175, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a80808a8 fc: #0808d5d5", 115, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #080808a8 fc: #0808d5d5", 115, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08080808 fc: #0808d5d5", 105, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #080808d5 fc: #0808d5d5", 125, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #0808d5d5", 135, 165, g, 0x000404);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #0808d5d5", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #0808d5d5", 165, 175, g, 0x000404);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #0808d5d5", 125, 135, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #0808d5d5", 135, 185, g, 0x000404);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #0808d5d5", 155, 155, g, 0x000202);
	// TestUtilities.check("SRC_IN c: #d508a8a8 fc: #0808d5d5", 145, 165, g, 0x000404);
	// TestUtilities.check("SRC_IN c: #d5a8d5d5 fc: #0808d5d5", 185, 175, g, 0x000404);
	// drawTransformedImage(0xd5080808, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a808a8d5 fc: #d5080808", 155, 135, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #d5080808", 155, 165, g, 0x040404);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #d5080808", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #d5080808", 185, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #d5080808", 165, 145, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #d5080808", 115, 175, g, 0x040404);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #d5080808", 165, 155, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #08d508a8 fc: #d5080808", 115, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #d5080808", 125, 135, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #08a80808 fc: #d5080808", 105, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #d5080808", 175, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a8a8 fc: #d5080808", 145, 155, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #a808d508 fc: #d5080808", 165, 135, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #d5080808", 145, 175, g, 0x040404);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #d5080808", 185, 165, g, 0x040404);
	// TestUtilities.check("SRC_IN c: #08d5a8d5 fc: #d5080808", 155, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #d5080808", 165, 175, g, 0x040404);
	// TestUtilities.check("SRC_IN c: #a8d508d5 fc: #d5080808", 125, 155, g, 0x020202);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #d5080808", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #d5080808", 135, 165, g, 0x040404);
	// drawTransformedImage(0xd5d5d508, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d5a8a8 fc: #d5d5d508", 145, 155, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #d5d5d508", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #d5d5d508", 165, 175, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #a8a808d5 fc: #d5d5d508", 125, 145, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #d5d5d508", 135, 185, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #a808d5a8 fc: #d5d5d508", 175, 135, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #a808a808 fc: #d5d5d508", 135, 135, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #d5d5d508", 185, 145, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #d5d5d508", 115, 155, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #a808d5d5 fc: #d5d5d508", 185, 135, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #d5d5d508", 105, 175, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #d508a8d5 fc: #d5d5d508", 155, 165, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #d5d5d508", 105, 185, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #080808a8 fc: #d5d5d508", 115, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #d5d5d508", 125, 135, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #08a808d5 fc: #d5d5d508", 125, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #d5d5d508", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #d5d5d508", 165, 185, g, 0x7a7a04);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #d5d5d508", 165, 155, g, 0x4c4c02);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #d5d5d508", 175, 105, g, 0x000000);
	// drawTransformedImage(0x08d5d508, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #08d5d508", 115, 155, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #08d5d508", 175, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #08d5d508", 105, 185, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #d5d5a8a8 fc: #08d5d508", 145, 185, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #a808d508 fc: #08d5d508", 165, 135, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #08d5d508", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #08d5d508", 135, 165, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #08d50808 fc: #08d5d508", 105, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a808 fc: #08d5d508", 135, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808d5d5 fc: #08d5d508", 185, 135, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #a8d50808 fc: #08d5d508", 105, 155, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #08d5d508", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #08d5d508", 165, 165, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #a80808d5 fc: #08d5d508", 125, 135, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #08d5d508", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #08d5d508", 165, 175, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #a8a8d5a8 fc: #08d5d508", 175, 145, g, 0x020200);
	// TestUtilities.check("SRC_IN c: #d50808d5 fc: #08d5d508", 125, 165, g, 0x040400);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #08d5d508", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d508 fc: #08d5d508", 165, 145, g, 0x020200);
	// drawTransformedImage(0xa8d5d508, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d5d5a8 fc: #a8d5d508", 175, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #a8d5d508", 105, 185, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #a8d5d508", 165, 175, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #a808d5d5 fc: #a8d5d508", 185, 135, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #a8a80808 fc: #a8d5d508", 105, 145, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #0808d5a8 fc: #a8d5d508", 175, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #a8d5d508", 145, 175, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #d508d5d5 fc: #a8d5d508", 185, 165, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #a8d5d508", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #a8d5d508", 185, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #a80808a8 fc: #a8d5d508", 115, 135, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #080808d5 fc: #a8d5d508", 125, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5080808 fc: #a8d5d508", 105, 165, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #a8d508a8 fc: #a8d5d508", 115, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #a8d5d508", 115, 175, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #a8d5d508", 175, 185, g, 0x616103);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a8d5d508", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8d5d5 fc: #a8d5d508", 185, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #a8d5d508", 155, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #0808a808 fc: #a8d5d508", 135, 105, g, 0x000000);
	// drawTransformedImage(0xd5a8a808, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d5a808 fc: #d5a8a808", 135, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #08d5a808 fc: #d5a8a808", 135, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8d5d5 fc: #d5a8a808", 185, 145, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #d5a8a808", 105, 185, g, 0x616104);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #d5a8a808", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #d5a8a808", 115, 165, g, 0x616104);
	// TestUtilities.check("SRC_IN c: #d5a808a8 fc: #d5a8a808", 115, 175, g, 0x616104);
	// TestUtilities.check("SRC_IN c: #08a8a8d5 fc: #d5a8a808", 155, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #d5a8a808", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5d508 fc: #d5a8a808", 165, 155, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #d5a8a808", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8080808 fc: #d5a8a808", 105, 135, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #a8a808d5 fc: #d5a8a808", 125, 145, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #08d5a8a8 fc: #d5a8a808", 145, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a8a8 fc: #d5a8a808", 145, 175, g, 0x616104);
	// TestUtilities.check("SRC_IN c: #d508a808 fc: #d5a8a808", 135, 165, g, 0x616104);
	// TestUtilities.check("SRC_IN c: #08d5d5a8 fc: #d5a8a808", 175, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8d5a8 fc: #d5a8a808", 175, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8d5 fc: #d5a8a808", 155, 135, g, 0x3c3c02);
	// TestUtilities.check("SRC_IN c: #a8d5d5a8 fc: #d5a8a808", 175, 155, g, 0x3c3c02);
	// drawTransformedImage(0xa8a8d5d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #a8d50808 fc: #a8a8d5d5", 105, 155, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #a8a8d5d5", 185, 155, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #08d5d5d5 fc: #a8a8d5d5", 185, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5a8d5 fc: #a8a8d5d5", 155, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5a8d5 fc: #a8a8d5d5", 155, 155, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #a8a8d5d5", 165, 165, g, 0x4c6161);
	// TestUtilities.check("SRC_IN c: #d50808d5 fc: #a8a8d5d5", 125, 165, g, 0x4c6161);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #a8a8d5d5", 115, 165, g, 0x4c6161);
	// TestUtilities.check("SRC_IN c: #08a808a8 fc: #a8a8d5d5", 115, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #a8a8d5d5", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #a8a8d5d5", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #a8a8d5d5", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d508d5 fc: #a8a8d5d5", 125, 155, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #a8a8d5d5", 165, 185, g, 0x4c6161);
	// TestUtilities.check("SRC_IN c: #08d508a8 fc: #a8a8d5d5", 115, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5d5a8 fc: #a8a8d5d5", 175, 155, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #a8a8a808 fc: #a8a8d5d5", 135, 145, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #d5d5a8a8 fc: #a8a8d5d5", 145, 185, g, 0x4c6161);
	// TestUtilities.check("SRC_IN c: #a8a808d5 fc: #a8a8d5d5", 125, 145, g, 0x2f3c3c);
	// TestUtilities.check("SRC_IN c: #0808a808 fc: #a8a8d5d5", 135, 105, g, 0x000000);
	// drawTransformedImage(0xa8d5a8d5, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #a8d5a8d5", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8a8a8d5 fc: #a8d5a8d5", 155, 145, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #a8a808a8 fc: #a8d5a8d5", 115, 145, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #a8d5a808 fc: #a8d5a8d5", 135, 155, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #a8d5a8d5", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #a8d5a8d5", 145, 135, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #a8a808d5 fc: #a8d5a8d5", 125, 145, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #d5d5a808 fc: #a8d5a8d5", 135, 185, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #d508d5a8 fc: #a8d5a8d5", 175, 165, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #080808d5 fc: #a8d5a8d5", 125, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a8d5a8d5", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #a8d5a8d5", 135, 175, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #a808a8d5 fc: #a8d5a8d5", 155, 135, g, 0x3c2f3c);
	// TestUtilities.check("SRC_IN c: #08d508d5 fc: #a8d5a8d5", 125, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #a8d5a8d5", 115, 165, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #08a80808 fc: #a8d5a8d5", 105, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d5a8 fc: #a8d5a8d5", 175, 185, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #d5a80808 fc: #a8d5a8d5", 105, 175, g, 0x614c61);
	// TestUtilities.check("SRC_IN c: #08d5d5d5 fc: #a8d5a8d5", 185, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #080808a8 fc: #a8d5a8d5", 115, 105, g, 0x000000);
	// drawTransformedImage(0xa808a8a8, BlendMode.SRC_IN);
	// TestUtilities.check("SRC_IN c: #d5a8a808 fc: #a808a8a8", 135, 175, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #d5d508a8 fc: #a808a8a8", 115, 185, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #08a8a808 fc: #a808a8a8", 135, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a8d5d5d5 fc: #a808a8a8", 185, 155, g, 0x022f2f);
	// TestUtilities.check("SRC_IN c: #d5d50808 fc: #a808a8a8", 105, 185, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #d5a8d5d5 fc: #a808a8a8", 185, 175, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #a8a8a8d5 fc: #a808a8a8", 155, 145, g, 0x022f2f);
	// TestUtilities.check("SRC_IN c: #0808d5d5 fc: #a808a8a8", 185, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5d508 fc: #a808a8a8", 165, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5d5d5d5 fc: #a808a8a8", 185, 185, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #d508d508 fc: #a808a8a8", 165, 165, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #d5d5d508 fc: #a808a8a8", 165, 185, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #0808a8a8 fc: #a808a8a8", 145, 105, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #08d5a808 fc: #a808a8a8", 135, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #a808a8a8 fc: #a808a8a8", 145, 135, g, 0x022f2f);
	// TestUtilities.check("SRC_IN c: #d5a8d508 fc: #a808a8a8", 165, 175, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #08d508a8 fc: #a808a8a8", 115, 125, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d5a808d5 fc: #a808a8a8", 125, 175, g, 0x034c4c);
	// TestUtilities.check("SRC_IN c: #08a8a8a8 fc: #a808a8a8", 145, 115, g, 0x000000);
	// TestUtilities.check("SRC_IN c: #d50808a8 fc: #a808a8a8", 115, 165, g, 0x034c4c);
	// // drawTransformedImage(0xd5d5a8d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a8a808d5 fc: #d5d5a8d5", 125, 145, g, 0x4c0361);
	// // TestUtilities.check("DST_IN c: #08a8a8a8 fc: #d5d5a8d5", 145, 115, g, 0x030303);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #d5d5a8d5", 165, 155, g, 0x616103);
	// // TestUtilities.check("DST_IN c: #08a808d5 fc: #d5d5a8d5", 125, 115, g, 0x030004);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #d5d5a8d5", 175, 115, g, 0x030403);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #d5d5a8d5", 135, 155, g, 0x614c03);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #d5d5a8d5", 145, 155, g, 0x614c4c);
	// // TestUtilities.check("DST_IN c: #08d508d5 fc: #d5d5a8d5", 125, 125, g, 0x040004);
	// // TestUtilities.check("DST_IN c: #a808d5a8 fc: #d5d5a8d5", 175, 135, g, 0x03614c);
	// // TestUtilities.check("DST_IN c: #d5d50808 fc: #d5d5a8d5", 105, 185, g, 0x7a0404);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #d5d5a8d5", 115, 165, g, 0x040461);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #d5d5a8d5", 145, 175, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #d5d5a8d5", 145, 165, g, 0x046161);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #d5d5a8d5", 115, 145, g, 0x4c034c);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #d5d5a8d5", 165, 135, g, 0x036103);
	// // TestUtilities.check("DST_IN c: #d5a8a808 fc: #d5d5a8d5", 135, 175, g, 0x616104);
	// // TestUtilities.check("DST_IN c: #d5d5d508 fc: #d5d5a8d5", 165, 185, g, 0x7a7a04);
	// // TestUtilities.check("DST_IN c: #080808a8 fc: #d5d5a8d5", 115, 105, g, 0x000003);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #d5d5a8d5", 185, 185, g, 0x7a7a7a);
	// // TestUtilities.check("DST_IN c: #d5a808d5 fc: #d5d5a8d5", 125, 175, g, 0x61047a);
	// // drawTransformedImage(0xa8a8d508, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #a8a8d508", 145, 185, g, 0x4c3c3c);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a8a8d508", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #a8a8d508", 105, 175, g, 0x3c0202);
	// // TestUtilities.check("DST_IN c: #08a80808 fc: #a8a8d508", 105, 115, g, 0x020000);
	// // TestUtilities.check("DST_IN c: #08d5a8a8 fc: #a8a8d508", 145, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #a8a8d508", 165, 135, g, 0x023c02);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #a8a8d508", 175, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #a8a8d508", 165, 145, g, 0x2f3c02);
	// // TestUtilities.check("DST_IN c: #a8d5a8d5 fc: #a8a8d508", 155, 155, g, 0x3c2f3c);
	// // TestUtilities.check("DST_IN c: #08a8d5d5 fc: #a8a8d508", 185, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #a8a8d508", 175, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #08a8a8a8 fc: #a8a8d508", 145, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #a8a8d508", 145, 165, g, 0x023c3c);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #a8a8d508", 145, 155, g, 0x3c2f2f);
	// // TestUtilities.check("DST_IN c: #d5a8a808 fc: #a8a8d508", 135, 175, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #d5a808a8 fc: #a8a8d508", 115, 175, g, 0x3c023c);
	// // TestUtilities.check("DST_IN c: #0808d508 fc: #a8a8d508", 165, 105, g, 0x000200);
	// // TestUtilities.check("DST_IN c: #a8080808 fc: #a8a8d508", 105, 135, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8a8a8d5 fc: #a8a8d508", 155, 145, g, 0x2f2f3c);
	// // TestUtilities.check("DST_IN c: #d5080808 fc: #a8a8d508", 105, 165, g, 0x020202);
	// // drawTransformedImage(0x08a8a8d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #08a8a8d5", 175, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #08a8a8d5", 125, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #08a8a8d5", 175, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #08a8a8d5", 105, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a80808d5 fc: #08a8a8d5", 125, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #08a8a8d5", 105, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #08a8a8d5", 165, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808a8a8 fc: #08a8a8d5", 145, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #08a8a8d5", 185, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #08a8a8d5", 165, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #08a8a8d5", 175, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a808d5 fc: #08a8a8d5", 125, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a808 fc: #08a8a8d5", 135, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #08a8a8d5", 165, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d508d5 fc: #08a8a8d5", 125, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #08a8a8d5", 135, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808a808 fc: #08a8a8d5", 135, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #08a8a8d5", 145, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8d508 fc: #08a8a8d5", 165, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d508a8 fc: #08a8a8d5", 115, 155, g, 0x000000);
	// // drawTransformedImage(0xd5a8a8d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d5d508a8 fc: #d5a8a8d5", 115, 185, g, 0x7a0461);
	// // TestUtilities.check("DST_IN c: #a808d5a8 fc: #d5a8a8d5", 175, 135, g, 0x03614c);
	// // TestUtilities.check("DST_IN c: #08d5a8d5 fc: #d5a8a8d5", 155, 125, g, 0x040304);
	// // TestUtilities.check("DST_IN c: #a8a8d5d5 fc: #d5a8a8d5", 185, 145, g, 0x4c6161);
	// // TestUtilities.check("DST_IN c: #d5d508d5 fc: #d5a8a8d5", 125, 185, g, 0x7a047a);
	// // TestUtilities.check("DST_IN c: #a808a808 fc: #d5a8a8d5", 135, 135, g, 0x034c03);
	// // TestUtilities.check("DST_IN c: #d5d5a8d5 fc: #d5a8a8d5", 155, 185, g, 0x7a617a);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #d5a8a8d5", 115, 165, g, 0x040461);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #d5a8a8d5", 135, 145, g, 0x4c4c03);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #d5a8a8d5", 135, 185, g, 0x7a6104);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #d5a8a8d5", 155, 165, g, 0x04617a);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #d5a8a8d5", 175, 105, g, 0x000403);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #d5a8a8d5", 125, 165, g, 0x04047a);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #d5a8a8d5", 145, 155, g, 0x614c4c);
	// // TestUtilities.check("DST_IN c: #08d508d5 fc: #d5a8a8d5", 125, 125, g, 0x040004);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #d5a8a8d5", 115, 145, g, 0x4c034c);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #d5a8a8d5", 185, 155, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #0808a8a8 fc: #d5a8a8d5", 145, 105, g, 0x000303);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #d5a8a8d5", 145, 175, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #08d50808 fc: #d5a8a8d5", 105, 125, g, 0x040000);
	// // drawTransformedImage(0xd5080808, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #d5080808", 155, 105, g, 0x000304);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #d5080808", 165, 155, g, 0x616103);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #d5080808", 175, 165, g, 0x047a61);
	// // TestUtilities.check("DST_IN c: #08a8a808 fc: #d5080808", 135, 115, g, 0x030300);
	// // TestUtilities.check("DST_IN c: #a80808d5 fc: #d5080808", 125, 135, g, 0x030361);
	// // TestUtilities.check("DST_IN c: #08a808d5 fc: #d5080808", 125, 115, g, 0x030004);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #d5080808", 135, 185, g, 0x7a6104);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #d5080808", 135, 125, g, 0x040300);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #d5080808", 165, 165, g, 0x047a04);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #d5080808", 175, 175, g, 0x617a61);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #d5080808", 115, 145, g, 0x4c034c);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #d5080808", 185, 155, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #d5d50808 fc: #d5080808", 105, 185, g, 0x7a0404);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #d5080808", 175, 115, g, 0x030403);
	// // TestUtilities.check("DST_IN c: #a80808a8 fc: #d5080808", 115, 135, g, 0x03034c);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #d5080808", 105, 145, g, 0x4c0303);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #d5080808", 165, 115, g, 0x030400);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #d5080808", 145, 175, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #08d5d5d5 fc: #d5080808", 185, 125, g, 0x040404);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #d5080808", 165, 135, g, 0x036103);
	// // drawTransformedImage(0x08080808, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #08080808", 135, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a808d5 fc: #08080808", 125, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #08080808", 175, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #08080808", 175, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5d508 fc: #08080808", 165, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #08080808", 155, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #08080808", 175, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d5a8 fc: #08080808", 175, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #08080808", 135, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #08080808", 165, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d50808 fc: #08080808", 105, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5a8d5 fc: #08080808", 155, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d508d5 fc: #08080808", 125, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #08080808", 125, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #08080808", 135, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #08080808", 105, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #08080808", 185, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #08080808", 105, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808a8a8 fc: #08080808", 145, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5a8d5 fc: #08080808", 155, 185, g, 0x000000);
	// // drawTransformedImage(0xd5a8d508, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #d5a8d508", 145, 165, g, 0x046161);
	// // TestUtilities.check("DST_IN c: #a808a808 fc: #d5a8d508", 135, 135, g, 0x034c03);
	// // TestUtilities.check("DST_IN c: #08a808d5 fc: #d5a8d508", 125, 115, g, 0x030004);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #d5a8d508", 145, 185, g, 0x7a6161);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #d5a8d508", 135, 155, g, 0x614c03);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #d5a8d508", 135, 125, g, 0x040300);
	// // TestUtilities.check("DST_IN c: #a8a8d5a8 fc: #d5a8d508", 175, 145, g, 0x4c614c);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #d5a8d508", 125, 165, g, 0x04047a);
	// // TestUtilities.check("DST_IN c: #a8d5a8d5 fc: #d5a8d508", 155, 155, g, 0x614c61);
	// // TestUtilities.check("DST_IN c: #08a808a8 fc: #d5a8d508", 115, 115, g, 0x030003);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #d5a8d508", 115, 165, g, 0x040461);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #d5a8d508", 105, 145, g, 0x4c0303);
	// // TestUtilities.check("DST_IN c: #08d508d5 fc: #d5a8d508", 125, 125, g, 0x040004);
	// // TestUtilities.check("DST_IN c: #08d5a8d5 fc: #d5a8d508", 155, 125, g, 0x040304);
	// // TestUtilities.check("DST_IN c: #a808d5a8 fc: #d5a8d508", 175, 135, g, 0x03614c);
	// // TestUtilities.check("DST_IN c: #0808a808 fc: #d5a8d508", 135, 105, g, 0x000300);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #d5a8d508", 185, 155, g, 0x616161);
	// // TestUtilities.check("DST_IN c: #d5d508a8 fc: #d5a8d508", 115, 185, g, 0x7a0461);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #d5a8d508", 165, 135, g, 0x036103);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #d5a8d508", 155, 105, g, 0x000304);
	// // drawTransformedImage(0xa8d5a8d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d5a8a8d5 fc: #a8d5a8d5", 155, 175, g, 0x3c3c4c);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #a8d5a8d5", 115, 145, g, 0x2f022f);
	// // TestUtilities.check("DST_IN c: #a8d508a8 fc: #a8d5a8d5", 115, 155, g, 0x3c022f);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a8d5a8d5", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #d5a8d5d5 fc: #a8d5a8d5", 185, 175, g, 0x3c4c4c);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #a8d5a8d5", 175, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #a8d5a8d5", 165, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #a8d5a8d5", 145, 185, g, 0x4c3c3c);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #a8d5a8d5", 105, 145, g, 0x2f0202);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a8d5a8d5", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #a808a8a8 fc: #a8d5a8d5", 145, 135, g, 0x022f2f);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #a8d5a8d5", 165, 155, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #a8d5a8d5", 135, 155, g, 0x3c2f02);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #a8d5a8d5", 185, 185, g, 0x4c4c4c);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #a8d5a8d5", 105, 175, g, 0x3c0202);
	// // TestUtilities.check("DST_IN c: #08d5a8d5 fc: #a8d5a8d5", 155, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8a808d5 fc: #a8d5a8d5", 125, 145, g, 0x2f023c);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #a8d5a8d5", 155, 165, g, 0x023c4c);
	// // TestUtilities.check("DST_IN c: #d5d508a8 fc: #a8d5a8d5", 115, 185, g, 0x4c023c);
	// // TestUtilities.check("DST_IN c: #0808a8a8 fc: #a8d5a8d5", 145, 105, g, 0x000202);
	// // drawTransformedImage(0xa808a8a8, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #08d5d5a8 fc: #a808a8a8", 175, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a808a8d5 fc: #a808a8a8", 155, 135, g, 0x022f3c);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #a808a8a8", 145, 165, g, 0x023c3c);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #a808a8a8", 135, 185, g, 0x4c3c02);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #a808a8a8", 185, 155, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #d5a8a808 fc: #a808a8a8", 135, 175, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #0808d508 fc: #a808a8a8", 165, 105, g, 0x000200);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #a808a8a8", 165, 165, g, 0x024c02);
	// // TestUtilities.check("DST_IN c: #08d5d5d5 fc: #a808a8a8", 185, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #a808a8a8", 185, 165, g, 0x024c4c);
	// // TestUtilities.check("DST_IN c: #08a8a8a8 fc: #a808a8a8", 145, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #a808a8a8", 165, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a808a8a8", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #a808a8a8", 135, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a808a8a8", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #a8a8a8d5 fc: #a808a8a8", 155, 145, g, 0x2f2f3c);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #a808a8a8", 105, 175, g, 0x3c0202);
	// // TestUtilities.check("DST_IN c: #a8080808 fc: #a808a8a8", 105, 135, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #a808a8a8", 115, 165, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #a808a8a8", 125, 105, g, 0x000002);
	// // drawTransformedImage(0xa8a8a8a8, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a8a8a8d5 fc: #a8a8a8a8", 155, 145, g, 0x2f2f3c);
	// // TestUtilities.check("DST_IN c: #d5d5d5a8 fc: #a8a8a8a8", 175, 185, g, 0x4c4c3c);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a8a8a8a8", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #a8d5d5a8 fc: #a8a8a8a8", 175, 155, g, 0x3c3c2f);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #a8a8a8a8", 125, 105, g, 0x000002);
	// // TestUtilities.check("DST_IN c: #d5a8d508 fc: #a8a8a8a8", 165, 175, g, 0x3c4c02);
	// // TestUtilities.check("DST_IN c: #0808a8a8 fc: #a8a8a8a8", 145, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #a808a8a8 fc: #a8a8a8a8", 145, 135, g, 0x022f2f);
	// // TestUtilities.check("DST_IN c: #a80808d5 fc: #a8a8a8a8", 125, 135, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #a8a8a8a8", 165, 155, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #a808d5a8 fc: #a8a8a8a8", 175, 135, g, 0x023c2f);
	// // TestUtilities.check("DST_IN c: #a808d5d5 fc: #a8a8a8a8", 185, 135, g, 0x023c3c);
	// // TestUtilities.check("DST_IN c: #d5a808d5 fc: #a8a8a8a8", 125, 175, g, 0x3c024c);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #a8a8a8a8", 135, 185, g, 0x4c3c02);
	// // TestUtilities.check("DST_IN c: #08a8d5d5 fc: #a8a8a8a8", 185, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8d508a8 fc: #a8a8a8a8", 115, 155, g, 0x3c022f);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #a8a8a8a8", 105, 175, g, 0x3c0202);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #a8a8a8a8", 165, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #a8a8a8a8", 155, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #a8a8a8a8", 185, 185, g, 0x4c4c4c);
	// // drawTransformedImage(0xa8d5d5d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a8d508d5 fc: #a8d5d5d5", 125, 155, g, 0x3c023c);
	// // TestUtilities.check("DST_IN c: #a8d508a8 fc: #a8d5d5d5", 115, 155, g, 0x3c022f);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #a8d5d5d5", 135, 185, g, 0x4c3c02);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #a8d5d5d5", 155, 165, g, 0x023c4c);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a8d5d5d5", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #a8d5d5d5", 185, 185, g, 0x4c4c4c);
	// // TestUtilities.check("DST_IN c: #d5a8a808 fc: #a8d5d5d5", 135, 175, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #08080808 fc: #a8d5d5d5", 105, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #a8d5d5d5", 125, 165, g, 0x02024c);
	// // TestUtilities.check("DST_IN c: #0808a808 fc: #a8d5d5d5", 135, 105, g, 0x000200);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #a8d5d5d5", 165, 155, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #08a808d5 fc: #a8d5d5d5", 125, 115, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #a8d5d5d5", 115, 165, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #d5a8a8d5 fc: #a8d5d5d5", 155, 175, g, 0x3c3c4c);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #a8d5d5d5", 145, 185, g, 0x4c3c3c);
	// // TestUtilities.check("DST_IN c: #d5a8d508 fc: #a8d5d5d5", 165, 175, g, 0x3c4c02);
	// // TestUtilities.check("DST_IN c: #08d5d508 fc: #a8d5d5d5", 165, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #a8d5d5d5", 135, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #0808d5d5 fc: #a8d5d5d5", 185, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #d508a808 fc: #a8d5d5d5", 135, 165, g, 0x023c02);
	// // drawTransformedImage(0xa8d50808, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a808a808 fc: #a8d50808", 135, 135, g, 0x022f02);
	// // TestUtilities.check("DST_IN c: #08d508a8 fc: #a8d50808", 115, 125, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #a8d50808", 155, 165, g, 0x023c4c);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #a8d50808", 135, 145, g, 0x2f2f02);
	// // TestUtilities.check("DST_IN c: #080808a8 fc: #a8d50808", 115, 105, g, 0x000002);
	// // TestUtilities.check("DST_IN c: #08a8a808 fc: #a8d50808", 135, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #a8d50808", 185, 155, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #a8d50808", 185, 165, g, 0x024c4c);
	// // TestUtilities.check("DST_IN c: #d5a8d5d5 fc: #a8d50808", 185, 175, g, 0x3c4c4c);
	// // TestUtilities.check("DST_IN c: #d5a8a8d5 fc: #a8d50808", 155, 175, g, 0x3c3c4c);
	// // TestUtilities.check("DST_IN c: #08a8a8d5 fc: #a8d50808", 155, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d5d5d508 fc: #a8d50808", 165, 185, g, 0x4c4c02);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a8d50808", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #a8d50808", 165, 135, g, 0x023c02);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #a8d50808", 135, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #a8d50808", 115, 145, g, 0x2f022f);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a8d50808", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #d5d5a8a8 fc: #a8d50808", 145, 185, g, 0x4c3c3c);
	// // TestUtilities.check("DST_IN c: #d5a8d508 fc: #a8d50808", 165, 175, g, 0x3c4c02);
	// // TestUtilities.check("DST_IN c: #08d5a8a8 fc: #a8d50808", 145, 125, g, 0x020202);
	// // drawTransformedImage(0x0808d5a8, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #0808d5a8", 165, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #0808d5a8", 165, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #0808d5a8", 175, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #0808d5a8", 175, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #0808d5a8", 145, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d5a8 fc: #0808d5a8", 175, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d50808 fc: #0808d5a8", 105, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d508a8 fc: #0808d5a8", 115, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #0808d5a8", 125, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808a8d5 fc: #0808d5a8", 155, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808d508 fc: #0808d5a8", 165, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #0808d5a8", 155, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d5a8 fc: #0808d5a8", 175, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8a8d5 fc: #0808d5a8", 155, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a808a8 fc: #0808d5a8", 115, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #0808d5a8", 165, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a808a8 fc: #0808d5a8", 115, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #0808d5a8", 115, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #0808d5a8", 125, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #0808d5a8", 165, 135, g, 0x000000);
	// // drawTransformedImage(0xa8a8d5d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #a8a8d5d5", 145, 165, g, 0x023c3c);
	// // TestUtilities.check("DST_IN c: #08d5d508 fc: #a8a8d5d5", 165, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #08a8d5d5 fc: #a8a8d5d5", 185, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #a8a8d5d5", 165, 155, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #a8a8d5d5", 175, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #08d5d5a8 fc: #a8a8d5d5", 175, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #08080808 fc: #a8a8d5d5", 105, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a8d5 fc: #a8a8d5d5", 155, 145, g, 0x2f2f3c);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #a8a8d5d5", 165, 145, g, 0x2f3c02);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #a8a8d5d5", 155, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #0808a8a8 fc: #a8a8d5d5", 145, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #a8a808d5 fc: #a8a8d5d5", 125, 145, g, 0x2f023c);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #a8a8d5d5", 105, 145, g, 0x2f0202);
	// // TestUtilities.check("DST_IN c: #a80808d5 fc: #a8a8d5d5", 125, 135, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #0808a808 fc: #a8a8d5d5", 135, 105, g, 0x000200);
	// // TestUtilities.check("DST_IN c: #08a8a808 fc: #a8a8d5d5", 135, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #a80808a8 fc: #a8a8d5d5", 115, 135, g, 0x02022f);
	// // TestUtilities.check("DST_IN c: #08a8a8d5 fc: #a8a8d5d5", 155, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #a8a8d5d5", 135, 155, g, 0x3c2f02);
	// // TestUtilities.check("DST_IN c: #08d5a8a8 fc: #a8a8d5d5", 145, 125, g, 0x020202);
	// // drawTransformedImage(0x08d5d508, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #08d5d508", 165, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a8d5 fc: #08d5d508", 155, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #08d5d508", 135, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d508d5 fc: #08d5d508", 125, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d5d5d5 fc: #08d5d508", 185, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #08d5d508", 145, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8a8d5 fc: #08d5d508", 155, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #08d5d508", 185, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #08d5d508", 145, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #08d5d508", 175, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808a8d5 fc: #08d5d508", 155, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #08d5d508", 165, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8a808 fc: #08d5d508", 135, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d508a8 fc: #08d5d508", 115, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #08d5d508", 125, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #08d5d508", 145, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d5d5 fc: #08d5d508", 185, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #08d5d508", 135, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #08d5d508", 185, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a80808 fc: #08d5d508", 105, 175, g, 0x000000);
	// // drawTransformedImage(0xa8d508a8, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d50808a8 fc: #a8d508a8", 115, 165, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #08d5a8d5 fc: #a8d508a8", 155, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #a8d508a8", 165, 145, g, 0x2f3c02);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #a8d508a8", 135, 155, g, 0x3c2f02);
	// // TestUtilities.check("DST_IN c: #a808d508 fc: #a8d508a8", 165, 135, g, 0x023c02);
	// // TestUtilities.check("DST_IN c: #0808a8d5 fc: #a8d508a8", 155, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #a8d508a8", 165, 165, g, 0x024c02);
	// // TestUtilities.check("DST_IN c: #d5d50808 fc: #a8d508a8", 105, 185, g, 0x4c0202);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #a8d508a8", 125, 105, g, 0x000002);
	// // TestUtilities.check("DST_IN c: #d5a8d5d5 fc: #a8d508a8", 185, 175, g, 0x3c4c4c);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a8d508a8", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #08a808a8 fc: #a8d508a8", 115, 115, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #08a8d5d5 fc: #a8d508a8", 185, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #a8d508a8", 185, 155, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #08a808d5 fc: #a8d508a8", 125, 115, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #08d5d5a8 fc: #a8d508a8", 175, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #0808d508 fc: #a8d508a8", 165, 105, g, 0x000200);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #a8d508a8", 165, 155, g, 0x3c3c02);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #a8d508a8", 145, 175, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #d5d5d5a8 fc: #a8d508a8", 175, 185, g, 0x4c4c3c);
	// // drawTransformedImage(0x08d5a8d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #08a8a8a8 fc: #08d5a8d5", 145, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808a808 fc: #08d5a8d5", 135, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #080808d5 fc: #08d5a8d5", 125, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d508 fc: #08d5a8d5", 165, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a808a8 fc: #08d5a8d5", 115, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5a8d5 fc: #08d5a8d5", 155, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d50808 fc: #08d5a8d5", 105, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808d508 fc: #08d5a8d5", 165, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8a8d5 fc: #08d5a8d5", 155, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a808d5d5 fc: #08d5a8d5", 185, 135, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d50808 fc: #08d5a8d5", 105, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d508 fc: #08d5a8d5", 165, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #08d5a8d5", 145, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #08d5a8d5", 185, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #08d5a8d5", 165, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d5a8 fc: #08d5a8d5", 175, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #08d5a8d5", 185, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808a808 fc: #08d5a8d5", 135, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5a8d508 fc: #08d5a8d5", 165, 175, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d50808d5 fc: #08d5a8d5", 125, 165, g, 0x000000);
	// // drawTransformedImage(0xa80808a8, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #a8a8a8d5 fc: #a80808a8", 155, 145, g, 0x2f2f3c);
	// // TestUtilities.check("DST_IN c: #08d5a808 fc: #a80808a8", 135, 125, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #a80808a8", 185, 165, g, 0x024c4c);
	// // TestUtilities.check("DST_IN c: #a8d508d5 fc: #a80808a8", 125, 155, g, 0x3c023c);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #a80808a8", 135, 145, g, 0x2f2f02);
	// // TestUtilities.check("DST_IN c: #08d5a8d5 fc: #a80808a8", 155, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #0808d5a8 fc: #a80808a8", 175, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #d5d50808 fc: #a80808a8", 105, 185, g, 0x4c0202);
	// // TestUtilities.check("DST_IN c: #d5a8a8a8 fc: #a80808a8", 145, 175, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #a8080808 fc: #a80808a8", 105, 135, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d5a8d5d5 fc: #a80808a8", 185, 175, g, 0x3c4c4c);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #a80808a8", 165, 165, g, 0x024c02);
	// // TestUtilities.check("DST_IN c: #d5d508d5 fc: #a80808a8", 125, 185, g, 0x4c024c);
	// // TestUtilities.check("DST_IN c: #a8a8a8a8 fc: #a80808a8", 145, 145, g, 0x2f2f2f);
	// // TestUtilities.check("DST_IN c: #a8d5a8a8 fc: #a80808a8", 145, 155, g, 0x3c2f2f);
	// // TestUtilities.check("DST_IN c: #08a8d5a8 fc: #a80808a8", 175, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #a80808a8", 135, 185, g, 0x4c3c02);
	// // TestUtilities.check("DST_IN c: #0808d5d5 fc: #a80808a8", 185, 105, g, 0x000202);
	// // TestUtilities.check("DST_IN c: #a808d5a8 fc: #a80808a8", 175, 135, g, 0x023c2f);
	// // TestUtilities.check("DST_IN c: #080808a8 fc: #a80808a8", 115, 105, g, 0x000002);
	// // drawTransformedImage(0xa808a808, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #08a808a8 fc: #a808a808", 115, 115, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #a8a8a8a8 fc: #a808a808", 145, 145, g, 0x2f2f2f);
	// // TestUtilities.check("DST_IN c: #d5080808 fc: #a808a808", 105, 165, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d508d5a8 fc: #a808a808", 175, 165, g, 0x024c3c);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #a808a808", 135, 185, g, 0x4c3c02);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #a808a808", 145, 165, g, 0x023c3c);
	// // TestUtilities.check("DST_IN c: #a80808d5 fc: #a808a808", 125, 135, g, 0x02023c);
	// // TestUtilities.check("DST_IN c: #08d5d5d5 fc: #a808a808", 185, 125, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #080808a8 fc: #a808a808", 115, 105, g, 0x000002);
	// // TestUtilities.check("DST_IN c: #08d508a8 fc: #a808a808", 115, 125, g, 0x020002);
	// // TestUtilities.check("DST_IN c: #a8a8d5a8 fc: #a808a808", 175, 145, g, 0x2f3c2f);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #a808a808", 165, 115, g, 0x020200);
	// // TestUtilities.check("DST_IN c: #a8d5a808 fc: #a808a808", 135, 155, g, 0x3c2f02);
	// // TestUtilities.check("DST_IN c: #a8a80808 fc: #a808a808", 105, 145, g, 0x2f0202);
	// // TestUtilities.check("DST_IN c: #d5a8d5a8 fc: #a808a808", 175, 175, g, 0x3c4c3c);
	// // TestUtilities.check("DST_IN c: #a8d5d5d5 fc: #a808a808", 185, 155, g, 0x3c3c3c);
	// // TestUtilities.check("DST_IN c: #a808a808 fc: #a808a808", 135, 135, g, 0x022f02);
	// // TestUtilities.check("DST_IN c: #08a8d5d5 fc: #a808a808", 185, 115, g, 0x020202);
	// // TestUtilities.check("DST_IN c: #d5d5a8d5 fc: #a808a808", 155, 185, g, 0x4c3c4c);
	// // TestUtilities.check("DST_IN c: #d508d508 fc: #a808a808", 165, 165, g, 0x024c02);
	// // drawTransformedImage(0x08a8d5d5, BlendMode.DST_IN);
	// // TestUtilities.check("DST_IN c: #d5d5a808 fc: #08a8d5d5", 135, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a80808 fc: #08a8d5d5", 105, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8a8d5 fc: #08a8d5d5", 155, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5d508 fc: #08a8d5d5", 165, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a808 fc: #08a8d5d5", 135, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808d5d5 fc: #08a8d5d5", 185, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d508d5 fc: #08a8d5d5", 125, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a808 fc: #08a8d5d5", 135, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8a8a8 fc: #08a8d5d5", 145, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5d5d5 fc: #08a8d5d5", 185, 185, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508d5d5 fc: #08a8d5d5", 185, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08d508d5 fc: #08a8d5d5", 125, 125, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d508a8a8 fc: #08a8d5d5", 145, 165, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8d5d5a8 fc: #08a8d5d5", 175, 155, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08080808 fc: #08a8d5d5", 105, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a8d5a8 fc: #08a8d5d5", 175, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #0808a8a8 fc: #08a8d5d5", 145, 105, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #08a8d508 fc: #08a8d5d5", 165, 115, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #a8a808d5 fc: #08a8d5d5", 125, 145, g, 0x000000);
	// // TestUtilities.check("DST_IN c: #d5d5d5a8 fc: #08a8d5d5", 175, 185, g, 0x000000);
	// // drawTransformedImage(0xa80808d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #a80808d5", 185, 175, g, 0x3b4bf0);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #a80808d5", 185, 155, g, 0x4848e1);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5a8 fc: #a80808d5", 175, 145, g, 0x3948e1);
	// // TestUtilities.check("MULTIPLY c: #a8a808a8 fc: #a80808d5", 115, 145, g, 0x3904e1);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8a8 fc: #a80808d5", 145, 145, g, 0x3939e1);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #a80808d5", 115, 135, g, 0x0404e1);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #a80808d5", 135, 185, g, 0x4b3b29);
	// // TestUtilities.check("MULTIPLY c: #d5d508a8 fc: #a80808d5", 115, 185, g, 0x4b03da);
	// // TestUtilities.check("MULTIPLY c: #a808d5d5 fc: #a80808d5", 185, 135, g, 0x0448e1);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5a8 fc: #a80808d5", 175, 185, g, 0x4b4bda);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #a80808d5", 145, 125, g, 0x3a2eaa);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #a80808d5", 165, 125, g, 0x3a3a8f);
	// // TestUtilities.check("MULTIPLY c: #d508d508 fc: #a80808d5", 165, 165, g, 0x034b29);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #a80808d5", 155, 185, g, 0x4b3bf0);
	// // TestUtilities.check("MULTIPLY c: #a8d50808 fc: #a80808d5", 105, 155, g, 0x480448);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #a80808d5", 175, 115, g, 0x2e3aaa);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8d5 fc: #a80808d5", 155, 175, g, 0x3b3bf0);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5d5 fc: #a80808d5", 185, 185, g, 0x4b4bf0);
	// // TestUtilities.check("MULTIPLY c: #08a8a8d5 fc: #a80808d5", 155, 115, g, 0x2e2eaa);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #a80808d5", 165, 175, g, 0x3b4b29);
	// // drawTransformedImage(0x0808d508, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #0808d508", 115, 135, g, 0x063a71);
	// // TestUtilities.check("MULTIPLY c: #080808d5 fc: #0808d508", 125, 105, g, 0x000c0c);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #0808d508", 165, 125, g, 0x0c0f00);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5a8 fc: #0808d508", 175, 155, g, 0x8faa71);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #0808d508", 185, 175, g, 0x8dd6b3);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8d5 fc: #0808d508", 155, 175, g, 0x8dd6b3);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #0808d508", 135, 115, g, 0x0a0f00);
	// // TestUtilities.check("MULTIPLY c: #08080808 fc: #0808d508", 105, 105, g, 0x000c00);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #0808d508", 115, 115, g, 0x0a0c0a);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #0808d508", 145, 105, g, 0x000f0a);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #0808d508", 115, 155, g, 0x8f3a71);
	// // TestUtilities.check("MULTIPLY c: #a8a80808 fc: #0808d508", 105, 145, g, 0x713a06);
	// // TestUtilities.check("MULTIPLY c: #a8d50808 fc: #0808d508", 105, 155, g, 0x8f3a06);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #0808d508", 145, 175, g, 0x8dd68d);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8d5 fc: #0808d508", 155, 155, g, 0x8faa8f);
	// // TestUtilities.check("MULTIPLY c: #d50808d5 fc: #0808d508", 125, 165, g, 0x0729b3);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #0808d508", 165, 105, g, 0x000f00);
	// // TestUtilities.check("MULTIPLY c: #a8d5a808 fc: #0808d508", 135, 155, g, 0x8faa06);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8a8 fc: #0808d508", 145, 185, g, 0xb3d68d);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5a8 fc: #0808d508", 175, 175, g, 0x8dd68d);
	// // drawTransformedImage(0xd508a8d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d5a808d5 fc: #d508a8d5", 125, 175, g, 0x2121f1);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #d508a8d5", 145, 105, g, 0x07d6d6);
	// // TestUtilities.check("MULTIPLY c: #a808a8d5 fc: #d508a8d5", 155, 135, g, 0x03b7f0);
	// // TestUtilities.check("MULTIPLY c: #d508d5a8 fc: #d508a8d5", 175, 165, g, 0x01c5c5);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #d508a8d5", 165, 175, g, 0x21c529);
	// // TestUtilities.check("MULTIPLY c: #a808a808 fc: #d508a8d5", 135, 135, g, 0x03b74b);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #d508a8d5", 165, 185, g, 0x29c529);
	// // TestUtilities.check("MULTIPLY c: #a8a80808 fc: #d508a8d5", 105, 145, g, 0x203b4b);
	// // TestUtilities.check("MULTIPLY c: #a808d5d5 fc: #d508a8d5", 185, 135, g, 0x03daf0);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #d508a8d5", 145, 175, g, 0x21a1c5);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #d508a8d5", 165, 105, g, 0x07d6b3);
	// // TestUtilities.check("MULTIPLY c: #08d50808 fc: #d508a8d5", 105, 125, g, 0x298db3);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8d5 fc: #d508a8d5", 155, 175, g, 0x21a1f1);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5a8 fc: #d508a8d5", 175, 145, g, 0x20dae1);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #d508a8d5", 155, 105, g, 0x07d6d6);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5a8 fc: #d508a8d5", 175, 155, g, 0x29dae1);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #d508a8d5", 115, 115, g, 0x218dd6);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #d508a8d5", 155, 145, g, 0x20b7f0);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #d508a8d5", 185, 115, g, 0x21d6d6);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8a8 fc: #d508a8d5", 145, 155, g, 0x29b7e1);
	// // drawTransformedImage(0x08d5a808, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a808a808 fc: #08d5a808", 135, 135, g, 0x3aaa06);
	// // TestUtilities.check("MULTIPLY c: #a8d5d508 fc: #08d5a808", 165, 155, g, 0xaaaa06);
	// // TestUtilities.check("MULTIPLY c: #a808a8a8 fc: #08d5a808", 145, 135, g, 0x3aaa71);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8a8 fc: #08d5a808", 145, 155, g, 0xaaaa71);
	// // TestUtilities.check("MULTIPLY c: #a8a808d5 fc: #08d5a808", 125, 145, g, 0xaa2e8f);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #08d5a808", 155, 145, g, 0xaaaa8f);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #08d5a808", 105, 165, g, 0x292107);
	// // TestUtilities.check("MULTIPLY c: #d5d508d5 fc: #08d5a808", 125, 185, g, 0xd621b3);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #08d5a808", 135, 105, g, 0x0c0f00);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #08d5a808", 135, 115, g, 0x0f0f00);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5a8 fc: #08d5a808", 175, 155, g, 0xaaaa71);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5a8 fc: #08d5a808", 175, 185, g, 0xd6d68d);
	// // TestUtilities.check("MULTIPLY c: #d50808d5 fc: #08d5a808", 125, 165, g, 0x2921b3);
	// // TestUtilities.check("MULTIPLY c: #0808d5a8 fc: #08d5a808", 175, 105, g, 0x0c0f0a);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8a8 fc: #08d5a808", 145, 185, g, 0xd6d68d);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #08d5a808", 125, 135, g, 0x3a2e8f);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #08d5a808", 145, 115, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #d5a808a8 fc: #08d5a808", 115, 175, g, 0xd6218d);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #08d5a808", 165, 125, g, 0x0f0f00);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #08d5a808", 155, 125, g, 0x0f0f0c);
	// // drawTransformedImage(0x0808d5a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #0808d5a8", 155, 185, g, 0xb3d6d6);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #0808d5a8", 115, 155, g, 0x8f3aaa);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #0808d5a8", 165, 185, g, 0xb3d621);
	// // TestUtilities.check("MULTIPLY c: #a8080808 fc: #0808d5a8", 105, 135, g, 0x063a2e);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #0808d5a8", 135, 115, g, 0x0a0f0a);
	// // TestUtilities.check("MULTIPLY c: #d5a808d5 fc: #0808d5a8", 125, 175, g, 0x8d29d6);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #0808d5a8", 175, 125, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #d50808a8 fc: #0808d5a8", 115, 165, g, 0x0729d6);
	// // TestUtilities.check("MULTIPLY c: #080808d5 fc: #0808d5a8", 125, 105, g, 0x000c0f);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #0808d5a8", 155, 145, g, 0x71aaaa);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #0808d5a8", 175, 115, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #08a80808 fc: #0808d5a8", 105, 115, g, 0x0a0c0a);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #0808d5a8", 185, 175, g, 0x8dd6d6);
	// // TestUtilities.check("MULTIPLY c: #0808d5a8 fc: #0808d5a8", 175, 105, g, 0x000f0f);
	// // TestUtilities.check("MULTIPLY c: #08d5a808 fc: #0808d5a8", 135, 125, g, 0x0c0f0a);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #0808d5a8", 165, 105, g, 0x000f0a);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #0808d5a8", 145, 115, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #d508a808 fc: #0808d5a8", 135, 165, g, 0x07d621);
	// // TestUtilities.check("MULTIPLY c: #08a8a8d5 fc: #0808d5a8", 155, 115, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #0808d5a8", 185, 115, g, 0x0a0f0f);
	// // drawTransformedImage(0xa8a8d5d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #a8a8d5d5", 135, 115, g, 0xaaaa8f);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5d5 fc: #a8a8d5d5", 185, 185, g, 0xe1f0f0);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #a8a8d5d5", 165, 185, g, 0xe1f029);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #a8a8d5d5", 165, 175, g, 0xb7f029);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #a8a8d5d5", 185, 115, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #d5d508d5 fc: #a8a8d5d5", 125, 185, g, 0xe129f0);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #a8a8d5d5", 165, 145, g, 0xc6e148);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #a8a8d5d5", 185, 145, g, 0xc6e1e1);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #a8a8d5d5", 175, 125, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #a8a8d5d5", 165, 105, g, 0x71aa8f);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #a8a8d5d5", 145, 115, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #a8a8d5d5", 145, 105, g, 0x71aaaa);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #a8a8d5d5", 135, 185, g, 0xe1da29);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #a8a8d5d5", 165, 125, g, 0xaaaa8f);
	// // TestUtilities.check("MULTIPLY c: #a8d508d5 fc: #a8a8d5d5", 125, 155, g, 0xe148e1);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #a8a8d5d5", 115, 155, g, 0xe148e1);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5a8 fc: #a8a8d5d5", 175, 185, g, 0xe1f0da);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #a8a8d5d5", 155, 185, g, 0xe1daf0);
	// // TestUtilities.check("MULTIPLY c: #a808d5d5 fc: #a8a8d5d5", 185, 135, g, 0x39e1e1);
	// // TestUtilities.check("MULTIPLY c: #08d5d5d5 fc: #a8a8d5d5", 185, 125, g, 0xaaaaaa);
	// // drawTransformedImage(0x08d5d5a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #08d5d5a8", 135, 115, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #0808d5d5 fc: #08d5d5a8", 185, 105, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #08a8a8d5 fc: #08d5d5a8", 155, 115, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #08d5a808 fc: #08d5d5a8", 135, 125, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #08d5d5a8", 145, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #08d5d5a8", 185, 175, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8d5 fc: #08d5d5a8", 155, 175, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5a8 fc: #08d5d5a8", 175, 145, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #08d5d5d5 fc: #08d5d5a8", 185, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #d508a808 fc: #08d5d5a8", 135, 165, g, 0x29d621);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #08d5d5a8", 185, 155, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #08d5d5a8", 125, 135, g, 0x3a3aaa);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5d5 fc: #08d5d5a8", 185, 185, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #080808a8 fc: #08d5d5a8", 115, 105, g, 0x0c0c0f);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #08d5d5a8", 115, 115, g, 0x0f0c0f);
	// // TestUtilities.check("MULTIPLY c: #d50808d5 fc: #08d5d5a8", 125, 165, g, 0x2929d6);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #08d5d5a8", 175, 115, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #08d5d5a8", 185, 145, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #08d5d5a8", 155, 185, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #08d5d5a8", 145, 175, g, 0xd6d6d6);
	// // drawTransformedImage(0xa80808a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #080808d5 fc: #a80808a8", 125, 105, g, 0x0606aa);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #a80808a8", 155, 105, g, 0x062eaa);
	// // TestUtilities.check("MULTIPLY c: #d508a8d5 fc: #a80808a8", 155, 165, g, 0x033be1);
	// // TestUtilities.check("MULTIPLY c: #0808d5d5 fc: #a80808a8", 185, 105, g, 0x063aaa);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #a80808a8", 155, 145, g, 0x3939e1);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #a80808a8", 125, 135, g, 0x0404e1);
	// // TestUtilities.check("MULTIPLY c: #a8a808d5 fc: #a80808a8", 125, 145, g, 0x3904e1);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #a80808a8", 165, 145, g, 0x394839);
	// // TestUtilities.check("MULTIPLY c: #08a808d5 fc: #a80808a8", 125, 115, g, 0x2e06aa);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #a80808a8", 165, 105, g, 0x063a71);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #a80808a8", 145, 105, g, 0x062eaa);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #a80808a8", 145, 175, g, 0x3b3bb7);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #a80808a8", 185, 115, g, 0x2e3aaa);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5a8 fc: #a80808a8", 175, 155, g, 0x4848c6);
	// // TestUtilities.check("MULTIPLY c: #a808a8d5 fc: #a80808a8", 155, 135, g, 0x0439e1);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8a8 fc: #a80808a8", 145, 185, g, 0x4b3bb7);
	// // TestUtilities.check("MULTIPLY c: #08d508a8 fc: #a80808a8", 115, 125, g, 0x3a06aa);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #a80808a8", 155, 185, g, 0x4b3be1);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #a80808a8", 175, 125, g, 0x3a3aaa);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #a80808a8", 105, 165, g, 0x030320);
	// // drawTransformedImage(0x0808a8a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #0808a8a8", 165, 175, g, 0x8dd621);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #0808a8a8", 145, 175, g, 0x8dd6d6);
	// // TestUtilities.check("MULTIPLY c: #08d50808 fc: #0808a8a8", 105, 125, g, 0x0c0a0a);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8d5 fc: #0808a8a8", 155, 155, g, 0x8faaaa);
	// // TestUtilities.check("MULTIPLY c: #08a8d508 fc: #0808a8a8", 165, 115, g, 0x0a0f0a);
	// // TestUtilities.check("MULTIPLY c: #a808d5a8 fc: #0808a8a8", 175, 135, g, 0x06aaaa);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #0808a8a8", 125, 135, g, 0x062eaa);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #0808a8a8", 175, 125, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #0808a8a8", 185, 155, g, 0x8faaaa);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #0808a8a8", 115, 135, g, 0x062eaa);
	// // TestUtilities.check("MULTIPLY c: #a8a808d5 fc: #0808a8a8", 125, 145, g, 0x712eaa);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #0808a8a8", 135, 105, g, 0x000f0a);
	// // TestUtilities.check("MULTIPLY c: #d508a8a8 fc: #0808a8a8", 145, 165, g, 0x07d6d6);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #0808a8a8", 115, 115, g, 0x0a0a0f);
	// // TestUtilities.check("MULTIPLY c: #d508d5d5 fc: #0808a8a8", 185, 165, g, 0x07d6d6);
	// // TestUtilities.check("MULTIPLY c: #d5d50808 fc: #0808a8a8", 105, 185, g, 0xb32121);
	// // TestUtilities.check("MULTIPLY c: #08d508a8 fc: #0808a8a8", 115, 125, g, 0x0c0a0f);
	// // TestUtilities.check("MULTIPLY c: #a8d508d5 fc: #0808a8a8", 125, 155, g, 0x8f2eaa);
	// // TestUtilities.check("MULTIPLY c: #a8a8a808 fc: #0808a8a8", 135, 145, g, 0x71aa2e);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #0808a8a8", 185, 145, g, 0x71aaaa);
	// // drawTransformedImage(0x08a8a8a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #08a8a8a8", 185, 115, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8a808d5 fc: #08a8a8a8", 125, 145, g, 0xaa2eaa);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #08a8a8a8", 155, 105, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8d50808 fc: #08a8a8a8", 105, 155, g, 0xaa2e2e);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #08a8a8a8", 165, 145, g, 0xaaaa2e);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #08a8a8a8", 185, 155, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #08a8a8a8", 135, 105, g, 0x0a0f0a);
	// // TestUtilities.check("MULTIPLY c: #d5d508a8 fc: #08a8a8a8", 115, 185, g, 0xd621d6);
	// // TestUtilities.check("MULTIPLY c: #a808d5a8 fc: #08a8a8a8", 175, 135, g, 0x2eaaaa);
	// // TestUtilities.check("MULTIPLY c: #d50808d5 fc: #08a8a8a8", 125, 165, g, 0x2121d6);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #08a8a8a8", 135, 115, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #08a8a8a8", 115, 135, g, 0x2e2eaa);
	// // TestUtilities.check("MULTIPLY c: #08d5d5d5 fc: #08a8a8a8", 185, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #08a8a8a8", 115, 155, g, 0xaa2eaa);
	// // TestUtilities.check("MULTIPLY c: #08a80808 fc: #08a8a8a8", 105, 115, g, 0x0f0a0a);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #08a8a8a8", 185, 175, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #d5a808d5 fc: #08a8a8a8", 125, 175, g, 0xd621d6);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #08a8a8a8", 145, 105, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #a808a8a8 fc: #08a8a8a8", 145, 135, g, 0x2eaaaa);
	// // TestUtilities.check("MULTIPLY c: #a8a80808 fc: #08a8a8a8", 105, 145, g, 0xaa2e2e);
	// // drawTransformedImage(0xd50808a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #d50808a8", 185, 155, g, 0x2929da);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #d50808a8", 185, 115, g, 0x2129d6);
	// // TestUtilities.check("MULTIPLY c: #d5a80808 fc: #d50808a8", 105, 175, g, 0x210121);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8d5 fc: #d50808a8", 155, 185, g, 0x2921c5);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #d50808a8", 105, 165, g, 0x010121);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #d50808a8", 115, 155, g, 0x2903b7);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #d50808a8", 145, 115, g, 0x2121d6);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #d50808a8", 165, 145, g, 0x20293b);
	// // TestUtilities.check("MULTIPLY c: #d508d508 fc: #d50808a8", 165, 165, g, 0x012921);
	// // TestUtilities.check("MULTIPLY c: #d508a808 fc: #d50808a8", 135, 165, g, 0x012121);
	// // TestUtilities.check("MULTIPLY c: #08080808 fc: #d50808a8", 105, 105, g, 0x07078d);
	// // TestUtilities.check("MULTIPLY c: #d508d5d5 fc: #d50808a8", 185, 165, g, 0x0129c5);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #d50808a8", 165, 185, g, 0x292921);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #d50808a8", 185, 175, g, 0x2129c5);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8d5 fc: #d50808a8", 155, 175, g, 0x2121c5);
	// // TestUtilities.check("MULTIPLY c: #08a8d508 fc: #d50808a8", 165, 115, g, 0x21298d);
	// // TestUtilities.check("MULTIPLY c: #a8d50808 fc: #d50808a8", 105, 155, g, 0x29033b);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8a8 fc: #d50808a8", 145, 145, g, 0x2020b7);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #d50808a8", 135, 115, g, 0x21218d);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #d50808a8", 175, 115, g, 0x2129d6);
	// // drawTransformedImage(0x08d5a8a8, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #08d5a8a8", 185, 145, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #a808d5d5 fc: #08d5a8a8", 185, 135, g, 0x3aaaaa);
	// // TestUtilities.check("MULTIPLY c: #d5a808a8 fc: #08d5a8a8", 115, 175, g, 0xd621d6);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #08d5a8a8", 165, 175, g, 0xd6d621);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #08d5a8a8", 105, 165, g, 0x292121);
	// // TestUtilities.check("MULTIPLY c: #d5d508a8 fc: #08d5a8a8", 115, 185, g, 0xd621d6);
	// // TestUtilities.check("MULTIPLY c: #d508a8d5 fc: #08d5a8a8", 155, 165, g, 0x29d6d6);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #08d5a8a8", 145, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8a808d5 fc: #08d5a8a8", 125, 145, g, 0xaa2eaa);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #08d5a8a8", 155, 105, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #08d5a8a8", 135, 185, g, 0xd6d621);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #08d5a8a8", 115, 115, g, 0x0f0a0f);
	// // TestUtilities.check("MULTIPLY c: #08a808d5 fc: #08d5a8a8", 125, 115, g, 0x0f0a0f);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #08d5a8a8", 155, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a808a808 fc: #08d5a8a8", 135, 135, g, 0x3aaa2e);
	// // TestUtilities.check("MULTIPLY c: #08d50808 fc: #08d5a8a8", 105, 125, g, 0x0f0a0a);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5d5 fc: #08d5a8a8", 185, 175, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #08d5a8a8", 135, 105, g, 0x0c0f0a);
	// // TestUtilities.check("MULTIPLY c: #a8d5d508 fc: #08d5a8a8", 165, 155, g, 0xaaaa2e);
	// // TestUtilities.check("MULTIPLY c: #a8d5a808 fc: #08d5a8a8", 135, 155, g, 0xaaaa2e);
	// // drawTransformedImage(0xd5a8d5d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a8a808 fc: #d5a8d5d5", 135, 145, g, 0xb7e14b);
	// // TestUtilities.check("MULTIPLY c: #0808d5d5 fc: #d5a8d5d5", 185, 105, g, 0x8dd6d6);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5a8 fc: #d5a8d5d5", 175, 175, g, 0xa1f1c5);
	// // TestUtilities.check("MULTIPLY c: #a8d5d5d5 fc: #d5a8d5d5", 185, 155, g, 0xdaf0f0);
	// // TestUtilities.check("MULTIPLY c: #08080808 fc: #d5a8d5d5", 105, 105, g, 0x8db3b3);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #d5a8d5d5", 155, 145, g, 0xb7e1f0);
	// // TestUtilities.check("MULTIPLY c: #a808d5d5 fc: #d5a8d5d5", 185, 135, g, 0x3bf0f0);
	// // TestUtilities.check("MULTIPLY c: #08a8d508 fc: #d5a8d5d5", 165, 115, g, 0xd6d6b3);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #d5a8d5d5", 185, 145, g, 0xb7f0f0);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5d5 fc: #d5a8d5d5", 185, 185, g, 0xc5f1f1);
	// // TestUtilities.check("MULTIPLY c: #d50808a8 fc: #d5a8d5d5", 115, 165, g, 0x2129c5);
	// // TestUtilities.check("MULTIPLY c: #a808d508 fc: #d5a8d5d5", 165, 135, g, 0x3bf04b);
	// // TestUtilities.check("MULTIPLY c: #08a8a808 fc: #d5a8d5d5", 135, 115, g, 0xd6d6b3);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #d5a8d5d5", 135, 105, g, 0x8dd6b3);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #d5a8d5d5", 115, 155, g, 0xda4be1);
	// // TestUtilities.check("MULTIPLY c: #08a80808 fc: #d5a8d5d5", 105, 115, g, 0xd6b3b3);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #d5a8d5d5", 165, 185, g, 0xc5f129);
	// // TestUtilities.check("MULTIPLY c: #d5a808d5 fc: #d5a8d5d5", 125, 175, g, 0xa129f1);
	// // TestUtilities.check("MULTIPLY c: #08d508d5 fc: #d5a8d5d5", 125, 125, g, 0xd6b3d6);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #d5a8d5d5", 165, 125, g, 0xd6d6b3);
	// // drawTransformedImage(0x0808d5d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a8a808 fc: #0808d5d5", 135, 145, g, 0x71aa3a);
	// // TestUtilities.check("MULTIPLY c: #a8080808 fc: #0808d5d5", 105, 135, g, 0x063a3a);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5a8 fc: #0808d5d5", 175, 185, g, 0xb3d6d6);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #0808d5d5", 155, 125, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #08a8d508 fc: #0808d5d5", 165, 115, g, 0x0a0f0c);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #0808d5d5", 165, 175, g, 0x8dd629);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8a8 fc: #0808d5d5", 145, 155, g, 0x8faaaa);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #0808d5d5", 115, 155, g, 0x8f3aaa);
	// // TestUtilities.check("MULTIPLY c: #d5a8a808 fc: #0808d5d5", 135, 175, g, 0x8dd629);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #0808d5d5", 115, 135, g, 0x063aaa);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #0808d5d5", 175, 125, g, 0x0c0f0f);
	// // TestUtilities.check("MULTIPLY c: #a8a80808 fc: #0808d5d5", 105, 145, g, 0x713a3a);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5d5 fc: #0808d5d5", 185, 185, g, 0xb3d6d6);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #0808d5d5", 165, 125, g, 0x0c0f0c);
	// // TestUtilities.check("MULTIPLY c: #0808a808 fc: #0808d5d5", 135, 105, g, 0x000f0c);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #0808d5d5", 185, 145, g, 0x71aaaa);
	// // TestUtilities.check("MULTIPLY c: #a808a8d5 fc: #0808d5d5", 155, 135, g, 0x06aaaa);
	// // TestUtilities.check("MULTIPLY c: #080808a8 fc: #0808d5d5", 115, 105, g, 0x000c0f);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #0808d5d5", 145, 115, g, 0x0a0f0f);
	// // TestUtilities.check("MULTIPLY c: #08d5a808 fc: #0808d5d5", 135, 125, g, 0x0c0f0c);
	// // drawTransformedImage(0xd5d50808, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5a8 fc: #d5d50808", 175, 145, g, 0xe12920);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #d5d50808", 125, 135, g, 0x4b0329);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #d5d50808", 175, 125, g, 0xd62921);
	// // TestUtilities.check("MULTIPLY c: #a8d508a8 fc: #d5d50808", 115, 155, g, 0xf00320);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #d5d50808", 185, 115, g, 0xd62929);
	// // TestUtilities.check("MULTIPLY c: #080808a8 fc: #d5d50808", 115, 105, g, 0xb30721);
	// // TestUtilities.check("MULTIPLY c: #08a8a8d5 fc: #d5d50808", 155, 115, g, 0xd62129);
	// // TestUtilities.check("MULTIPLY c: #d508d5d5 fc: #d5d50808", 185, 165, g, 0x292929);
	// // TestUtilities.check("MULTIPLY c: #a808a8a8 fc: #d5d50808", 145, 135, g, 0x4b2020);
	// // TestUtilities.check("MULTIPLY c: #d5d5d5a8 fc: #d5d50808", 175, 185, g, 0xf12921);
	// // TestUtilities.check("MULTIPLY c: #08d50808 fc: #d5d50808", 105, 125, g, 0xd60707);
	// // TestUtilities.check("MULTIPLY c: #0808d5d5 fc: #d5d50808", 185, 105, g, 0xb32929);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #d5d50808", 145, 125, g, 0xd62121);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #d5d50808", 135, 185, g, 0xf12101);
	// // TestUtilities.check("MULTIPLY c: #d5d508d5 fc: #d5d50808", 125, 185, g, 0xf10129);
	// // TestUtilities.check("MULTIPLY c: #08a80808 fc: #d5d50808", 105, 115, g, 0xd60707);
	// // TestUtilities.check("MULTIPLY c: #08d508a8 fc: #d5d50808", 115, 125, g, 0xd60721);
	// // TestUtilities.check("MULTIPLY c: #d50808a8 fc: #d5d50808", 115, 165, g, 0x290121);
	// // TestUtilities.check("MULTIPLY c: #08a808d5 fc: #d5d50808", 125, 115, g, 0xd60729);
	// // TestUtilities.check("MULTIPLY c: #a8080808 fc: #d5d50808", 105, 135, g, 0x4b0303);
	// // drawTransformedImage(0xd5d5a808, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #d5d5a808", 155, 145, g, 0xe1b729);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #d5d5a808", 145, 175, g, 0xc5a121);
	// // TestUtilities.check("MULTIPLY c: #d508a8d5 fc: #d5d5a808", 155, 165, g, 0x29a129);
	// // TestUtilities.check("MULTIPLY c: #0808d5a8 fc: #d5d5a808", 175, 105, g, 0xb3d621);
	// // TestUtilities.check("MULTIPLY c: #0808a8a8 fc: #d5d5a808", 145, 105, g, 0xb3d621);
	// // TestUtilities.check("MULTIPLY c: #08a8d508 fc: #d5d5a808", 165, 115, g, 0xd6d607);
	// // TestUtilities.check("MULTIPLY c: #a808a8a8 fc: #d5d5a808", 145, 135, g, 0x4bb720);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #d5d5a808", 155, 125, g, 0xd6d629);
	// // TestUtilities.check("MULTIPLY c: #d508d508 fc: #d5d5a808", 165, 165, g, 0x29c501);
	// // TestUtilities.check("MULTIPLY c: #a80808a8 fc: #d5d5a808", 115, 135, g, 0x4b3b20);
	// // TestUtilities.check("MULTIPLY c: #d5d5d508 fc: #d5d5a808", 165, 185, g, 0xf1c501);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5a8 fc: #d5d5a808", 175, 145, g, 0xe1da20);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #d5d5a808", 165, 145, g, 0xe1da03);
	// // TestUtilities.check("MULTIPLY c: #08d5a808 fc: #d5d5a808", 135, 125, g, 0xd6d607);
	// // TestUtilities.check("MULTIPLY c: #08a80808 fc: #d5d5a808", 105, 115, g, 0xd68d07);
	// // TestUtilities.check("MULTIPLY c: #d5d50808 fc: #d5d5a808", 105, 185, g, 0xf12101);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #d5d5a808", 105, 165, g, 0x292101);
	// // TestUtilities.check("MULTIPLY c: #d5a8a808 fc: #d5d5a808", 135, 175, g, 0xc5a101);
	// // TestUtilities.check("MULTIPLY c: #a8d508d5 fc: #d5d5a808", 125, 155, g, 0xf03b29);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #d5d5a808", 165, 105, g, 0xb3d607);
	// // drawTransformedImage(0xa8d5d508, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #a8d5d508", 135, 185, g, 0xf0da03);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #a8d5d508", 165, 105, g, 0x8faa06);
	// // TestUtilities.check("MULTIPLY c: #08d508d5 fc: #a8d5d508", 125, 125, g, 0xaa8f3a);
	// // TestUtilities.check("MULTIPLY c: #d508a8d5 fc: #a8d5d508", 155, 165, g, 0x29da4b);
	// // TestUtilities.check("MULTIPLY c: #0808d5a8 fc: #a8d5d508", 175, 105, g, 0x8faa2e);
	// // TestUtilities.check("MULTIPLY c: #a808a808 fc: #a8d5d508", 135, 135, g, 0x48e104);
	// // TestUtilities.check("MULTIPLY c: #d5a8a808 fc: #a8d5d508", 135, 175, g, 0xdada03);
	// // TestUtilities.check("MULTIPLY c: #080808a8 fc: #a8d5d508", 115, 105, g, 0x8f8f2e);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #a8d5d508", 165, 145, g, 0xe1e104);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #a8d5d508", 155, 125, g, 0xaaaa3a);
	// // TestUtilities.check("MULTIPLY c: #a8d50808 fc: #a8d5d508", 105, 155, g, 0xe14804);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #a8d5d508", 145, 115, g, 0xaaaa2e);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #a8d5d508", 175, 115, g, 0xaaaa2e);
	// // TestUtilities.check("MULTIPLY c: #080808d5 fc: #a8d5d508", 125, 105, g, 0x8f8f3a);
	// // TestUtilities.check("MULTIPLY c: #08a808a8 fc: #a8d5d508", 115, 115, g, 0xaa8f2e);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5a8 fc: #a8d5d508", 175, 175, g, 0xdaf03b);
	// // TestUtilities.check("MULTIPLY c: #d508a8a8 fc: #a8d5d508", 145, 165, g, 0x29da3b);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #a8d5d508", 165, 125, g, 0xaaaa06);
	// // TestUtilities.check("MULTIPLY c: #a8a8a8d5 fc: #a8d5d508", 155, 145, g, 0xe1e148);
	// // TestUtilities.check("MULTIPLY c: #a808a8d5 fc: #a8d5d508", 155, 135, g, 0x48e148);
	// // drawTransformedImage(0x08a8a8d5, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8a808a8 fc: #08a8a8d5", 115, 145, g, 0xaa2eaa);
	// // TestUtilities.check("MULTIPLY c: #d508d508 fc: #08a8a8d5", 165, 165, g, 0x21d629);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #08a8a8d5", 105, 165, g, 0x212129);
	// // TestUtilities.check("MULTIPLY c: #d508d5a8 fc: #08a8a8d5", 175, 165, g, 0x21d6d6);
	// // TestUtilities.check("MULTIPLY c: #a8d5a808 fc: #08a8a8d5", 135, 155, g, 0xaaaa3a);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5a8 fc: #08a8a8d5", 175, 175, g, 0xd6d6d6);
	// // TestUtilities.check("MULTIPLY c: #a808d5a8 fc: #08a8a8d5", 175, 135, g, 0x2eaaaa);
	// // TestUtilities.check("MULTIPLY c: #08a808d5 fc: #08a8a8d5", 125, 115, g, 0x0f0a0f);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8a8 fc: #08a8a8d5", 145, 155, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #d5a8a808 fc: #08a8a8d5", 135, 175, g, 0xd6d629);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #08a8a8d5", 165, 145, g, 0xaaaa3a);
	// // TestUtilities.check("MULTIPLY c: #a8a8a808 fc: #08a8a8d5", 135, 145, g, 0xaaaa3a);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8d5 fc: #08a8a8d5", 155, 155, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #d5d5a808 fc: #08a8a8d5", 135, 185, g, 0xd6d629);
	// // TestUtilities.check("MULTIPLY c: #a8a8d5d5 fc: #08a8a8d5", 185, 145, g, 0xaaaaaa);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #08a8a8d5", 145, 125, g, 0x0f0f0f);
	// // TestUtilities.check("MULTIPLY c: #a80808d5 fc: #08a8a8d5", 125, 135, g, 0x2e2eaa);
	// // TestUtilities.check("MULTIPLY c: #a8080808 fc: #08a8a8d5", 105, 135, g, 0x2e2e3a);
	// // TestUtilities.check("MULTIPLY c: #d5a8d508 fc: #08a8a8d5", 165, 175, g, 0xd6d629);
	// // TestUtilities.check("MULTIPLY c: #d5d5a8a8 fc: #08a8a8d5", 145, 185, g, 0xd6d6d6);
	// // drawTransformedImage(0x08a8d508, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #a8d5a808 fc: #08a8d508", 135, 155, g, 0xaaaa06);
	// // TestUtilities.check("MULTIPLY c: #d5a8d5a8 fc: #08a8d508", 175, 175, g, 0xd6d68d);
	// // TestUtilities.check("MULTIPLY c: #a808d508 fc: #08a8d508", 165, 135, g, 0x2eaa06);
	// // TestUtilities.check("MULTIPLY c: #d508d5a8 fc: #08a8d508", 175, 165, g, 0x21d68d);
	// // TestUtilities.check("MULTIPLY c: #08d508a8 fc: #08a8d508", 115, 125, g, 0x0f0c0a);
	// // TestUtilities.check("MULTIPLY c: #d5080808 fc: #08a8d508", 105, 165, g, 0x212907);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #08a8d508", 165, 125, g, 0x0f0f00);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #08a8d508", 155, 105, g, 0x0a0f0c);
	// // TestUtilities.check("MULTIPLY c: #d50808a8 fc: #08a8d508", 115, 165, g, 0x21298d);
	// // TestUtilities.check("MULTIPLY c: #08a8d5a8 fc: #08a8d508", 175, 115, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #08a8a8a8 fc: #08a8d508", 145, 115, g, 0x0f0f0a);
	// // TestUtilities.check("MULTIPLY c: #0808d5d5 fc: #08a8d508", 185, 105, g, 0x0a0f0c);
	// // TestUtilities.check("MULTIPLY c: #d50808d5 fc: #08a8d508", 125, 165, g, 0x2129b3);
	// // TestUtilities.check("MULTIPLY c: #08d5a808 fc: #08a8d508", 135, 125, g, 0x0f0f00);
	// // TestUtilities.check("MULTIPLY c: #080808a8 fc: #08a8d508", 115, 105, g, 0x0a0c0a);
	// // TestUtilities.check("MULTIPLY c: #a8a8a808 fc: #08a8d508", 135, 145, g, 0xaaaa06);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8d5 fc: #08a8d508", 155, 155, g, 0xaaaa8f);
	// // TestUtilities.check("MULTIPLY c: #0808d508 fc: #08a8d508", 165, 105, g, 0x0a0f00);
	// // TestUtilities.check("MULTIPLY c: #08d5a8d5 fc: #08a8d508", 155, 125, g, 0x0f0f0c);
	// // TestUtilities.check("MULTIPLY c: #a8a808a8 fc: #08a8d508", 115, 145, g, 0xaa3a71);
	// // drawTransformedImage(0xa8a80808, BlendMode.MULTIPLY);
	// // TestUtilities.check("MULTIPLY c: #d50808a8 fc: #a8a80808", 115, 165, g, 0x20033b);
	// // TestUtilities.check("MULTIPLY c: #a8a8d508 fc: #a8a80808", 165, 145, g, 0xc64804);
	// // TestUtilities.check("MULTIPLY c: #08080808 fc: #a8a80808", 105, 105, g, 0x710606);
	// // TestUtilities.check("MULTIPLY c: #08d5d5a8 fc: #a8a80808", 175, 125, g, 0xaa3a2e);
	// // TestUtilities.check("MULTIPLY c: #d5a8a8a8 fc: #a8a80808", 145, 175, g, 0xb73b3b);
	// // TestUtilities.check("MULTIPLY c: #d508a808 fc: #a8a80808", 135, 165, g, 0x203b03);
	// // TestUtilities.check("MULTIPLY c: #a808d5a8 fc: #a8a80808", 175, 135, g, 0x394839);
	// // TestUtilities.check("MULTIPLY c: #08d5a8a8 fc: #a8a80808", 145, 125, g, 0xaa2e2e);
	// // TestUtilities.check("MULTIPLY c: #08d5d508 fc: #a8a80808", 165, 125, g, 0xaa3a06);
	// // TestUtilities.check("MULTIPLY c: #d508d5d5 fc: #a8a80808", 185, 165, g, 0x204b4b);
	// // TestUtilities.check("MULTIPLY c: #a8d5d508 fc: #a8a80808", 165, 155, g, 0xe14804);
	// // TestUtilities.check("MULTIPLY c: #d508d508 fc: #a8a80808", 165, 165, g, 0x204b03);
	// // TestUtilities.check("MULTIPLY c: #08d508a8 fc: #a8a80808", 115, 125, g, 0xaa062e);
	// // TestUtilities.check("MULTIPLY c: #08a808d5 fc: #a8a80808", 125, 115, g, 0xaa063a);
	// // TestUtilities.check("MULTIPLY c: #0808a8d5 fc: #a8a80808", 155, 105, g, 0x712e3a);
	// // TestUtilities.check("MULTIPLY c: #d5a80808 fc: #a8a80808", 105, 175, g, 0xb70303);
	// // TestUtilities.check("MULTIPLY c: #08a8d5d5 fc: #a8a80808", 185, 115, g, 0xaa3a3a);
	// // TestUtilities.check("MULTIPLY c: #080808d5 fc: #a8a80808", 125, 105, g, 0x71063a);
	// // TestUtilities.check("MULTIPLY c: #a8080808 fc: #a8a80808", 105, 135, g, 0x390404);
	// // TestUtilities.check("MULTIPLY c: #a8d5a8a8 fc: #a8a80808", 145, 155, g, 0xe13939);
	// // drawTransformedImage(0xd508a808, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #d508a808", 125, 145, g, 0xa0a0c9);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #d508a808", 125, 185, g, 0xd0a5d0);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #d508a808", 135, 185, g, 0xd0da0e);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #d508a808", 135, 105, g, 0x0cbc0c);
	// // TestUtilities.check("SCREEN c: #a8d5a8a8 fc: #d508a808", 145, 155, g, 0xc9d3a0);
	// // TestUtilities.check("SCREEN c: #a808a808 fc: #d508a808", 135, 135, g, 0x0ed30e);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #d508a808", 125, 125, g, 0xb38eb3);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #d508a808", 165, 155, g, 0xc9e10e);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #d508a808", 185, 185, g, 0xd0e9d0);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #d508a808", 185, 145, g, 0xa0e1c9);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #d508a808", 135, 165, g, 0x0eda0e);
	// // TestUtilities.check("SCREEN c: #d5a8d5d5 fc: #d508a808", 185, 175, g, 0xa5e9d0);
	// // TestUtilities.check("SCREEN c: #d508d508 fc: #d508a808", 165, 165, g, 0x0ee90e);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #d508a808", 115, 115, g, 0x8e8e8e);
	// // TestUtilities.check("SCREEN c: #a8a8a8a8 fc: #d508a808", 145, 145, g, 0xa0d3a0);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #d508a808", 105, 185, g, 0xd0a50e);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #d508a808", 185, 155, g, 0xc9e1c9);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #d508a808", 125, 135, g, 0x0ea0c9);
	// // TestUtilities.check("SCREEN c: #a8d5d5a8 fc: #d508a808", 175, 155, g, 0xc9e1a0);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #d508a808", 175, 175, g, 0xa5e9a5);
	// // drawTransformedImage(0xa808d5a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8d508a8 fc: #a808d5a8", 115, 155, g, 0xbcbcc6);
	// // TestUtilities.check("SCREEN c: #d5a808d5 fc: #a808d5a8", 125, 175, g, 0xa0c9e1);
	// // TestUtilities.check("SCREEN c: #a8a808a8 fc: #a808d5a8", 115, 145, g, 0x96bcc6);
	// // TestUtilities.check("SCREEN c: #08a80808 fc: #a808d5a8", 105, 115, g, 0x718e71);
	// // TestUtilities.check("SCREEN c: #08a808d5 fc: #a808d5a8", 125, 115, g, 0x718ea0);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #a808d5a8", 175, 135, g, 0x0ddac6);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #a808d5a8", 125, 125, g, 0x8e8ea0);
	// // TestUtilities.check("SCREEN c: #d5a808a8 fc: #a808d5a8", 115, 175, g, 0xa0c9d3);
	// // TestUtilities.check("SCREEN c: #d5a8d5d5 fc: #a808d5a8", 185, 175, g, 0xa0e9e1);
	// // TestUtilities.check("SCREEN c: #d5a80808 fc: #a808d5a8", 105, 175, g, 0xa0c9a0);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #a808d5a8", 135, 125, g, 0x8ea071);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #a808d5a8", 135, 105, g, 0x0aa071);
	// // TestUtilities.check("SCREEN c: #d508a8d5 fc: #a808d5a8", 155, 165, g, 0x0ee1e1);
	// // TestUtilities.check("SCREEN c: #0808d5a8 fc: #a808d5a8", 175, 105, g, 0x0aa596);
	// // TestUtilities.check("SCREEN c: #08a8d5a8 fc: #a808d5a8", 175, 115, g, 0x71a596);
	// // TestUtilities.check("SCREEN c: #d5a8d508 fc: #a808d5a8", 165, 175, g, 0xa0e9a0);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #a808d5a8", 125, 185, g, 0xc9c9e1);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #a808d5a8", 165, 155, g, 0xbcda96);
	// // TestUtilities.check("SCREEN c: #0808d5d5 fc: #a808d5a8", 185, 105, g, 0x0aa5a0);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #a808d5a8", 185, 185, g, 0xc9e9e1);
	// // drawTransformedImage(0x0808a8d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #0808a8d5", 125, 135, g, 0x0a71a5);
	// // TestUtilities.check("SCREEN c: #08d5d5d5 fc: #0808a8d5", 185, 125, g, 0x0c0e0e);
	// // TestUtilities.check("SCREEN c: #08a8d508 fc: #0808a8d5", 165, 115, g, 0x0a0e0c);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #0808a8d5", 105, 155, g, 0x8e718e);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #0808a8d5", 135, 185, g, 0xb3bcb3);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #0808a8d5", 115, 115, g, 0x0a0a0e);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #0808a8d5", 105, 135, g, 0x0a718e);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #0808a8d5", 135, 125, g, 0x0c0d0c);
	// // TestUtilities.check("SCREEN c: #a808a8d5 fc: #0808a8d5", 155, 135, g, 0x0a96a5);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #0808a8d5", 175, 135, g, 0x0aa0a0);
	// // TestUtilities.check("SCREEN c: #a8d508d5 fc: #0808a8d5", 125, 155, g, 0x8e71a5);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #0808a8d5", 165, 125, g, 0x0c0e0c);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #0808a8d5", 165, 135, g, 0x0aa08e);
	// // TestUtilities.check("SCREEN c: #d5d508a8 fc: #0808a8d5", 115, 185, g, 0xb38ec9);
	// // TestUtilities.check("SCREEN c: #d5a8a8a8 fc: #0808a8d5", 145, 175, g, 0x8ebcc9);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #0808a8d5", 115, 165, g, 0x0c8ec9);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #0808a8d5", 135, 165, g, 0x0cbcb3);
	// // TestUtilities.check("SCREEN c: #d5d5d5a8 fc: #0808a8d5", 175, 185, g, 0xb3c9c9);
	// // TestUtilities.check("SCREEN c: #d508a8a8 fc: #0808a8d5", 145, 165, g, 0x0cbcc9);
	// // TestUtilities.check("SCREEN c: #d508a8d5 fc: #0808a8d5", 155, 165, g, 0x0cbcd0);
	// // drawTransformedImage(0xa8d5d5d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #a8d5d5d5", 115, 115, g, 0xa08ea0);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #a8d5d5d5", 175, 145, g, 0xd3dad3);
	// // TestUtilities.check("SCREEN c: #d5a808d5 fc: #a8d5d5d5", 125, 175, g, 0xe1c9e9);
	// // TestUtilities.check("SCREEN c: #a8a8a8d5 fc: #a8d5d5d5", 155, 145, g, 0xd3d3da);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #a8d5d5d5", 185, 115, g, 0xa0a5a5);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #a8d5d5d5", 145, 135, g, 0xbcd3d3);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #a8d5d5d5", 135, 185, g, 0xe9e1c9);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #a8d5d5d5", 165, 135, g, 0xbcdabc);
	// // TestUtilities.check("SCREEN c: #d508a8a8 fc: #a8d5d5d5", 145, 165, g, 0xc9e1e1);
	// // TestUtilities.check("SCREEN c: #080808a8 fc: #a8d5d5d5", 115, 105, g, 0x8e8ea0);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8d5d5d5", 135, 115, g, 0xa0a08e);
	// // TestUtilities.check("SCREEN c: #0808a8a8 fc: #a8d5d5d5", 145, 105, g, 0x8ea0a0);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #a8d5d5d5", 125, 185, g, 0xe9c9e9);
	// // TestUtilities.check("SCREEN c: #a8a8d508 fc: #a8d5d5d5", 165, 145, g, 0xd3dabc);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #a8d5d5d5", 185, 155, g, 0xdadada);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #a8d5d5d5", 105, 105, g, 0x8e8e8e);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #a8d5d5d5", 135, 105, g, 0x8ea08e);
	// // TestUtilities.check("SCREEN c: #a8d508d5 fc: #a8d5d5d5", 125, 155, g, 0xdabcda);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #a8d5d5d5", 145, 115, g, 0xa0a0a0);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #a8d5d5d5", 155, 125, g, 0xa5a0a5);
	// // drawTransformedImage(0x0808d5d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #08a80808 fc: #0808d5d5", 105, 115, g, 0x0a0c0c);
	// // TestUtilities.check("SCREEN c: #d508d5d5 fc: #0808d5d5", 185, 165, g, 0x0cd0d0);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #0808d5d5", 185, 155, g, 0x8ea5a5);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #0808d5d5", 115, 115, g, 0x0a0c0e);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #0808d5d5", 125, 135, g, 0x0a8ea5);
	// // TestUtilities.check("SCREEN c: #d5a8d5d5 fc: #0808d5d5", 185, 175, g, 0x8ed0d0);
	// // TestUtilities.check("SCREEN c: #a808d5d5 fc: #0808d5d5", 185, 135, g, 0x0aa5a5);
	// // TestUtilities.check("SCREEN c: #a8d5d5a8 fc: #0808d5d5", 175, 155, g, 0x8ea5a0);
	// // TestUtilities.check("SCREEN c: #a8a8a8d5 fc: #0808d5d5", 155, 145, g, 0x71a0a5);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #0808d5d5", 165, 155, g, 0x8ea58e);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #0808d5d5", 165, 125, g, 0x0c0e0c);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #0808d5d5", 185, 185, g, 0xb3d0d0);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #0808d5d5", 175, 145, g, 0x71a5a0);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #0808d5d5", 185, 145, g, 0x71a5a5);
	// // TestUtilities.check("SCREEN c: #a8d5a808 fc: #0808d5d5", 135, 155, g, 0x8ea08e);
	// // TestUtilities.check("SCREEN c: #d5a808d5 fc: #0808d5d5", 125, 175, g, 0x8eb3d0);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #0808d5d5", 115, 165, g, 0x0cb3c9);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #0808d5d5", 105, 135, g, 0x0a8e8e);
	// // TestUtilities.check("SCREEN c: #08d5d5a8 fc: #0808d5d5", 175, 125, g, 0x0c0e0e);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #0808d5d5", 135, 165, g, 0x0cc9b3);
	// // drawTransformedImage(0xa8d5a808, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #a8d5a808", 125, 185, g, 0xe9a0c9);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #a8d5a808", 165, 125, g, 0xa5a00a);
	// // TestUtilities.check("SCREEN c: #d5d5a8a8 fc: #a8d5a808", 145, 185, g, 0xe9d3a0);
	// // TestUtilities.check("SCREEN c: #d5a8a808 fc: #a8d5a808", 135, 175, g, 0xe1d30e);
	// // TestUtilities.check("SCREEN c: #08a80808 fc: #a8d5a808", 105, 115, g, 0xa0710a);
	// // TestUtilities.check("SCREEN c: #080808a8 fc: #a8d5a808", 115, 105, g, 0x8e7171);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #a8d5a808", 115, 115, g, 0xa07171);
	// // TestUtilities.check("SCREEN c: #08d50808 fc: #a8d5a808", 105, 125, g, 0xa5710a);
	// // TestUtilities.check("SCREEN c: #d5080808 fc: #a8d5a808", 105, 165, g, 0xc9a00e);
	// // TestUtilities.check("SCREEN c: #a808a8d5 fc: #a8d5a808", 155, 135, g, 0xbcc6bc);
	// // TestUtilities.check("SCREEN c: #a808d5d5 fc: #a8d5a808", 185, 135, g, 0xbcd3bc);
	// // TestUtilities.check("SCREEN c: #a8d508d5 fc: #a8d5a808", 125, 155, g, 0xda96bc);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #a8d5a808", 185, 145, g, 0xd3d3bc);
	// // TestUtilities.check("SCREEN c: #d5d5a8d5 fc: #a8d5a808", 155, 185, g, 0xe9d3c9);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8d5a808", 135, 115, g, 0xa0960a);
	// // TestUtilities.check("SCREEN c: #0808d508 fc: #a8d5a808", 165, 105, g, 0x8ea00a);
	// // TestUtilities.check("SCREEN c: #0808d5d5 fc: #a8d5a808", 185, 105, g, 0x8ea08e);
	// // TestUtilities.check("SCREEN c: #a80808a8 fc: #a8d5a808", 115, 135, g, 0xbc9696);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #a8d5a808", 175, 175, g, 0xe1e1a0);
	// // TestUtilities.check("SCREEN c: #a8d5d5a8 fc: #a8d5a808", 175, 155, g, 0xdad396);
	// // drawTransformedImage(0x08a8d5a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d508d508 fc: #08a8d5a8", 165, 165, g, 0x8ed08e);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #08a8d5a8", 175, 175, g, 0xbcd0bc);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #08a8d5a8", 145, 135, g, 0x71a096);
	// // TestUtilities.check("SCREEN c: #d5d5d5a8 fc: #08a8d5a8", 175, 185, g, 0xc9d0bc);
	// // TestUtilities.check("SCREEN c: #a8d508d5 fc: #08a8d5a8", 125, 155, g, 0xa08ea0);
	// // TestUtilities.check("SCREEN c: #d508a8d5 fc: #08a8d5a8", 155, 165, g, 0x8ec9c9);
	// // TestUtilities.check("SCREEN c: #a808a808 fc: #08a8d5a8", 135, 135, g, 0x71a071);
	// // TestUtilities.check("SCREEN c: #a80808a8 fc: #08a8d5a8", 115, 135, g, 0x718e96);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #08a8d5a8", 115, 125, g, 0x0e0c0d);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #08a8d5a8", 135, 125, g, 0x0e0e0a);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #08a8d5a8", 115, 165, g, 0x8eb3bc);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #08a8d5a8", 185, 145, g, 0x96a5a0);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #08a8d5a8", 105, 105, g, 0x0a0c0a);
	// // TestUtilities.check("SCREEN c: #08d50808 fc: #08a8d5a8", 105, 125, g, 0x0e0c0a);
	// // TestUtilities.check("SCREEN c: #080808a8 fc: #08a8d5a8", 115, 105, g, 0x0a0c0d);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #08a8d5a8", 155, 125, g, 0x0e0e0e);
	// // TestUtilities.check("SCREEN c: #d50808d5 fc: #08a8d5a8", 125, 165, g, 0x8eb3c9);
	// // TestUtilities.check("SCREEN c: #d5d508a8 fc: #08a8d5a8", 115, 185, g, 0xc9b3bc);
	// // TestUtilities.check("SCREEN c: #a808d5d5 fc: #08a8d5a8", 185, 135, g, 0x71a5a0);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #08a8d5a8", 175, 145, g, 0x96a596);
	// // drawTransformedImage(0xa8d5a8a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #a8d5a8a8", 135, 145, g, 0xd3c696);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #a8d5a8a8", 175, 175, g, 0xe1e1d3);
	// // TestUtilities.check("SCREEN c: #d508d508 fc: #a8d5a8a8", 165, 165, g, 0xc9e1a0);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #a8d5a8a8", 145, 115, g, 0xa09696);
	// // TestUtilities.check("SCREEN c: #08a8d508 fc: #a8d5a8a8", 165, 115, g, 0xa0a071);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #a8d5a8a8", 145, 135, g, 0xbcc6c6);
	// // TestUtilities.check("SCREEN c: #08a808d5 fc: #a8d5a8a8", 125, 115, g, 0xa071a0);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #a8d5a8a8", 135, 165, g, 0xc9d3a0);
	// // TestUtilities.check("SCREEN c: #d50808d5 fc: #a8d5a8a8", 125, 165, g, 0xc9a0e1);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #a8d5a8a8", 185, 155, g, 0xdad3d3);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #a8d5a8a8", 105, 105, g, 0x8e7171);
	// // TestUtilities.check("SCREEN c: #d508d5d5 fc: #a8d5a8a8", 185, 165, g, 0xc9e1e1);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #a8d5a8a8", 115, 115, g, 0xa07196);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8d5a8a8", 135, 115, g, 0xa09671);
	// // TestUtilities.check("SCREEN c: #a808a8d5 fc: #a8d5a8a8", 155, 135, g, 0xbcc6d3);
	// // TestUtilities.check("SCREEN c: #08d5a8a8 fc: #a8d5a8a8", 145, 125, g, 0xa59696);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #a8d5a8a8", 175, 165, g, 0xc9e1d3);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #a8d5a8a8", 165, 155, g, 0xdad396);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #a8d5a8a8", 125, 145, g, 0xd396d3);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #a8d5a8a8", 115, 125, g, 0xa57196);
	// // drawTransformedImage(0xa8d5d5a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #a8d5d5a8", 145, 135, g, 0xbcd3c6);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #a8d5d5a8", 185, 185, g, 0xe9e9e1);
	// // TestUtilities.check("SCREEN c: #a8d5a8d5 fc: #a8d5d5a8", 155, 155, g, 0xdad3d3);
	// // TestUtilities.check("SCREEN c: #d5d508a8 fc: #a8d5d5a8", 115, 185, g, 0xe9c9d3);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #a8d5d5a8", 185, 145, g, 0xd3dad3);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #a8d5d5a8", 175, 145, g, 0xd3dac6);
	// // TestUtilities.check("SCREEN c: #d5a8a8a8 fc: #a8d5d5a8", 145, 175, g, 0xe1e1d3);
	// // TestUtilities.check("SCREEN c: #a808a808 fc: #a8d5d5a8", 135, 135, g, 0xbcd396);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8d5d5a8", 135, 115, g, 0xa0a071);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #a8d5d5a8", 105, 185, g, 0xe9c9a0);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #a8d5d5a8", 135, 105, g, 0x8ea071);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #a8d5d5a8", 115, 125, g, 0xa58e96);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #a8d5d5a8", 105, 135, g, 0xbcbc96);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #a8d5d5a8", 115, 115, g, 0xa08e96);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #a8d5d5a8", 125, 125, g, 0xa58ea0);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #a8d5d5a8", 175, 135, g, 0xbcdac6);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #a8d5d5a8", 125, 185, g, 0xe9c9e1);
	// // TestUtilities.check("SCREEN c: #08a8d5a8 fc: #a8d5d5a8", 175, 115, g, 0xa0a596);
	// // TestUtilities.check("SCREEN c: #080808d5 fc: #a8d5d5a8", 125, 105, g, 0x8e8ea0);
	// // TestUtilities.check("SCREEN c: #08d5d5d5 fc: #a8d5d5a8", 185, 125, g, 0xa5a5a0);
	// // drawTransformedImage(0xa8d50808, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8a80808 fc: #a8d50808", 105, 145, g, 0xd30d0d);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #a8d50808", 135, 105, g, 0x8e710a);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #a8d50808", 105, 185, g, 0xe90e0e);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #a8d50808", 175, 175, g, 0xe1c9a0);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #a8d50808", 125, 185, g, 0xe90ec9);
	// // TestUtilities.check("SCREEN c: #d5d5a8d5 fc: #a8d50808", 155, 185, g, 0xe9a0c9);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #a8d50808", 135, 185, g, 0xe9a00e);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #a8d50808", 155, 125, g, 0xa5718e);
	// // TestUtilities.check("SCREEN c: #a8d5a8a8 fc: #a8d50808", 145, 155, g, 0xda9696);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #a8d50808", 105, 155, g, 0xda0d0d);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #a8d50808", 185, 115, g, 0xa08e8e);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8d50808", 135, 115, g, 0xa0710a);
	// // TestUtilities.check("SCREEN c: #d5a808a8 fc: #a8d50808", 115, 175, g, 0xe10ea0);
	// // TestUtilities.check("SCREEN c: #d5d508a8 fc: #a8d50808", 115, 185, g, 0xe90ea0);
	// // TestUtilities.check("SCREEN c: #a8a8a8d5 fc: #a8d50808", 155, 145, g, 0xd396bc);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #a8d50808", 185, 145, g, 0xd3bcbc);
	// // TestUtilities.check("SCREEN c: #a8d5d5a8 fc: #a8d50808", 175, 155, g, 0xdabc96);
	// // TestUtilities.check("SCREEN c: #a8a808a8 fc: #a8d50808", 115, 145, g, 0xd30d96);
	// // TestUtilities.check("SCREEN c: #08d5d5d5 fc: #a8d50808", 185, 125, g, 0xa58e8e);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #a8d50808", 135, 125, g, 0xa5710a);
	// // drawTransformedImage(0x08d5d5a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #08d5d5a8", 155, 125, g, 0x0e0e0e);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #08d5d5a8", 135, 165, g, 0xb3c98e);
	// // TestUtilities.check("SCREEN c: #08d5a8a8 fc: #08d5d5a8", 145, 125, g, 0x0e0e0d);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #08d5d5a8", 105, 155, g, 0xa58e71);
	// // TestUtilities.check("SCREEN c: #0808d508 fc: #08d5d5a8", 165, 105, g, 0x0c0e0a);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #08d5d5a8", 145, 135, g, 0x8ea096);
	// // TestUtilities.check("SCREEN c: #08a8a8d5 fc: #08d5d5a8", 155, 115, g, 0x0e0e0e);
	// // TestUtilities.check("SCREEN c: #a8d5a8d5 fc: #08d5d5a8", 155, 155, g, 0xa5a0a0);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #08d5d5a8", 175, 145, g, 0xa0a596);
	// // TestUtilities.check("SCREEN c: #0808a8a8 fc: #08d5d5a8", 145, 105, g, 0x0c0e0d);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #08d5d5a8", 145, 115, g, 0x0e0e0d);
	// // TestUtilities.check("SCREEN c: #d50808d5 fc: #08d5d5a8", 125, 165, g, 0xb3b3c9);
	// // TestUtilities.check("SCREEN c: #d5d508a8 fc: #08d5d5a8", 115, 185, g, 0xd0b3bc);
	// // TestUtilities.check("SCREEN c: #08a8d5a8 fc: #08d5d5a8", 175, 115, g, 0x0e0e0d);
	// // TestUtilities.check("SCREEN c: #d508a8a8 fc: #08d5d5a8", 145, 165, g, 0xb3c9bc);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #08d5d5a8", 165, 135, g, 0x8ea571);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #08d5d5a8", 135, 145, g, 0xa0a071);
	// // TestUtilities.check("SCREEN c: #d508a8d5 fc: #08d5d5a8", 155, 165, g, 0xb3c9c9);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #08d5d5a8", 135, 105, g, 0x0c0e0a);
	// // TestUtilities.check("SCREEN c: #a8a8d508 fc: #08d5d5a8", 165, 145, g, 0xa0a571);
	// // drawTransformedImage(0xa8a808a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #a8a808a8", 125, 145, g, 0xc60dd3);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #a8a808a8", 175, 145, g, 0xc6bcc6);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #a8a808a8", 115, 115, g, 0x960a96);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #a8a808a8", 125, 135, g, 0x960dd3);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #a8a808a8", 185, 145, g, 0xc6bcd3);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #a8a808a8", 155, 125, g, 0xa071a0);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #a8a808a8", 185, 155, g, 0xd3bcd3);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #a8a808a8", 165, 135, g, 0x96bc96);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #a8a808a8", 175, 165, g, 0xa0c9d3);
	// // TestUtilities.check("SCREEN c: #d5a80808 fc: #a8a808a8", 105, 175, g, 0xd30ea0);
	// // TestUtilities.check("SCREEN c: #0808d5d5 fc: #a8a808a8", 185, 105, g, 0x718ea0);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #a8a808a8", 185, 115, g, 0x968ea0);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #a8a808a8", 175, 175, g, 0xd3c9d3);
	// // TestUtilities.check("SCREEN c: #d5a808d5 fc: #a8a808a8", 125, 175, g, 0xd30ee1);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #a8a808a8", 175, 135, g, 0x96bcc6);
	// // TestUtilities.check("SCREEN c: #d5a8d5d5 fc: #a8a808a8", 185, 175, g, 0xd3c9e1);
	// // TestUtilities.check("SCREEN c: #0808a8d5 fc: #a8a808a8", 155, 105, g, 0x7171a0);
	// // TestUtilities.check("SCREEN c: #a8a808a8 fc: #a8a808a8", 115, 145, g, 0xc60dc6);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #a8a808a8", 135, 185, g, 0xe1a0a0);
	// // TestUtilities.check("SCREEN c: #080808a8 fc: #a8a808a8", 115, 105, g, 0x710a96);
	// // drawTransformedImage(0xd5d5d508, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #d5d5d508", 125, 145, g, 0xe1c9c9);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #d5d5d508", 115, 115, g, 0xc9b38e);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #d5d5d508", 145, 135, g, 0xc9e1a0);
	// // TestUtilities.check("SCREEN c: #d508d5d5 fc: #d5d5d508", 185, 165, g, 0xd0f1d0);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #d5d5d508", 105, 105, g, 0xb3b30c);
	// // TestUtilities.check("SCREEN c: #a808a808 fc: #d5d5d508", 135, 135, g, 0xc9e10e);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #d5d5d508", 105, 135, g, 0xc9c90e);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #d5d5d508", 155, 125, g, 0xd0c9b3);
	// // TestUtilities.check("SCREEN c: #d508a8a8 fc: #d5d5d508", 145, 165, g, 0xd0e9a5);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #d5d5d508", 135, 145, g, 0xe1e10e);
	// // TestUtilities.check("SCREEN c: #a8a8a8a8 fc: #d5d5d508", 145, 145, g, 0xe1e1a0);
	// // TestUtilities.check("SCREEN c: #d5d5d508 fc: #d5d5d508", 165, 185, g, 0xf1f10e);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #d5d5d508", 135, 165, g, 0xd0e90e);
	// // TestUtilities.check("SCREEN c: #0808a808 fc: #d5d5d508", 135, 105, g, 0xb3c90c);
	// // TestUtilities.check("SCREEN c: #d5d5d5a8 fc: #d5d5d508", 175, 185, g, 0xf1f1a5);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #d5d5d508", 125, 125, g, 0xd0b3b3);
	// // TestUtilities.check("SCREEN c: #08d5d5d5 fc: #d5d5d508", 185, 125, g, 0xd0d0b3);
	// // TestUtilities.check("SCREEN c: #d5d5a8d5 fc: #d5d5d508", 155, 185, g, 0xf1e9d0);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #d5d5d508", 105, 155, g, 0xe9c90e);
	// // TestUtilities.check("SCREEN c: #080808d5 fc: #d5d5d508", 125, 105, g, 0xb3b3b3);
	// // drawTransformedImage(0xa8a8d508, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #a8a8d508", 105, 185, g, 0xe1c90e);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #a8a8d508", 165, 125, g, 0xa0a50a);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #a8a8d508", 155, 125, g, 0xa0a08e);
	// // TestUtilities.check("SCREEN c: #a8d508a8 fc: #a8a8d508", 115, 155, g, 0xd3bc96);
	// // TestUtilities.check("SCREEN c: #a8a8a8d5 fc: #a8a8d508", 155, 145, g, 0xc6d3bc);
	// // TestUtilities.check("SCREEN c: #08d5a8a8 fc: #a8a8d508", 145, 125, g, 0xa0a071);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #a8a8d508", 105, 135, g, 0x96bc0d);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #a8a8d508", 185, 155, g, 0xd3dabc);
	// // TestUtilities.check("SCREEN c: #d508d5d5 fc: #a8a8d508", 185, 165, g, 0xa0e9c9);
	// // TestUtilities.check("SCREEN c: #d5a8d508 fc: #a8a8d508", 165, 175, g, 0xd3e90e);
	// // TestUtilities.check("SCREEN c: #d5a8a808 fc: #a8a8d508", 135, 175, g, 0xd3e10e);
	// // TestUtilities.check("SCREEN c: #d5080808 fc: #a8a8d508", 105, 165, g, 0xa0c90e);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #a8a8d508", 165, 155, g, 0xd3da0d);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #a8a8d508", 135, 115, g, 0x96a00a);
	// // TestUtilities.check("SCREEN c: #0808d5a8 fc: #a8a8d508", 175, 105, g, 0x71a571);
	// // TestUtilities.check("SCREEN c: #d5d5d5a8 fc: #a8a8d508", 175, 185, g, 0xe1e9a0);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #a8a8d508", 135, 145, g, 0xc6d30d);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #a8a8d508", 105, 155, g, 0xd3bc0d);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #a8a8d508", 165, 135, g, 0x96da0d);
	// // TestUtilities.check("SCREEN c: #a808d5d5 fc: #a8a8d508", 185, 135, g, 0x96dabc);
	// // drawTransformedImage(0x08d508d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #08d508d5", 145, 115, g, 0x0e0a0e);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #08d508d5", 175, 145, g, 0xa08ea0);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #08d508d5", 165, 125, g, 0x0e0c0c);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #08d508d5", 185, 185, g, 0xd0b3d0);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #08d508d5", 185, 145, g, 0xa08ea5);
	// // TestUtilities.check("SCREEN c: #0808d5a8 fc: #08d508d5", 175, 105, g, 0x0c0c0e);
	// // TestUtilities.check("SCREEN c: #d508d5d5 fc: #08d508d5", 185, 165, g, 0xb3b3d0);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #08d508d5", 175, 175, g, 0xc9b3c9);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #08d508d5", 175, 165, g, 0xb3b3c9);
	// // TestUtilities.check("SCREEN c: #08d5d5d5 fc: #08d508d5", 185, 125, g, 0x0e0c0e);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #08d508d5", 175, 135, g, 0x8e8ea0);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #08d508d5", 125, 125, g, 0x0e000e);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #08d508d5", 105, 105, g, 0x0c000c);
	// // TestUtilities.check("SCREEN c: #a8d5a808 fc: #08d508d5", 135, 155, g, 0xa5718e);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #08d508d5", 135, 145, g, 0xa0718e);
	// // TestUtilities.check("SCREEN c: #d5a808d5 fc: #08d508d5", 125, 175, g, 0xc90cd0);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #08d508d5", 155, 125, g, 0x0e0a0e);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #08d508d5", 185, 115, g, 0x0e0c0e);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #08d508d5", 115, 115, g, 0x0e000e);
	// // TestUtilities.check("SCREEN c: #08d5d5a8 fc: #08d508d5", 175, 125, g, 0x0e0c0e);
	// // drawTransformedImage(0x08a8a808, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #a8d508a8 fc: #08a8a808", 115, 155, g, 0xa07171);
	// // TestUtilities.check("SCREEN c: #08a8d508 fc: #08a8a808", 165, 115, g, 0x0d0e00);
	// // TestUtilities.check("SCREEN c: #08a8a8d5 fc: #08a8a808", 155, 115, g, 0x0d0d0c);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #08a8a808", 175, 165, g, 0x8ec98e);
	// // TestUtilities.check("SCREEN c: #a8d5a8a8 fc: #08a8a808", 145, 155, g, 0xa09671);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #08a8a808", 115, 165, g, 0x8e8e8e);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #08a8a808", 145, 135, g, 0x719671);
	// // TestUtilities.check("SCREEN c: #d5d5a8a8 fc: #08a8a808", 145, 185, g, 0xc9bc8e);
	// // TestUtilities.check("SCREEN c: #d5a8a808 fc: #08a8a808", 135, 175, g, 0xbcbc0c);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #08a8a808", 175, 135, g, 0x71a071);
	// // TestUtilities.check("SCREEN c: #a8d5a808 fc: #08a8a808", 135, 155, g, 0xa0960a);
	// // TestUtilities.check("SCREEN c: #08a80808 fc: #08a8a808", 105, 115, g, 0x0d0a00);
	// // TestUtilities.check("SCREEN c: #a8a8d5d5 fc: #08a8a808", 185, 145, g, 0x96a08e);
	// // TestUtilities.check("SCREEN c: #0808d5a8 fc: #08a8a808", 175, 105, g, 0x0a0e0a);
	// // TestUtilities.check("SCREEN c: #0808d508 fc: #08a8a808", 165, 105, g, 0x0a0e00);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #08a8a808", 135, 125, g, 0x0e0d00);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #08a8a808", 105, 105, g, 0x0a0a00);
	// // TestUtilities.check("SCREEN c: #a8a8a8a8 fc: #08a8a808", 145, 145, g, 0x969671);
	// // TestUtilities.check("SCREEN c: #a808d508 fc: #08a8a808", 165, 135, g, 0x71a00a);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #08a8a808", 125, 145, g, 0x96718e);
	// // drawTransformedImage(0x08a808d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d5a808a8 fc: #08a808d5", 115, 175, g, 0xbc0cc9);
	// // TestUtilities.check("SCREEN c: #d50808d5 fc: #08a808d5", 125, 165, g, 0x8e0cd0);
	// // TestUtilities.check("SCREEN c: #d508d508 fc: #08a808d5", 165, 165, g, 0x8eb3b3);
	// // TestUtilities.check("SCREEN c: #a808d5a8 fc: #08a808d5", 175, 135, g, 0x718ea0);
	// // TestUtilities.check("SCREEN c: #a8d5a8d5 fc: #08a808d5", 155, 155, g, 0xa071a5);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #08a808d5", 125, 135, g, 0x710aa5);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #08a808d5", 115, 165, g, 0x8e0cc9);
	// // TestUtilities.check("SCREEN c: #a8a8d5a8 fc: #08a808d5", 175, 145, g, 0x968ea0);
	// // TestUtilities.check("SCREEN c: #a808a808 fc: #08a808d5", 135, 135, g, 0x71718e);
	// // TestUtilities.check("SCREEN c: #d5d5d5d5 fc: #08a808d5", 185, 185, g, 0xc9b3d0);
	// // TestUtilities.check("SCREEN c: #d5d5a808 fc: #08a808d5", 135, 185, g, 0xc98eb3);
	// // TestUtilities.check("SCREEN c: #080808d5 fc: #08a808d5", 125, 105, g, 0x0a000e);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #08a808d5", 175, 165, g, 0x8eb3c9);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #08a808d5", 145, 115, g, 0x0d0a0e);
	// // TestUtilities.check("SCREEN c: #08a8a808 fc: #08a808d5", 135, 115, g, 0x0d0a0c);
	// // TestUtilities.check("SCREEN c: #a8a80808 fc: #08a808d5", 105, 145, g, 0x960a8e);
	// // TestUtilities.check("SCREEN c: #d5a8a8a8 fc: #08a808d5", 145, 175, g, 0xbc8ec9);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #08a808d5", 165, 125, g, 0x0e0c0c);
	// // TestUtilities.check("SCREEN c: #a8a808d5 fc: #08a808d5", 125, 145, g, 0x960aa5);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #08a808d5", 125, 125, g, 0x0e000e);
	// // drawTransformedImage(0xd5a8a808, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #08a8a8d5 fc: #d5a8a808", 155, 115, g, 0xbcbcb3);
	// // TestUtilities.check("SCREEN c: #d5a8a8a8 fc: #d5a8a808", 145, 175, g, 0xdadaa5);
	// // TestUtilities.check("SCREEN c: #d5d5d508 fc: #d5a8a808", 165, 185, g, 0xe9e90e);
	// // TestUtilities.check("SCREEN c: #a8d50808 fc: #d5a8a808", 105, 155, g, 0xe1a00e);
	// // TestUtilities.check("SCREEN c: #08d5d5a8 fc: #d5a8a808", 175, 125, g, 0xc9c98e);
	// // TestUtilities.check("SCREEN c: #d5d5a8a8 fc: #d5a8a808", 145, 185, g, 0xe9daa5);
	// // TestUtilities.check("SCREEN c: #a8a80808 fc: #d5a8a808", 105, 145, g, 0xd3a00e);
	// // TestUtilities.check("SCREEN c: #08d5a8a8 fc: #d5a8a808", 145, 125, g, 0xc9bc8e);
	// // TestUtilities.check("SCREEN c: #d5a808a8 fc: #d5a8a808", 115, 175, g, 0xdaa5a5);
	// // TestUtilities.check("SCREEN c: #d5a80808 fc: #d5a8a808", 105, 175, g, 0xdaa50e);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #d5a8a808", 185, 115, g, 0xbcc9b3);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #d5a8a808", 115, 115, g, 0xbc8e8e);
	// // TestUtilities.check("SCREEN c: #d5a8d508 fc: #d5a8a808", 165, 175, g, 0xdae90e);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #d5a8a808", 145, 135, g, 0xa0d3a0);
	// // TestUtilities.check("SCREEN c: #a8a8a808 fc: #d5a8a808", 135, 145, g, 0xd3d30e);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #d5a8a808", 135, 165, g, 0xa5da0e);
	// // TestUtilities.check("SCREEN c: #08d5a8d5 fc: #d5a8a808", 155, 125, g, 0xc9bcb3);
	// // TestUtilities.check("SCREEN c: #08d5d508 fc: #d5a8a808", 165, 125, g, 0xc9c90c);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #d5a8a808", 115, 125, g, 0xc98e8e);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #d5a8a808", 175, 165, g, 0xa5e9a5);
	// // drawTransformedImage(0x08d5d5d5, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d5d5a8a8 fc: #08d5d5d5", 145, 185, g, 0xd0c9c9);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #08d5d5d5", 105, 185, g, 0xd0b3b3);
	// // TestUtilities.check("SCREEN c: #a8a80808 fc: #08d5d5d5", 105, 145, g, 0xa08e8e);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #08d5d5d5", 125, 185, g, 0xd0b3d0);
	// // TestUtilities.check("SCREEN c: #a8d5a8a8 fc: #08d5d5d5", 145, 155, g, 0xa5a0a0);
	// // TestUtilities.check("SCREEN c: #0808d508 fc: #08d5d5d5", 165, 105, g, 0x0c0e0c);
	// // TestUtilities.check("SCREEN c: #08d508d5 fc: #08d5d5d5", 125, 125, g, 0x0e0c0e);
	// // TestUtilities.check("SCREEN c: #a8a808a8 fc: #08d5d5d5", 115, 145, g, 0xa08ea0);
	// // TestUtilities.check("SCREEN c: #a80808d5 fc: #08d5d5d5", 125, 135, g, 0x8e8ea5);
	// // TestUtilities.check("SCREEN c: #d5a8d508 fc: #08d5d5d5", 165, 175, g, 0xc9d0b3);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #08d5d5d5", 115, 125, g, 0x0e0c0e);
	// // TestUtilities.check("SCREEN c: #d50808d5 fc: #08d5d5d5", 125, 165, g, 0xb3b3d0);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #08d5d5d5", 165, 155, g, 0xa5a58e);
	// // TestUtilities.check("SCREEN c: #d508d5a8 fc: #08d5d5d5", 175, 165, g, 0xb3d0c9);
	// // TestUtilities.check("SCREEN c: #d50808a8 fc: #08d5d5d5", 115, 165, g, 0xb3b3c9);
	// // TestUtilities.check("SCREEN c: #d5d5d5a8 fc: #08d5d5d5", 175, 185, g, 0xd0d0c9);
	// // TestUtilities.check("SCREEN c: #08d5a808 fc: #08d5d5d5", 135, 125, g, 0x0e0e0c);
	// // TestUtilities.check("SCREEN c: #d508a808 fc: #08d5d5d5", 135, 165, g, 0xb3c9b3);
	// // TestUtilities.check("SCREEN c: #a808a8a8 fc: #08d5d5d5", 145, 135, g, 0x8ea0a0);
	// // TestUtilities.check("SCREEN c: #d5a8a8d5 fc: #08d5d5d5", 155, 175, g, 0xc9c9d0);
	// // drawTransformedImage(0xd5a8a8a8, BlendMode.SCREEN);
	// // TestUtilities.check("SCREEN c: #d5a808a8 fc: #d5a8a8a8", 115, 175, g, 0xdaa5da);
	// // TestUtilities.check("SCREEN c: #d5d50808 fc: #d5a8a8a8", 105, 185, g, 0xe9a5a5);
	// // TestUtilities.check("SCREEN c: #d5d508d5 fc: #d5a8a8a8", 125, 185, g, 0xe9a5e9);
	// // TestUtilities.check("SCREEN c: #08d5d5a8 fc: #d5a8a8a8", 175, 125, g, 0xc9c9bc);
	// // TestUtilities.check("SCREEN c: #a8080808 fc: #d5a8a8a8", 105, 135, g, 0xa0a0a0);
	// // TestUtilities.check("SCREEN c: #08a808a8 fc: #d5a8a8a8", 115, 115, g, 0xbc8ebc);
	// // TestUtilities.check("SCREEN c: #d5d5a8a8 fc: #d5a8a8a8", 145, 185, g, 0xe9dada);
	// // TestUtilities.check("SCREEN c: #a8d5d5d5 fc: #d5a8a8a8", 185, 155, g, 0xe1e1e1);
	// // TestUtilities.check("SCREEN c: #d5a8a808 fc: #d5a8a8a8", 135, 175, g, 0xdadaa5);
	// // TestUtilities.check("SCREEN c: #a8d5d508 fc: #d5a8a8a8", 165, 155, g, 0xe1e1a0);
	// // TestUtilities.check("SCREEN c: #08a8d5d5 fc: #d5a8a8a8", 185, 115, g, 0xbcc9c9);
	// // TestUtilities.check("SCREEN c: #08080808 fc: #d5a8a8a8", 105, 105, g, 0x8e8e8e);
	// // TestUtilities.check("SCREEN c: #d5d5a8d5 fc: #d5a8a8a8", 155, 185, g, 0xe9dae9);
	// // TestUtilities.check("SCREEN c: #08d508a8 fc: #d5a8a8a8", 115, 125, g, 0xc98ebc);
	// // TestUtilities.check("SCREEN c: #a8d5a808 fc: #d5a8a8a8", 135, 155, g, 0xe1d3a0);
	// // TestUtilities.check("SCREEN c: #08a8d508 fc: #d5a8a8a8", 165, 115, g, 0xbcc98e);
	// // TestUtilities.check("SCREEN c: #08a8a8a8 fc: #d5a8a8a8", 145, 115, g, 0xbcbcbc);
	// // TestUtilities.check("SCREEN c: #08a808d5 fc: #d5a8a8a8", 125, 115, g, 0xbc8ec9);
	// // TestUtilities.check("SCREEN c: #d5a8d5a8 fc: #d5a8a8a8", 175, 175, g, 0xdae9da);
	// // TestUtilities.check("SCREEN c: #080808a8 fc: #d5a8a8a8", 115, 105, g, 0x8e8ebc);
	// drawTransformedImage(0x08d508a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #08d508a8", 175, 155, g, 0x060005);
	// TestUtilities.check("SRC c: #08a808d5 fc: #08d508a8", 125, 115, g, 0x060005);
	// TestUtilities.check("SRC c: #d5a8a8d5 fc: #08d508a8", 155, 175, g, 0x060005);
	// TestUtilities.check("SRC c: #a80808d5 fc: #08d508a8", 125, 135, g, 0x060005);
	// TestUtilities.check("SRC c: #0808d508 fc: #08d508a8", 165, 105, g, 0x060005);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #08d508a8", 165, 155, g, 0x060005);
	// TestUtilities.check("SRC c: #080808d5 fc: #08d508a8", 125, 105, g, 0x060005);
	// TestUtilities.check("SRC c: #08a8a8a8 fc: #08d508a8", 145, 115, g, 0x060005);
	// TestUtilities.check("SRC c: #0808d5a8 fc: #08d508a8", 175, 105, g, 0x060005);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #08d508a8", 185, 125, g, 0x060005);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #08d508a8", 115, 155, g, 0x060005);
	// TestUtilities.check("SRC c: #d508a8d5 fc: #08d508a8", 155, 165, g, 0x060005);
	// TestUtilities.check("SRC c: #d5d5d5a8 fc: #08d508a8", 175, 185, g, 0x060005);
	// TestUtilities.check("SRC c: #a8d508d5 fc: #08d508a8", 125, 155, g, 0x060005);
	// TestUtilities.check("SRC c: #d5080808 fc: #08d508a8", 105, 165, g, 0x060005);
	// TestUtilities.check("SRC c: #d50808d5 fc: #08d508a8", 125, 165, g, 0x060005);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #08d508a8", 155, 125, g, 0x060005);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #08d508a8", 145, 135, g, 0x060005);
	// TestUtilities.check("SRC c: #08a80808 fc: #08d508a8", 105, 115, g, 0x060005);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #08d508a8", 185, 155, g, 0x060005);
	// drawTransformedImage(0xa808d5d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08d508d5 fc: #a808d5d5", 125, 125, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #a808d5d5", 155, 185, g, 0x058c8c);
	// TestUtilities.check("SRC c: #08a80808 fc: #a808d5d5", 105, 115, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5d5a808 fc: #a808d5d5", 135, 185, g, 0x058c8c);
	// TestUtilities.check("SRC c: #0808d508 fc: #a808d5d5", 165, 105, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #a808d5d5", 145, 155, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #a808d5d5", 175, 145, g, 0x058c8c);
	// TestUtilities.check("SRC c: #08d50808 fc: #a808d5d5", 105, 125, g, 0x058c8c);
	// TestUtilities.check("SRC c: #08a808a8 fc: #a808d5d5", 115, 115, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a808d5d5", 125, 135, g, 0x058c8c);
	// TestUtilities.check("SRC c: #0808d5d5 fc: #a808d5d5", 185, 105, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #a808d5d5", 115, 175, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #a808d5d5", 145, 135, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #a808d5d5", 175, 165, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #a808d5d5", 135, 155, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #a808d5d5", 135, 175, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a8a80808 fc: #a808d5d5", 105, 145, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #a808d5d5", 185, 185, g, 0x058c8c);
	// TestUtilities.check("SRC c: #d5a8a8a8 fc: #a808d5d5", 145, 175, g, 0x058c8c);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #a808d5d5", 115, 145, g, 0x058c8c);
	// drawTransformedImage(0xa8a80808, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d50808d5 fc: #a8a80808", 125, 165, g, 0x6e0505);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #a8a80808", 175, 165, g, 0x6e0505);
	// TestUtilities.check("SRC c: #08d508a8 fc: #a8a80808", 115, 125, g, 0x6e0505);
	// TestUtilities.check("SRC c: #080808d5 fc: #a8a80808", 125, 105, g, 0x6e0505);
	// TestUtilities.check("SRC c: #08a80808 fc: #a8a80808", 105, 115, g, 0x6e0505);
	// TestUtilities.check("SRC c: #0808d5d5 fc: #a8a80808", 185, 105, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #a8a80808", 155, 155, g, 0x6e0505);
	// TestUtilities.check("SRC c: #0808a8a8 fc: #a8a80808", 145, 105, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a8a80808", 125, 135, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #a8a80808", 115, 155, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a8080808 fc: #a8a80808", 105, 135, g, 0x6e0505);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #a8a80808", 155, 185, g, 0x6e0505);
	// TestUtilities.check("SRC c: #08d508d5 fc: #a8a80808", 125, 125, g, 0x6e0505);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #a8a80808", 145, 165, g, 0x6e0505);
	// TestUtilities.check("SRC c: #d508a808 fc: #a8a80808", 135, 165, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #a8a80808", 185, 155, g, 0x6e0505);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #a8a80808", 185, 185, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #a8a80808", 115, 145, g, 0x6e0505);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #a8a80808", 145, 135, g, 0x6e0505);
	// TestUtilities.check("SRC c: #0808d5a8 fc: #a8a80808", 175, 105, g, 0x6e0505);
	// drawTransformedImage(0xa808d508, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08a8a8a8 fc: #a808d508", 145, 115, g, 0x058c05);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a808d508", 125, 135, g, 0x058c05);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #a808d508", 115, 155, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5d508a8 fc: #a808d508", 115, 185, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5d5a8a8 fc: #a808d508", 145, 185, g, 0x058c05);
	// TestUtilities.check("SRC c: #08a808d5 fc: #a808d508", 125, 115, g, 0x058c05);
	// TestUtilities.check("SRC c: #a8a8d508 fc: #a808d508", 165, 145, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #a808d508", 185, 185, g, 0x058c05);
	// TestUtilities.check("SRC c: #08a8d508 fc: #a808d508", 165, 115, g, 0x058c05);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #a808d508", 155, 155, g, 0x058c05);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #a808d508", 185, 135, g, 0x058c05);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #a808d508", 175, 145, g, 0x058c05);
	// TestUtilities.check("SRC c: #a808a8d5 fc: #a808d508", 155, 135, g, 0x058c05);
	// TestUtilities.check("SRC c: #080808d5 fc: #a808d508", 125, 105, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #a808d508", 115, 175, g, 0x058c05);
	// TestUtilities.check("SRC c: #08a808a8 fc: #a808d508", 115, 115, g, 0x058c05);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #a808d508", 175, 155, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5d50808 fc: #a808d508", 105, 185, g, 0x058c05);
	// TestUtilities.check("SRC c: #080808a8 fc: #a808d508", 115, 105, g, 0x058c05);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #a808d508", 175, 175, g, 0x058c05);
	// drawTransformedImage(0x0808a8d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08d5a808 fc: #0808a8d5", 135, 125, g, 0x000506);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #0808a8d5", 175, 175, g, 0x000506);
	// TestUtilities.check("SRC c: #08a8d5d5 fc: #0808a8d5", 185, 115, g, 0x000506);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #0808a8d5", 165, 155, g, 0x000506);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #0808a8d5", 185, 135, g, 0x000506);
	// TestUtilities.check("SRC c: #a8a8a8a8 fc: #0808a8d5", 145, 145, g, 0x000506);
	// TestUtilities.check("SRC c: #a8a808d5 fc: #0808a8d5", 125, 145, g, 0x000506);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #0808a8d5", 155, 125, g, 0x000506);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #0808a8d5", 135, 175, g, 0x000506);
	// TestUtilities.check("SRC c: #0808d508 fc: #0808a8d5", 165, 105, g, 0x000506);
	// TestUtilities.check("SRC c: #d5d50808 fc: #0808a8d5", 105, 185, g, 0x000506);
	// TestUtilities.check("SRC c: #a808a8d5 fc: #0808a8d5", 155, 135, g, 0x000506);
	// TestUtilities.check("SRC c: #08a80808 fc: #0808a8d5", 105, 115, g, 0x000506);
	// TestUtilities.check("SRC c: #a8a8a8d5 fc: #0808a8d5", 155, 145, g, 0x000506);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #0808a8d5", 135, 155, g, 0x000506);
	// TestUtilities.check("SRC c: #08d5d5a8 fc: #0808a8d5", 175, 125, g, 0x000506);
	// TestUtilities.check("SRC c: #d5d5a808 fc: #0808a8d5", 135, 185, g, 0x000506);
	// TestUtilities.check("SRC c: #08d50808 fc: #0808a8d5", 105, 125, g, 0x000506);
	// TestUtilities.check("SRC c: #d5a808d5 fc: #0808a8d5", 125, 175, g, 0x000506);
	// TestUtilities.check("SRC c: #d5a8d5d5 fc: #0808a8d5", 185, 175, g, 0x000506);
	// drawTransformedImage(0x0808d5a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #a808a808 fc: #0808d5a8", 135, 135, g, 0x000605);
	// TestUtilities.check("SRC c: #d508d5d5 fc: #0808d5a8", 185, 165, g, 0x000605);
	// TestUtilities.check("SRC c: #d5a8a8a8 fc: #0808d5a8", 145, 175, g, 0x000605);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #0808d5a8", 155, 125, g, 0x000605);
	// TestUtilities.check("SRC c: #d50808a8 fc: #0808d5a8", 115, 165, g, 0x000605);
	// TestUtilities.check("SRC c: #a8a80808 fc: #0808d5a8", 105, 145, g, 0x000605);
	// TestUtilities.check("SRC c: #d5d50808 fc: #0808d5a8", 105, 185, g, 0x000605);
	// TestUtilities.check("SRC c: #080808a8 fc: #0808d5a8", 115, 105, g, 0x000605);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #0808d5a8", 115, 175, g, 0x000605);
	// TestUtilities.check("SRC c: #08080808 fc: #0808d5a8", 105, 105, g, 0x000605);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #0808d5a8", 145, 155, g, 0x000605);
	// TestUtilities.check("SRC c: #d5d508d5 fc: #0808d5a8", 125, 185, g, 0x000605);
	// TestUtilities.check("SRC c: #a80808d5 fc: #0808d5a8", 125, 135, g, 0x000605);
	// TestUtilities.check("SRC c: #0808a808 fc: #0808d5a8", 135, 105, g, 0x000605);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #0808d5a8", 135, 175, g, 0x000605);
	// TestUtilities.check("SRC c: #d508a808 fc: #0808d5a8", 135, 165, g, 0x000605);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #0808d5a8", 115, 155, g, 0x000605);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #0808d5a8", 115, 145, g, 0x000605);
	// TestUtilities.check("SRC c: #08a808a8 fc: #0808d5a8", 115, 115, g, 0x000605);
	// TestUtilities.check("SRC c: #08a8a808 fc: #0808d5a8", 135, 115, g, 0x000605);
	// drawTransformedImage(0xa8a8d5a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #a8a8d5a8", 175, 135, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #a8a8d5a8", 175, 165, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8a80808 fc: #a8a8d5a8", 105, 145, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8a8d5d5 fc: #a8a8d5a8", 185, 145, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #080808d5 fc: #a8a8d5a8", 125, 105, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d5a80808 fc: #a8a8d5a8", 105, 175, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #a8a8d5a8", 185, 125, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8a8d508 fc: #a8a8d5a8", 165, 145, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d508a808 fc: #a8a8d5a8", 135, 165, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #08a808a8 fc: #a8a8d5a8", 115, 115, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d5d508d5 fc: #a8a8d5a8", 125, 185, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d5d508a8 fc: #a8a8d5a8", 115, 185, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d50808a8 fc: #a8a8d5a8", 115, 165, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d5a8d508 fc: #a8a8d5a8", 165, 175, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #a8a8d5a8", 135, 155, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #a8a8d5a8", 175, 145, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a8a8d5a8", 125, 135, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #a8a808d5 fc: #a8a8d5a8", 125, 145, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #a8a8d5a8", 185, 185, g, 0x6e8c6e);
	// TestUtilities.check("SRC c: #08080808 fc: #a8a8d5a8", 105, 105, g, 0x6e8c6e);
	// drawTransformedImage(0x080808d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #080808a8 fc: #080808d5", 115, 105, g, 0x000006);
	// TestUtilities.check("SRC c: #d5080808 fc: #080808d5", 105, 165, g, 0x000006);
	// TestUtilities.check("SRC c: #a80808a8 fc: #080808d5", 115, 135, g, 0x000006);
	// TestUtilities.check("SRC c: #0808a808 fc: #080808d5", 135, 105, g, 0x000006);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #080808d5", 145, 155, g, 0x000006);
	// TestUtilities.check("SRC c: #a808d508 fc: #080808d5", 165, 135, g, 0x000006);
	// TestUtilities.check("SRC c: #d50808a8 fc: #080808d5", 115, 165, g, 0x000006);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #080808d5", 145, 135, g, 0x000006);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #080808d5", 165, 155, g, 0x000006);
	// TestUtilities.check("SRC c: #d5d5a8a8 fc: #080808d5", 145, 185, g, 0x000006);
	// TestUtilities.check("SRC c: #08a808d5 fc: #080808d5", 125, 115, g, 0x000006);
	// TestUtilities.check("SRC c: #a8a80808 fc: #080808d5", 105, 145, g, 0x000006);
	// TestUtilities.check("SRC c: #08a8a808 fc: #080808d5", 135, 115, g, 0x000006);
	// TestUtilities.check("SRC c: #0808a8d5 fc: #080808d5", 155, 105, g, 0x000006);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #080808d5", 175, 135, g, 0x000006);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #080808d5", 185, 185, g, 0x000006);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #080808d5", 185, 155, g, 0x000006);
	// TestUtilities.check("SRC c: #08d5d508 fc: #080808d5", 165, 125, g, 0x000006);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #080808d5", 165, 185, g, 0x000006);
	// TestUtilities.check("SRC c: #0808d5d5 fc: #080808d5", 185, 105, g, 0x000006);
	// drawTransformedImage(0x08a8a8d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #08a8a8d5", 175, 175, g, 0x050506);
	// TestUtilities.check("SRC c: #0808d508 fc: #08a8a8d5", 165, 105, g, 0x050506);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #08a8a8d5", 185, 155, g, 0x050506);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #08a8a8d5", 155, 155, g, 0x050506);
	// TestUtilities.check("SRC c: #a8d50808 fc: #08a8a8d5", 105, 155, g, 0x050506);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #08a8a8d5", 185, 135, g, 0x050506);
	// TestUtilities.check("SRC c: #08a8d508 fc: #08a8a8d5", 165, 115, g, 0x050506);
	// TestUtilities.check("SRC c: #a8a80808 fc: #08a8a8d5", 105, 145, g, 0x050506);
	// TestUtilities.check("SRC c: #0808a8a8 fc: #08a8a8d5", 145, 105, g, 0x050506);
	// TestUtilities.check("SRC c: #a8a8a808 fc: #08a8a8d5", 135, 145, g, 0x050506);
	// TestUtilities.check("SRC c: #d508d5d5 fc: #08a8a8d5", 185, 165, g, 0x050506);
	// TestUtilities.check("SRC c: #08d508a8 fc: #08a8a8d5", 115, 125, g, 0x050506);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #08a8a8d5", 155, 185, g, 0x050506);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #08a8a8d5", 165, 185, g, 0x050506);
	// TestUtilities.check("SRC c: #08a808a8 fc: #08a8a8d5", 115, 115, g, 0x050506);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #08a8a8d5", 135, 155, g, 0x050506);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #08a8a8d5", 115, 145, g, 0x050506);
	// TestUtilities.check("SRC c: #08a8a8d5 fc: #08a8a8d5", 155, 115, g, 0x050506);
	// TestUtilities.check("SRC c: #d5a80808 fc: #08a8a8d5", 105, 175, g, 0x050506);
	// TestUtilities.check("SRC c: #d5a8d5d5 fc: #08a8a8d5", 185, 175, g, 0x050506);
	// drawTransformedImage(0xd5d5d5d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #080808a8 fc: #d5d5d5d5", 115, 105, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #d5d5d5d5", 175, 175, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #d5d5d5d5", 175, 155, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a808d508 fc: #d5d5d5d5", 165, 135, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #08a8d508 fc: #d5d5d5d5", 165, 115, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8a8a8a8 fc: #d5d5d5d5", 145, 145, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #d5d5d5d5", 175, 135, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8080808 fc: #d5d5d5d5", 105, 135, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a808a808 fc: #d5d5d5d5", 135, 135, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #d5d5d5d5", 185, 185, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d5d5d5a8 fc: #d5d5d5d5", 175, 185, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #d5d5d5d5", 165, 155, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d508a8d5 fc: #d5d5d5d5", 155, 165, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d5d50808 fc: #d5d5d5d5", 105, 185, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #d5d5d5d5", 145, 155, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #d5d5d5d5", 155, 155, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8a8a808 fc: #d5d5d5d5", 135, 145, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #d5d5d5d5", 115, 175, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #a8a80808 fc: #d5d5d5d5", 105, 145, g, 0xb1b1b1);
	// TestUtilities.check("SRC c: #080808d5 fc: #d5d5d5d5", 125, 105, g, 0xb1b1b1);
	// drawTransformedImage(0xd5d5a8d5, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d508d5d5 fc: #d5d5a8d5", 185, 165, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #0808a808 fc: #d5d5a8d5", 135, 105, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #08d5a808 fc: #d5d5a8d5", 135, 125, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #d5d5a8d5", 155, 185, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8a8a8d5 fc: #d5d5a8d5", 155, 145, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #0808d5a8 fc: #d5d5a8d5", 175, 105, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #d5d5a8d5", 165, 155, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #d5d5a8d5", 145, 165, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8a8d508 fc: #d5d5a8d5", 165, 145, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a808d508 fc: #d5d5a8d5", 165, 135, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #08d50808 fc: #d5d5a8d5", 105, 125, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #d5d5a8d5", 145, 155, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #d5d5a8d5", 185, 125, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #08a8d5a8 fc: #d5d5a8d5", 175, 115, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #d5d5a8d5", 175, 155, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #d5d5a8d5", 155, 155, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #d5d5a8d5", 115, 175, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #d5d5a8d5", 185, 185, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #d5d5a8d5", 185, 155, g, 0xb18cb1);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #d5d5a8d5", 165, 185, g, 0xb18cb1);
	// drawTransformedImage(0xd5d5d508, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d5d5d5a8 fc: #d5d5d508", 175, 185, g, 0xb1b106);
	// TestUtilities.check("SRC c: #08a80808 fc: #d5d5d508", 105, 115, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #d5d5d508", 115, 155, g, 0xb1b106);
	// TestUtilities.check("SRC c: #0808a8d5 fc: #d5d5d508", 155, 105, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a80808a8 fc: #d5d5d508", 115, 135, g, 0xb1b106);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #d5d5d508", 185, 185, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8d508d5 fc: #d5d5d508", 125, 155, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a80808d5 fc: #d5d5d508", 125, 135, g, 0xb1b106);
	// TestUtilities.check("SRC c: #0808d508 fc: #d5d5d508", 165, 105, g, 0xb1b106);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #d5d5d508", 165, 185, g, 0xb1b106);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #d5d5d508", 185, 125, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8a808d5 fc: #d5d5d508", 125, 145, g, 0xb1b106);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #d5d5d508", 145, 165, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #d5d5d508", 175, 145, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #d5d5d508", 135, 155, g, 0xb1b106);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #d5d5d508", 135, 175, g, 0xb1b106);
	// TestUtilities.check("SRC c: #08080808 fc: #d5d5d508", 105, 105, g, 0xb1b106);
	// TestUtilities.check("SRC c: #a8080808 fc: #d5d5d508", 105, 135, g, 0xb1b106);
	// TestUtilities.check("SRC c: #d5a8a8d5 fc: #d5d5d508", 155, 175, g, 0xb1b106);
	// TestUtilities.check("SRC c: #08d508a8 fc: #d5d5d508", 115, 125, g, 0xb1b106);
	// drawTransformedImage(0xd50808a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #a808a8d5 fc: #d50808a8", 155, 135, g, 0x06068c);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #d50808a8", 145, 135, g, 0x06068c);
	// TestUtilities.check("SRC c: #08a808a8 fc: #d50808a8", 115, 115, g, 0x06068c);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #d50808a8", 135, 175, g, 0x06068c);
	// TestUtilities.check("SRC c: #08a8a808 fc: #d50808a8", 135, 115, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #d50808a8", 165, 155, g, 0x06068c);
	// TestUtilities.check("SRC c: #a808a808 fc: #d50808a8", 135, 135, g, 0x06068c);
	// TestUtilities.check("SRC c: #08a8a8a8 fc: #d50808a8", 145, 115, g, 0x06068c);
	// TestUtilities.check("SRC c: #08d5d508 fc: #d50808a8", 165, 125, g, 0x06068c);
	// TestUtilities.check("SRC c: #08d50808 fc: #d50808a8", 105, 125, g, 0x06068c);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #d50808a8", 145, 165, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8a8d508 fc: #d50808a8", 165, 145, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8a8d5d5 fc: #d50808a8", 185, 145, g, 0x06068c);
	// TestUtilities.check("SRC c: #d5d5d5d5 fc: #d50808a8", 185, 185, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8d5a8a8 fc: #d50808a8", 145, 155, g, 0x06068c);
	// TestUtilities.check("SRC c: #a80808a8 fc: #d50808a8", 115, 135, g, 0x06068c);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #d50808a8", 165, 185, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #d50808a8", 155, 155, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8a8a8a8 fc: #d50808a8", 145, 145, g, 0x06068c);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #d50808a8", 175, 155, g, 0x06068c);
	// drawTransformedImage(0xa8080808, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08a8a8d5 fc: #a8080808", 155, 115, g, 0x050505);
	// TestUtilities.check("SRC c: #08d5a808 fc: #a8080808", 135, 125, g, 0x050505);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #a8080808", 115, 155, g, 0x050505);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #a8080808", 155, 185, g, 0x050505);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #a8080808", 175, 175, g, 0x050505);
	// TestUtilities.check("SRC c: #08a80808 fc: #a8080808", 105, 115, g, 0x050505);
	// TestUtilities.check("SRC c: #a8a808d5 fc: #a8080808", 125, 145, g, 0x050505);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #a8080808", 135, 155, g, 0x050505);
	// TestUtilities.check("SRC c: #08a8d5d5 fc: #a8080808", 185, 115, g, 0x050505);
	// TestUtilities.check("SRC c: #08d5d508 fc: #a8080808", 165, 125, g, 0x050505);
	// TestUtilities.check("SRC c: #a8a80808 fc: #a8080808", 105, 145, g, 0x050505);
	// TestUtilities.check("SRC c: #080808d5 fc: #a8080808", 125, 105, g, 0x050505);
	// TestUtilities.check("SRC c: #a8a8d5d5 fc: #a8080808", 185, 145, g, 0x050505);
	// TestUtilities.check("SRC c: #d508a808 fc: #a8080808", 135, 165, g, 0x050505);
	// TestUtilities.check("SRC c: #08a808a8 fc: #a8080808", 115, 115, g, 0x050505);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #a8080808", 135, 175, g, 0x050505);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #a8080808", 185, 135, g, 0x050505);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #a8080808", 185, 155, g, 0x050505);
	// TestUtilities.check("SRC c: #d5a8a8d5 fc: #a8080808", 155, 175, g, 0x050505);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #a8080808", 145, 135, g, 0x050505);
	// drawTransformedImage(0xd508d5a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08080808 fc: #d508d5a8", 105, 105, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08a80808 fc: #d508d5a8", 105, 115, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #d508d5a8", 175, 165, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08a8d508 fc: #d508d5a8", 165, 115, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08d5d5a8 fc: #d508d5a8", 175, 125, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #d508d5a8", 115, 175, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d5d5a8a8 fc: #d508d5a8", 145, 185, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #d508d5a8", 145, 135, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d508d508 fc: #d508d5a8", 165, 165, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #d508d5a8", 145, 165, g, 0x06b18c);
	// TestUtilities.check("SRC c: #080808d5 fc: #d508d5a8", 125, 105, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a808d508 fc: #d508d5a8", 165, 135, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a8a80808 fc: #d508d5a8", 105, 145, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08d50808 fc: #d508d5a8", 105, 125, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #d508d5a8", 155, 125, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #d508d5a8", 175, 155, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #d508d5a8", 135, 155, g, 0x06b18c);
	// TestUtilities.check("SRC c: #d50808d5 fc: #d508d5a8", 125, 165, g, 0x06b18c);
	// TestUtilities.check("SRC c: #a8a8a808 fc: #d508d5a8", 135, 145, g, 0x06b18c);
	// TestUtilities.check("SRC c: #08a808a8 fc: #d508d5a8", 115, 115, g, 0x06b18c);
	// drawTransformedImage(0xa8a808a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a8a808a8", 125, 135, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a808a808 fc: #a8a808a8", 135, 135, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #a8a808a8", 185, 135, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d50808d5 fc: #a8a808a8", 125, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d5d50808 fc: #a8a808a8", 105, 185, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a8d5d508 fc: #a8a808a8", 165, 155, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #a8a808a8", 165, 185, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d5a80808 fc: #a8a808a8", 105, 175, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a80808a8 fc: #a8a808a8", 115, 135, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #a8a808a8", 175, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #08d508a8 fc: #a8a808a8", 115, 125, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d508a808 fc: #a8a808a8", 135, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #08a8d508 fc: #a8a808a8", 165, 115, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d5a8a8a8 fc: #a8a808a8", 145, 175, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d508d5d5 fc: #a8a808a8", 185, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #a8a808a8", 135, 155, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d5080808 fc: #a8a808a8", 105, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #a8a808a8", 145, 165, g, 0x6e056e);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #a8a808a8", 185, 125, g, 0x6e056e);
	// TestUtilities.check("SRC c: #a8080808 fc: #a8a808a8", 105, 135, g, 0x6e056e);
	// drawTransformedImage(0x08a8d5a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #0808a8d5 fc: #08a8d5a8", 155, 105, g, 0x050605);
	// TestUtilities.check("SRC c: #08a808d5 fc: #08a8d5a8", 125, 115, g, 0x050605);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #08a8d5a8", 145, 165, g, 0x050605);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #08a8d5a8", 155, 125, g, 0x050605);
	// TestUtilities.check("SRC c: #08a808a8 fc: #08a8d5a8", 115, 115, g, 0x050605);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #08a8d5a8", 135, 175, g, 0x050605);
	// TestUtilities.check("SRC c: #a8d508d5 fc: #08a8d5a8", 125, 155, g, 0x050605);
	// TestUtilities.check("SRC c: #a8a8a808 fc: #08a8d5a8", 135, 145, g, 0x050605);
	// TestUtilities.check("SRC c: #d508d5a8 fc: #08a8d5a8", 175, 165, g, 0x050605);
	// TestUtilities.check("SRC c: #a8a80808 fc: #08a8d5a8", 105, 145, g, 0x050605);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #08a8d5a8", 115, 175, g, 0x050605);
	// TestUtilities.check("SRC c: #d5d5d508 fc: #08a8d5a8", 165, 185, g, 0x050605);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #08a8d5a8", 175, 145, g, 0x050605);
	// TestUtilities.check("SRC c: #d5d5a8d5 fc: #08a8d5a8", 155, 185, g, 0x050605);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #08a8d5a8", 145, 135, g, 0x050605);
	// TestUtilities.check("SRC c: #a8a808d5 fc: #08a8d5a8", 125, 145, g, 0x050605);
	// TestUtilities.check("SRC c: #d5d5d5a8 fc: #08a8d5a8", 175, 185, g, 0x050605);
	// TestUtilities.check("SRC c: #d5a8d5d5 fc: #08a8d5a8", 185, 175, g, 0x050605);
	// TestUtilities.check("SRC c: #d508a8d5 fc: #08a8d5a8", 155, 165, g, 0x050605);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #08a8d5a8", 175, 135, g, 0x050605);
	// drawTransformedImage(0xa8a8a808, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d5a8d508 fc: #a8a8a808", 165, 175, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a8a8a8d5 fc: #a8a8a808", 155, 145, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a808d5d5 fc: #a8a8a808", 185, 135, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d508a808 fc: #a8a8a808", 135, 165, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #a8a8a808", 155, 125, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #08d5a808 fc: #a8a8a808", 135, 125, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #08d5d5a8 fc: #a8a8a808", 175, 125, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a80808d5 fc: #a8a8a808", 125, 135, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #a8a8a808", 145, 135, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #08a8d5a8 fc: #a8a8a808", 175, 115, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #08d50808 fc: #a8a8a808", 105, 125, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #0808a8d5 fc: #a8a8a808", 155, 105, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d5080808 fc: #a8a8a808", 105, 165, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d5d5a8a8 fc: #a8a8a808", 145, 185, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #a8a8a808", 145, 165, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a8a80808 fc: #a8a8a808", 105, 145, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a8a8d508 fc: #a8a8a808", 165, 145, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #a8d50808 fc: #a8a8a808", 105, 155, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d508d508 fc: #a8a8a808", 165, 165, g, 0x6e6e05);
	// TestUtilities.check("SRC c: #d5a80808 fc: #a8a8a808", 105, 175, g, 0x6e6e05);
	// drawTransformedImage(0xd5d5a808, BlendMode.SRC);
	// TestUtilities.check("SRC c: #08d5d5d5 fc: #d5d5a808", 185, 125, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #d5d5a808", 175, 135, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a8d5a8d5 fc: #d5d5a808", 155, 155, g, 0xb18c06);
	// TestUtilities.check("SRC c: #0808a8a8 fc: #d5d5a808", 145, 105, g, 0xb18c06);
	// TestUtilities.check("SRC c: #08a8d508 fc: #d5d5a808", 165, 115, g, 0xb18c06);
	// TestUtilities.check("SRC c: #0808d5d5 fc: #d5d5a808", 185, 105, g, 0xb18c06);
	// TestUtilities.check("SRC c: #d5a808a8 fc: #d5d5a808", 115, 175, g, 0xb18c06);
	// TestUtilities.check("SRC c: #08a808d5 fc: #d5d5a808", 125, 115, g, 0xb18c06);
	// TestUtilities.check("SRC c: #d508a8a8 fc: #d5d5a808", 145, 165, g, 0xb18c06);
	// TestUtilities.check("SRC c: #08d50808 fc: #d5d5a808", 105, 125, g, 0xb18c06);
	// TestUtilities.check("SRC c: #d50808a8 fc: #d5d5a808", 115, 165, g, 0xb18c06);
	// TestUtilities.check("SRC c: #d5a8a8a8 fc: #d5d5a808", 145, 175, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a8080808 fc: #d5d5a808", 105, 135, g, 0xb18c06);
	// TestUtilities.check("SRC c: #08a80808 fc: #d5d5a808", 105, 115, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #d5d5a808", 115, 145, g, 0xb18c06);
	// TestUtilities.check("SRC c: #d508a8d5 fc: #d5d5a808", 155, 165, g, 0xb18c06);
	// TestUtilities.check("SRC c: #08d508a8 fc: #d5d5a808", 115, 125, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a8d5d5a8 fc: #d5d5a808", 175, 155, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a8d508a8 fc: #d5d5a808", 115, 155, g, 0xb18c06);
	// TestUtilities.check("SRC c: #a808a8a8 fc: #d5d5a808", 145, 135, g, 0xb18c06);
	// drawTransformedImage(0xd5a808a8, BlendMode.SRC);
	// TestUtilities.check("SRC c: #d5a8a808 fc: #d5a808a8", 135, 175, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5d5d5a8 fc: #d5a808a8", 175, 185, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8a808a8 fc: #d5a808a8", 115, 145, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d508a808 fc: #d5a808a8", 135, 165, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8d5d5d5 fc: #d5a808a8", 185, 155, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5d50808 fc: #d5a808a8", 105, 185, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8d50808 fc: #d5a808a8", 105, 155, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5d5a8a8 fc: #d5a808a8", 145, 185, g, 0x8c068c);
	// TestUtilities.check("SRC c: #08d508a8 fc: #d5a808a8", 115, 125, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8a8d5a8 fc: #d5a808a8", 175, 145, g, 0x8c068c);
	// TestUtilities.check("SRC c: #080808a8 fc: #d5a808a8", 115, 105, g, 0x8c068c);
	// TestUtilities.check("SRC c: #08a808d5 fc: #d5a808a8", 125, 115, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5d508a8 fc: #d5a808a8", 115, 185, g, 0x8c068c);
	// TestUtilities.check("SRC c: #08a8a8a8 fc: #d5a808a8", 145, 115, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8d508d5 fc: #d5a808a8", 125, 155, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5a8d5a8 fc: #d5a808a8", 175, 175, g, 0x8c068c);
	// TestUtilities.check("SRC c: #08d5a8d5 fc: #d5a808a8", 155, 125, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a808d5a8 fc: #d5a808a8", 175, 135, g, 0x8c068c);
	// TestUtilities.check("SRC c: #a8d5a808 fc: #d5a808a8", 135, 155, g, 0x8c068c);
	// TestUtilities.check("SRC c: #d5a8d5d5 fc: #d5a808a8", 185, 175, g, 0x8c068c);
	// // End of tests
	// }
	//
	// private static void drawTransformedImage(int color, BlendMode blend) {
	//
	// Display display = Display.getDisplay();
	// GraphicsContext g = display.getGraphicsContext();
	// Matrix matrix = new Matrix();
	// matrix.setTranslate(100, 100);
	//
	// g.setColor(Colors.BLACK);
	// Painter.fillRectangle(g, 0, 0, display.getWidth(), display.getHeight());
	//
	// VectorImage image = VectorImage.getImage(BLENDMODE_SVG);
	// VectorImage transformed = image.transformWithFilter(color, blend);
	//
	// VectorGraphicsPainter.drawImage(g, transformed, matrix);
	// display.requestFlush();
	// }

}
