/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util;

/**
 * The <code>SecurityLevels</code> class enumerates the values for security levels of GATT attributes.
 */
public class SecurityLevels {

	/** No encryption required. */
	public static final int NONE = 0;

	/** Encryption required. */
	public static final int ENCRYPT = 1;

	/** Authentication required. */
	public static final int AUTH = 2;

	private SecurityLevels() {
		// private constructor
	}
}
