/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 *
 * This File is a derivative work. Subject to §4 of the applicable Apache License, MicroEJ provides the above different license terms and conditions for use.
 *
 * // Copyright (C) 2006 The Android Open Source Project
 * //
 * // Licensed under the Apache License, Version 2.0 (the "License");
 * // you may not use this file except in compliance with the License.
 * // You may obtain a copy of the License at
 * //
 * //      http://www.apache.org/licenses/LICENSE-2.0
 * //
 * // Unless required by applicable law or agreed to in writing, software
 * // distributed under the License is distributed on an "AS IS" BASIS,
 * // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * // See the License for the specific language governing permissions and
 * // limitations under the License.
 */
package ej.microvg;

/**
 * Represents a 3x3 matrix for transforming coordinates.
 */
public class Matrix {

	/**
	 * Creates an identity matrix.
	 */
	public Matrix() {
		throw new VectorGraphicsException();
	}

	/**
	 * Creates a matrix that is a deep copy of the given matrix.
	 *
	 * @param source
	 *            the matrix to copy from
	 */
	public Matrix(Matrix source) {
		throw new VectorGraphicsException();
	}

	/**
	 * Deep copies the given matrix into this matrix.
	 *
	 * @param source
	 *            the matrix to copy from
	 */
	public void set(Matrix source) {
		throw new VectorGraphicsException();
	}

	/**
	 * Resets the matrix to identity.
	 */
	public void reset() {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the matrix to translate by (dx, dy).
	 *
	 * @param dx
	 *            the translation on x
	 * @param dy
	 *            the translation on y
	 */
	public void setTranslate(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the matrix to scale by (sx, sy).
	 *
	 * @param sx
	 *            the scale on x
	 * @param sy
	 *            the scale on y
	 */
	public void setScale(float sx, float sy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the matrix to rotate about (0,0) by the specified number of degrees.
	 *
	 * @param degrees
	 *            the degrees to rotate
	 */
	public void setRotate(float degrees) {
		throw new VectorGraphicsException();
	}

	/**
	 * Sets the matrix to the concatenation of the two specified matrices.
	 * <p>
	 * Either of the two matrices may also be the target matrix, that is
	 * <code>matrixA.setConcat(matrixA, matrixB);</code> is valid.
	 *
	 * @param a
	 *            the first matrix
	 * @param b
	 *            the second matrix
	 */
	public void setConcat(Matrix a, Matrix b) {
		throw new VectorGraphicsException();
	}

	/**
	 * Preconcats the matrix with the specified translation. M' = M * T(dx, dy)
	 *
	 * @param dx
	 *            the translation on x
	 * @param dy
	 *            the translation on y
	 */
	public void preTranslate(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Preconcats the matrix with the specified scale. M' = M * S(sx, sy)
	 *
	 * @param sx
	 *            the scale on x
	 * @param sy
	 *            the scale on y
	 */
	public void preScale(float sx, float sy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Preconcats the matrix with the specified rotation. M' = M * R(degrees)
	 *
	 * @param degrees
	 *            the degrees to rotate
	 */
	public void preRotate(float degrees) {
		throw new VectorGraphicsException();
	}

	/**
	 * Preconcats the matrix with the specified matrix. M' = M * other
	 *
	 * @param other
	 *            the matrix to concat with
	 */
	public void preConcat(Matrix other) {
		throw new VectorGraphicsException();
	}

	/**
	 * Postconcats the matrix with the specified translation. M' = T(dx, dy) * M
	 *
	 * @param dx
	 *            the translation on x
	 * @param dy
	 *            the translation on y
	 */
	public void postTranslate(float dx, float dy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Postconcats the matrix with the specified scale. M' = S(sx, sy) * M
	 *
	 * @param sx
	 *            the scale on x
	 * @param sy
	 *            the scale on y
	 */
	public void postScale(float sx, float sy) {
		throw new VectorGraphicsException();
	}

	/**
	 * Postconcats the matrix with the specified rotation. M' = R(degrees) * M
	 *
	 * @param degrees
	 *            the degrees to rotate
	 */
	public void postRotate(float degrees) {
		throw new VectorGraphicsException();
	}

	/**
	 * Postconcats the matrix with the specified matrix. M' = other * M
	 *
	 * @param other
	 *            the matrix to concat with
	 */
	public void postConcat(Matrix other) {
		throw new VectorGraphicsException();
	}

	/**
	 * Returns the SNI context data of this matrix.
	 * <p>
	 * The SNI context can be used to call a native method with SNI. This allows to identify and to use an matrix in the
	 * native world in order to perform operations with this matrix.
	 * <p>
	 * The data format is implementation specific.
	 *
	 * @return the SNI context of this matrix.
	 */
	public float[] getSNIContext() {
		throw new RuntimeException();
	}
}
