/*
 * Java
 *
 * Copyright 2018-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.net.util.wifi;

import ej.ecom.wifi.AccessPoint;
import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Gather error messages.
 */
public final class Messages {

	// ****************//
	// Error messages. //
	// ****************//
	/**
	 * Unknown error.
	 */
	public static final int ERROR_UNKNOWN = -255;

	/**
	 * Error during unmount.
	 */
	public static final int ERROR_DURING_UNMOUNT = -1;

	/**
	 * Could not leave an {@link AccessPoint}.
	 */
	public static final int ERROR_DURING_LEAVE = -2;

	/**
	 * Timeout.
	 */
	public static final int ERROR_TIMEOUT = -3;

	/**
	 * No Wi-Fi manager.
	 */
	public static final int ERROR_NO_WIFI_MANAGER = -4;

	/**
	 * Access Popublic static final int not joined.
	 */
	public static final int ERROR_COULD_NOT_JOIN_AP = -5;

	/**
	 * SSID is null.
	 */
	public static final int ERROR_SSID_NULL = -6;

	/**
	 * Category for Wi-Fi errors.
	 */
	public static final String WIFI_CATEGORY = Messages.class.getPackage().getName();

	/**
	 * The message builder.
	 */
	public static final MessageBuilder BUILDER = BasicMessageLogger.INSTANCE.getMessageBuilder();

	/**
	 * The message logger.
	 */
	public static final MessageLogger LOGGER = BasicMessageLogger.INSTANCE;

	private Messages() {
		// Forbid instantiation
	}
}
