/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.annotation.Nullable;
import ej.hoka.http.HaltException;
import ej.hoka.http.Route;
import ej.hoka.http.RouteHandler;
import ej.hoka.http.Worker;
import ej.hoka.http.encoding.EncodingRegistry;
import ej.hoka.http.requesthandler.RequestHandler;
import ej.hoka.http.requesthandler.StaticFilesHandler;
import ej.hoka.log.HokaLogger;
import ej.hoka.tcp.TcpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import javax.net.ServerSocketFactory;

public class HttpServer {
    private static final int DEFAULT_TIMEOUT = 60000;
    private final TcpServer server;
    private final int workerCount;
    private final RouteHandler routesHandler;
    private final EncodingRegistry encodingRegistry;
    private String notFoundErrorMessage = "";
    private String notFoundErrorContentType = "text/plain";
    private String internalServerErrorMessage = "";
    private String internalServerErrorContentType = "text/plain";
    @Nullable
    private Thread[] workers;
    private final boolean devMode;
    private final boolean strictAcceptEncoding;

    private HttpServer(int port, int maxSimultaneousConnection, int workersCount, ServerSocketFactory serverSocketFactory, int connectionTimeout, EncodingRegistry encodingRegistry, String apiBase, @Nullable StaticFilesHandler staticFilesHandler, boolean strictAcceptEncoding, boolean trailingSlashSupport, boolean devMode) {
        this.server = new TcpServer(port, maxSimultaneousConnection, serverSocketFactory, connectionTimeout);
        this.workerCount = workersCount;
        this.encodingRegistry = encodingRegistry;
        this.routesHandler = new RouteHandler(apiBase, staticFilesHandler, trailingSlashSupport);
        this.strictAcceptEncoding = strictAcceptEncoding;
        this.devMode = devMode;
    }

    public static HttpServerBuilder builder() {
        return new HttpServerBuilder();
    }

    public void start() throws IOException {
        this.server.start();
        Thread[] ws = new Thread[this.workerCount];
        this.workers = ws;
        int i = this.workerCount - 1;
        while (i >= 0) {
            Thread worker;
            ws[i] = worker = new Thread((Runnable)new Worker(this.server, this.routesHandler, this.encodingRegistry, this.strictAcceptEncoding, this.notFoundErrorMessage, this.notFoundErrorContentType, this.internalServerErrorMessage, this.internalServerErrorContentType, this.devMode), "HTTP-Worker-" + i);
            worker.start();
            --i;
        }
    }

    public void stop() {
        this.server.stop();
        Thread[] jobs = this.workers;
        if (jobs != null) {
            int i = jobs.length - 1;
            while (i >= 0) {
                try {
                    jobs[i].join();
                }
                catch (InterruptedException e) {
                    HokaLogger.instance.error(e);
                    jobs[i].interrupt();
                }
                --i;
            }
        }
    }

    public void get(String path, RequestHandler handler) {
        this.get(path, null, handler);
    }

    public void get(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(2, path, acceptType, handler);
    }

    public void post(String path, RequestHandler handler) {
        this.post(path, null, handler);
    }

    public void post(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(1, path, acceptType, handler);
    }

    public void put(String path, RequestHandler handler) {
        this.put(path, null, handler);
    }

    public void put(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(3, path, acceptType, handler);
    }

    public void delete(String path, RequestHandler handler) {
        this.delete(path, null, handler);
    }

    public void delete(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(4, path, acceptType, handler);
    }

    public void head(String path, RequestHandler handler) {
        this.head(path, null, handler);
    }

    public void head(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(5, path, acceptType, handler);
    }

    public void connect(String path, RequestHandler handler) {
        this.connect(path, null, handler);
    }

    public void connect(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(6, path, acceptType, handler);
    }

    public void options(String path, RequestHandler handler) {
        this.options(path, null, handler);
    }

    public void options(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(7, path, acceptType, handler);
    }

    public void trace(String path, RequestHandler handler) {
        this.trace(path, null, handler);
    }

    public void trace(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(8, path, acceptType, handler);
    }

    public void patch(String path, RequestHandler handler) {
        this.patch(path, null, handler);
    }

    public void patch(String path, @Nullable String acceptType, RequestHandler handler) {
        this.routesHandler.add(9, path, acceptType, handler);
    }

    public void before(String path, RequestHandler handler) {
        this.routesHandler.add(11, path, handler);
    }

    public void before(RequestHandler handler) {
        this.routesHandler.add(10, "+/*all-routes", handler);
    }

    public void after(String path, RequestHandler handler) {
        this.routesHandler.add(12, path, handler);
    }

    public void after(RequestHandler handler) {
        this.routesHandler.add(13, "+/*all-routes", handler);
    }

    public static final void halt() {
        throw new HaltException();
    }

    public static final void halt(String status) {
        throw new HaltException(status);
    }

    public static final void halt(String status, String body) {
        throw new HaltException(status, body);
    }

    public final void notFoundError(@Nullable String response) {
        if (response == null) {
            throw new IllegalArgumentException();
        }
        this.notFoundError(response, "text/plain");
    }

    public final void notFoundError(@Nullable String response, @Nullable String contentType) {
        if (response == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        this.notFoundErrorMessage = response;
        this.notFoundErrorContentType = contentType;
    }

    public final void internalServerError(@Nullable String response) {
        if (response == null) {
            throw new IllegalArgumentException();
        }
        this.internalServerError(response, "text/plain");
    }

    public final void internalServerError(@Nullable String response, @Nullable String contentType) {
        if (response == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        this.internalServerErrorMessage = response;
        this.internalServerErrorContentType = contentType;
    }

    public final void exception(@Nullable Class<? extends Exception> exception, @Nullable RequestHandler handler) {
        if (exception == null || handler == null) {
            throw new IllegalArgumentException();
        }
        this.routesHandler.addExceptionHandler(exception, handler);
    }

    public final List<Route> getRoutes() {
        return this.routesHandler.getRoutes();
    }

    public int getPort() {
        return this.server.getPort();
    }

    @Nullable
    public InetAddress getInetAddress() {
        return this.server.getInetAddress();
    }

    /* synthetic */ HttpServer(int n, int n2, int n3, ServerSocketFactory serverSocketFactory, int n4, EncodingRegistry encodingRegistry, String string, StaticFilesHandler staticFilesHandler, boolean bl, boolean bl2, boolean bl3, HttpServer httpServer) {
        this(n, n2, n3, serverSocketFactory, n4, encodingRegistry, string, staticFilesHandler, bl, bl2, bl3);
    }

    public static class HttpServerBuilder {
        private int port = 0;
        private int simultaneousConnections = 1;
        private int workerCount = 1;
        private String apiBase = "";
        private ServerSocketFactory ssf = ServerSocketFactory.getDefault();
        private int connectionTimeout = 60000;
        private EncodingRegistry encodingRegistry = new EncodingRegistry();
        @Nullable
        private StaticFilesHandler staticFilesHandler = null;
        private boolean devMode = false;
        private boolean strictAcceptEncoding = false;
        private boolean trailingSlashSupport = false;

        private HttpServerBuilder() {
        }

        public HttpServerBuilder port(int port) {
            if (port < 0) {
                throw new IllegalArgumentException();
            }
            this.port = port;
            return this;
        }

        public HttpServerBuilder simultaneousConnections(int simultaneousConnections) {
            if (this.simultaneousConnections <= 0) {
                throw new IllegalArgumentException();
            }
            this.simultaneousConnections = simultaneousConnections;
            return this;
        }

        public HttpServerBuilder workerCount(int workerCount) {
            if (workerCount <= 0) {
                throw new IllegalArgumentException();
            }
            this.workerCount = workerCount;
            return this;
        }

        public HttpServerBuilder apiBase(@Nullable String apiBase) {
            if (apiBase == null || apiBase.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.apiBase = apiBase;
            return this;
        }

        public HttpServerBuilder secure(@Nullable ServerSocketFactory ssf) {
            if (ssf == null) {
                throw new IllegalArgumentException();
            }
            this.ssf = ssf;
            return this;
        }

        public HttpServerBuilder connectionTimeout(int connectionTimeout) {
            if (connectionTimeout < 0) {
                throw new IllegalArgumentException();
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HttpServerBuilder encodingRegistry(@Nullable EncodingRegistry encodingRegistry) {
            if (encodingRegistry == null) {
                throw new IllegalArgumentException();
            }
            this.encodingRegistry = encodingRegistry;
            return this;
        }

        public HttpServerBuilder withStrictAcceptContentEncoding() {
            this.strictAcceptEncoding = true;
            return this;
        }

        public HttpServerBuilder withTrailingSlashSupport() {
            this.trailingSlashSupport = true;
            return this;
        }

        public HttpServerBuilder staticFilesHandler(@Nullable StaticFilesHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException();
            }
            this.staticFilesHandler = handler;
            return this;
        }

        public HttpServerBuilder developmentMode() {
            this.devMode = true;
            return this;
        }

        public HttpServer build() {
            return new HttpServer(this.port, this.simultaneousConnections, this.workerCount, this.ssf, this.connectionTimeout, this.encodingRegistry, this.apiBase, this.staticFilesHandler, this.strictAcceptEncoding, this.trailingSlashSupport, this.devMode, null);
        }
    }
}

