/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.microui.display.Font;
import ej.mwt.style.background.Background;
import ej.mwt.style.background.RoundedBackground;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.dimension.FixedDimension;
import ej.mwt.style.dimension.OptimalDimension;
import ej.mwt.style.dimension.RelativeDimension;
import ej.mwt.style.outline.Outline;
import ej.mwt.style.outline.border.RoundedBorder;

class Stringifier {
    private Stringifier() {
    }

    public static String toString(Dimension dimension) {
        String string = dimension instanceof FixedDimension ? Stringifier.toString((FixedDimension)dimension) : (dimension instanceof OptimalDimension ? Stringifier.toString((OptimalDimension)dimension) : (dimension instanceof RelativeDimension ? Stringifier.toString((RelativeDimension)dimension) : Stringifier.getClassName(dimension)));
        return string;
    }

    public static String colorToString(int color) {
        switch (color) {
            case 0: {
                return "black";
            }
            case 255: {
                return "blue";
            }
            case 65535: {
                return "cyan";
            }
            case 0x808080: {
                return "gray";
            }
            case 32768: {
                return "green";
            }
            case 65280: {
                return "lime";
            }
            case 0xFF00FF: {
                return "magenta";
            }
            case 0x800000: {
                return "maroon";
            }
            case 128: {
                return "navy";
            }
            case 0x808000: {
                return "olive";
            }
            case 0x800080: {
                return "purple";
            }
            case 0xFF0000: {
                return "red";
            }
            case 0xC0C0C0: {
                return "silver";
            }
            case 32896: {
                return "teal";
            }
            case 0xFFFFFF: {
                return "white";
            }
            case 0xFFFF00: {
                return "yellow";
            }
        }
        String hex = Integer.toHexString(color);
        char[] chars = new char[7];
        chars[0] = 35;
        int i = 1;
        int n = hex.length();
        int len = chars.length;
        while (i < len) {
            int j = i + n - len;
            chars[i] = j < 0 ? 48 : (int)hex.charAt(j);
            ++i;
        }
        return new String(chars);
    }

    public static String toString(Outline border) {
        String string = border instanceof RoundedBorder ? Stringifier.toString((RoundedBorder)border) : Stringifier.getClassName(border);
        return string;
    }

    public static String toString(Background background) {
        String string = background instanceof RoundedBackground ? Stringifier.toString((RoundedBackground)background) : Stringifier.getClassName(background);
        return string;
    }

    public static String toString(Font font) {
        String string = Stringifier.getClassName(font);
        String descriptor = font.getDescriptor();
        if (!descriptor.isEmpty()) {
            string = String.valueOf(string) + "[" + descriptor + "]";
        }
        return string;
    }

    public static String alignmentToString(int alignment) {
        switch (alignment) {
            case 5: {
                return "bottom";
            }
            case 1: {
                return "hcenter";
            }
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "top";
            }
            case 4: {
                return "vcenter";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getClassName(Object object) {
        return Stringifier.getClassName(object.getClass());
    }

    private static String getClassName(Class<?> clazz) {
        int length;
        String simpleName = clazz.getSimpleName();
        if (simpleName.charAt((length = simpleName.length()) - 1) == '@' && simpleName.charAt(0) != '@') {
            simpleName = simpleName.substring(0, length - 1);
        }
        return simpleName;
    }

    private static String toString(RoundedBackground roundedBackground) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(RoundedBackground.class));
        stringBuilder.append("[color=").append(Stringifier.colorToString(roundedBackground.getColor()));
        stringBuilder.append(", radius=").append(roundedBackground.getCornerRadius());
        stringBuilder.append(", thickness=").append(roundedBackground.getBorderThickness());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String toString(RoundedBorder roundedBorder) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(RoundedBorder.class));
        stringBuilder.append("[color=").append(Stringifier.colorToString(roundedBorder.getColor()));
        stringBuilder.append(", radius=").append(roundedBorder.getCornerRadius());
        stringBuilder.append(", thickness=").append(roundedBorder.getThickness());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(FixedDimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(FixedDimension.class));
        stringBuilder.append("[width=").append(dimension.getWidth());
        stringBuilder.append(", height=").append(dimension.getHeight());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(OptimalDimension dimension) {
        String type = dimension == OptimalDimension.OPTIMAL_DIMENSION_X ? "X" : (dimension == OptimalDimension.OPTIMAL_DIMENSION_Y ? "Y" : (dimension == OptimalDimension.OPTIMAL_DIMENSION_XY ? "XY" : "unknown"));
        return String.valueOf(Stringifier.getClassName(OptimalDimension.class)) + "[" + type + "]";
    }

    public static String toString(RelativeDimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(FixedDimension.class));
        stringBuilder.append("[widthRatio=").append(dimension.getWidthRatio());
        stringBuilder.append(", heightRatio=").append(dimension.getHeightRatio());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

