/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool;

public final class ArrayTools {
    private ArrayTools() {
    }

    public static void checkBounds(byte[] bytes, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(bytes.length, offset, length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static void checkBounds(int arrayLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(arrayLength, offset, length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static void checkArrayBounds(int arrayLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(arrayLength, offset, length)) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void checkStringBounds(int stringLength, int offset, int length) {
        if (!ArrayTools.checkBoundsInternal(stringLength, offset, length)) {
            throw new StringIndexOutOfBoundsException();
        }
    }

    private static boolean checkBoundsInternal(int arrayLength, int offset, int length) {
        int offsetPlusLength = offset + length;
        return offset >= 0 && length >= 0 && offsetPlusLength <= arrayLength && offsetPlusLength >= 0;
    }

    public static <T> T[] add(T[] array, T element) {
        int arrayLength = array.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength + 1);
        result[arrayLength] = element;
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    public static <T> T[] add(T[] array, T[] other) {
        int arrayLength = array.length;
        int otherLength = other.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength + otherLength);
        System.arraycopy(array, 0, result, 0, arrayLength);
        System.arraycopy(other, 0, result, arrayLength, otherLength);
        return result;
    }

    public static <T> T[] insert(T[] array, int index, T element) {
        int arrayLength = array.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength + 1);
        result[index] = element;
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index, result, index + 1, arrayLength - index);
        return result;
    }

    public static <T> T[] remove(T[] array, T element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (array[i] != element) continue;
            T[] result = ArrayTools.createNewArray(array, arrayLength - 1);
            System.arraycopy(array, 0, result, 0, i);
            System.arraycopy(array, i + 1, result, i, arrayLength - i - 1);
            return result;
        }
        return array;
    }

    public static <T> T[] removeEquals(T[] array, T element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            T[] result = ArrayTools.createNewArray(array, arrayLength - 1);
            System.arraycopy(array, 0, result, 0, i);
            System.arraycopy(array, i + 1, result, i, arrayLength - i - 1);
            return result;
        }
        return array;
    }

    public static <T> T[] remove(T[] array, int index) {
        int arrayLength = array.length;
        T[] result = ArrayTools.createNewArray(array, arrayLength - 1);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, arrayLength - index - 1);
        return result;
    }

    public static <T> boolean contains(T[] array, T element) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T candidate = TArray[n2];
            if (element == candidate) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsEquals(T[] array, T element) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T candidate = TArray[n2];
            if (element.equals(candidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> int getIndex(T[] array, T element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int getIndexEquals(T[] array, T element) {
        int arrayLength = array.length;
        int i = 0;
        while (i < arrayLength) {
            if (element.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> T[] copy(T[] array) {
        return ArrayTools.copyInternal(array, array.length);
    }

    public static <T> T[] copy(Object[] array, Class<T[]> type) {
        return ArrayTools.copyInternal(array, array.length, type);
    }

    public static int[] add(int[] array, int element) {
        int arrayLength = array.length;
        int[] result = new int[arrayLength + 1];
        result[arrayLength] = element;
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    public static int[] remove(int[] array, int element) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (array[i] != element) continue;
            int[] result = new int[arrayLength - 1];
            System.arraycopy(array, 0, result, 0, i);
            System.arraycopy(array, i + 1, result, i, arrayLength - i - 1);
            return result;
        }
        return array;
    }

    public static int[] removeRange(int[] array, int offset, int length) {
        int arrayLength = array.length;
        int[] newArray = new int[arrayLength + length];
        System.arraycopy(array, 0, newArray, 0, offset);
        System.arraycopy(array, offset + length, newArray, 0, arrayLength - offset - length);
        return newArray;
    }

    public static int[] copy(int[] array) {
        int arrayLength = array.length;
        int[] result = new int[arrayLength];
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    public static <T> T[] add(T[] array, T element, int pointer) {
        try {
            array[pointer] = element;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            T[] result = ArrayTools.createNewArray(array, (pointer << 1) + 1);
            System.arraycopy(array, 0, result, 0, array.length);
            array = result;
            array[pointer] = element;
        }
        return array;
    }

    public static <T> T[] insert(T[] array, int index, T element, int pointer) {
        T[] result;
        int arrayLength = array.length;
        if (pointer == arrayLength) {
            result = ArrayTools.createNewArray(array, (pointer << 1) + 1);
            System.arraycopy(array, 0, result, 0, index);
        } else {
            result = array;
        }
        System.arraycopy(array, index, result, index + 1, pointer - index);
        result[index] = element;
        return result;
    }

    public static <T> boolean remove(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (array[i] != element) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = null;
            return true;
        }
        return false;
    }

    public static <T> boolean removeEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = null;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> int getIndex(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (element != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static <T> int getIndexEquals(T[] array, T element, int pointer) {
        int i = pointer;
        while (--i >= 0) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] copy(T[] array, int pointer) {
        return ArrayTools.copyInternal(array, pointer + 1);
    }

    public static <T> T[] copy(Object[] array, int pointer, Class<T[]> type) {
        return ArrayTools.copyInternal(array, pointer + 1, type);
    }

    public static int[] add(int[] array, int element, int pointer) {
        try {
            array[pointer] = element;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] result = new int[(pointer << 1) + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            array = result;
            array[pointer] = element;
        }
        return array;
    }

    public static boolean remove(int[] array, int element, int pointer) {
        int arrayLength;
        int i = arrayLength = array.length;
        while (--i >= 0) {
            if (array[i] != element) continue;
            System.arraycopy(array, 0, array, 0, i);
            System.arraycopy(array, i + 1, array, i, pointer - i);
            array[pointer] = 0;
            return true;
        }
        return false;
    }

    public static int[] copy(int[] array, int pointer) {
        int arrayLength = pointer + 1;
        int[] result = new int[arrayLength];
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    private static <T> T[] copyInternal(Object[] array, int arrayLength, Class<T[]> type) {
        T[] result = ArrayTools.createNewArray(type, arrayLength);
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    private static <T> T[] copyInternal(T[] array, int arrayLength) {
        T[] result = ArrayTools.createNewArray(array, arrayLength);
        System.arraycopy(array, 0, result, 0, arrayLength);
        return result;
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        return ArrayTools.createNewArray(array.getClass(), length);
    }

    public static <T> T[] createNewArray(Class<T[]> type, int length) {
        return (Object[])com.is2t.tools.ArrayTools.createNewArrayFromType(type, (int)length);
    }
}

