/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import ej.annotation.Nullable;
import ej.bon.Constants;
import ej.bon.Util;
import ej.trace.Tracer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttClient
implements IMqttClient {
    protected static final String MQTT = "MQTT";
    private static final String DEBUG_MODE = "micropaho.debug";
    private static final String SERVER_CHECKS = "micropaho.server.check";
    private static final String THREAD_PRIORITY = "micropaho.thread.priority";
    private static final int DEFAULT_PORT_TCP = 1883;
    private static final int DEFAULT_PORT_SSL = 8883;
    private static final String URI_PREFIX_TCP = "tcp";
    private static final String URI_PREFIX_SSL = "ssl";
    private static final String URI_SEP_PREFIX = "://";
    private static final char URI_SEP_PORT = ':';
    private static final int STATE_CONNECTED = 0;
    private static final int STATE_DISCONNECTED = 1;
    private static final int STATE_CLOSED = 2;
    private static final int MSG_CONNECT = 1;
    private static final int MSG_CONNACK = 2;
    private static final int MSG_PUBLISH = 3;
    private static final int MSG_PUBACK = 4;
    private static final int MSG_PUBREC = 5;
    private static final int MSG_PUBREL = 6;
    private static final int MSG_PUBCOMP = 7;
    private static final int MSG_SUBSCRIBE = 8;
    private static final int MSG_SUBACK = 9;
    private static final int MSG_UNSUBSCRIBE = 10;
    private static final int MSG_UNSUBACK = 11;
    private static final int MSG_PINGREQ = 12;
    private static final int MSG_PINGRESP = 13;
    private static final int MSG_DISCONNECT = 14;
    private static final int MQTT_SUBACK_RETURN_CODE_SUCCESS_QOS0 = 0;
    private static final int MQTT_SUBACK_RETURN_CODE_SUCCESS_QOS1 = 1;
    private static final int MQTT_SUBACK_RETURN_CODE_FAILURE = 128;
    protected static final int MQTT_QOS0 = 0;
    protected static final int MQTT_QOS1 = 1;
    private static final int MQTT_VERSION_3_1_1 = 4;
    private static final int MQTT_PACKET_IDENTIFIER_MIN = 1;
    private static final int MQTT_PACKET_IDENTIFIER_MAX = 65535;
    private static final int MQTT_SUBSCRIBE_RESERVED_FLAGS = 2;
    private static final int MSG_NONE = 0;
    private static final int PACKET_IDENTIFIER_NONE = 0;
    private static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    private static final int TRACE_NB_EVENTS = 3;
    private static final int TRACE_EVENT_MESSAGE_SENT = 0;
    private static final int TRACE_EVENT_MESSAGE_RECEIVED = 1;
    private static final int TRACE_EVENT_KEEP_ALIVE_UPDATED = 2;
    @Nullable
    private MqttCallback callback;
    @Nullable
    private Tracer tracer;
    private final String prefix;
    private final String host;
    private final int port;
    private final String clientId;
    private int state = 1;
    @Nullable
    private InputStream inputStream;
    @Nullable
    private OutputStream outputStream;
    @Nullable
    private Thread receiverThread;
    private int pendingMessageAction;
    private int pendingMessagePacketIdentifier;
    @Nullable
    protected MqttException pendingMessageAckException;
    private int nextPacketId;
    protected long lastOutboundActivityMillis;
    static final int MAX_NO_OF_REMAINING_LENGTH_BYTES = 4;

    public MqttClient(String serverURI, String clientId) throws MqttException {
        int port;
        String host;
        if (Constants.getBoolean((String)DEBUG_MODE)) {
            this.tracer = new Tracer(MQTT, 3);
        }
        this.clientId = clientId;
        int schemeSepIndex = serverURI.indexOf(URI_SEP_PREFIX);
        if (schemeSepIndex == -1) {
            throw new IllegalArgumentException(serverURI);
        }
        String scheme = serverURI.substring(0, schemeSepIndex);
        if (!scheme.equals(URI_PREFIX_TCP) && !scheme.equals(URI_PREFIX_SSL)) {
            throw new IllegalArgumentException(serverURI);
        }
        int hostStartIndex = schemeSepIndex + 3;
        int portSepIndex = serverURI.indexOf(58, hostStartIndex);
        if (portSepIndex == -1) {
            host = serverURI.substring(hostStartIndex);
            if (scheme.equals(URI_PREFIX_TCP)) {
                port = 1883;
            } else {
                assert (scheme.equals(URI_PREFIX_SSL));
                port = 8883;
            }
        } else {
            host = serverURI.substring(hostStartIndex, portSepIndex);
            try {
                int portStartIndex = portSepIndex + 1;
                port = Integer.parseInt(serverURI.substring(portStartIndex));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(serverURI);
            }
        }
        this.prefix = host;
        this.host = host;
        this.port = port;
        this.nextPacketId = 1;
    }

    @Override
    public void connect() throws MqttException {
        this.connect(new MqttConnectOptions());
    }

    @Override
    public synchronized void connect(MqttConnectOptions options) throws MqttException {
        InputStream is;
        Socket socket;
        int state = this.state;
        if (state == 0) {
            throw new MqttException(32100);
        }
        if (state == 2) {
            throw new MqttException(32111);
        }
        SocketFactory factory = options.getSocketFactory();
        if (factory == null) {
            factory = SocketFactory.getDefault();
            assert (factory != null);
        }
        InetSocketAddress sockaddr = new InetSocketAddress(this.host, this.port);
        try {
            socket = factory.createSocket();
            socket.connect(sockaddr, options.getConnectionTimeout() * 1000);
        }
        catch (IOException e) {
            throw new MqttException(32103, (Throwable)e);
        }
        try {
            is = socket.getInputStream();
            assert (is != null);
            this.inputStream = is;
            OutputStream os = socket.getOutputStream();
            assert (os != null);
            this.outputStream = os;
            this.writeConnect(os, this.clientId, options);
            this.readConnack(is, options);
        }
        catch (MqttException e) {
            this.closeStreams();
            throw e;
        }
        catch (EOFException e) {
            this.closeStreams();
            throw new MqttException(32109, (Throwable)e);
        }
        catch (IOException e) {
            this.closeStreams();
            throw new MqttException(e);
        }
        int keepAliveInMs = options.getKeepAliveInterval() * 1000;
        Thread receiverThread = new Thread((Runnable)new CommsReceiver(this, socket, is, keepAliveInMs), MQTT);
        receiverThread.setPriority(Constants.getInt((String)THREAD_PRIORITY));
        try {
            receiverThread.start();
        }
        catch (Throwable e) {
            this.closeStreams();
            throw new MqttException(e);
        }
        this.receiverThread = receiverThread;
        assert (this.inputStream != null);
        assert (this.outputStream != null);
        assert (this.receiverThread != null);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws MqttException {
        Thread receiverThread;
        assert (Thread.currentThread() != this.receiverThread);
        MqttClient mqttClient = this;
        synchronized (mqttClient) {
            int currentState = this.state;
            if (currentState == 0) {
                OutputStream os = this.outputStream;
                assert (os != null);
                int info = 224;
                try {
                    os.write(info);
                    MqttClient.writeLength(os, 0L);
                    os.flush();
                    if (Constants.getBoolean((String)DEBUG_MODE)) {
                        this.traceMessageSent(info);
                    }
                    this.lastOutboundActivityMillis = Util.platformTimeMillis();
                }
                catch (IOException iOException) {}
            } else {
                if (currentState == 1) {
                    throw new MqttException(32101);
                }
                assert (currentState == 2);
                throw new MqttException(32111);
            }
            receiverThread = this.receiverThread;
            this.internalDisconnect();
        }
        assert (receiverThread != null);
        try {
            receiverThread.join();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void subscribe(String topicFilter) throws MqttException {
        this.subscribe(topicFilter, 1);
    }

    @Override
    public void subscribe(String topicFilter, int qos) throws MqttException {
        this.subscribeOrUnsubscribe(8, topicFilter, qos);
    }

    private synchronized void subscribeOrUnsubscribe(int action, String topicFilter, int qos) throws MqttException {
        boolean subscribe;
        this.checkConnected();
        this.waitForNoPendingMessage();
        byte[] topicFilterUTF8 = MqttClient.getUTF8(topicFilter);
        int len = 4 + topicFilterUTF8.length;
        boolean bl = subscribe = action == 8;
        if (subscribe) {
            ++len;
        }
        OutputStream os = this.outputStream;
        assert (os != null);
        int info = action << 4 | 2;
        try {
            os.write(info);
            MqttClient.writeLength(os, len);
            this.writeAndRegisterPacketIdentifier(os, action);
            MqttClient.writeUTF8(os, topicFilterUTF8);
            if (subscribe) {
                os.write(qos);
            }
            os.flush();
            if (Constants.getBoolean((String)DEBUG_MODE)) {
                this.traceMessageSent(info);
            }
            this.lastOutboundActivityMillis = Util.platformTimeMillis();
        }
        catch (IOException e) {
            this.closeStreams();
            throw new MqttException(e);
        }
        this.waitForServerAcknowledgment();
    }

    @Override
    public void unsubscribe(String topicFilter) throws MqttException {
        this.subscribeOrUnsubscribe(10, topicFilter, 0);
    }

    @Override
    public void publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.publish(topic, message);
    }

    @Override
    public synchronized void publish(String topic, MqttMessage message) throws MqttException {
        this.checkConnected();
        this.waitForNoPendingMessage();
        byte[] topicUTF8 = MqttClient.getUTF8(topic);
        int qos = message.getQos();
        byte[] payload = message.getPayload();
        int len = 2 + topicUTF8.length + payload.length;
        if (qos > 0) {
            len += 2;
        }
        OutputStream os = this.outputStream;
        assert (os != null);
        int info = 0x30 | qos << 1;
        if (message.isRetained()) {
            info |= 1;
        }
        try {
            os.write(info);
            MqttClient.writeLength(os, len);
            MqttClient.writeUTF8(os, topicUTF8);
            if (qos > 0) {
                this.writeAndRegisterPacketIdentifier(os, 3);
            }
            os.write(payload);
            os.flush();
            if (Constants.getBoolean((String)DEBUG_MODE)) {
                this.traceMessageSent(info);
            }
            this.lastOutboundActivityMillis = Util.platformTimeMillis();
        }
        catch (IOException e) {
            this.closeStreams();
            throw new MqttException(e);
        }
        if (qos > 0) {
            this.waitForServerAcknowledgment();
        }
    }

    private void writeAndRegisterPacketIdentifier(OutputStream os, int message) throws IOException {
        int msgId = this.getNextPacketId();
        this.pendingMessageAction = message;
        this.pendingMessagePacketIdentifier = msgId;
        MqttClient.writeU16(os, msgId);
    }

    private void waitForNoPendingMessage() {
        while (this.pendingMessageAction != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (this.state == 1) {
            throw new MqttException(32104);
        }
    }

    private void waitForServerAcknowledgment() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        MqttException currentPendingMessageAckException = this.pendingMessageAckException;
        this.pendingMessageAction = 0;
        this.pendingMessagePacketIdentifier = 0;
        this.pendingMessageAckException = null;
        if (this.state == 1) {
            throw new MqttException(32104);
        }
        this.notify();
        if (currentPendingMessageAckException != null) {
            throw currentPendingMessageAckException;
        }
    }

    @Override
    public synchronized void close() throws MqttException {
        int currentState = this.state;
        if (currentState == 0) {
            throw new MqttException(32100);
        }
        if (currentState == 1) {
            this.state = 2;
        } else assert (currentState == 2);
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return String.valueOf(this.prefix) + URI_SEP_PREFIX + this.host + ':' + this.port;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.state == 0;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.callback = callback;
    }

    private void checkConnected() {
        if (this.state != 0) {
            throw new MqttException(32104);
        }
    }

    private void closeStreams() {
        OutputStream outputStream;
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            this.inputStream = null;
        }
        if ((outputStream = this.outputStream) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            this.inputStream = null;
        }
    }

    private void internalDisconnect() {
        if (this.state == 0) {
            this.closeStreams();
            this.receiverThread = null;
            this.state = 1;
            if (this.pendingMessageAction != 0) {
                this.notifyAll();
            }
        }
    }

    private synchronized void connectionLost(MqttException reason) {
        block3: {
            MqttCallback callback = this.callback;
            if (callback != null) {
                try {
                    callback.connectionLost(reason);
                }
                catch (Throwable e) {
                    if (!Constants.getBoolean((String)DEBUG_MODE)) break block3;
                    e.printStackTrace();
                }
            }
        }
        this.internalDisconnect();
    }

    private static void writeLength(OutputStream os, long number) throws IOException {
        assert (number >= 0L && number <= 0xFFFFFFFL);
        int numBytes = 0;
        long no = number;
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            os.write(digit);
        } while (no > 0L && ++numBytes < 4);
    }

    private static int readLength(InputStream is) throws IOException {
        int digit;
        int msgLength = 0;
        int multiplier = 1;
        do {
            digit = MqttClient.read(is);
            msgLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        if (Constants.getBoolean((String)SERVER_CHECKS) && (msgLength < 0 || msgLength > 0xFFFFFFF)) {
            throw new MqttException(44000);
        }
        return msgLength;
    }

    private static int readU16(InputStream is) throws IOException {
        int r1 = MqttClient.read(is);
        int r2 = MqttClient.read(is);
        int len = r1 << 8 | r2;
        return len;
    }

    private static byte[] readUTF8Bytes(InputStream is) throws IOException {
        int length = MqttClient.readU16(is);
        byte[] bytes = new byte[length];
        MqttClient.readFully(is, bytes);
        return bytes;
    }

    private static int read(InputStream is) throws IOException {
        int res = is.read();
        if (res == -1) {
            throw new EOFException();
        }
        return res;
    }

    private static byte[] getUTF8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void writeUTF8(OutputStream os, byte[] encodedString) throws IOException {
        MqttClient.writeU16(os, encodedString.length);
        os.write(encodedString);
    }

    private static void writeU16(OutputStream os, int value) throws IOException {
        assert ((value & 0xFFFF) == value);
        os.write(value >>> 8);
        os.write(value);
    }

    private void writeConnect(OutputStream os, String clientId, MqttConnectOptions options) throws IOException {
        int len = 10;
        byte[] clientIdUTF8 = MqttClient.getUTF8(clientId);
        len += clientIdUTF8.length + 2;
        String userName = options.getUserName();
        byte[] userNameUTF8 = null;
        byte[] passwordUTF8 = null;
        if (userName != null) {
            userNameUTF8 = MqttClient.getUTF8(userName);
            len += userNameUTF8.length + 2;
            char[] password = options.getPassword();
            if (password != null) {
                passwordUTF8 = MqttClient.getUTF8(new String(password));
                len += passwordUTF8.length + 2;
            }
        }
        int info = 16;
        os.write(info);
        MqttClient.writeLength(os, len);
        MqttClient.writeUTF8(os, MQTT.getBytes());
        os.write(4);
        int flags = 0;
        if (options.isCleanSession()) {
            flags |= 2;
        }
        if (userNameUTF8 != null) {
            flags |= 0x80;
            if (passwordUTF8 != null) {
                flags |= 0x40;
            }
        }
        os.write(flags);
        MqttClient.writeU16(os, options.getKeepAliveInterval());
        MqttClient.writeUTF8(os, clientIdUTF8);
        if (userNameUTF8 != null) {
            MqttClient.writeUTF8(os, userNameUTF8);
            if (passwordUTF8 != null) {
                MqttClient.writeUTF8(os, passwordUTF8);
            }
        }
        os.flush();
        this.lastOutboundActivityMillis = Util.platformTimeMillis();
        if (Constants.getBoolean((String)DEBUG_MODE)) {
            this.traceMessageSent(info);
        }
    }

    private void readConnack(InputStream is, MqttConnectOptions options) throws IOException {
        boolean sessionPresent;
        int header = MqttClient.read(is);
        int packetType = header >>> 4;
        if (packetType < 1 || packetType > 14) {
            throw new MqttException(32108);
        }
        if (Constants.getBoolean((String)DEBUG_MODE)) {
            Tracer tracer = this.tracer;
            assert (tracer != null);
            tracer.recordEvent(1, packetType);
        }
        if (packetType != 2) {
            throw new MqttException(32108);
        }
        int length = MqttClient.readLength(is);
        if (length != 2) {
            throw new MqttException(32108);
        }
        boolean bl = sessionPresent = (MqttClient.read(is) & 1) == 1;
        if (Constants.getBoolean((String)SERVER_CHECKS) && options.isCleanSession() && sessionPresent) {
            throw new MqttException(440001);
        }
        int returnCode = MqttClient.read(is);
        if (returnCode != 0) {
            throw new MqttException(returnCode);
        }
    }

    private int getNextPacketId() {
        this.nextPacketId = this.nextPacketId == 65535 ? 1 : this.nextPacketId + 1;
        return this.nextPacketId;
    }

    private void traceMessageSent(int info) {
        assert (Constants.getBoolean((String)DEBUG_MODE));
        Tracer tracer = this.tracer;
        assert (tracer != null);
        long time = this.lastOutboundActivityMillis;
        tracer.recordEvent(0, (int)(time >>> 32), (int)time, info >>> 4);
    }

    private static void readFully(InputStream is, byte[] array) throws IOException {
        int length = array.length;
        int ptr = 0;
        while (ptr < length) {
            int nb = is.read(array, ptr, length - ptr);
            if (nb == -1) {
                throw new EOFException();
            }
            ptr += nb;
        }
    }

    private class CommsReceiver
    implements Runnable {
        private final MqttClient client;
        private final Socket socket;
        private final InputStream inputStream;
        private final int keepAliveMillis;
        private boolean pingOutstanding;

        public CommsReceiver(MqttClient client, Socket socket, InputStream inputStream, int keepAliveMillis) {
            this.client = client;
            this.socket = socket;
            this.inputStream = inputStream;
            this.keepAliveMillis = keepAliveMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream inputStream = this.inputStream;
            boolean keepAliveEnabled = this.keepAliveMillis > 0;
            MqttClient client = this.client;
            try {
                block15: while (true) {
                    int header;
                    if (keepAliveEnabled) {
                        this.updateKeepAlive(client);
                    }
                    try {
                        header = MqttClient.read(inputStream);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        assert (keepAliveEnabled);
                        continue;
                    }
                    int packetType = header >>> 4;
                    if (Constants.getBoolean((String)MqttClient.DEBUG_MODE)) {
                        Tracer tracer = client.tracer;
                        assert (tracer != null);
                        tracer.recordEvent(1, packetType);
                    }
                    int length = MqttClient.readLength(inputStream);
                    switch (packetType) {
                        case 4: {
                            assert (length == 2);
                            int packetIdentifier = MqttClient.readU16(inputStream);
                            this.notifyAck(3, packetIdentifier, null);
                            continue block15;
                        }
                        case 9: {
                            MqttException ackError;
                            assert (length == 3);
                            int packetIdentifier = MqttClient.readU16(inputStream);
                            int returnCode = MqttClient.read(inputStream);
                            if (returnCode == 128) {
                                ackError = new MqttException(128);
                            } else {
                                if (Constants.getBoolean((String)MqttClient.SERVER_CHECKS) && returnCode != 0 && returnCode != 1) {
                                    ackError = new MqttException(128);
                                }
                                ackError = null;
                            }
                            this.notifyAck(8, packetIdentifier, ackError);
                            continue block15;
                        }
                        case 11: {
                            assert (length == 2);
                            int packetIdentifier = MqttClient.readU16(inputStream);
                            this.notifyAck(10, packetIdentifier, null);
                            continue block15;
                        }
                        case 3: {
                            MqttCallback callback;
                            boolean retained = (header & 1) != 0;
                            int qos = header >>> 1 & 3;
                            byte[] topicUTF8 = MqttClient.readUTF8Bytes(inputStream);
                            int currentLength = 2 + topicUTF8.length;
                            int packetid = 0;
                            if (qos > 0) {
                                packetid = MqttClient.readU16(inputStream);
                                currentLength += 2;
                            }
                            int payloadLength = length - currentLength;
                            byte[] payload = new byte[payloadLength];
                            MqttClient.readFully(inputStream, payload);
                            if (qos > 0) {
                                MqttClient mqttClient = client;
                                synchronized (mqttClient) {
                                    if (client.state == 0) {
                                        OutputStream os = client.outputStream;
                                        assert (os != null);
                                        int info = 64;
                                        os.write(info);
                                        MqttClient.writeLength(os, 2L);
                                        MqttClient.writeU16(os, packetid);
                                        os.flush();
                                        client.lastOutboundActivityMillis = Util.platformTimeMillis();
                                        if (Constants.getBoolean((String)MqttClient.DEBUG_MODE)) {
                                            client.traceMessageSent(info);
                                        }
                                    }
                                }
                            }
                            if ((callback = client.callback) == null) continue block15;
                            String topic = new String(topicUTF8, "UTF-8");
                            MqttMessage message = new MqttMessage(payload);
                            message.setQos(qos);
                            message.setRetained(retained);
                            callback.messageArrived(topic, message);
                            continue block15;
                        }
                        case 13: {
                            if (Constants.getBoolean((String)MqttClient.SERVER_CHECKS) && !this.pingOutstanding) {
                                throw new MqttException(44004);
                            }
                            this.pingOutstanding = false;
                            continue block15;
                        }
                    }
                    break;
                }
                throw new MqttException(32108);
            }
            catch (MqttException e) {
                client.connectionLost(e);
            }
            catch (Exception e) {
                client.connectionLost(new MqttException(32109, (Throwable)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateKeepAlive(MqttClient client) throws IOException {
            int timeToNextPingReqMillis;
            MqttClient mqttClient = client;
            synchronized (mqttClient) {
                if (client.state != 0) {
                    return;
                }
                long currentTimeMillis = Util.platformTimeMillis();
                int timeSinceLastOutboundActivityMillis = (int)(currentTimeMillis - client.lastOutboundActivityMillis);
                assert (timeSinceLastOutboundActivityMillis >= 0);
                timeToNextPingReqMillis = this.keepAliveMillis - timeSinceLastOutboundActivityMillis;
                if (timeToNextPingReqMillis <= 0) {
                    if (this.pingOutstanding) {
                        throw new MqttException(32000);
                    }
                    OutputStream os = client.outputStream;
                    assert (os != null);
                    int info = 192;
                    os.write(info);
                    MqttClient.writeLength(os, 0L);
                    os.flush();
                    client.lastOutboundActivityMillis = Util.platformTimeMillis();
                    if (Constants.getBoolean((String)MqttClient.DEBUG_MODE)) {
                        client.traceMessageSent(info);
                    }
                    timeToNextPingReqMillis = this.keepAliveMillis;
                    this.pingOutstanding = true;
                }
            }
            assert (timeToNextPingReqMillis > 0);
            this.socket.setSoTimeout(timeToNextPingReqMillis);
            if (Constants.getBoolean((String)MqttClient.DEBUG_MODE)) {
                Tracer tracer = client.tracer;
                assert (tracer != null);
                tracer.recordEvent(2, timeToNextPingReqMillis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAck(int expectedAction, int packetIdentifier, @Nullable MqttException e) throws IOException {
            MqttClient client;
            MqttClient mqttClient = client = this.client;
            synchronized (mqttClient) {
                if (Constants.getBoolean((String)MqttClient.SERVER_CHECKS)) {
                    if (client.pendingMessageAction != expectedAction) {
                        throw new MqttException(44002);
                    }
                    if (client.pendingMessagePacketIdentifier != packetIdentifier) {
                        throw new MqttException(44003);
                    }
                }
                client.pendingMessageAckException = e;
                client.notifyAll();
            }
        }
    }
}

