/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.bon.ByteArray;
import ej.websocket.CloseCodes;
import ej.websocket.Messages;
import ej.websocket.util.ArraysTools;
import ej.websocket.util.UTF8Validator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class RawFrame {
    private static final int BYTE_MAX_VALUE = 127;
    public static final byte OPCODE_CONTINUATION_FRAME = 0;
    public static final byte OPCODE_TEXT_FRAME = 1;
    public static final byte OPCODE_BINARY_FRAME = 2;
    public static final byte OPCODE_CONNECTION_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private byte[] bytes;

    public RawFrame(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.bytes = (byte[])bytes.clone();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte getFIN() {
        return (byte)((this.bytes[0] & 0x80) >> 7);
    }

    public byte getRSV() {
        return (byte)((this.bytes[0] & 0x70) >> 4);
    }

    public byte getOpcode() {
        return (byte)(this.bytes[0] & 0xF);
    }

    public boolean hasValidOpcode() {
        byte code = this.getOpcode();
        return code == 0 || code == 1 || code == 2 || code == 8 || code == 9 || code == 10;
    }

    public byte getMASK() {
        return (byte)((this.bytes[1] & 0x80) >> 7);
    }

    public boolean isControlFrame() {
        byte opcode = this.getOpcode();
        return (opcode & 8) != 0;
    }

    public boolean isMasked() {
        return this.getMASK() == 1;
    }

    public boolean isValid() throws IOException {
        if (!this.hasValidOpcode()) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -1));
        }
        if (this.getOpcode() == 1 && this.getLength() != 0) {
            long payloadLength = this.getPayloadLength();
            if (payloadLength > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
            }
            if (!UTF8Validator.isValid(this.bytes, this.getPayloadOffset(), (int)payloadLength)) {
                throw new UnsupportedEncodingException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -2));
            }
        }
        if (this.isControlFrame()) {
            this.isControlValid();
        }
        return true;
    }

    private void isControlValid() throws IOException, UnsupportedEncodingException {
        if (this.getFIN() != 1) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -5));
        }
        if (this.getLength() > 125) {
            throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -6, new Object[]{this.getLength()}));
        }
        if (this.getOpcode() == 8) {
            if (this.getLength() == 1) {
                throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9));
            }
            if (this.getLength() >= 2) {
                int lsb;
                byte[] payload = this.getPayload(true);
                int msb = payload[0] & 0xFF;
                int code = (msb << 8) + (lsb = payload[1] & 0xFF);
                if (!CloseCodes.canBeUsedInCloseFrame(code)) {
                    throw new IOException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -7, new Object[]{code}));
                }
                if (!UTF8Validator.isValid(payload, 2, payload.length - 2)) {
                    throw new UnsupportedEncodingException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -2));
                }
            }
        }
    }

    public byte getLength() {
        return (byte)(this.bytes[1] & 0x7F);
    }

    public boolean hasExtendedLength() {
        return this.getLength() == 126;
    }

    public boolean hasVeryExtendedLength() {
        return this.getLength() == 127;
    }

    public long getExtendedLength() {
        if (this.hasExtendedLength()) {
            int msb = this.bytes[2] & 0xFF;
            int lsb = this.bytes[3] & 0xFF;
            return (msb << 8) + lsb;
        }
        if (this.hasVeryExtendedLength()) {
            return ByteArray.readLong((byte[])this.bytes, (int)2, (int)1);
        }
        return 0L;
    }

    public void setLength(long length) {
        long previousLength = this.getPayloadLength();
        if (previousLength >= 127L && length < 127L) {
            this.bytes = ArraysTools.removeRange(this.bytes, 2, 2);
        } else if (previousLength < 127L && length >= 127L) {
            this.bytes = ArraysTools.insertRange(this.bytes, 2, 2);
        }
        this.bytes[1] = (byte)(this.bytes[1] | 0x7F);
        this.bytes[1] = (byte)(Math.min(length, 126L) & 0x7FL);
        if (length >= 127L) {
            this.bytes[2] = (byte)(length >> 8 & 0xFFL);
            this.bytes[3] = (byte)(length & 0xFFL);
        }
    }

    public byte[] getMaskingKey() {
        if (this.isMasked()) {
            byte[] maskingKey = new byte[4];
            int offset = this.hasExtendedLength() ? 4 : 2;
            System.arraycopy(this.bytes, offset, maskingKey, 0, 4);
            return maskingKey;
        }
        return null;
    }

    public byte[] getPayload(boolean unmaskIfNeeded) {
        if (this.isMasked() && unmaskIfNeeded) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        int offset = this.getPayloadOffset();
        long payloadLength = this.getPayloadLength();
        if (payloadLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        byte[] payload = new byte[(int)payloadLength];
        System.arraycopy(this.bytes, offset, payload, 0, (int)payloadLength);
        return payload;
    }

    public String getPayloadAsString(boolean unmaskIfNeeded) {
        if (this.isMasked() && unmaskIfNeeded) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        int offset = this.getPayloadOffset();
        long payloadLength = this.getPayloadLength();
        if (payloadLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        return new String(this.bytes, offset, (int)payloadLength);
    }

    public long getPayloadLength() {
        long payloadLength = this.getLength();
        if (this.hasExtendedLength() || this.hasVeryExtendedLength()) {
            payloadLength = this.getExtendedLength();
        }
        return payloadLength;
    }

    private int getPayloadOffset() {
        int offset = 2;
        if (this.hasExtendedLength()) {
            offset += 2;
        } else if (this.hasVeryExtendedLength()) {
            offset += 8;
        }
        if (this.isMasked()) {
            offset += 4;
        }
        return offset;
    }

    public synchronized void append(RawFrame f) {
        int currentOffset = this.getPayloadOffset();
        long currentPayloadLength = this.getPayloadLength();
        byte[] fBytes = f.getBytes();
        long currentLength = (long)currentOffset + currentPayloadLength;
        long fPayloadLength = f.getPayloadLength();
        long length = fPayloadLength + currentPayloadLength;
        if (currentLength > Integer.MAX_VALUE || fPayloadLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        this.bytes = ArraysTools.add(this.bytes, 0, (int)currentLength, fBytes, f.getPayloadOffset(), (int)fPayloadLength);
        this.setLength(length);
    }
}

