/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.color;

import ej.bon.XMath;
import ej.microui.display.Display;
import ej.widget.util.color.ColorHelper;

public class GradientHelper {
    private GradientHelper() {
    }

    public static int blendColors(int color1, int color2, float ratio) {
        ratio = XMath.limit((float)ratio, (float)0.0f, (float)1.0f);
        int red1 = ColorHelper.getRed(color1);
        int green1 = ColorHelper.getGreen(color1);
        int blue1 = ColorHelper.getBlue(color1);
        int red2 = ColorHelper.getRed(color2);
        int green2 = ColorHelper.getGreen(color2);
        int blue2 = ColorHelper.getBlue(color2);
        float invRatio = 1.0f - ratio;
        int red = (int)((float)red1 * invRatio + (float)red2 * ratio);
        int green = (int)((float)green1 * invRatio + (float)green2 * ratio);
        int blue = (int)((float)blue1 * invRatio + (float)blue2 * ratio);
        return ColorHelper.getColor(red, green, blue);
    }

    public static int[] createGradient(Display display, int startColor, int endColor) {
        float currentRed = ColorHelper.getRed(startColor);
        float currentGreen = ColorHelper.getGreen(startColor);
        float currentBlue = ColorHelper.getBlue(startColor);
        int endRed = ColorHelper.getRed(endColor);
        int endGreen = ColorHelper.getGreen(endColor);
        int endBlue = ColorHelper.getBlue(endColor);
        int stepsRed = (int)((float)endRed - currentRed);
        int stepsGreen = (int)((float)endGreen - currentGreen);
        int stepsBlue = (int)((float)endBlue - currentBlue);
        int maxSteps = Math.max(Math.abs(stepsRed), Math.max(Math.abs(stepsGreen), Math.abs(stepsBlue)));
        int[] colors = new int[maxSteps];
        int length = 0;
        float stepRed = (float)stepsRed / (float)maxSteps;
        float stepGreen = (float)stepsGreen / (float)maxSteps;
        float stepBlue = (float)stepsBlue / (float)maxSteps;
        int lastColor = -1;
        while (maxSteps >= 0) {
            int color = ColorHelper.getColor((int)currentRed, (int)currentGreen, (int)currentBlue);
            int displayColor = display.getDisplayColor(color);
            if (displayColor != lastColor) {
                colors[length] = displayColor;
                ++length;
                lastColor = displayColor;
            }
            currentRed += stepRed;
            currentGreen += stepGreen;
            currentBlue += stepBlue;
            --maxSteps;
        }
        int[] result = new int[length];
        System.arraycopy(colors, 0, result, 0, length);
        return result;
    }
}

