/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.basictool.ArrayTools;
import ej.hoka.http.Cookie;
import ej.hoka.http.encoding.ContentEncoding;
import ej.hoka.http.encoding.EncodingRegistry;
import ej.hoka.log.HokaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private static final String RESPONSE_COLON = ": ";
    private static final String RESPONSE_HTTP11 = "HTTP/1.1 ";
    private static final String RESPONSE_CONTENTTYPE = "content-type: ";
    private String status;
    private String mimeType;
    private Object data;
    private long length = -1L;
    private final Map<String, String> headers = new HashMap<String, String>(5);
    private Cookie[] cookies = new Cookie[0];

    public HttpResponse() {
        this.setStatus("200 OK");
        this.setData((String)null);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addHeaders(Map<String, String> map) {
        this.headers.putAll(map);
    }

    public String getHeader(String key) {
        if (key == null) {
            return null;
        }
        return this.headers.get(key.toLowerCase());
    }

    protected long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setData(String data) {
        byte[] result = data == null ? new byte[]{} : data.getBytes();
        this.data = result;
        this.setLength(result.length);
    }

    public void setData(String data, String encoding) throws UnsupportedEncodingException {
        byte[] result = data == null ? new byte[]{} : data.getBytes(encoding);
        this.data = result;
        this.setLength(result.length);
    }

    public void setData(byte[] data) {
        byte[] result = data == null ? new byte[]{} : data;
        this.data = result;
        this.setLength(result.length);
    }

    public void setData(InputStream dataStream) {
        this.setData(dataStream, -1L);
    }

    public void setData(InputStream dataStream, long length) {
        this.data = dataStream;
        this.setLength(length);
    }

    private void setLength(long length) {
        if (length < 0L) {
            this.headers.remove("content-length");
        } else {
            this.headers.put("content-length", Long.toString(length));
        }
        this.length = length;
    }

    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public final void setStatus(String status) {
        this.status = status;
    }

    public void addCookie(String name, String value) {
        this.addCookie(name, value, 0);
    }

    public void addCookie(String name, String value, int maxAge) {
        this.cookies = (Cookie[])ArrayTools.add((Object[])this.cookies, (Object)new Cookie(name, value, maxAge));
    }

    public void addCookie(String name, String value, int maxAge, boolean secured, boolean httpOnly) {
        this.addCookie(name, value, null, null, maxAge, secured, httpOnly);
    }

    public void addCookie(String name, String value, String domain, String path, int maxAge, boolean secured, boolean httpOnly) {
        this.addCookie(name, value, domain, path, maxAge, null, secured, httpOnly);
    }

    public void addCookie(String name, String value, String domain, String path, int maxAge, Date expires, boolean secured, boolean httpOnly) {
        this.addCookie(name, value, domain, path, maxAge, expires, secured, httpOnly, null);
    }

    public void addCookie(String name, String value, String domain, String path, int maxAge, Date expires, boolean secured, boolean httpOnly, Cookie.SameSite sameSite) {
        this.cookies = (Cookie[])ArrayTools.add((Object[])this.cookies, (Object)new Cookie(name, value, domain, path, maxAge, expires, secured, httpOnly, sameSite));
    }

    void sendResponse(OutputStream outputStream, ContentEncoding encodingHandler, EncodingRegistry encodingRegistry, int bufferSize) throws IOException {
        long length;
        if (encodingHandler != null) {
            this.addHeader("content-encoding", encodingHandler.getId());
        }
        if ((length = this.getLength()) < 0L) {
            this.addHeader("transfer-encoding", encodingRegistry.getChunkedTransferEncoding().getId());
        }
        this.writeHTTPHeader(outputStream);
        Object data = this.data;
        if (data instanceof byte[]) {
            byte[] dataArray = (byte[])data;
            this.sendRawDataResponse(dataArray, outputStream, encodingHandler, encodingRegistry);
        } else if (data != null) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream dataStream = (InputStream)data;){
                this.sendInputStreamResponse(dataStream, outputStream, encodingHandler, encodingRegistry, bufferSize);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        outputStream.flush();
    }

    private void sendRawDataResponse(byte[] rawData, OutputStream outputStream, ContentEncoding encodingHandler, EncodingRegistry encodingRegistry) throws IOException {
        block19: {
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream dataOutput = encodingRegistry.getIdentityTransferCodingHandler().open(this, outputStream);){
                if (encodingHandler != null) {
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (OutputStream encodedDataOutput = encodingHandler.open(dataOutput);){
                        HttpResponse.writeAndFlush(rawData, encodedDataOutput);
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                HttpResponse.writeAndFlush(rawData, dataOutput);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void sendInputStreamResponse(InputStream dataStream, OutputStream outputStream, ContentEncoding encodingHandler, EncodingRegistry encodingRegistry, int bufferSize) {
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStream dataOutput = this.length == -1L ? encodingRegistry.getChunkedTransferEncoding().open(this, outputStream) : encodingRegistry.getIdentityTransferCodingHandler().open(this, outputStream);){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (OutputStream ecodedOutput = encodingHandler != null ? encodingHandler.open(dataOutput) : null;){
                    int len;
                    OutputStream output = ecodedOutput != null ? ecodedOutput : dataOutput;
                    byte[] readBuffer = new byte[bufferSize];
                    while ((len = dataStream.read(readBuffer)) >= 0) {
                        output.write(readBuffer, 0, len);
                        output.flush();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            HokaLogger.instance.error(t);
        }
    }

    private void writeHTTPHeader(OutputStream output) throws IOException {
        byte[] eofHeader = "\r\n".getBytes();
        output.write(RESPONSE_HTTP11.getBytes());
        output.write(this.getStatus().trim().getBytes());
        output.write(eofHeader);
        if (this.mimeType != null) {
            output.write(RESPONSE_CONTENTTYPE.getBytes());
            output.write(this.mimeType.getBytes());
            output.write(eofHeader);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            output.write(key.getBytes());
            output.write(RESPONSE_COLON.getBytes());
            output.write(value.getBytes());
            output.write(eofHeader);
        }
        Cookie[] cookieArray = this.cookies;
        int n = this.cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            output.write("Set-Cookie".getBytes());
            output.write(RESPONSE_COLON.getBytes());
            output.write(cookie.toString().getBytes());
            output.write(eofHeader);
            ++n2;
        }
        output.write(eofHeader);
    }

    private static void writeAndFlush(byte[] data, OutputStream stream) throws IOException {
        stream.write(data);
        stream.flush();
        stream.close();
    }
}

