/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender.helper;

import com.microej.tool.classextender.ClassExtender;
import ej.basictool.annotation.Extend;
import java.io.Closeable;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class ClassPoolHelper
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ClassPoolHelper.class.getName());
    private final ClassPool pool;
    private final List<ClassPath> classpaths;

    static {
        ClassPool.cacheOpenedJarFile = false;
    }

    public ClassPoolHelper(File ... classpath) {
        LOGGER.finest("Create new class pool");
        this.pool = new ClassPool(ClassExtender.includeDefaultClasspath);
        try {
            this.pool.appendClassPath(new File(Extend.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath());
        }
        catch (URISyntaxException | NotFoundException e) {
            LOGGER.log(Level.FINEST, "Could not add extend annotation in classpath: {0}", e.getMessage());
        }
        this.classpaths = new ArrayList<ClassPath>(classpath.length);
        File[] fileArray = classpath;
        int n = classpath.length;
        int n2 = 0;
        while (n2 < n) {
            File cp = fileArray[n2];
            try {
                LOGGER.log(Level.FINEST, "Add {0} to class pool", cp.getAbsoluteFile());
                this.classpaths.add(this.pool.insertClassPath(cp.getAbsolutePath()));
            }
            catch (NotFoundException notFoundException) {
                LOGGER.log(Level.WARNING, "Could not add {0} to classpath", cp.getAbsolutePath());
            }
            ++n2;
        }
    }

    public CtClass getClass(String className) throws ClassNotFoundException {
        try {
            return this.pool.get(className);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException("Could not find " + className, e);
        }
    }

    @Override
    public void close() {
        LOGGER.finest("Close class pool");
        this.classpaths.stream().forEach(cp -> this.pool.removeClassPath((ClassPath)cp));
    }
}

