/*
 * Decompiled with CFR 0.152.
 */
package ej.util.message.basic;

import ej.util.message.MessageBuilder;
import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageBuilder;

public class FilterMessageLogger
implements MessageLogger {
    private static final char FINEST = '\n';
    private static final char FINER = '\u0014';
    private static final char FINE = '\u001e';
    private static final char INFO = '(';
    private static final char CONFIG = '2';
    private static final char WARNING = '<';
    private static final char SEVERE = 'F';
    public static final char OFF = '\u00ff';
    public static final char ALL = '\u0000';
    public static final FilterMessageLogger INSTANCE = new FilterMessageLogger();
    private MessageBuilder builder;
    private char printLevel;

    public FilterMessageLogger() {
        this(BasicMessageBuilder.INSTANCE);
    }

    public FilterMessageLogger(MessageBuilder builder) {
        this(builder, 'I');
    }

    public FilterMessageLogger(MessageBuilder builder, char level) {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.builder = builder;
        this.setLevel(level);
    }

    @Override
    public MessageBuilder getMessageBuilder() {
        return this.builder;
    }

    @Override
    public void setMessageBuilder(MessageBuilder builder) {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.builder = builder;
    }

    public void setLevel(char level) throws IllegalArgumentException {
        this.printLevel = this.getLevelId(level);
    }

    public char getLevel() {
        return this.getLevelFromId(this.printLevel);
    }

    @Override
    public void log(char level, String category, int id) {
        if (this.shouldPrint(level)) {
            System.out.println(this.builder.buildMessage(level, category, id));
        }
    }

    @Override
    public void log(char level, String category, int id, Throwable t) {
        if (this.shouldPrint(level)) {
            System.out.println(this.builder.buildMessage(level, category, id, t));
        }
    }

    @Override
    public void log(char level, String category, int id, Object ... arguments) {
        if (this.shouldPrint(level)) {
            System.out.println(this.builder.buildMessage(level, category, id, arguments));
        }
    }

    @Override
    public void log(char level, String category, int id, Throwable t, Object ... arguments) {
        if (this.shouldPrint(level)) {
            System.out.println(this.builder.buildMessage(level, category, id, t, arguments));
        }
    }

    private boolean shouldPrint(char level) {
        return this.printLevel <= this.getLevelId(level);
    }

    private char getLevelId(char level) {
        switch (level) {
            case 'S': {
                return 'F';
            }
            case 'W': {
                return '<';
            }
            case 'C': {
                return '2';
            }
            case 'I': {
                return '(';
            }
            case 'F': {
                return '\u001e';
            }
            case 'G': {
                return '\u0014';
            }
            case 'H': {
                return '\n';
            }
            case '\u00ff': {
                return '\u00ff';
            }
            case '\u0000': {
                return '\u0000';
            }
        }
        throw new IllegalArgumentException();
    }

    private char getLevelFromId(char level) {
        switch (level) {
            case 'F': {
                return 'S';
            }
            case '<': {
                return 'W';
            }
            case '2': {
                return 'C';
            }
            case '(': {
                return 'I';
            }
            case '\u001e': {
                return 'F';
            }
            case '\u0014': {
                return 'G';
            }
            case '\n': {
                return 'H';
            }
            case '\u00ff': {
                return '\u00ff';
            }
            case '\u0000': {
                return '\u0000';
            }
        }
        throw new IllegalArgumentException();
    }
}

