/*
 * Decompiled with CFR 0.152.
 */
package ej.junit;

import ej.junit.TestListener;

public class CheckHelperTestListener
implements TestListener {
    private final boolean verbose = Boolean.getBoolean("ej.junit.checkhelper.verbose");

    @Override
    public void testBeforeClassMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.err.println("[JUNIT] Running @BeforeClass method: " + methodName);
        }
    }

    @Override
    public void testInstance(String testClass) {
        if (this.verbose) {
            System.err.println("[JUNIT] Instantiating: " + testClass);
        }
    }

    @Override
    public void testBeforeMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.err.println("[JUNIT] Running @Before method: " + methodName);
        }
    }

    @Override
    public void testAfterMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.err.println("[JUNIT] Running @After method: " + methodName);
        }
    }

    @Override
    public void testAfterClassMethod(String testClass, String methodName) {
        if (this.verbose) {
            System.err.println("[JUNIT] Running @AfterClass method: " + methodName);
        }
    }

    private void log(String text) {
        System.err.println("[JUNIT] " + text);
    }

    @Override
    public void onSuiteStart(String name) {
        this.log("Suite start\t" + name);
    }

    @Override
    public void onSuiteEnd(String name, int runs, int failures, int errors) {
        this.log("Suite end\t" + name);
        System.err.println(String.valueOf(failures == 0 && errors == 0 ? "PASSED:\t" : "FAILED:\t") + runs + " tests\t" + failures + " failures\t" + errors + " errors");
    }

    @Override
    public void onCaseStart(String name, String className, String file, int line) {
        this.log("Test start\t" + name + "\t" + className + "\t" + file + "\t" + line);
    }

    @Override
    public void onCaseEnd(String name, double duration) {
        this.log("Test end\t" + name + "\t" + duration + " seconds");
    }

    @Override
    public void onFailure(String message, String type, String trace) {
        this.log("Failure\t" + type + "\t" + message);
        this.log("TRACE START\n" + trace);
        this.log("TRACE END");
    }

    @Override
    public void onError(String message, String type, String trace) {
        this.log("Error\t" + type + "\t" + message);
        this.log("TRACE START\n" + trace);
        this.log("TRACE END");
    }

    @Override
    public void onSkip(String message) {
        this.log("Skipped\t" + message);
    }
}

